SET FOREIGN_KEY_CHECKS=0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;


CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint UNSIGNED NOT NULL,
  `comment_id` bigint UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint UNSIGNED NOT NULL,
  `comment_post_ID` bigint UNSIGNED NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint UNSIGNED NOT NULL DEFAULT '0',
  `user_id` bigint UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_content_status` (
  `rid` bigint NOT NULL,
  `nid` bigint NOT NULL,
  `timestamp` datetime NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_core_status` (
  `id` bigint NOT NULL,
  `rid` bigint NOT NULL,
  `module` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `origin` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `target` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` smallint NOT NULL,
  `tp_revision` int NOT NULL DEFAULT '1',
  `ts_status` text COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_flags` (
  `id` int NOT NULL,
  `lang_code` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `flag` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `from_template` tinyint NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_icl_flags` (`id`, `lang_code`, `flag`, `from_template`) VALUES
(1, 'ar', 'ar.png', 0),
(2, 'bg', 'bg.png', 0),
(3, 'bn', 'bn.png', 0),
(4, 'bs', 'bs.png', 0),
(5, 'ca', 'ca.png', 0),
(6, 'cs', 'cs.png', 0),
(7, 'cy', 'cy.png', 0),
(8, 'da', 'da.png', 0),
(9, 'de', 'de.png', 0),
(10, 'el', 'el.png', 0),
(11, 'en', 'en.png', 0),
(12, 'eo', 'eo.png', 0),
(13, 'es', 'es.png', 0),
(14, 'et', 'et.png', 0),
(15, 'eu', 'eu.png', 0),
(16, 'fa', 'fa.png', 0),
(17, 'fi', 'fi.png', 0),
(18, 'fr', 'fr.png', 0),
(19, 'ga', 'ga.png', 0),
(20, 'gl', 'gl.png', 0),
(21, 'he', 'he.png', 0),
(22, 'hi', 'hi.png', 0),
(23, 'hr', 'hr.png', 0),
(24, 'hu', 'hu.png', 0),
(25, 'hy', 'hy.png', 0),
(26, 'id', 'id.png', 0),
(27, 'is', 'is.png', 0),
(28, 'it', 'it.png', 0),
(29, 'ja', 'ja.png', 0),
(30, 'ko', 'ko.png', 0),
(31, 'ku', 'ku.png', 0),
(32, 'lt', 'lt.png', 0),
(33, 'lv', 'lv.png', 0),
(34, 'mk', 'mk.png', 0),
(35, 'mn', 'mn.png', 0),
(36, 'ms', 'ms.png', 0),
(37, 'mt', 'mt.png', 0),
(38, 'ne', 'ne.png', 0),
(39, 'nl', 'nl.png', 0),
(40, 'no', 'no.png', 0),
(41, 'pa', 'pa.png', 0),
(42, 'pl', 'pl.png', 0),
(43, 'pt-br', 'pt-br.png', 0),
(44, 'pt-pt', 'pt-pt.png', 0),
(45, 'qu', 'qu.png', 0),
(46, 'ro', 'ro.png', 0),
(47, 'ru', 'ru.png', 0),
(48, 'sk', 'sk.png', 0),
(49, 'sl', 'sl.png', 0),
(50, 'so', 'so.png', 0),
(51, 'sq', 'sq.png', 0),
(52, 'sr', 'sr.png', 0),
(53, 'sv', 'sv.png', 0),
(54, 'ta', 'ta.png', 0),
(55, 'th', 'th.png', 0),
(56, 'tr', 'tr.png', 0),
(57, 'uk', 'uk.png', 0),
(58, 'ur', 'ur.png', 0),
(59, 'uz', 'uz.png', 0),
(60, 'vi', 'vi.png', 0),
(61, 'yi', 'yi.png', 0),
(62, 'zh-hans', 'zh.png', 0),
(63, 'zh-hant', 'zh.png', 0),
(64, 'zu', 'zu.png', 0);

CREATE TABLE `wp_icl_languages` (
  `id` int NOT NULL,
  `code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `english_name` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `major` tinyint NOT NULL DEFAULT '0',
  `active` tinyint NOT NULL,
  `default_locale` varchar(35) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tag` varchar(35) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `encode_url` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_icl_languages` (`id`, `code`, `english_name`, `major`, `active`, `default_locale`, `tag`, `encode_url`) VALUES
(1, 'en', 'English', 1, 0, 'en_US', 'en', 0),
(2, 'es', 'Spanish', 1, 0, 'es_ES', 'es', 0),
(3, 'de', 'German', 1, 0, 'de_DE', 'de', 0),
(4, 'fr', 'French', 1, 0, 'fr_FR', 'fr', 0),
(5, 'ar', 'Arabic', 0, 0, 'ar', 'ar', 0),
(6, 'bs', 'Bosnian', 0, 0, 'bs_BA', 'bs', 0),
(7, 'bg', 'Bulgarian', 0, 0, 'bg_BG', 'bg', 0),
(8, 'ca', 'Catalan', 0, 0, 'ca', 'ca', 0),
(9, 'cs', 'Czech', 0, 0, 'cs_CZ', 'cs', 0),
(10, 'sk', 'Slovak', 0, 0, 'sk_SK', 'sk', 0),
(11, 'cy', 'Welsh', 0, 0, 'cy_GB', 'cy', 0),
(12, 'da', 'Danish', 1, 0, 'da_DK', 'da', 0),
(13, 'el', 'Greek', 0, 0, 'el', 'el', 0),
(14, 'eo', 'Esperanto', 0, 0, 'eo_UY', 'eo', 0),
(15, 'et', 'Estonian', 0, 0, 'et', 'et', 0),
(16, 'eu', 'Basque', 0, 0, 'eu_ES', 'eu', 0),
(17, 'fa', 'Persian', 0, 0, 'fa_IR', 'fa', 0),
(18, 'fi', 'Finnish', 0, 0, 'fi', 'fi', 0),
(19, 'ga', 'Irish', 0, 0, 'ga_IE', 'ga', 0),
(20, 'he', 'Hebrew', 0, 0, 'he_IL', 'he', 0),
(21, 'hi', 'Hindi', 0, 0, 'hi_IN', 'hi', 0),
(22, 'hr', 'Croatian', 0, 0, 'hr', 'hr', 0),
(23, 'hu', 'Hungarian', 0, 0, 'hu_HU', 'hu', 0),
(24, 'hy', 'Armenian', 0, 0, 'hy_AM', 'hy', 0),
(25, 'id', 'Indonesian', 0, 0, 'id_ID', 'id', 0),
(26, 'is', 'Icelandic', 0, 0, 'is_IS', 'is', 0),
(27, 'it', 'Italian', 1, 0, 'it_IT', 'it', 0),
(28, 'ja', 'Japanese', 1, 0, 'ja', 'ja', 0),
(29, 'ko', 'Korean', 0, 0, 'ko_KR', 'ko', 0),
(30, 'ku', 'Kurdish', 0, 0, 'ckb', 'ku', 0),
(31, 'lv', 'Latvian', 0, 0, 'lv_LV', 'lv', 0),
(32, 'lt', 'Lithuanian', 0, 0, 'lt_LT', 'lt', 0),
(33, 'mk', 'Macedonian', 0, 0, 'mk_MK', 'mk', 0),
(34, 'mt', 'Maltese', 0, 0, 'mt_MT', 'mt', 0),
(35, 'mn', 'Mongolian', 0, 0, 'mn_MN', 'mn', 0),
(36, 'ne', 'Nepali', 0, 0, 'ne', 'ne', 0),
(37, 'nl', 'Dutch', 1, 0, 'nl_NL', 'nl', 0),
(38, 'no', 'Norwegian Bokmål', 0, 0, 'nb_NO', 'no', 0),
(39, 'pa', 'Punjabi', 0, 0, '', 'pa', 0),
(40, 'pl', 'Polish', 0, 0, 'pl_PL', 'pl', 0),
(41, 'pt-pt', 'Portuguese, Portugal', 0, 0, 'pt_PT', 'pt-pt', 0),
(42, 'pt-br', 'Portuguese, Brazil', 0, 0, 'pt_BR', 'pt-br', 0),
(43, 'qu', 'Quechua', 0, 0, 'quz_PE', 'qu', 0),
(44, 'ro', 'Romanian', 0, 0, 'ro_RO', 'ro', 0),
(45, 'ru', 'Russian', 1, 0, 'ru_RU', 'ru', 0),
(46, 'sl', 'Slovenian', 0, 0, 'sl_SI', 'sl', 0),
(47, 'so', 'Somali', 0, 0, 'so_SO', 'so', 0),
(48, 'sq', 'Albanian', 0, 0, 'sq_AL', 'sq', 0),
(49, 'sr', 'Serbian', 0, 0, 'sr_RS', 'sr', 0),
(50, 'sv', 'Swedish', 0, 0, 'sv_SE', 'sv', 0),
(51, 'ta', 'Tamil', 0, 0, 'ta_IN', 'ta', 0),
(52, 'th', 'Thai', 0, 0, 'th', 'th', 0),
(53, 'tr', 'Turkish', 0, 0, 'tr_TR', 'tr', 0),
(54, 'uk', 'Ukrainian', 0, 0, 'uk', 'uk', 0),
(55, 'ur', 'Urdu', 0, 0, 'uz_UZ', 'ur', 0),
(56, 'uz', 'Uzbek', 0, 0, 'uz_UZ', 'uz', 0),
(57, 'vi', 'Vietnamese', 0, 0, 'vi_VN', 'vi', 0),
(58, 'yi', 'Yiddish', 0, 0, '', 'yi', 0),
(59, 'zh-hans', 'Chinese (Simplified)', 1, 0, 'zh_CN', 'zh-hans', 0),
(60, 'zu', 'Zulu', 0, 0, '', 'zu', 0),
(61, 'zh-hant', 'Chinese (Traditional)', 1, 0, 'zh_TW', 'zh-hant', 0),
(62, 'ms', 'Malay', 0, 0, 'ms_MY', 'ms', 0),
(63, 'gl', 'Galician', 0, 0, 'gl_ES', 'gl', 0),
(64, 'bn', 'Bengali', 0, 0, 'bn_BD', 'bn', 0);

CREATE TABLE `wp_icl_languages_translations` (
  `id` int NOT NULL,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `display_language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_icl_languages_translations` (`id`, `language_code`, `display_language_code`, `name`) VALUES
(1, 'en', 'en', 'English'),
(2, 'en', 'es', 'Inglés'),
(3, 'en', 'de', 'Englisch'),
(4, 'en', 'fr', 'Anglais'),
(5, 'en', 'ar', 'الإنجليزية'),
(6, 'en', 'bs', 'English'),
(7, 'en', 'bg', 'Английски'),
(8, 'en', 'ca', 'English'),
(9, 'en', 'cs', 'Angličtina'),
(10, 'en', 'sk', 'Angličtina'),
(11, 'en', 'cy', 'English'),
(12, 'en', 'da', 'English'),
(13, 'en', 'el', 'Αγγλικα'),
(14, 'en', 'eo', 'English'),
(15, 'en', 'et', 'English'),
(16, 'en', 'eu', 'English'),
(17, 'en', 'fa', 'English'),
(18, 'en', 'fi', 'englanti'),
(19, 'en', 'ga', 'English'),
(20, 'en', 'he', 'אנגלית'),
(21, 'en', 'hi', 'English'),
(22, 'en', 'hr', 'Engleski'),
(23, 'en', 'hu', 'angol'),
(24, 'en', 'hy', 'English'),
(25, 'en', 'id', 'English'),
(26, 'en', 'is', 'English'),
(27, 'en', 'it', 'Inglese'),
(28, 'en', 'ja', '英語'),
(29, 'en', 'ko', '영어'),
(30, 'en', 'ku', 'English'),
(31, 'en', 'lv', 'English'),
(32, 'en', 'lt', 'English'),
(33, 'en', 'mk', 'English'),
(34, 'en', 'mt', 'English'),
(35, 'en', 'mn', 'English'),
(36, 'en', 'ne', 'English'),
(37, 'en', 'nl', 'Engels'),
(38, 'en', 'no', 'Engelsk'),
(39, 'en', 'pa', 'English'),
(40, 'en', 'pl', 'angielski'),
(41, 'en', 'pt-pt', 'Inglês'),
(42, 'en', 'pt-br', 'Inglês'),
(43, 'en', 'qu', 'English'),
(44, 'en', 'ro', 'Engleză'),
(45, 'en', 'ru', 'Английский'),
(46, 'en', 'sl', 'Angleščina'),
(47, 'en', 'so', 'English'),
(48, 'en', 'sq', 'English'),
(49, 'en', 'sr', 'енглески'),
(50, 'en', 'sv', 'Engelska'),
(51, 'en', 'ta', 'English'),
(52, 'en', 'th', 'อังกฤษ'),
(53, 'en', 'tr', 'İngilizce'),
(54, 'en', 'uk', 'English'),
(55, 'en', 'ur', 'English'),
(56, 'en', 'uz', 'English'),
(57, 'en', 'vi', 'English'),
(58, 'en', 'yi', 'English'),
(59, 'en', 'zh-hans', '英语'),
(60, 'en', 'zu', 'English'),
(61, 'en', 'zh-hant', '英語'),
(62, 'en', 'ms', 'English'),
(63, 'en', 'gl', 'English'),
(64, 'en', 'bn', 'English'),
(65, 'es', 'en', 'Spanish'),
(66, 'es', 'es', 'Español'),
(67, 'es', 'de', 'Spanisch'),
(68, 'es', 'fr', 'Espagnol'),
(69, 'es', 'ar', 'الأسبانية'),
(70, 'es', 'bs', 'Spanish'),
(71, 'es', 'bg', 'Испански'),
(72, 'es', 'ca', 'Spanish'),
(73, 'es', 'cs', 'Španělský'),
(74, 'es', 'sk', 'Španielčina'),
(75, 'es', 'cy', 'Spanish'),
(76, 'es', 'da', 'Spanish'),
(77, 'es', 'el', 'Ισπανικα'),
(78, 'es', 'eo', 'Spanish'),
(79, 'es', 'et', 'Spanish'),
(80, 'es', 'eu', 'Spanish'),
(81, 'es', 'fa', 'Spanish'),
(82, 'es', 'fi', 'espanja'),
(83, 'es', 'ga', 'Spanish'),
(84, 'es', 'he', 'ספרדית'),
(85, 'es', 'hi', 'Spanish'),
(86, 'es', 'hr', 'španjolski'),
(87, 'es', 'hu', 'spanyol'),
(88, 'es', 'hy', 'Spanish'),
(89, 'es', 'id', 'Spanish'),
(90, 'es', 'is', 'Spanish'),
(91, 'es', 'it', 'Spagnolo'),
(92, 'es', 'ja', 'スペイン語'),
(93, 'es', 'ko', '스페인어'),
(94, 'es', 'ku', 'Spanish'),
(95, 'es', 'lv', 'Spanish'),
(96, 'es', 'lt', 'Spanish'),
(97, 'es', 'mk', 'Spanish'),
(98, 'es', 'mt', 'Spanish'),
(99, 'es', 'mn', 'Spanish'),
(100, 'es', 'ne', 'Spanish'),
(101, 'es', 'nl', 'Spaans'),
(102, 'es', 'no', 'Spansk'),
(103, 'es', 'pa', 'Spanish'),
(104, 'es', 'pl', 'hiszpański'),
(105, 'es', 'pt-pt', 'Espanhol'),
(106, 'es', 'pt-br', 'Espanhol'),
(107, 'es', 'qu', 'Spanish'),
(108, 'es', 'ro', 'Spaniolă'),
(109, 'es', 'ru', 'Испанский'),
(110, 'es', 'sl', 'Španščina'),
(111, 'es', 'so', 'Spanish'),
(112, 'es', 'sq', 'Spanish'),
(113, 'es', 'sr', 'шпански'),
(114, 'es', 'sv', 'Spanska'),
(115, 'es', 'ta', 'Spanish'),
(116, 'es', 'th', 'สเปน'),
(117, 'es', 'tr', 'İspanyolca'),
(118, 'es', 'uk', 'Spanish'),
(119, 'es', 'ur', 'Spanish'),
(120, 'es', 'uz', 'Spanish'),
(121, 'es', 'vi', 'Spanish'),
(122, 'es', 'yi', 'Spanish'),
(123, 'es', 'zh-hans', '西班牙语'),
(124, 'es', 'zu', 'Spanish'),
(125, 'es', 'zh-hant', '西班牙語'),
(126, 'es', 'ms', 'Spanish'),
(127, 'es', 'gl', 'Spanish'),
(128, 'es', 'bn', 'Spanish'),
(129, 'de', 'en', 'German'),
(130, 'de', 'es', 'Alemán'),
(131, 'de', 'de', 'Deutsch'),
(132, 'de', 'fr', 'Allemand'),
(133, 'de', 'ar', 'الألمانية'),
(134, 'de', 'bs', 'German'),
(135, 'de', 'bg', 'Немски'),
(136, 'de', 'ca', 'German'),
(137, 'de', 'cs', 'Němec'),
(138, 'de', 'sk', 'Nemčina'),
(139, 'de', 'cy', 'German'),
(140, 'de', 'da', 'German'),
(141, 'de', 'el', 'Γερμανικα'),
(142, 'de', 'eo', 'German'),
(143, 'de', 'et', 'German'),
(144, 'de', 'eu', 'German'),
(145, 'de', 'fa', 'German'),
(146, 'de', 'fi', 'saksa'),
(147, 'de', 'ga', 'German'),
(148, 'de', 'he', 'גרמנית'),
(149, 'de', 'hi', 'German'),
(150, 'de', 'hr', 'Njemački'),
(151, 'de', 'hu', 'német'),
(152, 'de', 'hy', 'German'),
(153, 'de', 'id', 'German'),
(154, 'de', 'is', 'German'),
(155, 'de', 'it', 'Tedesco'),
(156, 'de', 'ja', 'ドイツ語'),
(157, 'de', 'ko', '독어'),
(158, 'de', 'ku', 'German'),
(159, 'de', 'lv', 'German'),
(160, 'de', 'lt', 'German'),
(161, 'de', 'mk', 'German'),
(162, 'de', 'mt', 'German'),
(163, 'de', 'mn', 'German'),
(164, 'de', 'ne', 'German'),
(165, 'de', 'nl', 'Duits'),
(166, 'de', 'no', 'Tysk'),
(167, 'de', 'pa', 'German'),
(168, 'de', 'pl', 'niemiecki'),
(169, 'de', 'pt-pt', 'Alemão'),
(170, 'de', 'pt-br', 'Alemão'),
(171, 'de', 'qu', 'German'),
(172, 'de', 'ro', 'Germană'),
(173, 'de', 'ru', 'Немецкий'),
(174, 'de', 'sl', 'Nemščina'),
(175, 'de', 'so', 'German'),
(176, 'de', 'sq', 'German'),
(177, 'de', 'sr', 'немачки'),
(178, 'de', 'sv', 'Tyska'),
(179, 'de', 'ta', 'German'),
(180, 'de', 'th', 'เยอรมัน'),
(181, 'de', 'tr', 'Almanca'),
(182, 'de', 'uk', 'German'),
(183, 'de', 'ur', 'German'),
(184, 'de', 'uz', 'German'),
(185, 'de', 'vi', 'German'),
(186, 'de', 'yi', 'German'),
(187, 'de', 'zh-hans', '德语'),
(188, 'de', 'zu', 'German'),
(189, 'de', 'zh-hant', '德語'),
(190, 'de', 'ms', 'German'),
(191, 'de', 'gl', 'German'),
(192, 'de', 'bn', 'German'),
(193, 'fr', 'en', 'French'),
(194, 'fr', 'es', 'Francés'),
(195, 'fr', 'de', 'Französisch'),
(196, 'fr', 'fr', 'Français'),
(197, 'fr', 'ar', 'الفرنسية'),
(198, 'fr', 'bs', 'French'),
(199, 'fr', 'bg', 'Френски'),
(200, 'fr', 'ca', 'French'),
(201, 'fr', 'cs', 'Francouzština'),
(202, 'fr', 'sk', 'Francúzština'),
(203, 'fr', 'cy', 'French'),
(204, 'fr', 'da', 'French'),
(205, 'fr', 'el', 'Γαλλικα'),
(206, 'fr', 'eo', 'French'),
(207, 'fr', 'et', 'French'),
(208, 'fr', 'eu', 'French'),
(209, 'fr', 'fa', 'French'),
(210, 'fr', 'fi', 'ranska'),
(211, 'fr', 'ga', 'French'),
(212, 'fr', 'he', 'צרפתית'),
(213, 'fr', 'hi', 'French'),
(214, 'fr', 'hr', 'Francuzi'),
(215, 'fr', 'hu', 'francia'),
(216, 'fr', 'hy', 'French'),
(217, 'fr', 'id', 'French'),
(218, 'fr', 'is', 'French'),
(219, 'fr', 'it', 'Francese'),
(220, 'fr', 'ja', 'フランス語'),
(221, 'fr', 'ko', '불어'),
(222, 'fr', 'ku', 'French'),
(223, 'fr', 'lv', 'French'),
(224, 'fr', 'lt', 'French'),
(225, 'fr', 'mk', 'French'),
(226, 'fr', 'mt', 'French'),
(227, 'fr', 'mn', 'French'),
(228, 'fr', 'ne', 'French'),
(229, 'fr', 'nl', 'Frans'),
(230, 'fr', 'no', 'Fransk'),
(231, 'fr', 'pa', 'French'),
(232, 'fr', 'pl', 'francuski'),
(233, 'fr', 'pt-pt', 'Francês'),
(234, 'fr', 'pt-br', 'Francês'),
(235, 'fr', 'qu', 'French'),
(236, 'fr', 'ro', 'Franceză'),
(237, 'fr', 'ru', 'Французский'),
(238, 'fr', 'sl', 'Francoščina'),
(239, 'fr', 'so', 'French'),
(240, 'fr', 'sq', 'French'),
(241, 'fr', 'sr', 'француски'),
(242, 'fr', 'sv', 'Franska'),
(243, 'fr', 'ta', 'French'),
(244, 'fr', 'th', 'ฝรั่งเศส'),
(245, 'fr', 'tr', 'Fransızca'),
(246, 'fr', 'uk', 'French'),
(247, 'fr', 'ur', 'French'),
(248, 'fr', 'uz', 'French'),
(249, 'fr', 'vi', 'French'),
(250, 'fr', 'yi', 'French'),
(251, 'fr', 'zh-hans', '法语'),
(252, 'fr', 'zu', 'French'),
(253, 'fr', 'zh-hant', '法語'),
(254, 'fr', 'ms', 'French'),
(255, 'fr', 'gl', 'French'),
(256, 'fr', 'bn', 'French'),
(257, 'ar', 'en', 'Arabic'),
(258, 'ar', 'es', 'Árabe'),
(259, 'ar', 'de', 'Arabisch'),
(260, 'ar', 'fr', 'Arabe'),
(261, 'ar', 'ar', 'العربية'),
(262, 'ar', 'bs', 'Arabic'),
(263, 'ar', 'bg', 'Арабски'),
(264, 'ar', 'ca', 'Arabic'),
(265, 'ar', 'cs', 'Arabština'),
(266, 'ar', 'sk', 'Arabčina'),
(267, 'ar', 'cy', 'Arabic'),
(268, 'ar', 'da', 'Arabic'),
(269, 'ar', 'el', 'Αραβικα'),
(270, 'ar', 'eo', 'Arabic'),
(271, 'ar', 'et', 'Arabic'),
(272, 'ar', 'eu', 'Arabic'),
(273, 'ar', 'fa', 'Arabic'),
(274, 'ar', 'fi', 'arabia'),
(275, 'ar', 'ga', 'Arabic'),
(276, 'ar', 'he', 'ערבית'),
(277, 'ar', 'hi', 'Arabic'),
(278, 'ar', 'hr', 'Arapski'),
(279, 'ar', 'hu', 'arab'),
(280, 'ar', 'hy', 'Arabic'),
(281, 'ar', 'id', 'Arabic'),
(282, 'ar', 'is', 'Arabic'),
(283, 'ar', 'it', 'Arabo'),
(284, 'ar', 'ja', 'アラビア語'),
(285, 'ar', 'ko', '아랍어'),
(286, 'ar', 'ku', 'Arabic'),
(287, 'ar', 'lv', 'Arabic'),
(288, 'ar', 'lt', 'Arabic'),
(289, 'ar', 'mk', 'Arabic'),
(290, 'ar', 'mt', 'Arabic'),
(291, 'ar', 'mn', 'Arabic'),
(292, 'ar', 'ne', 'Arabic'),
(293, 'ar', 'nl', 'Arabisch'),
(294, 'ar', 'no', 'Arabisk'),
(295, 'ar', 'pa', 'Arabic'),
(296, 'ar', 'pl', 'arabski'),
(297, 'ar', 'pt-pt', 'Árabe'),
(298, 'ar', 'pt-br', 'Árabe'),
(299, 'ar', 'qu', 'Arabic'),
(300, 'ar', 'ro', 'Arabică'),
(301, 'ar', 'ru', 'Арабский'),
(302, 'ar', 'sl', 'Arabščina'),
(303, 'ar', 'so', 'Arabic'),
(304, 'ar', 'sq', 'Arabic'),
(305, 'ar', 'sr', 'арапски'),
(306, 'ar', 'sv', 'Arabiska'),
(307, 'ar', 'ta', 'Arabic'),
(308, 'ar', 'th', 'อารบิก'),
(309, 'ar', 'tr', 'Arapça'),
(310, 'ar', 'uk', 'Arabic'),
(311, 'ar', 'ur', 'Arabic'),
(312, 'ar', 'uz', 'Arabic'),
(313, 'ar', 'vi', 'Arabic'),
(314, 'ar', 'yi', 'Arabic'),
(315, 'ar', 'zh-hans', '阿拉伯语'),
(316, 'ar', 'zu', 'Arabic'),
(317, 'ar', 'zh-hant', '阿拉伯語'),
(318, 'ar', 'ms', 'Arabic'),
(319, 'ar', 'gl', 'Arabic'),
(320, 'ar', 'bn', 'Arabic'),
(321, 'bs', 'en', 'Bosnian'),
(322, 'bs', 'es', 'Bosnio'),
(323, 'bs', 'de', 'Bosnisch'),
(324, 'bs', 'fr', 'Bosnien'),
(325, 'bs', 'ar', 'البوسنية'),
(326, 'bs', 'bs', 'Bosnian'),
(327, 'bs', 'bg', 'Босненски'),
(328, 'bs', 'ca', 'Bosnian'),
(329, 'bs', 'cs', 'Bosenština'),
(330, 'bs', 'sk', 'Bosniačtina'),
(331, 'bs', 'cy', 'Bosnian'),
(332, 'bs', 'da', 'Bosnian'),
(333, 'bs', 'el', 'Βοσνιακα'),
(334, 'bs', 'eo', 'Bosnian'),
(335, 'bs', 'et', 'Bosnian'),
(336, 'bs', 'eu', 'Bosnian'),
(337, 'bs', 'fa', 'Bosnian'),
(338, 'bs', 'fi', 'bosnia'),
(339, 'bs', 'ga', 'Bosnian'),
(340, 'bs', 'he', 'בוסנית'),
(341, 'bs', 'hi', 'Bosnian'),
(342, 'bs', 'hr', 'Bosanski'),
(343, 'bs', 'hu', 'bosnyák'),
(344, 'bs', 'hy', 'Bosnian'),
(345, 'bs', 'id', 'Bosnian'),
(346, 'bs', 'is', 'Bosnian'),
(347, 'bs', 'it', 'Bosniaco'),
(348, 'bs', 'ja', 'ボスニア語'),
(349, 'bs', 'ko', '보즈니아어'),
(350, 'bs', 'ku', 'Bosnian'),
(351, 'bs', 'lv', 'Bosnian'),
(352, 'bs', 'lt', 'Bosnian'),
(353, 'bs', 'mk', 'Bosnian'),
(354, 'bs', 'mt', 'Bosnian'),
(355, 'bs', 'mn', 'Bosnian'),
(356, 'bs', 'ne', 'Bosnian'),
(357, 'bs', 'nl', 'Bosnisch'),
(358, 'bs', 'no', 'Bosnisk'),
(359, 'bs', 'pa', 'Bosnian'),
(360, 'bs', 'pl', 'bośniacki'),
(361, 'bs', 'pt-pt', 'Bósnio'),
(362, 'bs', 'pt-br', 'Bósnio'),
(363, 'bs', 'qu', 'Bosnian'),
(364, 'bs', 'ro', 'Bosniacă'),
(365, 'bs', 'ru', 'Боснийский'),
(366, 'bs', 'sl', 'Bosanski'),
(367, 'bs', 'so', 'Bosnian'),
(368, 'bs', 'sq', 'Bosnian'),
(369, 'bs', 'sr', 'босански'),
(370, 'bs', 'sv', 'Bosniska'),
(371, 'bs', 'ta', 'Bosnian'),
(372, 'bs', 'th', 'บอสเนียน'),
(373, 'bs', 'tr', 'Boşnakça'),
(374, 'bs', 'uk', 'Bosnian'),
(375, 'bs', 'ur', 'Bosnian'),
(376, 'bs', 'uz', 'Bosnian'),
(377, 'bs', 'vi', 'Bosnian'),
(378, 'bs', 'yi', 'Bosnian'),
(379, 'bs', 'zh-hans', '波斯尼亚语'),
(380, 'bs', 'zu', 'Bosnian'),
(381, 'bs', 'zh-hant', '波士尼亞語'),
(382, 'bs', 'ms', 'Bosnian'),
(383, 'bs', 'gl', 'Bosnian'),
(384, 'bs', 'bn', 'Bosnian'),
(385, 'bg', 'en', 'Bulgarian'),
(386, 'bg', 'es', 'Búlgaro'),
(387, 'bg', 'de', 'Bulgarisch'),
(388, 'bg', 'fr', 'Bulgare'),
(389, 'bg', 'ar', 'البلغارية'),
(390, 'bg', 'bs', 'Bulgarian'),
(391, 'bg', 'bg', 'Български'),
(392, 'bg', 'ca', 'Bulgarian'),
(393, 'bg', 'cs', 'Bulharština'),
(394, 'bg', 'sk', 'Bulharčina'),
(395, 'bg', 'cy', 'Bulgarian'),
(396, 'bg', 'da', 'Bulgarian'),
(397, 'bg', 'el', 'Βουλγαρικα'),
(398, 'bg', 'eo', 'Bulgarian'),
(399, 'bg', 'et', 'Bulgarian'),
(400, 'bg', 'eu', 'Bulgarian'),
(401, 'bg', 'fa', 'Bulgarian'),
(402, 'bg', 'fi', 'bulgaria'),
(403, 'bg', 'ga', 'Bulgarian'),
(404, 'bg', 'he', 'בולגרית'),
(405, 'bg', 'hi', 'Bulgarian'),
(406, 'bg', 'hr', 'Bugarski'),
(407, 'bg', 'hu', 'bolgár'),
(408, 'bg', 'hy', 'Bulgarian'),
(409, 'bg', 'id', 'Bulgarian'),
(410, 'bg', 'is', 'Bulgarian'),
(411, 'bg', 'it', 'Bulgaro'),
(412, 'bg', 'ja', 'ブルガリア語'),
(413, 'bg', 'ko', '불가리아어'),
(414, 'bg', 'ku', 'Bulgarian'),
(415, 'bg', 'lv', 'Bulgarian'),
(416, 'bg', 'lt', 'Bulgarian'),
(417, 'bg', 'mk', 'Bulgarian'),
(418, 'bg', 'mt', 'Bulgarian'),
(419, 'bg', 'mn', 'Bulgarian'),
(420, 'bg', 'ne', 'Bulgarian'),
(421, 'bg', 'nl', 'Bulgaars'),
(422, 'bg', 'no', 'Bulgarian'),
(423, 'bg', 'pa', 'Bulgarian'),
(424, 'bg', 'pl', 'bułgarski'),
(425, 'bg', 'pt-pt', 'Búlgaro'),
(426, 'bg', 'pt-br', 'Búlgaro'),
(427, 'bg', 'qu', 'Bulgarian'),
(428, 'bg', 'ro', 'Bulgară'),
(429, 'bg', 'ru', 'Болгарский'),
(430, 'bg', 'sl', 'Bolgarščina'),
(431, 'bg', 'so', 'Bulgarian'),
(432, 'bg', 'sq', 'Bulgarian'),
(433, 'bg', 'sr', 'бугарски'),
(434, 'bg', 'sv', 'Bulgariska'),
(435, 'bg', 'ta', 'Bulgarian'),
(436, 'bg', 'th', 'บัลแกเรียน'),
(437, 'bg', 'tr', 'Bulgarca'),
(438, 'bg', 'uk', 'Bulgarian'),
(439, 'bg', 'ur', 'Bulgarian'),
(440, 'bg', 'uz', 'Bulgarian'),
(441, 'bg', 'vi', 'Bulgarian'),
(442, 'bg', 'yi', 'Bulgarian'),
(443, 'bg', 'zh-hans', '保加利亚语'),
(444, 'bg', 'zu', 'Bulgarian'),
(445, 'bg', 'zh-hant', '保加利亞語'),
(446, 'bg', 'ms', 'Bulgarian'),
(447, 'bg', 'gl', 'Bulgarian'),
(448, 'bg', 'bn', 'Bulgarian'),
(449, 'ca', 'en', 'Catalan'),
(450, 'ca', 'es', 'Catalán'),
(451, 'ca', 'de', 'Katalanisch'),
(452, 'ca', 'fr', 'Catalan'),
(453, 'ca', 'ar', 'الكاتالوينية'),
(454, 'ca', 'bs', 'Catalan'),
(455, 'ca', 'bg', 'Каталонски'),
(456, 'ca', 'ca', 'Català'),
(457, 'ca', 'cs', 'Katalánština'),
(458, 'ca', 'sk', 'Katalánčina'),
(459, 'ca', 'cy', 'Catalan'),
(460, 'ca', 'da', 'Catalan'),
(461, 'ca', 'el', 'Καταλανικα'),
(462, 'ca', 'eo', 'Catalan'),
(463, 'ca', 'et', 'Catalan'),
(464, 'ca', 'eu', 'Catalan'),
(465, 'ca', 'fa', 'Catalan'),
(466, 'ca', 'fi', 'katalaani'),
(467, 'ca', 'ga', 'Catalan'),
(468, 'ca', 'he', 'קטלאנית'),
(469, 'ca', 'hi', 'Catalan'),
(470, 'ca', 'hr', 'Katalonski'),
(471, 'ca', 'hu', 'katalán'),
(472, 'ca', 'hy', 'Catalan'),
(473, 'ca', 'id', 'Catalan'),
(474, 'ca', 'is', 'Catalan'),
(475, 'ca', 'it', 'Catalano'),
(476, 'ca', 'ja', 'カタルーニャ語'),
(477, 'ca', 'ko', '카탈로니아어'),
(478, 'ca', 'ku', 'Catalan'),
(479, 'ca', 'lv', 'Catalan'),
(480, 'ca', 'lt', 'Catalan'),
(481, 'ca', 'mk', 'Catalan'),
(482, 'ca', 'mt', 'Catalan'),
(483, 'ca', 'mn', 'Catalan'),
(484, 'ca', 'ne', 'Catalan'),
(485, 'ca', 'nl', 'Catalaans'),
(486, 'ca', 'no', 'catalan'),
(487, 'ca', 'pa', 'Catalan'),
(488, 'ca', 'pl', 'kataloński'),
(489, 'ca', 'pt-pt', 'Catalão'),
(490, 'ca', 'pt-br', 'Catalão'),
(491, 'ca', 'qu', 'Catalan'),
(492, 'ca', 'ro', 'Catalană'),
(493, 'ca', 'ru', 'Каталанский'),
(494, 'ca', 'sl', 'Katalonščina'),
(495, 'ca', 'so', 'Catalan'),
(496, 'ca', 'sq', 'Catalan'),
(497, 'ca', 'sr', 'каталонски'),
(498, 'ca', 'sv', 'Katalanska'),
(499, 'ca', 'ta', 'Catalan'),
(500, 'ca', 'th', 'คะตะลาน'),
(501, 'ca', 'tr', 'Katalan dili'),
(502, 'ca', 'uk', 'Catalan'),
(503, 'ca', 'ur', 'Catalan'),
(504, 'ca', 'uz', 'Catalan'),
(505, 'ca', 'vi', 'Catalan'),
(506, 'ca', 'yi', 'Catalan'),
(507, 'ca', 'zh-hans', '加泰罗尼亚语'),
(508, 'ca', 'zu', 'Catalan'),
(509, 'ca', 'zh-hant', '加泰羅尼亞語'),
(510, 'ca', 'ms', 'Catalan'),
(511, 'ca', 'gl', 'Catalan'),
(512, 'ca', 'bn', 'Catalan'),
(513, 'cs', 'en', 'Czech'),
(514, 'cs', 'es', 'Checo'),
(515, 'cs', 'de', 'Tschechisch'),
(516, 'cs', 'fr', 'Tchèque'),
(517, 'cs', 'ar', 'التشيكية'),
(518, 'cs', 'bs', 'Czech'),
(519, 'cs', 'bg', 'Чешки'),
(520, 'cs', 'ca', 'Czech'),
(521, 'cs', 'cs', 'Čeština'),
(522, 'cs', 'sk', 'Čeština'),
(523, 'cs', 'cy', 'Czech'),
(524, 'cs', 'da', 'Czech'),
(525, 'cs', 'el', 'Τσεχικη'),
(526, 'cs', 'eo', 'Czech'),
(527, 'cs', 'et', 'Czech'),
(528, 'cs', 'eu', 'Czech'),
(529, 'cs', 'fa', 'Czech'),
(530, 'cs', 'fi', 'tsekki'),
(531, 'cs', 'ga', 'Czech'),
(532, 'cs', 'he', 'צ\'כית'),
(533, 'cs', 'hi', 'Czech'),
(534, 'cs', 'hr', 'češki'),
(535, 'cs', 'hu', 'cseh'),
(536, 'cs', 'hy', 'Czech'),
(537, 'cs', 'id', 'Czech'),
(538, 'cs', 'is', 'Czech'),
(539, 'cs', 'it', 'Ceco'),
(540, 'cs', 'ja', 'チェコ語'),
(541, 'cs', 'ko', '체코슬로바키아어'),
(542, 'cs', 'ku', 'Czech'),
(543, 'cs', 'lv', 'Czech'),
(544, 'cs', 'lt', 'Czech'),
(545, 'cs', 'mk', 'Czech'),
(546, 'cs', 'mt', 'Czech'),
(547, 'cs', 'mn', 'Czech'),
(548, 'cs', 'ne', 'Czech'),
(549, 'cs', 'nl', 'Tsjechisch'),
(550, 'cs', 'no', 'Czech'),
(551, 'cs', 'pa', 'Czech'),
(552, 'cs', 'pl', 'czeski'),
(553, 'cs', 'pt-pt', 'Tcheco'),
(554, 'cs', 'pt-br', 'Tcheco'),
(555, 'cs', 'qu', 'Czech'),
(556, 'cs', 'ro', 'Cehă'),
(557, 'cs', 'ru', 'Чешский'),
(558, 'cs', 'sl', 'Češčina'),
(559, 'cs', 'so', 'Czech'),
(560, 'cs', 'sq', 'Czech'),
(561, 'cs', 'sr', 'чешки'),
(562, 'cs', 'sv', 'Tjeckiska'),
(563, 'cs', 'ta', 'Czech'),
(564, 'cs', 'th', 'เช็ก'),
(565, 'cs', 'tr', 'Çekçe'),
(566, 'cs', 'uk', 'Czech'),
(567, 'cs', 'ur', 'Czech'),
(568, 'cs', 'uz', 'Czech'),
(569, 'cs', 'vi', 'Czech'),
(570, 'cs', 'yi', 'Czech'),
(571, 'cs', 'zh-hans', '捷克语'),
(572, 'cs', 'zu', 'Czech'),
(573, 'cs', 'zh-hant', '捷克語'),
(574, 'cs', 'ms', 'Czech'),
(575, 'cs', 'gl', 'Czech'),
(576, 'cs', 'bn', 'Czech'),
(577, 'sk', 'en', 'Slovak'),
(578, 'sk', 'es', 'Eslavo'),
(579, 'sk', 'de', 'Slowakisch'),
(580, 'sk', 'fr', 'Slave'),
(581, 'sk', 'ar', 'السلافية'),
(582, 'sk', 'bs', 'Slovak'),
(583, 'sk', 'bg', 'Словашки'),
(584, 'sk', 'ca', 'Slovak'),
(585, 'sk', 'cs', 'Slovenština'),
(586, 'sk', 'sk', 'Slovenčina'),
(587, 'sk', 'cy', 'Slovak'),
(588, 'sk', 'da', 'Slovak'),
(589, 'sk', 'el', 'Σλαβικη'),
(590, 'sk', 'eo', 'Slovak'),
(591, 'sk', 'et', 'Slovak'),
(592, 'sk', 'eu', 'Slovak'),
(593, 'sk', 'fa', 'Slovak'),
(594, 'sk', 'fi', 'slaavi'),
(595, 'sk', 'ga', 'Slovak'),
(596, 'sk', 'he', 'סלאבית'),
(597, 'sk', 'hi', 'Slovak'),
(598, 'sk', 'hr', 'Slovak'),
(599, 'sk', 'hu', 'szláv'),
(600, 'sk', 'hy', 'Slovak'),
(601, 'sk', 'id', 'Slovak'),
(602, 'sk', 'is', 'Slovak'),
(603, 'sk', 'it', 'Slavo'),
(604, 'sk', 'ja', 'スラヴ語派'),
(605, 'sk', 'ko', '슬라브어'),
(606, 'sk', 'ku', 'Slovak'),
(607, 'sk', 'lv', 'Slovak'),
(608, 'sk', 'lt', 'Slovak'),
(609, 'sk', 'mk', 'Slovak'),
(610, 'sk', 'mt', 'Slovak'),
(611, 'sk', 'mn', 'Slovak'),
(612, 'sk', 'ne', 'Slovak'),
(613, 'sk', 'nl', 'Slavisch'),
(614, 'sk', 'no', 'Slovak'),
(615, 'sk', 'pa', 'Slovak'),
(616, 'sk', 'pl', 'słowacki'),
(617, 'sk', 'pt-pt', 'Eslavo'),
(618, 'sk', 'pt-br', 'Eslavo'),
(619, 'sk', 'qu', 'Slovak'),
(620, 'sk', 'ro', 'Slavă'),
(621, 'sk', 'ru', 'Славянский'),
(622, 'sk', 'sl', 'Slovaščina'),
(623, 'sk', 'so', 'Slovak'),
(624, 'sk', 'sq', 'Slovak'),
(625, 'sk', 'sr', 'словачки'),
(626, 'sk', 'sv', 'Slavisk'),
(627, 'sk', 'ta', 'Slovak'),
(628, 'sk', 'th', 'สลาวิก'),
(629, 'sk', 'tr', 'Slav dili'),
(630, 'sk', 'uk', 'Slovak'),
(631, 'sk', 'ur', 'Slovak'),
(632, 'sk', 'uz', 'Slovak'),
(633, 'sk', 'vi', 'Slovak'),
(634, 'sk', 'yi', 'Slovak'),
(635, 'sk', 'zh-hans', '斯拉夫语'),
(636, 'sk', 'zu', 'Slovak'),
(637, 'sk', 'zh-hant', '斯拉夫語'),
(638, 'sk', 'ms', 'Slovak'),
(639, 'sk', 'gl', 'Slovak'),
(640, 'sk', 'bn', 'Slovak'),
(641, 'cy', 'en', 'Welsh'),
(642, 'cy', 'es', 'Galés'),
(643, 'cy', 'de', 'Walisisch'),
(644, 'cy', 'fr', 'Gallois'),
(645, 'cy', 'ar', 'الولزية'),
(646, 'cy', 'bs', 'Welsh'),
(647, 'cy', 'bg', 'Уелски'),
(648, 'cy', 'ca', 'Welsh'),
(649, 'cy', 'cs', 'Velšský'),
(650, 'cy', 'sk', 'Welština'),
(651, 'cy', 'cy', 'Cymraeg'),
(652, 'cy', 'da', 'Welsh'),
(653, 'cy', 'el', 'Welsh'),
(654, 'cy', 'eo', 'Welsh'),
(655, 'cy', 'et', 'Welsh'),
(656, 'cy', 'eu', 'Welsh'),
(657, 'cy', 'fa', 'Welsh'),
(658, 'cy', 'fi', 'kymri'),
(659, 'cy', 'ga', 'Welsh'),
(660, 'cy', 'he', 'וולשית'),
(661, 'cy', 'hi', 'Welsh'),
(662, 'cy', 'hr', 'Velški'),
(663, 'cy', 'hu', 'vels'),
(664, 'cy', 'hy', 'Welsh'),
(665, 'cy', 'id', 'Welsh'),
(666, 'cy', 'is', 'Welsh'),
(667, 'cy', 'it', 'Gallese'),
(668, 'cy', 'ja', 'ウェールズ語'),
(669, 'cy', 'ko', '웨일즈어'),
(670, 'cy', 'ku', 'Welsh'),
(671, 'cy', 'lv', 'Welsh'),
(672, 'cy', 'lt', 'Welsh'),
(673, 'cy', 'mk', 'Welsh'),
(674, 'cy', 'mt', 'Welsh'),
(675, 'cy', 'mn', 'Welsh'),
(676, 'cy', 'ne', 'Welsh'),
(677, 'cy', 'nl', 'Welsh'),
(678, 'cy', 'no', 'Welsh'),
(679, 'cy', 'pa', 'Welsh'),
(680, 'cy', 'pl', 'walijski'),
(681, 'cy', 'pt-pt', 'Galês'),
(682, 'cy', 'pt-br', 'Galês'),
(683, 'cy', 'qu', 'Welsh'),
(684, 'cy', 'ro', 'Galeză'),
(685, 'cy', 'ru', 'Валлийский'),
(686, 'cy', 'sl', 'Welsh'),
(687, 'cy', 'so', 'Welsh'),
(688, 'cy', 'sq', 'Welsh'),
(689, 'cy', 'sr', 'велшки'),
(690, 'cy', 'sv', 'Walesiska'),
(691, 'cy', 'ta', 'Welsh'),
(692, 'cy', 'th', 'เวลช์'),
(693, 'cy', 'tr', 'Galce'),
(694, 'cy', 'uk', 'Welsh'),
(695, 'cy', 'ur', 'Welsh'),
(696, 'cy', 'uz', 'Welsh'),
(697, 'cy', 'vi', 'Welsh'),
(698, 'cy', 'yi', 'Welsh'),
(699, 'cy', 'zh-hans', '威尔士语'),
(700, 'cy', 'zu', 'Welsh'),
(701, 'cy', 'zh-hant', '威爾士語'),
(702, 'cy', 'ms', 'Welsh'),
(703, 'cy', 'gl', 'Welsh'),
(704, 'cy', 'bn', 'Welsh'),
(705, 'da', 'en', 'Danish'),
(706, 'da', 'es', 'Danés'),
(707, 'da', 'de', 'Dänisch'),
(708, 'da', 'fr', 'Danois'),
(709, 'da', 'ar', 'الدانماركية'),
(710, 'da', 'bs', 'Danish'),
(711, 'da', 'bg', 'Датски'),
(712, 'da', 'ca', 'Danish'),
(713, 'da', 'cs', 'Dánský'),
(714, 'da', 'sk', 'Dánčina'),
(715, 'da', 'cy', 'Danish'),
(716, 'da', 'da', 'Dansk'),
(717, 'da', 'el', 'Δανεζικα'),
(718, 'da', 'eo', 'Danish'),
(719, 'da', 'et', 'Danish'),
(720, 'da', 'eu', 'Danish'),
(721, 'da', 'fa', 'Danish'),
(722, 'da', 'fi', 'tanska'),
(723, 'da', 'ga', 'Danish'),
(724, 'da', 'he', 'דנית'),
(725, 'da', 'hi', 'Danish'),
(726, 'da', 'hr', 'Danski'),
(727, 'da', 'hu', 'dán'),
(728, 'da', 'hy', 'Danish'),
(729, 'da', 'id', 'Danish'),
(730, 'da', 'is', 'Danish'),
(731, 'da', 'it', 'Danese'),
(732, 'da', 'ja', 'デンマーク語'),
(733, 'da', 'ko', '덴마크어'),
(734, 'da', 'ku', 'Danish'),
(735, 'da', 'lv', 'Danish'),
(736, 'da', 'lt', 'Danish'),
(737, 'da', 'mk', 'Danish'),
(738, 'da', 'mt', 'Danish'),
(739, 'da', 'mn', 'Danish'),
(740, 'da', 'ne', 'Danish'),
(741, 'da', 'nl', 'Deens'),
(742, 'da', 'no', 'Danish'),
(743, 'da', 'pa', 'Danish'),
(744, 'da', 'pl', 'duński'),
(745, 'da', 'pt-pt', 'Dinamarquês'),
(746, 'da', 'pt-br', 'Dinamarquês'),
(747, 'da', 'qu', 'Danish'),
(748, 'da', 'ro', 'Daneză'),
(749, 'da', 'ru', 'Датский'),
(750, 'da', 'sl', 'Danščina'),
(751, 'da', 'so', 'Danish'),
(752, 'da', 'sq', 'Danish'),
(753, 'da', 'sr', 'дански'),
(754, 'da', 'sv', 'Danska'),
(755, 'da', 'ta', 'Danish'),
(756, 'da', 'th', 'เดนมาร์ก'),
(757, 'da', 'tr', 'Danca'),
(758, 'da', 'uk', 'Danish'),
(759, 'da', 'ur', 'Danish'),
(760, 'da', 'uz', 'Danish'),
(761, 'da', 'vi', 'Danish'),
(762, 'da', 'yi', 'Danish'),
(763, 'da', 'zh-hans', '丹麦语'),
(764, 'da', 'zu', 'Danish'),
(765, 'da', 'zh-hant', '丹麥語'),
(766, 'da', 'ms', 'Danish'),
(767, 'da', 'gl', 'Danish'),
(768, 'da', 'bn', 'Danish'),
(769, 'el', 'en', 'Greek'),
(770, 'el', 'es', 'Griego'),
(771, 'el', 'de', 'Griechisch'),
(772, 'el', 'fr', 'Grec moderne'),
(773, 'el', 'ar', 'اليونانية'),
(774, 'el', 'bs', 'Greek'),
(775, 'el', 'bg', 'Гръцки'),
(776, 'el', 'ca', 'Greek'),
(777, 'el', 'cs', 'Řečtina'),
(778, 'el', 'sk', 'Gréčtina'),
(779, 'el', 'cy', 'Greek'),
(780, 'el', 'da', 'Greek'),
(781, 'el', 'el', 'Ελληνικα'),
(782, 'el', 'eo', 'Greek'),
(783, 'el', 'et', 'Greek'),
(784, 'el', 'eu', 'Greek'),
(785, 'el', 'fa', 'Greek'),
(786, 'el', 'fi', 'kreikka'),
(787, 'el', 'ga', 'Greek'),
(788, 'el', 'he', 'יוונית'),
(789, 'el', 'hi', 'Greek'),
(790, 'el', 'hr', 'Grčki'),
(791, 'el', 'hu', 'görög'),
(792, 'el', 'hy', 'Greek'),
(793, 'el', 'id', 'Greek'),
(794, 'el', 'is', 'Greek'),
(795, 'el', 'it', 'Greco'),
(796, 'el', 'ja', 'ギリシア語'),
(797, 'el', 'ko', '그리스어'),
(798, 'el', 'ku', 'Greek'),
(799, 'el', 'lv', 'Greek'),
(800, 'el', 'lt', 'Greek'),
(801, 'el', 'mk', 'Greek'),
(802, 'el', 'mt', 'Greek'),
(803, 'el', 'mn', 'Greek'),
(804, 'el', 'ne', 'Greek'),
(805, 'el', 'nl', 'Grieks'),
(806, 'el', 'no', 'Gresk'),
(807, 'el', 'pa', 'Greek'),
(808, 'el', 'pl', 'grecki'),
(809, 'el', 'pt-pt', 'Grego'),
(810, 'el', 'pt-br', 'Grego'),
(811, 'el', 'qu', 'Greek'),
(812, 'el', 'ro', 'Greacă'),
(813, 'el', 'ru', 'Греческий'),
(814, 'el', 'sl', 'Greek'),
(815, 'el', 'so', 'Greek'),
(816, 'el', 'sq', 'Greek'),
(817, 'el', 'sr', 'грчки'),
(818, 'el', 'sv', 'Grekiska'),
(819, 'el', 'ta', 'Greek'),
(820, 'el', 'th', 'กรีก'),
(821, 'el', 'tr', 'Yunanca'),
(822, 'el', 'uk', 'Greek'),
(823, 'el', 'ur', 'Greek'),
(824, 'el', 'uz', 'Greek'),
(825, 'el', 'vi', 'Greek'),
(826, 'el', 'yi', 'Greek'),
(827, 'el', 'zh-hans', '希腊语'),
(828, 'el', 'zu', 'Greek'),
(829, 'el', 'zh-hant', '希臘語'),
(830, 'el', 'ms', 'Greek'),
(831, 'el', 'gl', 'Greek'),
(832, 'el', 'bn', 'Greek'),
(833, 'eo', 'en', 'Esperanto'),
(834, 'eo', 'es', 'Esperanto'),
(835, 'eo', 'de', 'Esperanto'),
(836, 'eo', 'fr', 'Espéranto'),
(837, 'eo', 'ar', 'الاسبرانتو'),
(838, 'eo', 'bs', 'Esperanto'),
(839, 'eo', 'bg', 'Есперанто'),
(840, 'eo', 'ca', 'Esperanto'),
(841, 'eo', 'cs', 'Esperanto'),
(842, 'eo', 'sk', 'Esperanto'),
(843, 'eo', 'cy', 'Esperanto'),
(844, 'eo', 'da', 'Esperanto'),
(845, 'eo', 'el', 'Εσπεραντο'),
(846, 'eo', 'eo', 'Esperanta'),
(847, 'eo', 'et', 'Esperanto'),
(848, 'eo', 'eu', 'Esperanto'),
(849, 'eo', 'fa', 'Esperanto'),
(850, 'eo', 'fi', 'esperanto'),
(851, 'eo', 'ga', 'Esperanto'),
(852, 'eo', 'he', 'אספרנטו'),
(853, 'eo', 'hi', 'Esperanto'),
(854, 'eo', 'hr', 'Esperanto'),
(855, 'eo', 'hu', 'eszperantó'),
(856, 'eo', 'hy', 'Esperanto'),
(857, 'eo', 'id', 'Esperanto'),
(858, 'eo', 'is', 'Esperanto'),
(859, 'eo', 'it', 'Esperanto'),
(860, 'eo', 'ja', 'エスペラント語'),
(861, 'eo', 'ko', '에스페란토어'),
(862, 'eo', 'ku', 'Esperanto'),
(863, 'eo', 'lv', 'Esperanto'),
(864, 'eo', 'lt', 'Esperanto'),
(865, 'eo', 'mk', 'Esperanto'),
(866, 'eo', 'mt', 'Esperanto'),
(867, 'eo', 'mn', 'Esperanto'),
(868, 'eo', 'ne', 'Esperanto'),
(869, 'eo', 'nl', 'Esperanto'),
(870, 'eo', 'no', 'Esperanto'),
(871, 'eo', 'pa', 'Esperanto'),
(872, 'eo', 'pl', 'esperanto'),
(873, 'eo', 'pt-pt', 'Esperanto'),
(874, 'eo', 'pt-br', 'Esperanto'),
(875, 'eo', 'qu', 'Esperanto'),
(876, 'eo', 'ro', 'Esperanto'),
(877, 'eo', 'ru', 'Эсперанто'),
(878, 'eo', 'sl', 'Esperanto'),
(879, 'eo', 'so', 'Esperanto'),
(880, 'eo', 'sq', 'Esperanto'),
(881, 'eo', 'sr', 'есперанто'),
(882, 'eo', 'sv', 'Esperanto'),
(883, 'eo', 'ta', 'Esperanto'),
(884, 'eo', 'th', 'เอสเปอรันโต'),
(885, 'eo', 'tr', 'Esperanto'),
(886, 'eo', 'uk', 'Esperanto'),
(887, 'eo', 'ur', 'Esperanto'),
(888, 'eo', 'uz', 'Esperanto'),
(889, 'eo', 'vi', 'Esperanto'),
(890, 'eo', 'yi', 'Esperanto'),
(891, 'eo', 'zh-hans', '世界语'),
(892, 'eo', 'zu', 'Esperanto'),
(893, 'eo', 'zh-hant', '世界語'),
(894, 'eo', 'ms', 'Esperanto'),
(895, 'eo', 'gl', 'Esperanto'),
(896, 'eo', 'bn', 'Esperanto'),
(897, 'et', 'en', 'Estonian'),
(898, 'et', 'es', 'Estonio'),
(899, 'et', 'de', 'Estnisch'),
(900, 'et', 'fr', 'Estonien'),
(901, 'et', 'ar', 'الأستونية'),
(902, 'et', 'bs', 'Estonian'),
(903, 'et', 'bg', 'Естонски'),
(904, 'et', 'ca', 'Estonian'),
(905, 'et', 'cs', 'Estonština'),
(906, 'et', 'sk', 'Estónčina'),
(907, 'et', 'cy', 'Estonian'),
(908, 'et', 'da', 'Estonian'),
(909, 'et', 'el', 'Εσθονικα'),
(910, 'et', 'eo', 'Estonian'),
(911, 'et', 'et', 'Eesti'),
(912, 'et', 'eu', 'Estonian'),
(913, 'et', 'fa', 'Estonian'),
(914, 'et', 'fi', 'eesti'),
(915, 'et', 'ga', 'Estonian'),
(916, 'et', 'he', 'אסטונית'),
(917, 'et', 'hi', 'Estonian'),
(918, 'et', 'hr', 'Estonski'),
(919, 'et', 'hu', 'észt'),
(920, 'et', 'hy', 'Estonian'),
(921, 'et', 'id', 'Estonian'),
(922, 'et', 'is', 'Estonian'),
(923, 'et', 'it', 'Estone'),
(924, 'et', 'ja', 'エストニア語'),
(925, 'et', 'ko', '에스토니아어'),
(926, 'et', 'ku', 'Estonian'),
(927, 'et', 'lv', 'Estonian'),
(928, 'et', 'lt', 'Estonian'),
(929, 'et', 'mk', 'Estonian'),
(930, 'et', 'mt', 'Estonian'),
(931, 'et', 'mn', 'Estonian'),
(932, 'et', 'ne', 'Estonian'),
(933, 'et', 'nl', 'Ests'),
(934, 'et', 'no', 'Estonian'),
(935, 'et', 'pa', 'Estonian'),
(936, 'et', 'pl', 'estoński'),
(937, 'et', 'pt-pt', 'Estoniano'),
(938, 'et', 'pt-br', 'Estoniano'),
(939, 'et', 'qu', 'Estonian'),
(940, 'et', 'ro', 'Estoniană'),
(941, 'et', 'ru', 'Эстонский'),
(942, 'et', 'sl', 'Estonščina'),
(943, 'et', 'so', 'Estonian'),
(944, 'et', 'sq', 'Estonian'),
(945, 'et', 'sr', 'естонски'),
(946, 'et', 'sv', 'Estniska'),
(947, 'et', 'ta', 'Estonian'),
(948, 'et', 'th', 'เอสโตเนียน'),
(949, 'et', 'tr', 'Estonya dili'),
(950, 'et', 'uk', 'Estonian'),
(951, 'et', 'ur', 'Estonian'),
(952, 'et', 'uz', 'Estonian'),
(953, 'et', 'vi', 'Estonian'),
(954, 'et', 'yi', 'Estonian'),
(955, 'et', 'zh-hans', '爱沙尼亚语'),
(956, 'et', 'zu', 'Estonian'),
(957, 'et', 'zh-hant', '愛沙尼亞語'),
(958, 'et', 'ms', 'Estonian'),
(959, 'et', 'gl', 'Estonian'),
(960, 'et', 'bn', 'Estonian'),
(961, 'eu', 'en', 'Basque'),
(962, 'eu', 'es', 'Euskera'),
(963, 'eu', 'de', 'Baskisch'),
(964, 'eu', 'fr', 'Basque'),
(965, 'eu', 'ar', 'لغة الباسك'),
(966, 'eu', 'bs', 'Basque'),
(967, 'eu', 'bg', 'Баски'),
(968, 'eu', 'ca', 'Basque'),
(969, 'eu', 'cs', 'Basque'),
(970, 'eu', 'sk', 'Baskičtina'),
(971, 'eu', 'cy', 'Basque'),
(972, 'eu', 'da', 'Basque'),
(973, 'eu', 'el', 'Βασκικα'),
(974, 'eu', 'eo', 'Basque'),
(975, 'eu', 'et', 'Basque'),
(976, 'eu', 'eu', 'Euskara'),
(977, 'eu', 'fa', 'Basque'),
(978, 'eu', 'fi', 'baski'),
(979, 'eu', 'ga', 'Basque'),
(980, 'eu', 'he', 'בסקית'),
(981, 'eu', 'hi', 'Basque'),
(982, 'eu', 'hr', 'Baskijski'),
(983, 'eu', 'hu', 'baszk'),
(984, 'eu', 'hy', 'Basque'),
(985, 'eu', 'id', 'Basque'),
(986, 'eu', 'is', 'Basque'),
(987, 'eu', 'it', 'Basco'),
(988, 'eu', 'ja', 'バスク語'),
(989, 'eu', 'ko', '바스크어'),
(990, 'eu', 'ku', 'Basque'),
(991, 'eu', 'lv', 'Basque'),
(992, 'eu', 'lt', 'Basque'),
(993, 'eu', 'mk', 'Basque'),
(994, 'eu', 'mt', 'Basque'),
(995, 'eu', 'mn', 'Basque'),
(996, 'eu', 'ne', 'Basque'),
(997, 'eu', 'nl', 'Baskisch'),
(998, 'eu', 'no', 'Basque'),
(999, 'eu', 'pa', 'Basque'),
(1000, 'eu', 'pl', 'baskijski'),
(1001, 'eu', 'pt-pt', 'Basco'),
(1002, 'eu', 'pt-br', 'Basco'),
(1003, 'eu', 'qu', 'Basque'),
(1004, 'eu', 'ro', 'Bască'),
(1005, 'eu', 'ru', 'Баскский'),
(1006, 'eu', 'sl', 'Baskovščina'),
(1007, 'eu', 'so', 'Basque'),
(1008, 'eu', 'sq', 'Basque'),
(1009, 'eu', 'sr', 'баскијски'),
(1010, 'eu', 'sv', 'Baskiska'),
(1011, 'eu', 'ta', 'Basque'),
(1012, 'eu', 'th', 'บาสค์'),
(1013, 'eu', 'tr', 'Bask dili'),
(1014, 'eu', 'uk', 'Basque'),
(1015, 'eu', 'ur', 'Basque'),
(1016, 'eu', 'uz', 'Basque'),
(1017, 'eu', 'vi', 'Basque'),
(1018, 'eu', 'yi', 'Basque'),
(1019, 'eu', 'zh-hans', '巴斯克语'),
(1020, 'eu', 'zu', 'Basque'),
(1021, 'eu', 'zh-hant', '巴斯克語'),
(1022, 'eu', 'ms', 'Basque'),
(1023, 'eu', 'gl', 'Basque'),
(1024, 'eu', 'bn', 'Basque'),
(1025, 'fa', 'en', 'Persian'),
(1026, 'fa', 'es', 'Persa'),
(1027, 'fa', 'de', 'Persisch'),
(1028, 'fa', 'fr', 'Perse'),
(1029, 'fa', 'ar', 'الفارسية'),
(1030, 'fa', 'bs', 'Persian'),
(1031, 'fa', 'bg', 'Персийски'),
(1032, 'fa', 'ca', 'Persian'),
(1033, 'fa', 'cs', 'Perský'),
(1034, 'fa', 'sk', 'Perzština'),
(1035, 'fa', 'cy', 'Persian'),
(1036, 'fa', 'da', 'Persian'),
(1037, 'fa', 'el', 'Περσικος'),
(1038, 'fa', 'eo', 'Persian'),
(1039, 'fa', 'et', 'Persian'),
(1040, 'fa', 'eu', 'Persian'),
(1041, 'fa', 'fa', 'فارسی'),
(1042, 'fa', 'fi', 'persia'),
(1043, 'fa', 'ga', 'Persian'),
(1044, 'fa', 'he', 'פרסית'),
(1045, 'fa', 'hi', 'Persian'),
(1046, 'fa', 'hr', 'Perzijski'),
(1047, 'fa', 'hu', 'perzsa'),
(1048, 'fa', 'hy', 'Persian'),
(1049, 'fa', 'id', 'Persian'),
(1050, 'fa', 'is', 'Persian'),
(1051, 'fa', 'it', 'Persiano'),
(1052, 'fa', 'ja', 'ペルシア語'),
(1053, 'fa', 'ko', '페르시아어'),
(1054, 'fa', 'ku', 'Persian'),
(1055, 'fa', 'lv', 'Persian'),
(1056, 'fa', 'lt', 'Persian'),
(1057, 'fa', 'mk', 'Persian'),
(1058, 'fa', 'mt', 'Persian'),
(1059, 'fa', 'mn', 'Persian'),
(1060, 'fa', 'ne', 'Persian'),
(1061, 'fa', 'nl', 'Perzisch'),
(1062, 'fa', 'no', 'Persisk'),
(1063, 'fa', 'pa', 'Persian'),
(1064, 'fa', 'pl', 'perski'),
(1065, 'fa', 'pt-pt', 'Persa'),
(1066, 'fa', 'pt-br', 'Persa'),
(1067, 'fa', 'qu', 'Persian'),
(1068, 'fa', 'ro', 'Persană'),
(1069, 'fa', 'ru', 'Персидский'),
(1070, 'fa', 'sl', 'Perzijski'),
(1071, 'fa', 'so', 'Persian'),
(1072, 'fa', 'sq', 'Persian'),
(1073, 'fa', 'sr', 'персијски'),
(1074, 'fa', 'sv', 'Persiska'),
(1075, 'fa', 'ta', 'Persian'),
(1076, 'fa', 'th', 'เปอร์เซียน'),
(1077, 'fa', 'tr', 'Farsça'),
(1078, 'fa', 'uk', 'Persian'),
(1079, 'fa', 'ur', 'Persian'),
(1080, 'fa', 'uz', 'Persian'),
(1081, 'fa', 'vi', 'Persian'),
(1082, 'fa', 'yi', 'Persian'),
(1083, 'fa', 'zh-hans', '波斯语'),
(1084, 'fa', 'zu', 'Persian'),
(1085, 'fa', 'zh-hant', '波斯語'),
(1086, 'fa', 'ms', 'Persian'),
(1087, 'fa', 'gl', 'Persian'),
(1088, 'fa', 'bn', 'Persian'),
(1089, 'fi', 'en', 'Finnish'),
(1090, 'fi', 'es', 'Finlandés'),
(1091, 'fi', 'de', 'Finnisch'),
(1092, 'fi', 'fr', 'Finnois'),
(1093, 'fi', 'ar', 'الفنلندية'),
(1094, 'fi', 'bs', 'Finnish'),
(1095, 'fi', 'bg', 'Фински'),
(1096, 'fi', 'ca', 'Finnish'),
(1097, 'fi', 'cs', 'Finský'),
(1098, 'fi', 'sk', 'Fínština'),
(1099, 'fi', 'cy', 'Finnish'),
(1100, 'fi', 'da', 'Finnish'),
(1101, 'fi', 'el', 'Φινλανδικη'),
(1102, 'fi', 'eo', 'Finnish'),
(1103, 'fi', 'et', 'Finnish'),
(1104, 'fi', 'eu', 'Finnish'),
(1105, 'fi', 'fa', 'Finnish'),
(1106, 'fi', 'fi', 'Suomi'),
(1107, 'fi', 'ga', 'Finnish'),
(1108, 'fi', 'he', 'פינית'),
(1109, 'fi', 'hi', 'Finnish'),
(1110, 'fi', 'hr', 'Finski'),
(1111, 'fi', 'hu', 'finn'),
(1112, 'fi', 'hy', 'Finnish'),
(1113, 'fi', 'id', 'Finnish'),
(1114, 'fi', 'is', 'Finnish'),
(1115, 'fi', 'it', 'Finlandese'),
(1116, 'fi', 'ja', 'フィンランド語'),
(1117, 'fi', 'ko', '핀란드어'),
(1118, 'fi', 'ku', 'Finnish'),
(1119, 'fi', 'lv', 'Finnish'),
(1120, 'fi', 'lt', 'Finnish'),
(1121, 'fi', 'mk', 'Finnish'),
(1122, 'fi', 'mt', 'Finnish'),
(1123, 'fi', 'mn', 'Finnish'),
(1124, 'fi', 'ne', 'Finnish'),
(1125, 'fi', 'nl', 'Fins'),
(1126, 'fi', 'no', 'Finsk'),
(1127, 'fi', 'pa', 'Finnish'),
(1128, 'fi', 'pl', 'fiński'),
(1129, 'fi', 'pt-pt', 'Finlandês'),
(1130, 'fi', 'pt-br', 'Finlandês'),
(1131, 'fi', 'qu', 'Finnish'),
(1132, 'fi', 'ro', 'Finlandeză'),
(1133, 'fi', 'ru', 'Финский'),
(1134, 'fi', 'sl', 'Finski'),
(1135, 'fi', 'so', 'Finnish'),
(1136, 'fi', 'sq', 'Finnish'),
(1137, 'fi', 'sr', 'фински'),
(1138, 'fi', 'sv', 'Finska'),
(1139, 'fi', 'ta', 'Finnish'),
(1140, 'fi', 'th', 'ฟินนิช'),
(1141, 'fi', 'tr', 'Fince'),
(1142, 'fi', 'uk', 'Finnish'),
(1143, 'fi', 'ur', 'Finnish'),
(1144, 'fi', 'uz', 'Finnish'),
(1145, 'fi', 'vi', 'Finnish'),
(1146, 'fi', 'yi', 'Finnish'),
(1147, 'fi', 'zh-hans', '芬兰语'),
(1148, 'fi', 'zu', 'Finnish'),
(1149, 'fi', 'zh-hant', '芬蘭語'),
(1150, 'fi', 'ms', 'Finnish'),
(1151, 'fi', 'gl', 'Finnish'),
(1152, 'fi', 'bn', 'Finnish'),
(1153, 'ga', 'en', 'Irish'),
(1154, 'ga', 'es', 'Irlandés'),
(1155, 'ga', 'de', 'Irisch'),
(1156, 'ga', 'fr', 'Irlandais'),
(1157, 'ga', 'ar', 'الأيرلندية'),
(1158, 'ga', 'bs', 'Irish'),
(1159, 'ga', 'bg', 'Ирландски'),
(1160, 'ga', 'ca', 'Irish'),
(1161, 'ga', 'cs', 'Irský'),
(1162, 'ga', 'sk', 'Írština'),
(1163, 'ga', 'cy', 'Irish'),
(1164, 'ga', 'da', 'Irish'),
(1165, 'ga', 'el', 'Ιρλανδικα'),
(1166, 'ga', 'eo', 'Irish'),
(1167, 'ga', 'et', 'Irish'),
(1168, 'ga', 'eu', 'Irish'),
(1169, 'ga', 'fa', 'Irish'),
(1170, 'ga', 'fi', 'iiri'),
(1171, 'ga', 'ga', 'Gaeilge'),
(1172, 'ga', 'he', 'אירית'),
(1173, 'ga', 'hi', 'Irish'),
(1174, 'ga', 'hr', 'Irci'),
(1175, 'ga', 'hu', 'ír'),
(1176, 'ga', 'hy', 'Irish'),
(1177, 'ga', 'id', 'Irish'),
(1178, 'ga', 'is', 'Irish'),
(1179, 'ga', 'it', 'Irlandese'),
(1180, 'ga', 'ja', 'アイルランド語'),
(1181, 'ga', 'ko', '아일랜드어'),
(1182, 'ga', 'ku', 'Irish'),
(1183, 'ga', 'lv', 'Irish'),
(1184, 'ga', 'lt', 'Irish'),
(1185, 'ga', 'mk', 'Irish'),
(1186, 'ga', 'mt', 'Irish'),
(1187, 'ga', 'mn', 'Irish'),
(1188, 'ga', 'ne', 'Irish'),
(1189, 'ga', 'nl', 'Iers'),
(1190, 'ga', 'no', 'Irish'),
(1191, 'ga', 'pa', 'Irish'),
(1192, 'ga', 'pl', 'irlandzki'),
(1193, 'ga', 'pt-pt', 'Irlandês'),
(1194, 'ga', 'pt-br', 'Irlandês'),
(1195, 'ga', 'qu', 'Irish'),
(1196, 'ga', 'ro', 'Irlandeză'),
(1197, 'ga', 'ru', 'Ирландский'),
(1198, 'ga', 'sl', 'Irski'),
(1199, 'ga', 'so', 'Irish'),
(1200, 'ga', 'sq', 'Irish'),
(1201, 'ga', 'sr', 'ирски'),
(1202, 'ga', 'sv', 'Irländska'),
(1203, 'ga', 'ta', 'Irish'),
(1204, 'ga', 'th', 'ไอริช'),
(1205, 'ga', 'tr', 'İrlanda dili'),
(1206, 'ga', 'uk', 'Irish'),
(1207, 'ga', 'ur', 'Irish'),
(1208, 'ga', 'uz', 'Irish'),
(1209, 'ga', 'vi', 'Irish'),
(1210, 'ga', 'yi', 'Irish'),
(1211, 'ga', 'zh-hans', '爱尔兰语'),
(1212, 'ga', 'zu', 'Irish'),
(1213, 'ga', 'zh-hant', '愛爾蘭語'),
(1214, 'ga', 'ms', 'Irish'),
(1215, 'ga', 'gl', 'Irish'),
(1216, 'ga', 'bn', 'Irish'),
(1217, 'he', 'en', 'Hebrew'),
(1218, 'he', 'es', 'Hebreo'),
(1219, 'he', 'de', 'Hebräisch'),
(1220, 'he', 'fr', 'Hébreu'),
(1221, 'he', 'ar', 'العبرية'),
(1222, 'he', 'bs', 'Hebrew'),
(1223, 'he', 'bg', 'Иврит'),
(1224, 'he', 'ca', 'Hebrew'),
(1225, 'he', 'cs', 'Hebrejština'),
(1226, 'he', 'sk', 'Hebrejčina'),
(1227, 'he', 'cy', 'Hebrew'),
(1228, 'he', 'da', 'Hebrew'),
(1229, 'he', 'el', 'Εβραικα'),
(1230, 'he', 'eo', 'Hebrew'),
(1231, 'he', 'et', 'Hebrew'),
(1232, 'he', 'eu', 'Hebrew'),
(1233, 'he', 'fa', 'Hebrew'),
(1234, 'he', 'fi', 'heprea'),
(1235, 'he', 'ga', 'Hebrew'),
(1236, 'he', 'he', 'עברית'),
(1237, 'he', 'hi', 'Hebrew'),
(1238, 'he', 'hr', 'Hebrejski'),
(1239, 'he', 'hu', 'héber'),
(1240, 'he', 'hy', 'Hebrew'),
(1241, 'he', 'id', 'Hebrew'),
(1242, 'he', 'is', 'Hebrew'),
(1243, 'he', 'it', 'Ebraico'),
(1244, 'he', 'ja', 'ヘブライ語'),
(1245, 'he', 'ko', '히브리어'),
(1246, 'he', 'ku', 'Hebrew'),
(1247, 'he', 'lv', 'Hebrew'),
(1248, 'he', 'lt', 'Hebrew'),
(1249, 'he', 'mk', 'Hebrew'),
(1250, 'he', 'mt', 'Hebrew'),
(1251, 'he', 'mn', 'Hebrew'),
(1252, 'he', 'ne', 'Hebrew'),
(1253, 'he', 'nl', 'Hebreeuws'),
(1254, 'he', 'no', 'Hebraisk'),
(1255, 'he', 'pa', 'Hebrew'),
(1256, 'he', 'pl', 'hebrajski'),
(1257, 'he', 'pt-pt', 'Hebraico'),
(1258, 'he', 'pt-br', 'Hebraico'),
(1259, 'he', 'qu', 'Hebrew'),
(1260, 'he', 'ro', 'Ebraică'),
(1261, 'he', 'ru', 'Иврит'),
(1262, 'he', 'sl', 'Hebrejščina'),
(1263, 'he', 'so', 'Hebrew'),
(1264, 'he', 'sq', 'Hebrew'),
(1265, 'he', 'sr', 'Хебрејски'),
(1266, 'he', 'sv', 'Hebreiska'),
(1267, 'he', 'ta', 'Hebrew'),
(1268, 'he', 'th', 'ฮิบรู'),
(1269, 'he', 'tr', 'İbranice'),
(1270, 'he', 'uk', 'Hebrew'),
(1271, 'he', 'ur', 'Hebrew'),
(1272, 'he', 'uz', 'Hebrew'),
(1273, 'he', 'vi', 'Hebrew'),
(1274, 'he', 'yi', 'Hebrew'),
(1275, 'he', 'zh-hans', '希伯来语'),
(1276, 'he', 'zu', 'Hebrew'),
(1277, 'he', 'zh-hant', '希伯來語'),
(1278, 'he', 'ms', 'Hebrew'),
(1279, 'he', 'gl', 'Hebrew'),
(1280, 'he', 'bn', 'Hebrew'),
(1281, 'hi', 'en', 'Hindi'),
(1282, 'hi', 'es', 'Hindi'),
(1283, 'hi', 'de', 'Hindi'),
(1284, 'hi', 'fr', 'Hindi'),
(1285, 'hi', 'ar', 'الهندية'),
(1286, 'hi', 'bs', 'Hindi'),
(1287, 'hi', 'bg', 'Хинди'),
(1288, 'hi', 'ca', 'Hindi'),
(1289, 'hi', 'cs', 'Hindština'),
(1290, 'hi', 'sk', 'Hindčina'),
(1291, 'hi', 'cy', 'Hindi'),
(1292, 'hi', 'da', 'Hindi'),
(1293, 'hi', 'el', 'Ινδικα'),
(1294, 'hi', 'eo', 'Hindi'),
(1295, 'hi', 'et', 'Hindi'),
(1296, 'hi', 'eu', 'Hindi'),
(1297, 'hi', 'fa', 'Hindi'),
(1298, 'hi', 'fi', 'hindi'),
(1299, 'hi', 'ga', 'Hindi'),
(1300, 'hi', 'he', 'הודית'),
(1301, 'hi', 'hi', 'हिन्दी'),
(1302, 'hi', 'hr', 'Hindski'),
(1303, 'hi', 'hu', 'hindi'),
(1304, 'hi', 'hy', 'Hindi'),
(1305, 'hi', 'id', 'Hindi'),
(1306, 'hi', 'is', 'Hindi'),
(1307, 'hi', 'it', 'Hindi'),
(1308, 'hi', 'ja', 'ヒンディー語'),
(1309, 'hi', 'ko', '힌두어'),
(1310, 'hi', 'ku', 'Hindi'),
(1311, 'hi', 'lv', 'Hindi'),
(1312, 'hi', 'lt', 'Hindi'),
(1313, 'hi', 'mk', 'Hindi'),
(1314, 'hi', 'mt', 'Hindi'),
(1315, 'hi', 'mn', 'Hindi'),
(1316, 'hi', 'ne', 'Hindi'),
(1317, 'hi', 'nl', 'Hindi'),
(1318, 'hi', 'no', 'Hindi'),
(1319, 'hi', 'pa', 'Hindi'),
(1320, 'hi', 'pl', 'hindi'),
(1321, 'hi', 'pt-pt', 'Hindi'),
(1322, 'hi', 'pt-br', 'Hindi'),
(1323, 'hi', 'qu', 'Hindi'),
(1324, 'hi', 'ro', 'Hindi'),
(1325, 'hi', 'ru', 'Хинди'),
(1326, 'hi', 'sl', 'Hindi'),
(1327, 'hi', 'so', 'Hindi'),
(1328, 'hi', 'sq', 'Hindi'),
(1329, 'hi', 'sr', 'хинди'),
(1330, 'hi', 'sv', 'Hindi'),
(1331, 'hi', 'ta', 'Hindi'),
(1332, 'hi', 'th', 'ฮินดิ'),
(1333, 'hi', 'tr', 'Hintçe'),
(1334, 'hi', 'uk', 'Hindi'),
(1335, 'hi', 'ur', 'Hindi'),
(1336, 'hi', 'uz', 'Hindi'),
(1337, 'hi', 'vi', 'Hindi'),
(1338, 'hi', 'yi', 'Hindi'),
(1339, 'hi', 'zh-hans', '印地语'),
(1340, 'hi', 'zu', 'Hindi'),
(1341, 'hi', 'zh-hant', '印地語'),
(1342, 'hi', 'ms', 'Hindi'),
(1343, 'hi', 'gl', 'Hindi'),
(1344, 'hi', 'bn', 'Hindi'),
(1345, 'hr', 'en', 'Croatian'),
(1346, 'hr', 'es', 'Croata'),
(1347, 'hr', 'de', 'Kroatisch'),
(1348, 'hr', 'fr', 'Croate'),
(1349, 'hr', 'ar', 'الكرواتية'),
(1350, 'hr', 'bs', 'Croatian'),
(1351, 'hr', 'bg', 'Хърватски'),
(1352, 'hr', 'ca', 'Croatian'),
(1353, 'hr', 'cs', 'Chorvatský'),
(1354, 'hr', 'sk', 'Chorvátština'),
(1355, 'hr', 'cy', 'Croatian'),
(1356, 'hr', 'da', 'Croatian'),
(1357, 'hr', 'el', 'Κροατικα'),
(1358, 'hr', 'eo', 'Croatian'),
(1359, 'hr', 'et', 'Croatian'),
(1360, 'hr', 'eu', 'Croatian'),
(1361, 'hr', 'fa', 'Croatian'),
(1362, 'hr', 'fi', 'kroatia'),
(1363, 'hr', 'ga', 'Croatian'),
(1364, 'hr', 'he', 'קרוטאית'),
(1365, 'hr', 'hi', 'Croatian'),
(1366, 'hr', 'hr', 'Hrvatski'),
(1367, 'hr', 'hu', 'horvát'),
(1368, 'hr', 'hy', 'Croatian'),
(1369, 'hr', 'id', 'Croatian'),
(1370, 'hr', 'is', 'Croatian'),
(1371, 'hr', 'it', 'Croato'),
(1372, 'hr', 'ja', 'クロアチア語'),
(1373, 'hr', 'ko', '크로아시아어'),
(1374, 'hr', 'ku', 'Croatian'),
(1375, 'hr', 'lv', 'Croatian'),
(1376, 'hr', 'lt', 'Croatian'),
(1377, 'hr', 'mk', 'Croatian'),
(1378, 'hr', 'mt', 'Croatian'),
(1379, 'hr', 'mn', 'Croatian'),
(1380, 'hr', 'ne', 'Croatian'),
(1381, 'hr', 'nl', 'Kroatisch'),
(1382, 'hr', 'no', 'Kroatisk'),
(1383, 'hr', 'pa', 'Croatian'),
(1384, 'hr', 'pl', 'chorwacki'),
(1385, 'hr', 'pt-pt', 'Croata'),
(1386, 'hr', 'pt-br', 'Croata'),
(1387, 'hr', 'qu', 'Croatian'),
(1388, 'hr', 'ro', 'Croată'),
(1389, 'hr', 'ru', 'Хорватский'),
(1390, 'hr', 'sl', 'Hrvaški'),
(1391, 'hr', 'so', 'Croatian'),
(1392, 'hr', 'sq', 'Croatian'),
(1393, 'hr', 'sr', 'хрватски'),
(1394, 'hr', 'sv', 'Kroatiska'),
(1395, 'hr', 'ta', 'Croatian'),
(1396, 'hr', 'th', 'โครเอเชีย'),
(1397, 'hr', 'tr', 'Hırvatça'),
(1398, 'hr', 'uk', 'Croatian'),
(1399, 'hr', 'ur', 'Croatian'),
(1400, 'hr', 'uz', 'Croatian'),
(1401, 'hr', 'vi', 'Croatian'),
(1402, 'hr', 'yi', 'Croatian'),
(1403, 'hr', 'zh-hans', '克罗地亚语'),
(1404, 'hr', 'zu', 'Croatian'),
(1405, 'hr', 'zh-hant', '克羅地亞語'),
(1406, 'hr', 'ms', 'Croatian'),
(1407, 'hr', 'gl', 'Croatian'),
(1408, 'hr', 'bn', 'Croatian'),
(1409, 'hu', 'en', 'Hungarian'),
(1410, 'hu', 'es', 'Húngaro'),
(1411, 'hu', 'de', 'Ungarisch'),
(1412, 'hu', 'fr', 'Hongrois'),
(1413, 'hu', 'ar', 'الهنغارية'),
(1414, 'hu', 'bs', 'Hungarian'),
(1415, 'hu', 'bg', 'Унгарски'),
(1416, 'hu', 'ca', 'Hungarian'),
(1417, 'hu', 'cs', 'Maďarština'),
(1418, 'hu', 'sk', 'Maďarčina'),
(1419, 'hu', 'cy', 'Hungarian'),
(1420, 'hu', 'da', 'Hungarian'),
(1421, 'hu', 'el', 'Ουγγρικα'),
(1422, 'hu', 'eo', 'Hungarian'),
(1423, 'hu', 'et', 'Hungarian'),
(1424, 'hu', 'eu', 'Hungarian'),
(1425, 'hu', 'fa', 'Hungarian'),
(1426, 'hu', 'fi', 'unkari'),
(1427, 'hu', 'ga', 'Hungarian'),
(1428, 'hu', 'he', 'הונגרית'),
(1429, 'hu', 'hi', 'Hungarian'),
(1430, 'hu', 'hr', 'Mađarski'),
(1431, 'hu', 'hu', 'Magyar'),
(1432, 'hu', 'hy', 'Hungarian'),
(1433, 'hu', 'id', 'Hungarian'),
(1434, 'hu', 'is', 'Hungarian'),
(1435, 'hu', 'it', 'Ungherese'),
(1436, 'hu', 'ja', 'ハンガリー語'),
(1437, 'hu', 'ko', '헝가리어'),
(1438, 'hu', 'ku', 'Hungarian'),
(1439, 'hu', 'lv', 'Hungarian'),
(1440, 'hu', 'lt', 'Hungarian'),
(1441, 'hu', 'mk', 'Hungarian'),
(1442, 'hu', 'mt', 'Hungarian'),
(1443, 'hu', 'mn', 'Hungarian'),
(1444, 'hu', 'ne', 'Hungarian'),
(1445, 'hu', 'nl', 'Hongaars'),
(1446, 'hu', 'no', 'Ungarsk'),
(1447, 'hu', 'pa', 'Hungarian'),
(1448, 'hu', 'pl', 'węgierski'),
(1449, 'hu', 'pt-pt', 'Húngaro'),
(1450, 'hu', 'pt-br', 'Húngaro'),
(1451, 'hu', 'qu', 'Hungarian'),
(1452, 'hu', 'ro', 'Ungară'),
(1453, 'hu', 'ru', 'Венгерский'),
(1454, 'hu', 'sl', 'Madžarski'),
(1455, 'hu', 'so', 'Hungarian'),
(1456, 'hu', 'sq', 'Hungarian'),
(1457, 'hu', 'sr', 'мађарски'),
(1458, 'hu', 'sv', 'Ungerska'),
(1459, 'hu', 'ta', 'Hungarian'),
(1460, 'hu', 'th', 'ฮังการี'),
(1461, 'hu', 'tr', 'Macarca'),
(1462, 'hu', 'uk', 'Hungarian'),
(1463, 'hu', 'ur', 'Hungarian'),
(1464, 'hu', 'uz', 'Hungarian'),
(1465, 'hu', 'vi', 'Hungarian'),
(1466, 'hu', 'yi', 'Hungarian'),
(1467, 'hu', 'zh-hans', '匈牙利语'),
(1468, 'hu', 'zu', 'Hungarian'),
(1469, 'hu', 'zh-hant', '匈牙利語'),
(1470, 'hu', 'ms', 'Hungarian'),
(1471, 'hu', 'gl', 'Hungarian'),
(1472, 'hu', 'bn', 'Hungarian'),
(1473, 'hy', 'en', 'Armenian'),
(1474, 'hy', 'es', 'Armenio'),
(1475, 'hy', 'de', 'Armenisch'),
(1476, 'hy', 'fr', 'Arménien'),
(1477, 'hy', 'ar', 'الأرمينية'),
(1478, 'hy', 'bs', 'Armenian'),
(1479, 'hy', 'bg', 'Арменски'),
(1480, 'hy', 'ca', 'Armenian'),
(1481, 'hy', 'cs', 'Arménský'),
(1482, 'hy', 'sk', 'Arménčina'),
(1483, 'hy', 'cy', 'Armenian'),
(1484, 'hy', 'da', 'Armenian'),
(1485, 'hy', 'el', 'Αρμενικα'),
(1486, 'hy', 'eo', 'Armenian'),
(1487, 'hy', 'et', 'Armenian'),
(1488, 'hy', 'eu', 'Armenian'),
(1489, 'hy', 'fa', 'Armenian'),
(1490, 'hy', 'fi', 'armenia'),
(1491, 'hy', 'ga', 'Armenian'),
(1492, 'hy', 'he', 'ארמנית'),
(1493, 'hy', 'hi', 'Armenian'),
(1494, 'hy', 'hr', 'Armenac'),
(1495, 'hy', 'hu', 'örmény'),
(1496, 'hy', 'hy', 'Հայերեն'),
(1497, 'hy', 'id', 'Armenian'),
(1498, 'hy', 'is', 'Armenian'),
(1499, 'hy', 'it', 'Armeno'),
(1500, 'hy', 'ja', 'アルメニア語'),
(1501, 'hy', 'ko', '아르메니아어'),
(1502, 'hy', 'ku', 'Armenian'),
(1503, 'hy', 'lv', 'Armenian'),
(1504, 'hy', 'lt', 'Armenian'),
(1505, 'hy', 'mk', 'Armenian'),
(1506, 'hy', 'mt', 'Armenian'),
(1507, 'hy', 'mn', 'Armenian'),
(1508, 'hy', 'ne', 'Armenian'),
(1509, 'hy', 'nl', 'Armeens'),
(1510, 'hy', 'no', 'Armensk'),
(1511, 'hy', 'pa', 'Armenian'),
(1512, 'hy', 'pl', 'ormiański'),
(1513, 'hy', 'pt-pt', 'Arménio'),
(1514, 'hy', 'pt-br', 'Arménio'),
(1515, 'hy', 'qu', 'Armenian'),
(1516, 'hy', 'ro', 'Armeană'),
(1517, 'hy', 'ru', 'Армянский'),
(1518, 'hy', 'sl', 'Armenski'),
(1519, 'hy', 'so', 'Armenian'),
(1520, 'hy', 'sq', 'Armenian'),
(1521, 'hy', 'sr', 'јерменски'),
(1522, 'hy', 'sv', 'Armeniska'),
(1523, 'hy', 'ta', 'Armenian'),
(1524, 'hy', 'th', 'อาร์เมเนีย'),
(1525, 'hy', 'tr', 'Ermenice'),
(1526, 'hy', 'uk', 'Armenian'),
(1527, 'hy', 'ur', 'Armenian'),
(1528, 'hy', 'uz', 'Armenian'),
(1529, 'hy', 'vi', 'Armenian'),
(1530, 'hy', 'yi', 'Armenian'),
(1531, 'hy', 'zh-hans', '亚美尼亚语'),
(1532, 'hy', 'zu', 'Armenian'),
(1533, 'hy', 'zh-hant', '亞美尼亞語'),
(1534, 'hy', 'ms', 'Armenian'),
(1535, 'hy', 'gl', 'Armenian'),
(1536, 'hy', 'bn', 'Armenian'),
(1537, 'id', 'en', 'Indonesian'),
(1538, 'id', 'es', 'Indonesio'),
(1539, 'id', 'de', 'Indonesisch'),
(1540, 'id', 'fr', 'Indonésien'),
(1541, 'id', 'ar', 'الأندونيسية'),
(1542, 'id', 'bs', 'Indonesian'),
(1543, 'id', 'bg', 'Индонезийски'),
(1544, 'id', 'ca', 'Indonesian'),
(1545, 'id', 'cs', 'Indonéský'),
(1546, 'id', 'sk', 'Indonézčina'),
(1547, 'id', 'cy', 'Indonesian'),
(1548, 'id', 'da', 'Indonesian'),
(1549, 'id', 'el', 'Ινδονησιακα'),
(1550, 'id', 'eo', 'Indonesian'),
(1551, 'id', 'et', 'Indonesian'),
(1552, 'id', 'eu', 'Indonesian'),
(1553, 'id', 'fa', 'Indonesian'),
(1554, 'id', 'fi', 'indonesia'),
(1555, 'id', 'ga', 'Indonesian'),
(1556, 'id', 'he', 'אינדונזית'),
(1557, 'id', 'hi', 'Indonesian'),
(1558, 'id', 'hr', 'Indonezijski'),
(1559, 'id', 'hu', 'indonéz'),
(1560, 'id', 'hy', 'Indonesian'),
(1561, 'id', 'id', 'Indonesia'),
(1562, 'id', 'is', 'Indonesian'),
(1563, 'id', 'it', 'Indonesiano'),
(1564, 'id', 'ja', 'インドネシア語'),
(1565, 'id', 'ko', '인도네시아어'),
(1566, 'id', 'ku', 'Indonesian'),
(1567, 'id', 'lv', 'Indonesian'),
(1568, 'id', 'lt', 'Indonesian'),
(1569, 'id', 'mk', 'Indonesian'),
(1570, 'id', 'mt', 'Indonesian'),
(1571, 'id', 'mn', 'Indonesian'),
(1572, 'id', 'ne', 'Indonesian'),
(1573, 'id', 'nl', 'Indonesisch'),
(1574, 'id', 'no', 'Indonesian'),
(1575, 'id', 'pa', 'Indonesian'),
(1576, 'id', 'pl', 'indonezyjski'),
(1577, 'id', 'pt-pt', 'Indonésio'),
(1578, 'id', 'pt-br', 'Indonésio'),
(1579, 'id', 'qu', 'Indonesian'),
(1580, 'id', 'ro', 'Indoneziană'),
(1581, 'id', 'ru', 'Индонезийский'),
(1582, 'id', 'sl', 'Indonezijski'),
(1583, 'id', 'so', 'Indonesian'),
(1584, 'id', 'sq', 'Indonesian'),
(1585, 'id', 'sr', 'индонезијски'),
(1586, 'id', 'sv', 'Indonesiska'),
(1587, 'id', 'ta', 'Indonesian'),
(1588, 'id', 'th', 'อินโดนีเซีย'),
(1589, 'id', 'tr', 'Endonezya dili'),
(1590, 'id', 'uk', 'Indonesian'),
(1591, 'id', 'ur', 'Indonesian'),
(1592, 'id', 'uz', 'Indonesian'),
(1593, 'id', 'vi', 'Indonesian'),
(1594, 'id', 'yi', 'Indonesian'),
(1595, 'id', 'zh-hans', '印度尼西亚语'),
(1596, 'id', 'zu', 'Indonesian'),
(1597, 'id', 'zh-hant', '印尼語'),
(1598, 'id', 'ms', 'Indonesian'),
(1599, 'id', 'gl', 'Indonesian'),
(1600, 'id', 'bn', 'Indonesian'),
(1601, 'is', 'en', 'Icelandic'),
(1602, 'is', 'es', 'Islandés'),
(1603, 'is', 'de', 'Isländisch'),
(1604, 'is', 'fr', 'Islandais'),
(1605, 'is', 'ar', 'الأيسلاندية'),
(1606, 'is', 'bs', 'Icelandic'),
(1607, 'is', 'bg', 'Исландски'),
(1608, 'is', 'ca', 'Icelandic'),
(1609, 'is', 'cs', 'Islandský'),
(1610, 'is', 'sk', 'Islančina'),
(1611, 'is', 'cy', 'Icelandic'),
(1612, 'is', 'da', 'Icelandic'),
(1613, 'is', 'el', 'Ισλανδικα'),
(1614, 'is', 'eo', 'Icelandic'),
(1615, 'is', 'et', 'Icelandic'),
(1616, 'is', 'eu', 'Icelandic'),
(1617, 'is', 'fa', 'Icelandic'),
(1618, 'is', 'fi', 'islanti'),
(1619, 'is', 'ga', 'Icelandic'),
(1620, 'is', 'he', 'איסלנדית'),
(1621, 'is', 'hi', 'Icelandic'),
(1622, 'is', 'hr', 'Islandski'),
(1623, 'is', 'hu', 'izlandi'),
(1624, 'is', 'hy', 'Icelandic'),
(1625, 'is', 'id', 'Icelandic'),
(1626, 'is', 'is', 'Íslenska'),
(1627, 'is', 'it', 'Islandese'),
(1628, 'is', 'ja', 'アイスランド語'),
(1629, 'is', 'ko', '아이슬랜드어'),
(1630, 'is', 'ku', 'Icelandic'),
(1631, 'is', 'lv', 'Icelandic'),
(1632, 'is', 'lt', 'Icelandic'),
(1633, 'is', 'mk', 'Icelandic'),
(1634, 'is', 'mt', 'Icelandic'),
(1635, 'is', 'mn', 'Icelandic'),
(1636, 'is', 'ne', 'Icelandic'),
(1637, 'is', 'nl', 'Ijslands'),
(1638, 'is', 'no', 'Islandsk'),
(1639, 'is', 'pa', 'Icelandic'),
(1640, 'is', 'pl', 'islandzki'),
(1641, 'is', 'pt-pt', 'Islandês'),
(1642, 'is', 'pt-br', 'Islandês'),
(1643, 'is', 'qu', 'Icelandic'),
(1644, 'is', 'ro', 'Islandeză'),
(1645, 'is', 'ru', 'Исландский'),
(1646, 'is', 'sl', 'Islandski'),
(1647, 'is', 'so', 'Icelandic'),
(1648, 'is', 'sq', 'Icelandic'),
(1649, 'is', 'sr', 'исландски'),
(1650, 'is', 'sv', 'Isländska'),
(1651, 'is', 'ta', 'Icelandic'),
(1652, 'is', 'th', 'ไอซ์แลนด์'),
(1653, 'is', 'tr', 'İzlandaca'),
(1654, 'is', 'uk', 'Icelandic'),
(1655, 'is', 'ur', 'Icelandic'),
(1656, 'is', 'uz', 'Icelandic'),
(1657, 'is', 'vi', 'Icelandic'),
(1658, 'is', 'yi', 'Icelandic'),
(1659, 'is', 'zh-hans', '冰岛语'),
(1660, 'is', 'zu', 'Icelandic'),
(1661, 'is', 'zh-hant', '冰島語'),
(1662, 'is', 'ms', 'Icelandic'),
(1663, 'is', 'gl', 'Icelandic'),
(1664, 'is', 'bn', 'Icelandic'),
(1665, 'it', 'en', 'Italian'),
(1666, 'it', 'es', 'Italiano'),
(1667, 'it', 'de', 'Italienisch'),
(1668, 'it', 'fr', 'Italien'),
(1669, 'it', 'ar', 'الإيطالية'),
(1670, 'it', 'bs', 'Italian'),
(1671, 'it', 'bg', 'Италиански'),
(1672, 'it', 'ca', 'Italian'),
(1673, 'it', 'cs', 'Ital'),
(1674, 'it', 'sk', 'Taliančina'),
(1675, 'it', 'cy', 'Italian'),
(1676, 'it', 'da', 'Italian'),
(1677, 'it', 'el', 'Ιταλικα'),
(1678, 'it', 'eo', 'Italian'),
(1679, 'it', 'et', 'Italian'),
(1680, 'it', 'eu', 'Italian'),
(1681, 'it', 'fa', 'Italian'),
(1682, 'it', 'fi', 'italia'),
(1683, 'it', 'ga', 'Italian'),
(1684, 'it', 'he', 'איטלקית'),
(1685, 'it', 'hi', 'Italian'),
(1686, 'it', 'hr', 'Talijanski'),
(1687, 'it', 'hu', 'olasz'),
(1688, 'it', 'hy', 'Italian'),
(1689, 'it', 'id', 'Italian'),
(1690, 'it', 'is', 'Italian'),
(1691, 'it', 'it', 'Italiano'),
(1692, 'it', 'ja', 'イタリア語'),
(1693, 'it', 'ko', '이태리어'),
(1694, 'it', 'ku', 'Italian'),
(1695, 'it', 'lv', 'Italian'),
(1696, 'it', 'lt', 'Italian'),
(1697, 'it', 'mk', 'Italian'),
(1698, 'it', 'mt', 'Italian'),
(1699, 'it', 'mn', 'Italian'),
(1700, 'it', 'ne', 'Italian'),
(1701, 'it', 'nl', 'Italiaans'),
(1702, 'it', 'no', 'Italiensk'),
(1703, 'it', 'pa', 'Italian'),
(1704, 'it', 'pl', 'włoski'),
(1705, 'it', 'pt-pt', 'Italiano'),
(1706, 'it', 'pt-br', 'Italiano'),
(1707, 'it', 'qu', 'Italian'),
(1708, 'it', 'ro', 'Italiană'),
(1709, 'it', 'ru', 'Итальянский'),
(1710, 'it', 'sl', 'Italijanski'),
(1711, 'it', 'so', 'Italian'),
(1712, 'it', 'sq', 'Italian'),
(1713, 'it', 'sr', 'италијански'),
(1714, 'it', 'sv', 'Italienska'),
(1715, 'it', 'ta', 'Italian'),
(1716, 'it', 'th', 'อิตาลี'),
(1717, 'it', 'tr', 'İtalyanca'),
(1718, 'it', 'uk', 'Italian'),
(1719, 'it', 'ur', 'Italian'),
(1720, 'it', 'uz', 'Italian'),
(1721, 'it', 'vi', 'Italian'),
(1722, 'it', 'yi', 'Italian'),
(1723, 'it', 'zh-hans', '意大利语'),
(1724, 'it', 'zu', 'Italian'),
(1725, 'it', 'zh-hant', '義大利語'),
(1726, 'it', 'ms', 'Italian'),
(1727, 'it', 'gl', 'Italian'),
(1728, 'it', 'bn', 'Italian'),
(1729, 'ja', 'en', 'Japanese'),
(1730, 'ja', 'es', 'Japonés'),
(1731, 'ja', 'de', 'Japanisch'),
(1732, 'ja', 'fr', 'Japonais'),
(1733, 'ja', 'ar', 'اليابانية'),
(1734, 'ja', 'bs', 'Japanese'),
(1735, 'ja', 'bg', 'Японски'),
(1736, 'ja', 'ca', 'Japanese'),
(1737, 'ja', 'cs', 'Japonský'),
(1738, 'ja', 'sk', 'Japonština'),
(1739, 'ja', 'cy', 'Japanese'),
(1740, 'ja', 'da', 'Japanese'),
(1741, 'ja', 'el', 'Ιαπωνικα'),
(1742, 'ja', 'eo', 'Japanese');
INSERT INTO `wp_icl_languages_translations` (`id`, `language_code`, `display_language_code`, `name`) VALUES
(1743, 'ja', 'et', 'Japanese'),
(1744, 'ja', 'eu', 'Japanese'),
(1745, 'ja', 'fa', 'Japanese'),
(1746, 'ja', 'fi', 'japani'),
(1747, 'ja', 'ga', 'Japanese'),
(1748, 'ja', 'he', 'יפנית'),
(1749, 'ja', 'hi', 'Japanese'),
(1750, 'ja', 'hr', 'Japanski'),
(1751, 'ja', 'hu', 'japán'),
(1752, 'ja', 'hy', 'Japanese'),
(1753, 'ja', 'id', 'Japanese'),
(1754, 'ja', 'is', 'Japanese'),
(1755, 'ja', 'it', 'Giapponese'),
(1756, 'ja', 'ja', '日本語'),
(1757, 'ja', 'ko', '일어'),
(1758, 'ja', 'ku', 'Japanese'),
(1759, 'ja', 'lv', 'Japanese'),
(1760, 'ja', 'lt', 'Japanese'),
(1761, 'ja', 'mk', 'Japanese'),
(1762, 'ja', 'mt', 'Japanese'),
(1763, 'ja', 'mn', 'Japanese'),
(1764, 'ja', 'ne', 'Japanese'),
(1765, 'ja', 'nl', 'Japans'),
(1766, 'ja', 'no', 'Japansk'),
(1767, 'ja', 'pa', 'Japanese'),
(1768, 'ja', 'pl', 'japoński'),
(1769, 'ja', 'pt-pt', 'Japonês'),
(1770, 'ja', 'pt-br', 'Japonês'),
(1771, 'ja', 'qu', 'Japanese'),
(1772, 'ja', 'ro', 'Japoneză'),
(1773, 'ja', 'ru', 'Японский'),
(1774, 'ja', 'sl', 'Japonski'),
(1775, 'ja', 'so', 'Japanese'),
(1776, 'ja', 'sq', 'Japanese'),
(1777, 'ja', 'sr', 'јапански'),
(1778, 'ja', 'sv', 'Japanska'),
(1779, 'ja', 'ta', 'Japanese'),
(1780, 'ja', 'th', 'ญี่ปุ่น'),
(1781, 'ja', 'tr', 'Japonca'),
(1782, 'ja', 'uk', 'Japanese'),
(1783, 'ja', 'ur', 'Japanese'),
(1784, 'ja', 'uz', 'Japanese'),
(1785, 'ja', 'vi', 'Japanese'),
(1786, 'ja', 'yi', 'Japanese'),
(1787, 'ja', 'zh-hans', '日语'),
(1788, 'ja', 'zu', 'Japanese'),
(1789, 'ja', 'zh-hant', '日語'),
(1790, 'ja', 'ms', 'Japanese'),
(1791, 'ja', 'gl', 'Japanese'),
(1792, 'ja', 'bn', 'Japanese'),
(1793, 'ko', 'en', 'Korean'),
(1794, 'ko', 'es', 'Coreano'),
(1795, 'ko', 'de', 'Koreanisch'),
(1796, 'ko', 'fr', 'Coréen'),
(1797, 'ko', 'ar', 'الكورية'),
(1798, 'ko', 'bs', 'Korean'),
(1799, 'ko', 'bg', 'Корейски'),
(1800, 'ko', 'ca', 'Korean'),
(1801, 'ko', 'cs', 'Korejský'),
(1802, 'ko', 'sk', 'Kórejčina'),
(1803, 'ko', 'cy', 'Korean'),
(1804, 'ko', 'da', 'Korean'),
(1805, 'ko', 'el', 'Κορεατικα'),
(1806, 'ko', 'eo', 'Korean'),
(1807, 'ko', 'et', 'Korean'),
(1808, 'ko', 'eu', 'Korean'),
(1809, 'ko', 'fa', 'Korean'),
(1810, 'ko', 'fi', 'korea'),
(1811, 'ko', 'ga', 'Korean'),
(1812, 'ko', 'he', 'קוראנית'),
(1813, 'ko', 'hi', 'Korean'),
(1814, 'ko', 'hr', 'Korejski'),
(1815, 'ko', 'hu', 'koreai'),
(1816, 'ko', 'hy', 'Korean'),
(1817, 'ko', 'id', 'Korean'),
(1818, 'ko', 'is', 'Korean'),
(1819, 'ko', 'it', 'Coreano'),
(1820, 'ko', 'ja', '韓国語'),
(1821, 'ko', 'ko', '한국어'),
(1822, 'ko', 'ku', 'Korean'),
(1823, 'ko', 'lv', 'Korean'),
(1824, 'ko', 'lt', 'Korean'),
(1825, 'ko', 'mk', 'Korean'),
(1826, 'ko', 'mt', 'Korean'),
(1827, 'ko', 'mn', 'Korean'),
(1828, 'ko', 'ne', 'Korean'),
(1829, 'ko', 'nl', 'Koreaans'),
(1830, 'ko', 'no', 'Koreanske'),
(1831, 'ko', 'pa', 'Korean'),
(1832, 'ko', 'pl', 'koreański'),
(1833, 'ko', 'pt-pt', 'Coreano'),
(1834, 'ko', 'pt-br', 'Coreano'),
(1835, 'ko', 'qu', 'Korean'),
(1836, 'ko', 'ro', 'Coreană'),
(1837, 'ko', 'ru', 'Корейский'),
(1838, 'ko', 'sl', 'Korejski'),
(1839, 'ko', 'so', 'Korean'),
(1840, 'ko', 'sq', 'Korean'),
(1841, 'ko', 'sr', 'корејски'),
(1842, 'ko', 'sv', 'Koreanska'),
(1843, 'ko', 'ta', 'Korean'),
(1844, 'ko', 'th', 'เกาหลี'),
(1845, 'ko', 'tr', 'Kore dili'),
(1846, 'ko', 'uk', 'Korean'),
(1847, 'ko', 'ur', 'Korean'),
(1848, 'ko', 'uz', 'Korean'),
(1849, 'ko', 'vi', 'Korean'),
(1850, 'ko', 'yi', 'Korean'),
(1851, 'ko', 'zh-hans', '韩语'),
(1852, 'ko', 'zu', 'Korean'),
(1853, 'ko', 'zh-hant', '韓語'),
(1854, 'ko', 'ms', 'Korean'),
(1855, 'ko', 'gl', 'Korean'),
(1856, 'ko', 'bn', 'Korean'),
(1857, 'ku', 'en', 'Kurdish'),
(1858, 'ku', 'es', 'Kurdo'),
(1859, 'ku', 'de', 'Kurdisch'),
(1860, 'ku', 'fr', 'Kurde'),
(1861, 'ku', 'ar', 'الكردية'),
(1862, 'ku', 'bs', 'Kurdish'),
(1863, 'ku', 'bg', 'Кюрдски'),
(1864, 'ku', 'ca', 'Kurdish'),
(1865, 'ku', 'cs', 'Kurdský'),
(1866, 'ku', 'sk', 'Kurdština'),
(1867, 'ku', 'cy', 'Kurdish'),
(1868, 'ku', 'da', 'Kurdish'),
(1869, 'ku', 'el', 'Κουρδικα'),
(1870, 'ku', 'eo', 'Kurdish'),
(1871, 'ku', 'et', 'Kurdish'),
(1872, 'ku', 'eu', 'Kurdish'),
(1873, 'ku', 'fa', 'Kurdish'),
(1874, 'ku', 'fi', 'kurdi'),
(1875, 'ku', 'ga', 'Kurdish'),
(1876, 'ku', 'he', 'כורדית'),
(1877, 'ku', 'hi', 'Kurdish'),
(1878, 'ku', 'hr', 'Kurdski'),
(1879, 'ku', 'hu', 'kurd'),
(1880, 'ku', 'hy', 'Kurdish'),
(1881, 'ku', 'id', 'Kurdish'),
(1882, 'ku', 'is', 'Kurdish'),
(1883, 'ku', 'it', 'Curdo'),
(1884, 'ku', 'ja', 'クルド語'),
(1885, 'ku', 'ko', '쿠르드어'),
(1886, 'ku', 'ku', 'Kurdish'),
(1887, 'ku', 'lv', 'Kurdish'),
(1888, 'ku', 'lt', 'Kurdish'),
(1889, 'ku', 'mk', 'Kurdish'),
(1890, 'ku', 'mt', 'Kurdish'),
(1891, 'ku', 'mn', 'Kurdish'),
(1892, 'ku', 'ne', 'Kurdish'),
(1893, 'ku', 'nl', 'Koerdish'),
(1894, 'ku', 'no', 'Kurdisk'),
(1895, 'ku', 'pa', 'Kurdish'),
(1896, 'ku', 'pl', 'kurdyjski'),
(1897, 'ku', 'pt-pt', 'Curdo'),
(1898, 'ku', 'pt-br', 'Curdo'),
(1899, 'ku', 'qu', 'Kurdish'),
(1900, 'ku', 'ro', 'Kurdă'),
(1901, 'ku', 'ru', 'Курдский'),
(1902, 'ku', 'sl', 'Kurdščina'),
(1903, 'ku', 'so', 'Kurdish'),
(1904, 'ku', 'sq', 'Kurdish'),
(1905, 'ku', 'sr', 'курдски'),
(1906, 'ku', 'sv', 'Kurdiska'),
(1907, 'ku', 'ta', 'Kurdish'),
(1908, 'ku', 'th', 'เคอร์ดิช'),
(1909, 'ku', 'tr', 'Kürtçe'),
(1910, 'ku', 'uk', 'Kurdish'),
(1911, 'ku', 'ur', 'Kurdish'),
(1912, 'ku', 'uz', 'Kurdish'),
(1913, 'ku', 'vi', 'Kurdish'),
(1914, 'ku', 'yi', 'Kurdish'),
(1915, 'ku', 'zh-hans', '库尔德语'),
(1916, 'ku', 'zu', 'Kurdish'),
(1917, 'ku', 'zh-hant', '庫爾德語'),
(1918, 'ku', 'ms', 'Kurdish'),
(1919, 'ku', 'gl', 'Kurdish'),
(1920, 'ku', 'bn', 'Kurdish'),
(1921, 'lv', 'en', 'Latvian'),
(1922, 'lv', 'es', 'Letón'),
(1923, 'lv', 'de', 'Lettisch'),
(1924, 'lv', 'fr', 'Letton'),
(1925, 'lv', 'ar', 'اللاتفية'),
(1926, 'lv', 'bs', 'Latvian'),
(1927, 'lv', 'bg', 'Латвийски'),
(1928, 'lv', 'ca', 'Latvian'),
(1929, 'lv', 'cs', 'Lotyština'),
(1930, 'lv', 'sk', 'Lotyština'),
(1931, 'lv', 'cy', 'Latvian'),
(1932, 'lv', 'da', 'Latvian'),
(1933, 'lv', 'el', 'Λετονικα'),
(1934, 'lv', 'eo', 'Latvian'),
(1935, 'lv', 'et', 'Latvian'),
(1936, 'lv', 'eu', 'Latvian'),
(1937, 'lv', 'fa', 'Latvian'),
(1938, 'lv', 'fi', 'latvia'),
(1939, 'lv', 'ga', 'Latvian'),
(1940, 'lv', 'he', 'לטבית'),
(1941, 'lv', 'hi', 'Latvian'),
(1942, 'lv', 'hr', 'Letonski'),
(1943, 'lv', 'hu', 'lett'),
(1944, 'lv', 'hy', 'Latvian'),
(1945, 'lv', 'id', 'Latvian'),
(1946, 'lv', 'is', 'Latvian'),
(1947, 'lv', 'it', 'Lettone'),
(1948, 'lv', 'ja', 'ラトビア語'),
(1949, 'lv', 'ko', '라트비아어'),
(1950, 'lv', 'ku', 'Latvian'),
(1951, 'lv', 'lv', 'Latviešu'),
(1952, 'lv', 'lt', 'Latvian'),
(1953, 'lv', 'mk', 'Latvian'),
(1954, 'lv', 'mt', 'Latvian'),
(1955, 'lv', 'mn', 'Latvian'),
(1956, 'lv', 'ne', 'Latvian'),
(1957, 'lv', 'nl', 'Lets'),
(1958, 'lv', 'no', 'Latvisk'),
(1959, 'lv', 'pa', 'Latvian'),
(1960, 'lv', 'pl', 'łotewski'),
(1961, 'lv', 'pt-pt', 'Letão'),
(1962, 'lv', 'pt-br', 'Letão'),
(1963, 'lv', 'qu', 'Latvian'),
(1964, 'lv', 'ro', 'Letoniană'),
(1965, 'lv', 'ru', 'латышский'),
(1966, 'lv', 'sl', 'Latvijščina'),
(1967, 'lv', 'so', 'Latvian'),
(1968, 'lv', 'sq', 'Latvian'),
(1969, 'lv', 'sr', 'летонски'),
(1970, 'lv', 'sv', 'Lettiska'),
(1971, 'lv', 'ta', 'Latvian'),
(1972, 'lv', 'th', 'ลัตเวีย'),
(1973, 'lv', 'tr', 'Letonca'),
(1974, 'lv', 'uk', 'Latvian'),
(1975, 'lv', 'ur', 'Latvian'),
(1976, 'lv', 'uz', 'Latvian'),
(1977, 'lv', 'vi', 'Latvian'),
(1978, 'lv', 'yi', 'Latvian'),
(1979, 'lv', 'zh-hans', '拉脱维亚语'),
(1980, 'lv', 'zu', 'Latvian'),
(1981, 'lv', 'zh-hant', '拉脫維亞語'),
(1982, 'lv', 'ms', 'Latvian'),
(1983, 'lv', 'gl', 'Latvian'),
(1984, 'lv', 'bn', 'Latvian'),
(1985, 'lt', 'en', 'Lithuanian'),
(1986, 'lt', 'es', 'Lituano'),
(1987, 'lt', 'de', 'Litauisch'),
(1988, 'lt', 'fr', 'Lituanien'),
(1989, 'lt', 'ar', 'اللتوانية'),
(1990, 'lt', 'bs', 'Lithuanian'),
(1991, 'lt', 'bg', 'Литовски'),
(1992, 'lt', 'ca', 'Lithuanian'),
(1993, 'lt', 'cs', 'litevský'),
(1994, 'lt', 'sk', 'Litovčina'),
(1995, 'lt', 'cy', 'Lithuanian'),
(1996, 'lt', 'da', 'Lithuanian'),
(1997, 'lt', 'el', 'Λιθουανικα'),
(1998, 'lt', 'eo', 'Lithuanian'),
(1999, 'lt', 'et', 'Lithuanian'),
(2000, 'lt', 'eu', 'Lithuanian'),
(2001, 'lt', 'fa', 'Lithuanian'),
(2002, 'lt', 'fi', 'liettua'),
(2003, 'lt', 'ga', 'Lithuanian'),
(2004, 'lt', 'he', 'ליטאית'),
(2005, 'lt', 'hi', 'Lithuanian'),
(2006, 'lt', 'hr', 'Litvanski'),
(2007, 'lt', 'hu', 'litván'),
(2008, 'lt', 'hy', 'Lithuanian'),
(2009, 'lt', 'id', 'Lithuanian'),
(2010, 'lt', 'is', 'Lithuanian'),
(2011, 'lt', 'it', 'Lituano'),
(2012, 'lt', 'ja', 'リトアニア語'),
(2013, 'lt', 'ko', '리투아니아어'),
(2014, 'lt', 'ku', 'Lithuanian'),
(2015, 'lt', 'lv', 'Lithuanian'),
(2016, 'lt', 'lt', 'Lietuvos'),
(2017, 'lt', 'mk', 'Lithuanian'),
(2018, 'lt', 'mt', 'Lithuanian'),
(2019, 'lt', 'mn', 'Lithuanian'),
(2020, 'lt', 'ne', 'Lithuanian'),
(2021, 'lt', 'nl', 'Litouws'),
(2022, 'lt', 'no', 'Litauisk'),
(2023, 'lt', 'pa', 'Lithuanian'),
(2024, 'lt', 'pl', 'litewski'),
(2025, 'lt', 'pt-pt', 'Lituano'),
(2026, 'lt', 'pt-br', 'Lituano'),
(2027, 'lt', 'qu', 'Lithuanian'),
(2028, 'lt', 'ro', 'Lituaniană'),
(2029, 'lt', 'ru', 'Литовский'),
(2030, 'lt', 'sl', 'Litovščina'),
(2031, 'lt', 'so', 'Lithuanian'),
(2032, 'lt', 'sq', 'Lithuanian'),
(2033, 'lt', 'sr', 'литвански'),
(2034, 'lt', 'sv', 'Litauiska'),
(2035, 'lt', 'ta', 'Lithuanian'),
(2036, 'lt', 'th', 'ลิธัวเนีย'),
(2037, 'lt', 'tr', 'Litvanyaca'),
(2038, 'lt', 'uk', 'Lithuanian'),
(2039, 'lt', 'ur', 'Lithuanian'),
(2040, 'lt', 'uz', 'Lithuanian'),
(2041, 'lt', 'vi', 'Lithuanian'),
(2042, 'lt', 'yi', 'Lithuanian'),
(2043, 'lt', 'zh-hans', '立陶宛语'),
(2044, 'lt', 'zu', 'Lithuanian'),
(2045, 'lt', 'zh-hant', '立陶宛語'),
(2046, 'lt', 'ms', 'Lithuanian'),
(2047, 'lt', 'gl', 'Lithuanian'),
(2048, 'lt', 'bn', 'Lithuanian'),
(2049, 'mk', 'en', 'Macedonian'),
(2050, 'mk', 'es', 'Macedonio'),
(2051, 'mk', 'de', 'Mazedonisch'),
(2052, 'mk', 'fr', 'Macédonien'),
(2053, 'mk', 'ar', 'المقدونية'),
(2054, 'mk', 'bs', 'Macedonian'),
(2055, 'mk', 'bg', 'Македонски'),
(2056, 'mk', 'ca', 'Macedonian'),
(2057, 'mk', 'cs', 'Makedonský'),
(2058, 'mk', 'sk', 'Macedónština'),
(2059, 'mk', 'cy', 'Macedonian'),
(2060, 'mk', 'da', 'Macedonian'),
(2061, 'mk', 'el', 'Μακεδονικο'),
(2062, 'mk', 'eo', 'Macedonian'),
(2063, 'mk', 'et', 'Macedonian'),
(2064, 'mk', 'eu', 'Macedonian'),
(2065, 'mk', 'fa', 'Macedonian'),
(2066, 'mk', 'fi', 'makedonia'),
(2067, 'mk', 'ga', 'Macedonian'),
(2068, 'mk', 'he', 'מקדונית'),
(2069, 'mk', 'hi', 'Macedonian'),
(2070, 'mk', 'hr', 'Makedonski'),
(2071, 'mk', 'hu', 'macedón'),
(2072, 'mk', 'hy', 'Macedonian'),
(2073, 'mk', 'id', 'Macedonian'),
(2074, 'mk', 'is', 'Macedonian'),
(2075, 'mk', 'it', 'Macedone'),
(2076, 'mk', 'ja', 'マケドニア語'),
(2077, 'mk', 'ko', '마케도니아어'),
(2078, 'mk', 'ku', 'Macedonian'),
(2079, 'mk', 'lv', 'Macedonian'),
(2080, 'mk', 'lt', 'Macedonian'),
(2081, 'mk', 'mk', 'македонски'),
(2082, 'mk', 'mt', 'Macedonian'),
(2083, 'mk', 'mn', 'Macedonian'),
(2084, 'mk', 'ne', 'Macedonian'),
(2085, 'mk', 'nl', 'Macedonisch'),
(2086, 'mk', 'no', 'Makedonsk'),
(2087, 'mk', 'pa', 'Macedonian'),
(2088, 'mk', 'pl', 'macedoński'),
(2089, 'mk', 'pt-pt', 'Macedônio'),
(2090, 'mk', 'pt-br', 'Macedônio'),
(2091, 'mk', 'qu', 'Macedonian'),
(2092, 'mk', 'ro', 'Macedoniană'),
(2093, 'mk', 'ru', 'Македонский'),
(2094, 'mk', 'sl', 'Makedonski'),
(2095, 'mk', 'so', 'Macedonian'),
(2096, 'mk', 'sq', 'Macedonian'),
(2097, 'mk', 'sr', 'македонски'),
(2098, 'mk', 'sv', 'Makedonska'),
(2099, 'mk', 'ta', 'Macedonian'),
(2100, 'mk', 'th', 'มาซิโดเนีย'),
(2101, 'mk', 'tr', 'Makedonyaca'),
(2102, 'mk', 'uk', 'Macedonian'),
(2103, 'mk', 'ur', 'Macedonian'),
(2104, 'mk', 'uz', 'Macedonian'),
(2105, 'mk', 'vi', 'Macedonian'),
(2106, 'mk', 'yi', 'Macedonian'),
(2107, 'mk', 'zh-hans', '马其顿语'),
(2108, 'mk', 'zu', 'Macedonian'),
(2109, 'mk', 'zh-hant', '馬其頓語'),
(2110, 'mk', 'ms', 'Macedonian'),
(2111, 'mk', 'gl', 'Macedonian'),
(2112, 'mk', 'bn', 'Macedonian'),
(2113, 'mt', 'en', 'Maltese'),
(2114, 'mt', 'es', 'Maltés'),
(2115, 'mt', 'de', 'Maltesisch'),
(2116, 'mt', 'fr', 'Maltais'),
(2117, 'mt', 'ar', 'المالطية'),
(2118, 'mt', 'bs', 'Maltese'),
(2119, 'mt', 'bg', 'Малтийски'),
(2120, 'mt', 'ca', 'Maltese'),
(2121, 'mt', 'cs', 'Maltština'),
(2122, 'mt', 'sk', 'Maltézština'),
(2123, 'mt', 'cy', 'Maltese'),
(2124, 'mt', 'da', 'Maltese'),
(2125, 'mt', 'el', 'Μαλτεζικα'),
(2126, 'mt', 'eo', 'Maltese'),
(2127, 'mt', 'et', 'Maltese'),
(2128, 'mt', 'eu', 'Maltese'),
(2129, 'mt', 'fa', 'Maltese'),
(2130, 'mt', 'fi', 'malta'),
(2131, 'mt', 'ga', 'Maltese'),
(2132, 'mt', 'he', 'מלטזית'),
(2133, 'mt', 'hi', 'Maltese'),
(2134, 'mt', 'hr', 'Malteški'),
(2135, 'mt', 'hu', 'máltai'),
(2136, 'mt', 'hy', 'Maltese'),
(2137, 'mt', 'id', 'Maltese'),
(2138, 'mt', 'is', 'Maltese'),
(2139, 'mt', 'it', 'Maltese'),
(2140, 'mt', 'ja', 'マルタ語'),
(2141, 'mt', 'ko', '몰타어'),
(2142, 'mt', 'ku', 'Maltese'),
(2143, 'mt', 'lv', 'Maltese'),
(2144, 'mt', 'lt', 'Maltese'),
(2145, 'mt', 'mk', 'Maltese'),
(2146, 'mt', 'mt', 'Malti'),
(2147, 'mt', 'mn', 'Maltese'),
(2148, 'mt', 'ne', 'Maltese'),
(2149, 'mt', 'nl', 'Maltees'),
(2150, 'mt', 'no', 'Maltese'),
(2151, 'mt', 'pa', 'Maltese'),
(2152, 'mt', 'pl', 'maltański'),
(2153, 'mt', 'pt-pt', 'Maltês'),
(2154, 'mt', 'pt-br', 'Maltês'),
(2155, 'mt', 'qu', 'Maltese'),
(2156, 'mt', 'ro', 'Malteză'),
(2157, 'mt', 'ru', 'Мальтийский'),
(2158, 'mt', 'sl', 'Malteški'),
(2159, 'mt', 'so', 'Maltese'),
(2160, 'mt', 'sq', 'Maltese'),
(2161, 'mt', 'sr', 'малтешки'),
(2162, 'mt', 'sv', 'Maltesiska'),
(2163, 'mt', 'ta', 'Maltese'),
(2164, 'mt', 'th', 'มอลทีส'),
(2165, 'mt', 'tr', 'Malta dili'),
(2166, 'mt', 'uk', 'Maltese'),
(2167, 'mt', 'ur', 'Maltese'),
(2168, 'mt', 'uz', 'Maltese'),
(2169, 'mt', 'vi', 'Maltese'),
(2170, 'mt', 'yi', 'Maltese'),
(2171, 'mt', 'zh-hans', '马耳他语'),
(2172, 'mt', 'zu', 'Maltese'),
(2173, 'mt', 'zh-hant', '馬爾他語'),
(2174, 'mt', 'ms', 'Maltese'),
(2175, 'mt', 'gl', 'Maltese'),
(2176, 'mt', 'bn', 'Maltese'),
(2177, 'mn', 'en', 'Mongolian'),
(2178, 'mn', 'es', 'Mongol'),
(2179, 'mn', 'de', 'Mongolisch'),
(2180, 'mn', 'fr', 'Mongol'),
(2181, 'mn', 'ar', 'المنغولية'),
(2182, 'mn', 'bs', 'Mongolian'),
(2183, 'mn', 'bg', 'Монголски'),
(2184, 'mn', 'ca', 'Mongolian'),
(2185, 'mn', 'cs', 'Mongolský'),
(2186, 'mn', 'sk', 'Mongolština'),
(2187, 'mn', 'cy', 'Mongolian'),
(2188, 'mn', 'da', 'Mongolian'),
(2189, 'mn', 'el', 'Μογγολικα'),
(2190, 'mn', 'eo', 'Mongolian'),
(2191, 'mn', 'et', 'Mongolian'),
(2192, 'mn', 'eu', 'Mongolian'),
(2193, 'mn', 'fa', 'Mongolian'),
(2194, 'mn', 'fi', 'mongoli'),
(2195, 'mn', 'ga', 'Mongolian'),
(2196, 'mn', 'he', 'מונגולית'),
(2197, 'mn', 'hi', 'Mongolian'),
(2198, 'mn', 'hr', 'Mongolski'),
(2199, 'mn', 'hu', 'mongol'),
(2200, 'mn', 'hy', 'Mongolian'),
(2201, 'mn', 'id', 'Mongolian'),
(2202, 'mn', 'is', 'Mongolian'),
(2203, 'mn', 'it', 'Mongolo'),
(2204, 'mn', 'ja', 'モンゴル語'),
(2205, 'mn', 'ko', '몽골어'),
(2206, 'mn', 'ku', 'Mongolian'),
(2207, 'mn', 'lv', 'Mongolian'),
(2208, 'mn', 'lt', 'Mongolian'),
(2209, 'mn', 'mk', 'Mongolian'),
(2210, 'mn', 'mt', 'Mongolian'),
(2211, 'mn', 'mn', 'Mongolian'),
(2212, 'mn', 'ne', 'Mongolian'),
(2213, 'mn', 'nl', 'Mongools'),
(2214, 'mn', 'no', 'Mongolsk'),
(2215, 'mn', 'pa', 'Mongolian'),
(2216, 'mn', 'pl', 'mongolski'),
(2217, 'mn', 'pt-pt', 'Mongolian'),
(2218, 'mn', 'pt-br', 'Mongolian'),
(2219, 'mn', 'qu', 'Mongolian'),
(2220, 'mn', 'ro', 'Mongoleză'),
(2221, 'mn', 'ru', 'Монгольский'),
(2222, 'mn', 'sl', 'Mongolski'),
(2223, 'mn', 'so', 'Mongolian'),
(2224, 'mn', 'sq', 'Mongolian'),
(2225, 'mn', 'sr', 'монголски'),
(2226, 'mn', 'sv', 'Mongoliska'),
(2227, 'mn', 'ta', 'Mongolian'),
(2228, 'mn', 'th', 'มองโกเลีย'),
(2229, 'mn', 'tr', 'Mongolca'),
(2230, 'mn', 'uk', 'Mongolian'),
(2231, 'mn', 'ur', 'Mongolian'),
(2232, 'mn', 'uz', 'Mongolian'),
(2233, 'mn', 'vi', 'Mongolian'),
(2234, 'mn', 'yi', 'Mongolian'),
(2235, 'mn', 'zh-hans', '蒙古语'),
(2236, 'mn', 'zu', 'Mongolian'),
(2237, 'mn', 'zh-hant', '蒙古語'),
(2238, 'mn', 'ms', 'Mongolian'),
(2239, 'mn', 'gl', 'Mongolian'),
(2240, 'mn', 'bn', 'Mongolian'),
(2241, 'ne', 'en', 'Nepali'),
(2242, 'ne', 'es', 'Nepalí'),
(2243, 'ne', 'de', 'Nepali'),
(2244, 'ne', 'fr', 'Népalais'),
(2245, 'ne', 'ar', 'النيبالية'),
(2246, 'ne', 'bs', 'Nepali'),
(2247, 'ne', 'bg', 'Непалски'),
(2248, 'ne', 'ca', 'Nepali'),
(2249, 'ne', 'cs', 'Nepálský'),
(2250, 'ne', 'sk', 'Nepálčina'),
(2251, 'ne', 'cy', 'Nepali'),
(2252, 'ne', 'da', 'Nepali'),
(2253, 'ne', 'el', 'Νεπαλι'),
(2254, 'ne', 'eo', 'Nepali'),
(2255, 'ne', 'et', 'Nepali'),
(2256, 'ne', 'eu', 'Nepali'),
(2257, 'ne', 'fa', 'Nepali'),
(2258, 'ne', 'fi', 'nepali'),
(2259, 'ne', 'ga', 'Nepali'),
(2260, 'ne', 'he', 'נפאלית'),
(2261, 'ne', 'hi', 'Nepali'),
(2262, 'ne', 'hr', 'Nepalski'),
(2263, 'ne', 'hu', 'nepáli'),
(2264, 'ne', 'hy', 'Nepali'),
(2265, 'ne', 'id', 'Nepali'),
(2266, 'ne', 'is', 'Nepali'),
(2267, 'ne', 'it', 'Nepalese'),
(2268, 'ne', 'ja', 'ネパール語'),
(2269, 'ne', 'ko', '네팔어'),
(2270, 'ne', 'ku', 'Nepali'),
(2271, 'ne', 'lv', 'Nepali'),
(2272, 'ne', 'lt', 'Nepali'),
(2273, 'ne', 'mk', 'Nepali'),
(2274, 'ne', 'mt', 'Nepali'),
(2275, 'ne', 'mn', 'Nepali'),
(2276, 'ne', 'ne', 'Nepali'),
(2277, 'ne', 'nl', 'Nepalees'),
(2278, 'ne', 'no', 'Nepali'),
(2279, 'ne', 'pa', 'Nepali'),
(2280, 'ne', 'pl', 'nepalski'),
(2281, 'ne', 'pt-pt', 'Nepali'),
(2282, 'ne', 'pt-br', 'Nepali'),
(2283, 'ne', 'qu', 'Nepali'),
(2284, 'ne', 'ro', 'Nepaleză'),
(2285, 'ne', 'ru', 'Непальский'),
(2286, 'ne', 'sl', 'Nepalščina'),
(2287, 'ne', 'so', 'Nepali'),
(2288, 'ne', 'sq', 'Nepali'),
(2289, 'ne', 'sr', 'непалски'),
(2290, 'ne', 'sv', 'Nepalesiska'),
(2291, 'ne', 'ta', 'Nepali'),
(2292, 'ne', 'th', 'เนปาล'),
(2293, 'ne', 'tr', 'Nepal dili'),
(2294, 'ne', 'uk', 'Nepali'),
(2295, 'ne', 'ur', 'Nepali'),
(2296, 'ne', 'uz', 'Nepali'),
(2297, 'ne', 'vi', 'Nepali'),
(2298, 'ne', 'yi', 'Nepali'),
(2299, 'ne', 'zh-hans', '尼泊尔语'),
(2300, 'ne', 'zu', 'Nepali'),
(2301, 'ne', 'zh-hant', '尼泊爾語'),
(2302, 'ne', 'ms', 'Nepali'),
(2303, 'ne', 'gl', 'Nepali'),
(2304, 'ne', 'bn', 'Nepali'),
(2305, 'nl', 'en', 'Dutch'),
(2306, 'nl', 'es', 'Holandés'),
(2307, 'nl', 'de', 'Niederländisch'),
(2308, 'nl', 'fr', 'Néerlandais'),
(2309, 'nl', 'ar', 'الهولندية'),
(2310, 'nl', 'bs', 'Dutch'),
(2311, 'nl', 'bg', 'Холандски'),
(2312, 'nl', 'ca', 'Dutch'),
(2313, 'nl', 'cs', 'Holandský'),
(2314, 'nl', 'sk', 'Holandčina'),
(2315, 'nl', 'cy', 'Dutch'),
(2316, 'nl', 'da', 'Dutch'),
(2317, 'nl', 'el', 'Ολλανδικα'),
(2318, 'nl', 'eo', 'Dutch'),
(2319, 'nl', 'et', 'Dutch'),
(2320, 'nl', 'eu', 'Dutch'),
(2321, 'nl', 'fa', 'Dutch'),
(2322, 'nl', 'fi', 'hollanti'),
(2323, 'nl', 'ga', 'Dutch'),
(2324, 'nl', 'he', 'הולנדית'),
(2325, 'nl', 'hi', 'Dutch'),
(2326, 'nl', 'hr', 'Holandski'),
(2327, 'nl', 'hu', 'holland'),
(2328, 'nl', 'hy', 'Dutch'),
(2329, 'nl', 'id', 'Dutch'),
(2330, 'nl', 'is', 'Dutch'),
(2331, 'nl', 'it', 'Olandese'),
(2332, 'nl', 'ja', 'オランダ語'),
(2333, 'nl', 'ko', '화란어'),
(2334, 'nl', 'ku', 'Dutch'),
(2335, 'nl', 'lv', 'Dutch'),
(2336, 'nl', 'lt', 'Dutch'),
(2337, 'nl', 'mk', 'Dutch'),
(2338, 'nl', 'mt', 'Dutch'),
(2339, 'nl', 'mn', 'Dutch'),
(2340, 'nl', 'ne', 'Dutch'),
(2341, 'nl', 'nl', 'Nederlands'),
(2342, 'nl', 'no', 'Nederlandsk'),
(2343, 'nl', 'pa', 'Dutch'),
(2344, 'nl', 'pl', 'holenderski'),
(2345, 'nl', 'pt-pt', 'Holandês'),
(2346, 'nl', 'pt-br', 'Holandês'),
(2347, 'nl', 'qu', 'Dutch'),
(2348, 'nl', 'ro', 'Olaneză'),
(2349, 'nl', 'ru', 'Голландский'),
(2350, 'nl', 'sl', 'Nizozemščina'),
(2351, 'nl', 'so', 'Dutch'),
(2352, 'nl', 'sq', 'Dutch'),
(2353, 'nl', 'sr', 'холандски'),
(2354, 'nl', 'sv', 'Nederländska'),
(2355, 'nl', 'ta', 'Dutch'),
(2356, 'nl', 'th', 'ดัตช์'),
(2357, 'nl', 'tr', 'Hollandaca'),
(2358, 'nl', 'uk', 'Dutch'),
(2359, 'nl', 'ur', 'Dutch'),
(2360, 'nl', 'uz', 'Dutch'),
(2361, 'nl', 'vi', 'Dutch'),
(2362, 'nl', 'yi', 'Dutch'),
(2363, 'nl', 'zh-hans', '荷兰语'),
(2364, 'nl', 'zu', 'Dutch'),
(2365, 'nl', 'zh-hant', '荷蘭語'),
(2366, 'nl', 'ms', 'Dutch'),
(2367, 'nl', 'gl', 'Dutch'),
(2368, 'nl', 'bn', 'Dutch'),
(2369, 'no', 'en', 'Norwegian Bokmål'),
(2370, 'no', 'es', 'Bokmål'),
(2371, 'no', 'de', 'Norwegisch (Buchsprache)'),
(2372, 'no', 'fr', 'Norvégien Bokmål'),
(2373, 'no', 'ar', 'البوكمالية النرويجية'),
(2374, 'no', 'bs', 'Norwegian Bokmål'),
(2375, 'no', 'bg', 'Норвежки книжовен'),
(2376, 'no', 'ca', 'Norwegian Bokmål'),
(2377, 'no', 'cs', 'Norwegian bokmål'),
(2378, 'no', 'sk', 'Nórsky jazyk Bokmål'),
(2379, 'no', 'cy', 'Norwegian Bokmål'),
(2380, 'no', 'da', 'Norwegian Bokmål'),
(2381, 'no', 'el', 'Νορβηγικα'),
(2382, 'no', 'eo', 'Norwegian Bokmål'),
(2383, 'no', 'et', 'Norwegian Bokmål'),
(2384, 'no', 'eu', 'Norwegian Bokmål'),
(2385, 'no', 'fa', 'Norwegian Bokmål'),
(2386, 'no', 'fi', 'kirjanorja'),
(2387, 'no', 'ga', 'Norwegian Bokmål'),
(2388, 'no', 'he', 'נורווגית'),
(2389, 'no', 'hi', 'Norwegian Bokmål'),
(2390, 'no', 'hr', 'Književni norveški'),
(2391, 'no', 'hu', 'norvég bokmål'),
(2392, 'no', 'hy', 'Norwegian Bokmål'),
(2393, 'no', 'id', 'Norwegian Bokmål'),
(2394, 'no', 'is', 'Norwegian Bokmål'),
(2395, 'no', 'it', 'Norvegese Bokmål'),
(2396, 'no', 'ja', 'ノルウェー・ブークモール'),
(2397, 'no', 'ko', '노르웨이 보크말어'),
(2398, 'no', 'ku', 'Norwegian Bokmål'),
(2399, 'no', 'lv', 'Norwegian Bokmål'),
(2400, 'no', 'lt', 'Norwegian Bokmål'),
(2401, 'no', 'mk', 'Norwegian Bokmål'),
(2402, 'no', 'mt', 'Norwegian Bokmål'),
(2403, 'no', 'mn', 'Norwegian Bokmål'),
(2404, 'no', 'ne', 'Norwegian Bokmål'),
(2405, 'no', 'nl', 'Noors Bokmål'),
(2406, 'no', 'no', 'Norsk bokmål'),
(2407, 'no', 'pa', 'Norwegian Bokmål'),
(2408, 'no', 'pl', 'norweski bokmål'),
(2409, 'no', 'pt-pt', 'Norueguês'),
(2410, 'no', 'pt-br', 'Norueguês'),
(2411, 'no', 'qu', 'Norwegian Bokmål'),
(2412, 'no', 'ro', 'Bokmål (norvegiană)'),
(2413, 'no', 'ru', 'Норвежский букмол'),
(2414, 'no', 'sl', 'Knjižna norveščina'),
(2415, 'no', 'so', 'Norwegian Bokmål'),
(2416, 'no', 'sq', 'Norwegian Bokmål'),
(2417, 'no', 'sr', 'Норвешки бокмал'),
(2418, 'no', 'sv', 'Norskt Bokmål'),
(2419, 'no', 'ta', 'Norwegian Bokmål'),
(2420, 'no', 'th', 'นอร์วิเจียนบอกมาล'),
(2421, 'no', 'tr', 'Bokmal Norveç dili'),
(2422, 'no', 'uk', 'Norwegian Bokmål'),
(2423, 'no', 'ur', 'Norwegian Bokmål'),
(2424, 'no', 'uz', 'Norwegian Bokmål'),
(2425, 'no', 'vi', 'Norwegian Bokmål'),
(2426, 'no', 'yi', 'Norwegian Bokmål'),
(2427, 'no', 'zh-hans', '挪威布克莫尔语'),
(2428, 'no', 'zu', 'Norwegian Bokmål'),
(2429, 'no', 'zh-hant', '挪威布克莫爾語'),
(2430, 'no', 'ms', 'Norwegian Bokmål'),
(2431, 'no', 'gl', 'Norwegian Bokmål'),
(2432, 'no', 'bn', 'Norwegian Bokmål'),
(2433, 'pa', 'en', 'Punjabi'),
(2434, 'pa', 'es', 'Panyabí'),
(2435, 'pa', 'de', 'Pandschabi'),
(2436, 'pa', 'fr', 'Panjabi'),
(2437, 'pa', 'ar', 'البنجابية'),
(2438, 'pa', 'bs', 'Punjabi'),
(2439, 'pa', 'bg', 'Панджабски'),
(2440, 'pa', 'ca', 'Punjabi'),
(2441, 'pa', 'cs', 'Punjabi'),
(2442, 'pa', 'sk', 'Pandžábčina'),
(2443, 'pa', 'cy', 'Punjabi'),
(2444, 'pa', 'da', 'Punjabi'),
(2445, 'pa', 'el', 'Panjabi'),
(2446, 'pa', 'eo', 'Punjabi'),
(2447, 'pa', 'et', 'Punjabi'),
(2448, 'pa', 'eu', 'Punjabi'),
(2449, 'pa', 'fa', 'Punjabi'),
(2450, 'pa', 'fi', 'pandzabi'),
(2451, 'pa', 'ga', 'Punjabi'),
(2452, 'pa', 'he', 'פנג\'אבית'),
(2453, 'pa', 'hi', 'Punjabi'),
(2454, 'pa', 'hr', 'Pendžabljanin'),
(2455, 'pa', 'hu', 'pandzsábi'),
(2456, 'pa', 'hy', 'Punjabi'),
(2457, 'pa', 'id', 'Punjabi'),
(2458, 'pa', 'is', 'Punjabi'),
(2459, 'pa', 'it', 'Panjabi'),
(2460, 'pa', 'ja', 'パンジャーブ語'),
(2461, 'pa', 'ko', '펀자브어'),
(2462, 'pa', 'ku', 'Punjabi'),
(2463, 'pa', 'lv', 'Punjabi'),
(2464, 'pa', 'lt', 'Punjabi'),
(2465, 'pa', 'mk', 'Punjabi'),
(2466, 'pa', 'mt', 'Punjabi'),
(2467, 'pa', 'mn', 'Punjabi'),
(2468, 'pa', 'ne', 'Punjabi'),
(2469, 'pa', 'nl', 'Punjabi'),
(2470, 'pa', 'no', 'Punjabi'),
(2471, 'pa', 'pa', 'Punjabi'),
(2472, 'pa', 'pl', 'pendżabi'),
(2473, 'pa', 'pt-pt', 'Panjabi'),
(2474, 'pa', 'pt-br', 'Panjabi'),
(2475, 'pa', 'qu', 'Punjabi'),
(2476, 'pa', 'ro', 'Punjabi'),
(2477, 'pa', 'ru', 'Панджаби'),
(2478, 'pa', 'sl', 'Pandžabščina'),
(2479, 'pa', 'so', 'Punjabi'),
(2480, 'pa', 'sq', 'Punjabi'),
(2481, 'pa', 'sr', 'панџаби'),
(2482, 'pa', 'sv', 'Punjabi'),
(2483, 'pa', 'ta', 'Punjabi'),
(2484, 'pa', 'th', 'ปัญจาบ'),
(2485, 'pa', 'tr', 'Pencapça'),
(2486, 'pa', 'uk', 'Punjabi'),
(2487, 'pa', 'ur', 'Punjabi'),
(2488, 'pa', 'uz', 'Punjabi'),
(2489, 'pa', 'vi', 'Punjabi'),
(2490, 'pa', 'yi', 'Punjabi'),
(2491, 'pa', 'zh-hans', '旁遮普语'),
(2492, 'pa', 'zu', 'Punjabi'),
(2493, 'pa', 'zh-hant', '旁遮普語'),
(2494, 'pa', 'ms', 'Punjabi'),
(2495, 'pa', 'gl', 'Punjabi'),
(2496, 'pa', 'bn', 'Punjabi'),
(2497, 'pl', 'en', 'Polish'),
(2498, 'pl', 'es', 'Polaco'),
(2499, 'pl', 'de', 'Polnisch'),
(2500, 'pl', 'fr', 'Polonais'),
(2501, 'pl', 'ar', 'البولندية'),
(2502, 'pl', 'bs', 'Polish'),
(2503, 'pl', 'bg', 'Полски'),
(2504, 'pl', 'ca', 'Polish'),
(2505, 'pl', 'cs', 'Polský'),
(2506, 'pl', 'sk', 'Polština'),
(2507, 'pl', 'cy', 'Polish'),
(2508, 'pl', 'da', 'Polish'),
(2509, 'pl', 'el', 'Πολωνικα'),
(2510, 'pl', 'eo', 'Polish'),
(2511, 'pl', 'et', 'Polish'),
(2512, 'pl', 'eu', 'Polish'),
(2513, 'pl', 'fa', 'Polish'),
(2514, 'pl', 'fi', 'puola'),
(2515, 'pl', 'ga', 'Polish'),
(2516, 'pl', 'he', 'פולנית'),
(2517, 'pl', 'hi', 'Polish'),
(2518, 'pl', 'hr', 'Poljski'),
(2519, 'pl', 'hu', 'lengyel'),
(2520, 'pl', 'hy', 'Polish'),
(2521, 'pl', 'id', 'Polish'),
(2522, 'pl', 'is', 'Polish'),
(2523, 'pl', 'it', 'Polacco'),
(2524, 'pl', 'ja', 'ポーランド語'),
(2525, 'pl', 'ko', '폴란드어'),
(2526, 'pl', 'ku', 'Polish'),
(2527, 'pl', 'lv', 'Polish'),
(2528, 'pl', 'lt', 'Polish'),
(2529, 'pl', 'mk', 'Polish'),
(2530, 'pl', 'mt', 'Polish'),
(2531, 'pl', 'mn', 'Polish'),
(2532, 'pl', 'ne', 'Polish'),
(2533, 'pl', 'nl', 'Pools'),
(2534, 'pl', 'no', 'Polsk'),
(2535, 'pl', 'pa', 'Polish'),
(2536, 'pl', 'pl', 'polski'),
(2537, 'pl', 'pt-pt', 'Polonês'),
(2538, 'pl', 'pt-br', 'Polonês'),
(2539, 'pl', 'qu', 'Polish'),
(2540, 'pl', 'ro', 'Poloneză'),
(2541, 'pl', 'ru', 'Польский'),
(2542, 'pl', 'sl', 'Poljski'),
(2543, 'pl', 'so', 'Polish'),
(2544, 'pl', 'sq', 'Polish'),
(2545, 'pl', 'sr', 'пољски'),
(2546, 'pl', 'sv', 'Polska'),
(2547, 'pl', 'ta', 'Polish'),
(2548, 'pl', 'th', 'โปแลนด์'),
(2549, 'pl', 'tr', 'Polonyaca'),
(2550, 'pl', 'uk', 'Polish'),
(2551, 'pl', 'ur', 'Polish'),
(2552, 'pl', 'uz', 'Polish'),
(2553, 'pl', 'vi', 'Polish'),
(2554, 'pl', 'yi', 'Polish'),
(2555, 'pl', 'zh-hans', '波兰语'),
(2556, 'pl', 'zu', 'Polish'),
(2557, 'pl', 'zh-hant', '波蘭語'),
(2558, 'pl', 'ms', 'Polish'),
(2559, 'pl', 'gl', 'Polish'),
(2560, 'pl', 'bn', 'Polish'),
(2561, 'pt-pt', 'en', 'Portuguese (Portugal)'),
(2562, 'pt-pt', 'es', 'Portugués, Portugal'),
(2563, 'pt-pt', 'de', 'Portugiesisch, Portugal'),
(2564, 'pt-pt', 'fr', 'Portugais - du Portugal'),
(2565, 'pt-pt', 'ar', 'البرتغالية ، البرتغال'),
(2566, 'pt-pt', 'bs', 'Portuguese, Portugal'),
(2567, 'pt-pt', 'bg', 'Португалски (Португалия)'),
(2568, 'pt-pt', 'ca', 'Portuguese, Portugal'),
(2569, 'pt-pt', 'cs', 'Portugalština ( Portugalsko)'),
(2570, 'pt-pt', 'sk', 'Portugalština'),
(2571, 'pt-pt', 'cy', 'Portuguese, Portugal'),
(2572, 'pt-pt', 'da', 'Portuguese, Portugal'),
(2573, 'pt-pt', 'el', 'Πορτογαλικα'),
(2574, 'pt-pt', 'eo', 'Portuguese, Portugal'),
(2575, 'pt-pt', 'et', 'Portuguese, Portugal'),
(2576, 'pt-pt', 'eu', 'Portuguese, Portugal'),
(2577, 'pt-pt', 'fa', 'Portuguese, Portugal'),
(2578, 'pt-pt', 'fi', 'portugali'),
(2579, 'pt-pt', 'ga', 'Portuguese, Portugal'),
(2580, 'pt-pt', 'he', 'פורטוגזית'),
(2581, 'pt-pt', 'hi', 'Portuguese, Portugal'),
(2582, 'pt-pt', 'hr', 'Portugalski (Portugal)'),
(2583, 'pt-pt', 'hu', 'portugál'),
(2584, 'pt-pt', 'hy', 'Portuguese, Portugal'),
(2585, 'pt-pt', 'id', 'Portuguese, Portugal'),
(2586, 'pt-pt', 'is', 'Portuguese, Portugal'),
(2587, 'pt-pt', 'it', 'Portoghese, Portogallo'),
(2588, 'pt-pt', 'ja', 'ポルトガル語'),
(2589, 'pt-pt', 'ko', '포르투갈 포르투갈어'),
(2590, 'pt-pt', 'ku', 'Portuguese, Portugal'),
(2591, 'pt-pt', 'lv', 'Portuguese, Portugal'),
(2592, 'pt-pt', 'lt', 'Portuguese, Portugal'),
(2593, 'pt-pt', 'mk', 'Portuguese, Portugal'),
(2594, 'pt-pt', 'mt', 'Portuguese, Portugal'),
(2595, 'pt-pt', 'mn', 'Portuguese, Portugal'),
(2596, 'pt-pt', 'ne', 'Portuguese, Portugal'),
(2597, 'pt-pt', 'nl', 'Portugees, Portugal'),
(2598, 'pt-pt', 'no', 'Portugisisk (Portugal)'),
(2599, 'pt-pt', 'pa', 'Portuguese, Portugal'),
(2600, 'pt-pt', 'pl', 'portugalski, Portugalia'),
(2601, 'pt-pt', 'pt-pt', 'Português'),
(2602, 'pt-pt', 'pt-br', 'Português'),
(2603, 'pt-pt', 'qu', 'Portuguese, Portugal'),
(2604, 'pt-pt', 'ro', 'Portugheză (Portugalia)'),
(2605, 'pt-pt', 'ru', 'Португальский, Португалия'),
(2606, 'pt-pt', 'sl', 'Portugalščina ( Portugalska )'),
(2607, 'pt-pt', 'so', 'Portuguese, Portugal'),
(2608, 'pt-pt', 'sq', 'Portuguese, Portugal'),
(2609, 'pt-pt', 'sr', 'Португалски (Португалија)'),
(2610, 'pt-pt', 'sv', 'Portugisiska, Portugal'),
(2611, 'pt-pt', 'ta', 'Portuguese, Portugal'),
(2612, 'pt-pt', 'th', 'โปรตุเกส'),
(2613, 'pt-pt', 'tr', 'Portekizce, Portekiz'),
(2614, 'pt-pt', 'uk', 'Portuguese, Portugal'),
(2615, 'pt-pt', 'ur', 'Portuguese, Portugal'),
(2616, 'pt-pt', 'uz', 'Portuguese, Portugal'),
(2617, 'pt-pt', 'vi', 'Portuguese, Portugal'),
(2618, 'pt-pt', 'yi', 'Portuguese, Portugal'),
(2619, 'pt-pt', 'zh-hans', '葡萄牙语（葡萄牙）'),
(2620, 'pt-pt', 'zu', 'Portuguese, Portugal'),
(2621, 'pt-pt', 'zh-hant', '葡萄牙語（葡萄牙）'),
(2622, 'pt-pt', 'ms', 'Portuguese, Portugal'),
(2623, 'pt-pt', 'gl', 'Portuguese, Portugal'),
(2624, 'pt-pt', 'bn', 'Portuguese, Portugal'),
(2625, 'pt-br', 'en', 'Portuguese (Brazil)'),
(2626, 'pt-br', 'es', 'Portugués, Brasil'),
(2627, 'pt-br', 'de', 'Portugiesisch, Brasilien'),
(2628, 'pt-br', 'fr', 'Portugais - du Brésil'),
(2629, 'pt-br', 'ar', 'البرتغالية ،البرازيل'),
(2630, 'pt-br', 'bs', 'Portuguese, Brazil'),
(2631, 'pt-br', 'bg', 'Португалски (Бразилия)'),
(2632, 'pt-br', 'ca', 'Portuguese, Brazil'),
(2633, 'pt-br', 'cs', 'Portugalština ( Brazílie)'),
(2634, 'pt-br', 'sk', 'Brazílska Portugalština'),
(2635, 'pt-br', 'cy', 'Portuguese, Brazil'),
(2636, 'pt-br', 'da', 'Portuguese, Brazil'),
(2637, 'pt-br', 'el', 'Πορτογαλικα'),
(2638, 'pt-br', 'eo', 'Portuguese, Brazil'),
(2639, 'pt-br', 'et', 'Portuguese, Brazil'),
(2640, 'pt-br', 'eu', 'Portuguese, Brazil'),
(2641, 'pt-br', 'fa', 'Portuguese, Brazil'),
(2642, 'pt-br', 'fi', 'Brasilian portugali'),
(2643, 'pt-br', 'ga', 'Portuguese, Brazil'),
(2644, 'pt-br', 'he', 'פורטוגזית - ברזיל'),
(2645, 'pt-br', 'hi', 'Portuguese, Brazil'),
(2646, 'pt-br', 'hr', 'Portugalski (Brazil)'),
(2647, 'pt-br', 'hu', 'brazil'),
(2648, 'pt-br', 'hy', 'Portuguese, Brazil'),
(2649, 'pt-br', 'id', 'Portuguese, Brazil'),
(2650, 'pt-br', 'is', 'Portuguese, Brazil'),
(2651, 'pt-br', 'it', 'Portoghese, Brasile'),
(2652, 'pt-br', 'ja', 'ポルトガル語（ブラジル）'),
(2653, 'pt-br', 'ko', '브라질 포르투갈어'),
(2654, 'pt-br', 'ku', 'Portuguese, Brazil'),
(2655, 'pt-br', 'lv', 'Portuguese, Brazil'),
(2656, 'pt-br', 'lt', 'Portuguese, Brazil'),
(2657, 'pt-br', 'mk', 'Portuguese, Brazil'),
(2658, 'pt-br', 'mt', 'Portuguese, Brazil'),
(2659, 'pt-br', 'mn', 'Portuguese, Brazil'),
(2660, 'pt-br', 'ne', 'Portuguese, Brazil'),
(2661, 'pt-br', 'nl', 'Portugees, Brazilië'),
(2662, 'pt-br', 'no', 'Portugisisk (Brasil)'),
(2663, 'pt-br', 'pa', 'Portuguese, Brazil'),
(2664, 'pt-br', 'pl', 'portugalski, Brazylia'),
(2665, 'pt-br', 'pt-pt', 'Português'),
(2666, 'pt-br', 'pt-br', 'Português'),
(2667, 'pt-br', 'qu', 'Portuguese, Brazil'),
(2668, 'pt-br', 'ro', 'Portugheză (Brazilia)'),
(2669, 'pt-br', 'ru', 'Португальский, Бразилия'),
(2670, 'pt-br', 'sl', 'Portugalščina ( Brazilija )'),
(2671, 'pt-br', 'so', 'Portuguese, Brazil'),
(2672, 'pt-br', 'sq', 'Portuguese, Brazil'),
(2673, 'pt-br', 'sr', 'Португалски (Бразил)'),
(2674, 'pt-br', 'sv', 'Portugisiska, Brasilien'),
(2675, 'pt-br', 'ta', 'Portuguese, Brazil'),
(2676, 'pt-br', 'th', 'โปรตุเกสบราซิล'),
(2677, 'pt-br', 'tr', 'Portekizce, Brezilya'),
(2678, 'pt-br', 'uk', 'Portuguese, Brazil'),
(2679, 'pt-br', 'ur', 'Portuguese, Brazil'),
(2680, 'pt-br', 'uz', 'Portuguese, Brazil'),
(2681, 'pt-br', 'vi', 'Portuguese, Brazil'),
(2682, 'pt-br', 'yi', 'Portuguese, Brazil'),
(2683, 'pt-br', 'zh-hans', '葡萄牙语（巴西）'),
(2684, 'pt-br', 'zu', 'Portuguese, Brazil'),
(2685, 'pt-br', 'zh-hant', '葡萄牙語（巴西）'),
(2686, 'pt-br', 'ms', 'Portuguese, Brazil'),
(2687, 'pt-br', 'gl', 'Portuguese, Brazil'),
(2688, 'pt-br', 'bn', 'Portuguese, Brazil'),
(2689, 'qu', 'en', 'Quechua'),
(2690, 'qu', 'es', 'Quechua'),
(2691, 'qu', 'de', 'Quechua'),
(2692, 'qu', 'fr', 'Quechua'),
(2693, 'qu', 'ar', 'الكويتشوا'),
(2694, 'qu', 'bs', 'Quechua'),
(2695, 'qu', 'bg', 'Кечуа'),
(2696, 'qu', 'ca', 'Quechua'),
(2697, 'qu', 'cs', 'Quechua'),
(2698, 'qu', 'sk', 'Jazyk Quechua'),
(2699, 'qu', 'cy', 'Quechua'),
(2700, 'qu', 'da', 'Quechua'),
(2701, 'qu', 'el', 'Κετσουα'),
(2702, 'qu', 'eo', 'Quechua'),
(2703, 'qu', 'et', 'Quechua'),
(2704, 'qu', 'eu', 'Quechua'),
(2705, 'qu', 'fa', 'Quechua'),
(2706, 'qu', 'fi', 'ketsua'),
(2707, 'qu', 'ga', 'Quechua'),
(2708, 'qu', 'he', 'קצ\'ואה'),
(2709, 'qu', 'hi', 'Quechua'),
(2710, 'qu', 'hr', 'Quechua'),
(2711, 'qu', 'hu', 'quechua'),
(2712, 'qu', 'hy', 'Quechua'),
(2713, 'qu', 'id', 'Quechua'),
(2714, 'qu', 'is', 'Quechua'),
(2715, 'qu', 'it', 'Quechua'),
(2716, 'qu', 'ja', 'ケチュア語'),
(2717, 'qu', 'ko', '케추아어'),
(2718, 'qu', 'ku', 'Quechua'),
(2719, 'qu', 'lv', 'Quechua'),
(2720, 'qu', 'lt', 'Quechua'),
(2721, 'qu', 'mk', 'Quechua'),
(2722, 'qu', 'mt', 'Quechua'),
(2723, 'qu', 'mn', 'Quechua'),
(2724, 'qu', 'ne', 'Quechua'),
(2725, 'qu', 'nl', 'Quechua'),
(2726, 'qu', 'no', 'Quechua'),
(2727, 'qu', 'pa', 'Quechua'),
(2728, 'qu', 'pl', 'keczua'),
(2729, 'qu', 'pt-pt', 'Quechua'),
(2730, 'qu', 'pt-br', 'Quechua'),
(2731, 'qu', 'qu', 'Quechua'),
(2732, 'qu', 'ro', 'Quechuană'),
(2733, 'qu', 'ru', 'Кечуа'),
(2734, 'qu', 'sl', 'Quechua'),
(2735, 'qu', 'so', 'Quechua'),
(2736, 'qu', 'sq', 'Quechua'),
(2737, 'qu', 'sr', 'Кечуа'),
(2738, 'qu', 'sv', 'Quechua'),
(2739, 'qu', 'ta', 'Quechua'),
(2740, 'qu', 'th', 'คิวชัว'),
(2741, 'qu', 'tr', 'Quechua dili'),
(2742, 'qu', 'uk', 'Quechua'),
(2743, 'qu', 'ur', 'Quechua'),
(2744, 'qu', 'uz', 'Quechua'),
(2745, 'qu', 'vi', 'Quechua'),
(2746, 'qu', 'yi', 'Quechua'),
(2747, 'qu', 'zh-hans', '盖丘亚语'),
(2748, 'qu', 'zu', 'Quechua'),
(2749, 'qu', 'zh-hant', '蓋丘亞語'),
(2750, 'qu', 'ms', 'Quechua'),
(2751, 'qu', 'gl', 'Quechua'),
(2752, 'qu', 'bn', 'Quechua'),
(2753, 'ro', 'en', 'Romanian'),
(2754, 'ro', 'es', 'Rumano'),
(2755, 'ro', 'de', 'Rumänisch'),
(2756, 'ro', 'fr', 'Roumain'),
(2757, 'ro', 'ar', 'الرومانية'),
(2758, 'ro', 'bs', 'Romanian'),
(2759, 'ro', 'bg', 'Румънски'),
(2760, 'ro', 'ca', 'Romanian'),
(2761, 'ro', 'cs', 'Rumunština'),
(2762, 'ro', 'sk', 'Rumunčina'),
(2763, 'ro', 'cy', 'Romanian'),
(2764, 'ro', 'da', 'Romanian'),
(2765, 'ro', 'el', 'Ρουμανικα'),
(2766, 'ro', 'eo', 'Romanian'),
(2767, 'ro', 'et', 'Romanian'),
(2768, 'ro', 'eu', 'Romanian'),
(2769, 'ro', 'fa', 'Romanian'),
(2770, 'ro', 'fi', 'romania'),
(2771, 'ro', 'ga', 'Romanian'),
(2772, 'ro', 'he', 'רומנית'),
(2773, 'ro', 'hi', 'Romanian'),
(2774, 'ro', 'hr', 'Rumunjski'),
(2775, 'ro', 'hu', 'román'),
(2776, 'ro', 'hy', 'Romanian'),
(2777, 'ro', 'id', 'Romanian'),
(2778, 'ro', 'is', 'Romanian'),
(2779, 'ro', 'it', 'Rumeno'),
(2780, 'ro', 'ja', 'ルーマニア語'),
(2781, 'ro', 'ko', '로마니아어'),
(2782, 'ro', 'ku', 'Romanian'),
(2783, 'ro', 'lv', 'Romanian'),
(2784, 'ro', 'lt', 'Romanian'),
(2785, 'ro', 'mk', 'Romanian'),
(2786, 'ro', 'mt', 'Romanian'),
(2787, 'ro', 'mn', 'Romanian'),
(2788, 'ro', 'ne', 'Romanian'),
(2789, 'ro', 'nl', 'Roemeens'),
(2790, 'ro', 'no', 'Rumensk'),
(2791, 'ro', 'pa', 'Romanian'),
(2792, 'ro', 'pl', 'rumuński'),
(2793, 'ro', 'pt-pt', 'Romeno'),
(2794, 'ro', 'pt-br', 'Romeno'),
(2795, 'ro', 'qu', 'Romanian'),
(2796, 'ro', 'ro', 'Română'),
(2797, 'ro', 'ru', 'Румынский'),
(2798, 'ro', 'sl', 'Romunščina'),
(2799, 'ro', 'so', 'Romanian'),
(2800, 'ro', 'sq', 'Romanian'),
(2801, 'ro', 'sr', 'румунски'),
(2802, 'ro', 'sv', 'Rumänska'),
(2803, 'ro', 'ta', 'Romanian'),
(2804, 'ro', 'th', 'โรมาเนีย'),
(2805, 'ro', 'tr', 'Rumence'),
(2806, 'ro', 'uk', 'Romanian'),
(2807, 'ro', 'ur', 'Romanian'),
(2808, 'ro', 'uz', 'Romanian'),
(2809, 'ro', 'vi', 'Romanian'),
(2810, 'ro', 'yi', 'Romanian'),
(2811, 'ro', 'zh-hans', '罗马尼亚语'),
(2812, 'ro', 'zu', 'Romanian'),
(2813, 'ro', 'zh-hant', '羅馬尼亞語'),
(2814, 'ro', 'ms', 'Romanian'),
(2815, 'ro', 'gl', 'Romanian'),
(2816, 'ro', 'bn', 'Romanian'),
(2817, 'ru', 'en', 'Russian'),
(2818, 'ru', 'es', 'Ruso'),
(2819, 'ru', 'de', 'Russisch'),
(2820, 'ru', 'fr', 'Russe'),
(2821, 'ru', 'ar', 'الروسية'),
(2822, 'ru', 'bs', 'Russian'),
(2823, 'ru', 'bg', 'Руски'),
(2824, 'ru', 'ca', 'Russian'),
(2825, 'ru', 'cs', 'Ruský'),
(2826, 'ru', 'sk', 'Ruština'),
(2827, 'ru', 'cy', 'Russian'),
(2828, 'ru', 'da', 'Russian'),
(2829, 'ru', 'el', 'Ρωσικα'),
(2830, 'ru', 'eo', 'Russian'),
(2831, 'ru', 'et', 'Russian'),
(2832, 'ru', 'eu', 'Russian'),
(2833, 'ru', 'fa', 'Russian'),
(2834, 'ru', 'fi', 'venäjä'),
(2835, 'ru', 'ga', 'Russian'),
(2836, 'ru', 'he', 'רוסית'),
(2837, 'ru', 'hi', 'Russian'),
(2838, 'ru', 'hr', 'Ruski'),
(2839, 'ru', 'hu', 'orosz'),
(2840, 'ru', 'hy', 'Russian'),
(2841, 'ru', 'id', 'Russian'),
(2842, 'ru', 'is', 'Russian'),
(2843, 'ru', 'it', 'Russo'),
(2844, 'ru', 'ja', 'ロシア語'),
(2845, 'ru', 'ko', '러시아어'),
(2846, 'ru', 'ku', 'Russian'),
(2847, 'ru', 'lv', 'Russian'),
(2848, 'ru', 'lt', 'Russian'),
(2849, 'ru', 'mk', 'Russian'),
(2850, 'ru', 'mt', 'Russian'),
(2851, 'ru', 'mn', 'Russian'),
(2852, 'ru', 'ne', 'Russian'),
(2853, 'ru', 'nl', 'Russisch'),
(2854, 'ru', 'no', 'Russisk'),
(2855, 'ru', 'pa', 'Russian'),
(2856, 'ru', 'pl', 'rosyjski'),
(2857, 'ru', 'pt-pt', 'Russo'),
(2858, 'ru', 'pt-br', 'Russo'),
(2859, 'ru', 'qu', 'Russian'),
(2860, 'ru', 'ro', 'Rusă'),
(2861, 'ru', 'ru', 'Русский'),
(2862, 'ru', 'sl', 'Ruščina'),
(2863, 'ru', 'so', 'Russian'),
(2864, 'ru', 'sq', 'Russian'),
(2865, 'ru', 'sr', 'руски'),
(2866, 'ru', 'sv', 'Ryska'),
(2867, 'ru', 'ta', 'Russian'),
(2868, 'ru', 'th', 'รัสเซีย'),
(2869, 'ru', 'tr', 'Rusça'),
(2870, 'ru', 'uk', 'Russian'),
(2871, 'ru', 'ur', 'Russian'),
(2872, 'ru', 'uz', 'Russian'),
(2873, 'ru', 'vi', 'Russian'),
(2874, 'ru', 'yi', 'Russian'),
(2875, 'ru', 'zh-hans', '俄语'),
(2876, 'ru', 'zu', 'Russian'),
(2877, 'ru', 'zh-hant', '俄語'),
(2878, 'ru', 'ms', 'Russian'),
(2879, 'ru', 'gl', 'Russian'),
(2880, 'ru', 'bn', 'Russian'),
(2881, 'sl', 'en', 'Slovenian'),
(2882, 'sl', 'es', 'Esloveno'),
(2883, 'sl', 'de', 'Slowenisch'),
(2884, 'sl', 'fr', 'Slovène'),
(2885, 'sl', 'ar', 'السلوفانية'),
(2886, 'sl', 'bs', 'Slovenian'),
(2887, 'sl', 'bg', 'Словенски'),
(2888, 'sl', 'ca', 'Slovenian'),
(2889, 'sl', 'cs', 'Slovinština'),
(2890, 'sl', 'sk', 'Slovinčina'),
(2891, 'sl', 'cy', 'Slovenian'),
(2892, 'sl', 'da', 'Slovenian'),
(2893, 'sl', 'el', 'Σλοβενικα'),
(2894, 'sl', 'eo', 'Slovenian'),
(2895, 'sl', 'et', 'Slovenian'),
(2896, 'sl', 'eu', 'Slovenian'),
(2897, 'sl', 'fa', 'Slovenian'),
(2898, 'sl', 'fi', 'sloveeni'),
(2899, 'sl', 'ga', 'Slovenian'),
(2900, 'sl', 'he', 'סלובנית'),
(2901, 'sl', 'hi', 'Slovenian'),
(2902, 'sl', 'hr', 'Slovenac'),
(2903, 'sl', 'hu', 'szlovén'),
(2904, 'sl', 'hy', 'Slovenian'),
(2905, 'sl', 'id', 'Slovenian'),
(2906, 'sl', 'is', 'Slovenian'),
(2907, 'sl', 'it', 'Sloveno'),
(2908, 'sl', 'ja', 'スロベニア語'),
(2909, 'sl', 'ko', '슬로베니아어'),
(2910, 'sl', 'ku', 'Slovenian'),
(2911, 'sl', 'lv', 'Slovenian'),
(2912, 'sl', 'lt', 'Slovenian'),
(2913, 'sl', 'mk', 'Slovenian'),
(2914, 'sl', 'mt', 'Slovenian'),
(2915, 'sl', 'mn', 'Slovenian'),
(2916, 'sl', 'ne', 'Slovenian'),
(2917, 'sl', 'nl', 'Sloveens'),
(2918, 'sl', 'no', 'Slovensk'),
(2919, 'sl', 'pa', 'Slovenian'),
(2920, 'sl', 'pl', 'słoweński'),
(2921, 'sl', 'pt-pt', 'Esloveno'),
(2922, 'sl', 'pt-br', 'Esloveno'),
(2923, 'sl', 'qu', 'Slovenian'),
(2924, 'sl', 'ro', 'Slovenă'),
(2925, 'sl', 'ru', 'Словенский'),
(2926, 'sl', 'sl', 'Slovenščina'),
(2927, 'sl', 'so', 'Slovenian'),
(2928, 'sl', 'sq', 'Slovenian'),
(2929, 'sl', 'sr', 'словеначки'),
(2930, 'sl', 'sv', 'Slovenska'),
(2931, 'sl', 'ta', 'Slovenian'),
(2932, 'sl', 'th', 'สโลวีเนียน'),
(2933, 'sl', 'tr', 'Sloven dili'),
(2934, 'sl', 'uk', 'Slovenian'),
(2935, 'sl', 'ur', 'Slovenian'),
(2936, 'sl', 'uz', 'Slovenian'),
(2937, 'sl', 'vi', 'Slovenian'),
(2938, 'sl', 'yi', 'Slovenian'),
(2939, 'sl', 'zh-hans', '斯洛文尼亚语'),
(2940, 'sl', 'zu', 'Slovenian'),
(2941, 'sl', 'zh-hant', '斯洛文尼亞語'),
(2942, 'sl', 'ms', 'Slovenian'),
(2943, 'sl', 'gl', 'Slovenian'),
(2944, 'sl', 'bn', 'Slovenian'),
(2945, 'so', 'en', 'Somali'),
(2946, 'so', 'es', 'Somalí'),
(2947, 'so', 'de', 'Somali'),
(2948, 'so', 'fr', 'Somali'),
(2949, 'so', 'ar', 'الصومالية'),
(2950, 'so', 'bs', 'Somali'),
(2951, 'so', 'bg', 'Сомалийски'),
(2952, 'so', 'ca', 'Somali'),
(2953, 'so', 'cs', 'Somali'),
(2954, 'so', 'sk', 'Somálčina'),
(2955, 'so', 'cy', 'Somali'),
(2956, 'so', 'da', 'Somali'),
(2957, 'so', 'el', 'Somali'),
(2958, 'so', 'eo', 'Somali'),
(2959, 'so', 'et', 'Somali'),
(2960, 'so', 'eu', 'Somali'),
(2961, 'so', 'fa', 'Somali'),
(2962, 'so', 'fi', 'somali'),
(2963, 'so', 'ga', 'Somali'),
(2964, 'so', 'he', 'סומלית'),
(2965, 'so', 'hi', 'Somali'),
(2966, 'so', 'hr', 'Somalijski'),
(2967, 'so', 'hu', 'szomáli'),
(2968, 'so', 'hy', 'Somali'),
(2969, 'so', 'id', 'Somali'),
(2970, 'so', 'is', 'Somali'),
(2971, 'so', 'it', 'Somalo'),
(2972, 'so', 'ja', 'ソマリ語'),
(2973, 'so', 'ko', '소말리아어'),
(2974, 'so', 'ku', 'Somali'),
(2975, 'so', 'lv', 'Somali'),
(2976, 'so', 'lt', 'Somali'),
(2977, 'so', 'mk', 'Somali'),
(2978, 'so', 'mt', 'Somali'),
(2979, 'so', 'mn', 'Somali'),
(2980, 'so', 'ne', 'Somali'),
(2981, 'so', 'nl', 'Somalisch'),
(2982, 'so', 'no', 'Somali'),
(2983, 'so', 'pa', 'Somali'),
(2984, 'so', 'pl', 'somalijski'),
(2985, 'so', 'pt-pt', 'Somali'),
(2986, 'so', 'pt-br', 'Somali'),
(2987, 'so', 'qu', 'Somali'),
(2988, 'so', 'ro', 'Somaleză'),
(2989, 'so', 'ru', 'Сомалийский'),
(2990, 'so', 'sl', 'Somalski'),
(2991, 'so', 'so', 'Somali'),
(2992, 'so', 'sq', 'Somali'),
(2993, 'so', 'sr', 'Сомалијски'),
(2994, 'so', 'sv', 'Somaliska'),
(2995, 'so', 'ta', 'Somali'),
(2996, 'so', 'th', 'โซมาลี'),
(2997, 'so', 'tr', 'Somalice'),
(2998, 'so', 'uk', 'Somali'),
(2999, 'so', 'ur', 'Somali'),
(3000, 'so', 'uz', 'Somali'),
(3001, 'so', 'vi', 'Somali'),
(3002, 'so', 'yi', 'Somali'),
(3003, 'so', 'zh-hans', '索马里语'),
(3004, 'so', 'zu', 'Somali'),
(3005, 'so', 'zh-hant', '索馬里語'),
(3006, 'so', 'ms', 'Somali'),
(3007, 'so', 'gl', 'Somali'),
(3008, 'so', 'bn', 'Somali'),
(3009, 'sq', 'en', 'Albanian'),
(3010, 'sq', 'es', 'Albanés'),
(3011, 'sq', 'de', 'Albanisch'),
(3012, 'sq', 'fr', 'Albanais'),
(3013, 'sq', 'ar', 'الألبانية'),
(3014, 'sq', 'bs', 'Albanian'),
(3015, 'sq', 'bg', 'Албански'),
(3016, 'sq', 'ca', 'Albanian'),
(3017, 'sq', 'cs', 'Albánský'),
(3018, 'sq', 'sk', 'Albánčina'),
(3019, 'sq', 'cy', 'Albanian'),
(3020, 'sq', 'da', 'Albanian'),
(3021, 'sq', 'el', 'Αλβανικα'),
(3022, 'sq', 'eo', 'Albanian'),
(3023, 'sq', 'et', 'Albanian'),
(3024, 'sq', 'eu', 'Albanian'),
(3025, 'sq', 'fa', 'Albanian'),
(3026, 'sq', 'fi', 'albania'),
(3027, 'sq', 'ga', 'Albanian'),
(3028, 'sq', 'he', 'אלבנית'),
(3029, 'sq', 'hi', 'Albanian'),
(3030, 'sq', 'hr', 'Albanac'),
(3031, 'sq', 'hu', 'albán'),
(3032, 'sq', 'hy', 'Albanian'),
(3033, 'sq', 'id', 'Albanian'),
(3034, 'sq', 'is', 'Albanian'),
(3035, 'sq', 'it', 'Albanese'),
(3036, 'sq', 'ja', 'アルバニア語'),
(3037, 'sq', 'ko', '알바니아어'),
(3038, 'sq', 'ku', 'Albanian'),
(3039, 'sq', 'lv', 'Albanian'),
(3040, 'sq', 'lt', 'Albanian'),
(3041, 'sq', 'mk', 'Albanian'),
(3042, 'sq', 'mt', 'Albanian'),
(3043, 'sq', 'mn', 'Albanian'),
(3044, 'sq', 'ne', 'Albanian'),
(3045, 'sq', 'nl', 'Albaans'),
(3046, 'sq', 'no', 'Albansk'),
(3047, 'sq', 'pa', 'Albanian'),
(3048, 'sq', 'pl', 'albański'),
(3049, 'sq', 'pt-pt', 'Albanês'),
(3050, 'sq', 'pt-br', 'Albanês'),
(3051, 'sq', 'qu', 'Albanian'),
(3052, 'sq', 'ro', 'Albaneză'),
(3053, 'sq', 'ru', 'Албанский'),
(3054, 'sq', 'sl', 'Albanski'),
(3055, 'sq', 'so', 'Albanian'),
(3056, 'sq', 'sq', 'Albanian'),
(3057, 'sq', 'sr', 'албански'),
(3058, 'sq', 'sv', 'Albanska'),
(3059, 'sq', 'ta', 'Albanian'),
(3060, 'sq', 'th', 'อัลเบเนีย'),
(3061, 'sq', 'tr', 'Arnavutça'),
(3062, 'sq', 'uk', 'Albanian'),
(3063, 'sq', 'ur', 'Albanian'),
(3064, 'sq', 'uz', 'Albanian'),
(3065, 'sq', 'vi', 'Albanian'),
(3066, 'sq', 'yi', 'Albanian'),
(3067, 'sq', 'zh-hans', '阿尔巴尼亚语'),
(3068, 'sq', 'zu', 'Albanian'),
(3069, 'sq', 'zh-hant', '阿爾巴尼亞語'),
(3070, 'sq', 'ms', 'Albanian'),
(3071, 'sq', 'gl', 'Albanian'),
(3072, 'sq', 'bn', 'Albanian'),
(3073, 'sr', 'en', 'Serbian'),
(3074, 'sr', 'es', 'Serbio'),
(3075, 'sr', 'de', 'Serbisch'),
(3076, 'sr', 'fr', 'Serbe'),
(3077, 'sr', 'ar', 'الصربية'),
(3078, 'sr', 'bs', 'Serbian'),
(3079, 'sr', 'bg', 'Сръбски'),
(3080, 'sr', 'ca', 'Serbian'),
(3081, 'sr', 'cs', 'Srbský'),
(3082, 'sr', 'sk', 'Srbština'),
(3083, 'sr', 'cy', 'Serbian'),
(3084, 'sr', 'da', 'Serbian'),
(3085, 'sr', 'el', 'Σερβικα'),
(3086, 'sr', 'eo', 'Serbian'),
(3087, 'sr', 'et', 'Serbian'),
(3088, 'sr', 'eu', 'Serbian'),
(3089, 'sr', 'fa', 'Serbian'),
(3090, 'sr', 'fi', 'serbia'),
(3091, 'sr', 'ga', 'Serbian'),
(3092, 'sr', 'he', 'סרבית'),
(3093, 'sr', 'hi', 'Serbian'),
(3094, 'sr', 'hr', 'Srpski'),
(3095, 'sr', 'hu', 'szerb'),
(3096, 'sr', 'hy', 'Serbian'),
(3097, 'sr', 'id', 'Serbian'),
(3098, 'sr', 'is', 'Serbian'),
(3099, 'sr', 'it', 'Serbo'),
(3100, 'sr', 'ja', 'セルビア語'),
(3101, 'sr', 'ko', '세르비아어'),
(3102, 'sr', 'ku', 'Serbian'),
(3103, 'sr', 'lv', 'Serbian'),
(3104, 'sr', 'lt', 'Serbian'),
(3105, 'sr', 'mk', 'Serbian'),
(3106, 'sr', 'mt', 'Serbian'),
(3107, 'sr', 'mn', 'Serbian'),
(3108, 'sr', 'ne', 'Serbian'),
(3109, 'sr', 'nl', 'Servisch'),
(3110, 'sr', 'no', 'Serbisk'),
(3111, 'sr', 'pa', 'Serbian'),
(3112, 'sr', 'pl', 'serbski'),
(3113, 'sr', 'pt-pt', 'Sérvio'),
(3114, 'sr', 'pt-br', 'Sérvio'),
(3115, 'sr', 'qu', 'Serbian'),
(3116, 'sr', 'ro', 'Sârbă'),
(3117, 'sr', 'ru', 'Сербский'),
(3118, 'sr', 'sl', 'Srbski'),
(3119, 'sr', 'so', 'Serbian'),
(3120, 'sr', 'sq', 'Serbian'),
(3121, 'sr', 'sr', 'српски'),
(3122, 'sr', 'sv', 'Serbiska'),
(3123, 'sr', 'ta', 'Serbian'),
(3124, 'sr', 'th', 'เซอร์เบีย'),
(3125, 'sr', 'tr', 'Sırpça'),
(3126, 'sr', 'uk', 'Serbian'),
(3127, 'sr', 'ur', 'Serbian'),
(3128, 'sr', 'uz', 'Serbian'),
(3129, 'sr', 'vi', 'Serbian'),
(3130, 'sr', 'yi', 'Serbian'),
(3131, 'sr', 'zh-hans', '赛尔维亚语'),
(3132, 'sr', 'zu', 'Serbian'),
(3133, 'sr', 'zh-hant', '賽爾維亞語'),
(3134, 'sr', 'ms', 'Serbian'),
(3135, 'sr', 'gl', 'Serbian'),
(3136, 'sr', 'bn', 'Serbian'),
(3137, 'sv', 'en', 'Swedish'),
(3138, 'sv', 'es', 'Sueco'),
(3139, 'sv', 'de', 'Schwedisch'),
(3140, 'sv', 'fr', 'Suédois'),
(3141, 'sv', 'ar', 'السويدية'),
(3142, 'sv', 'bs', 'Swedish'),
(3143, 'sv', 'bg', 'Шведски'),
(3144, 'sv', 'ca', 'Swedish'),
(3145, 'sv', 'cs', 'Švédský'),
(3146, 'sv', 'sk', 'Švédština'),
(3147, 'sv', 'cy', 'Swedish'),
(3148, 'sv', 'da', 'Swedish'),
(3149, 'sv', 'el', 'Σουηδικη'),
(3150, 'sv', 'eo', 'Swedish'),
(3151, 'sv', 'et', 'Swedish'),
(3152, 'sv', 'eu', 'Swedish'),
(3153, 'sv', 'fa', 'Swedish'),
(3154, 'sv', 'fi', 'ruotsi'),
(3155, 'sv', 'ga', 'Swedish'),
(3156, 'sv', 'he', 'שוודית'),
(3157, 'sv', 'hi', 'Swedish'),
(3158, 'sv', 'hr', 'švedski'),
(3159, 'sv', 'hu', 'svéd'),
(3160, 'sv', 'hy', 'Swedish'),
(3161, 'sv', 'id', 'Swedish'),
(3162, 'sv', 'is', 'Swedish'),
(3163, 'sv', 'it', 'Svedese'),
(3164, 'sv', 'ja', 'スウェーデン語'),
(3165, 'sv', 'ko', '스웨덴어'),
(3166, 'sv', 'ku', 'Swedish'),
(3167, 'sv', 'lv', 'Swedish'),
(3168, 'sv', 'lt', 'Swedish'),
(3169, 'sv', 'mk', 'Swedish'),
(3170, 'sv', 'mt', 'Swedish'),
(3171, 'sv', 'mn', 'Swedish'),
(3172, 'sv', 'ne', 'Swedish'),
(3173, 'sv', 'nl', 'Zweeds'),
(3174, 'sv', 'no', 'Swedish'),
(3175, 'sv', 'pa', 'Swedish'),
(3176, 'sv', 'pl', 'szwedzki'),
(3177, 'sv', 'pt-pt', 'Sueco'),
(3178, 'sv', 'pt-br', 'Sueco'),
(3179, 'sv', 'qu', 'Swedish'),
(3180, 'sv', 'ro', 'Suedeză'),
(3181, 'sv', 'ru', 'Шведский'),
(3182, 'sv', 'sl', 'Švedščina'),
(3183, 'sv', 'so', 'Swedish'),
(3184, 'sv', 'sq', 'Swedish'),
(3185, 'sv', 'sr', 'шведски'),
(3186, 'sv', 'sv', 'Svenska'),
(3187, 'sv', 'ta', 'Swedish'),
(3188, 'sv', 'th', 'สวีเดน'),
(3189, 'sv', 'tr', 'İsveççe'),
(3190, 'sv', 'uk', 'Swedish'),
(3191, 'sv', 'ur', 'Swedish'),
(3192, 'sv', 'uz', 'Swedish'),
(3193, 'sv', 'vi', 'Swedish'),
(3194, 'sv', 'yi', 'Swedish'),
(3195, 'sv', 'zh-hans', '瑞典语'),
(3196, 'sv', 'zu', 'Swedish'),
(3197, 'sv', 'zh-hant', '瑞典語'),
(3198, 'sv', 'ms', 'Swedish'),
(3199, 'sv', 'gl', 'Swedish'),
(3200, 'sv', 'bn', 'Swedish'),
(3201, 'ta', 'en', 'Tamil'),
(3202, 'ta', 'es', 'Tamil'),
(3203, 'ta', 'de', 'Tamil'),
(3204, 'ta', 'fr', 'Tamoul'),
(3205, 'ta', 'ar', 'التاميلية'),
(3206, 'ta', 'bs', 'Tamil'),
(3207, 'ta', 'bg', 'Тамилски'),
(3208, 'ta', 'ca', 'Tamil'),
(3209, 'ta', 'cs', 'Tamil'),
(3210, 'ta', 'sk', 'Tamilčina'),
(3211, 'ta', 'cy', 'Tamil'),
(3212, 'ta', 'da', 'Tamil'),
(3213, 'ta', 'el', 'Ταμιλ'),
(3214, 'ta', 'eo', 'Tamil'),
(3215, 'ta', 'et', 'Tamil'),
(3216, 'ta', 'eu', 'Tamil'),
(3217, 'ta', 'fa', 'Tamil'),
(3218, 'ta', 'fi', 'tamili'),
(3219, 'ta', 'ga', 'Tamil'),
(3220, 'ta', 'he', 'טמילית'),
(3221, 'ta', 'hi', 'Tamil'),
(3222, 'ta', 'hr', 'Tamil'),
(3223, 'ta', 'hu', 'tamil'),
(3224, 'ta', 'hy', 'Tamil'),
(3225, 'ta', 'id', 'Tamil'),
(3226, 'ta', 'is', 'Tamil'),
(3227, 'ta', 'it', 'Tamil'),
(3228, 'ta', 'ja', 'タミル語'),
(3229, 'ta', 'ko', '타밀어'),
(3230, 'ta', 'ku', 'Tamil'),
(3231, 'ta', 'lv', 'Tamil'),
(3232, 'ta', 'lt', 'Tamil'),
(3233, 'ta', 'mk', 'Tamil'),
(3234, 'ta', 'mt', 'Tamil'),
(3235, 'ta', 'mn', 'Tamil'),
(3236, 'ta', 'ne', 'Tamil'),
(3237, 'ta', 'nl', 'Tamil'),
(3238, 'ta', 'no', 'Tamil'),
(3239, 'ta', 'pa', 'Tamil'),
(3240, 'ta', 'pl', 'tamilski'),
(3241, 'ta', 'pt-pt', 'Tamil'),
(3242, 'ta', 'pt-br', 'Tamil'),
(3243, 'ta', 'qu', 'Tamil'),
(3244, 'ta', 'ro', 'Tamilă'),
(3245, 'ta', 'ru', 'Тамильский'),
(3246, 'ta', 'sl', 'Tamilščina'),
(3247, 'ta', 'so', 'Tamil'),
(3248, 'ta', 'sq', 'Tamil'),
(3249, 'ta', 'sr', 'тамилски'),
(3250, 'ta', 'sv', 'Tamil'),
(3251, 'ta', 'ta', 'Tamil'),
(3252, 'ta', 'th', 'ทมิฬ'),
(3253, 'ta', 'tr', 'Tamil dili'),
(3254, 'ta', 'uk', 'Tamil'),
(3255, 'ta', 'ur', 'Tamil'),
(3256, 'ta', 'uz', 'Tamil'),
(3257, 'ta', 'vi', 'Tamil'),
(3258, 'ta', 'yi', 'Tamil'),
(3259, 'ta', 'zh-hans', '泰米尔语'),
(3260, 'ta', 'zu', 'Tamil'),
(3261, 'ta', 'zh-hant', '泰米爾語'),
(3262, 'ta', 'ms', 'Tamil'),
(3263, 'ta', 'gl', 'Tamil'),
(3264, 'ta', 'bn', 'Tamil'),
(3265, 'th', 'en', 'Thai'),
(3266, 'th', 'es', 'Tailandés'),
(3267, 'th', 'de', 'Thai'),
(3268, 'th', 'fr', 'Thaï'),
(3269, 'th', 'ar', 'التايلندية'),
(3270, 'th', 'bs', 'Thai'),
(3271, 'th', 'bg', 'Тайски'),
(3272, 'th', 'ca', 'Thai'),
(3273, 'th', 'cs', 'Thai'),
(3274, 'th', 'sk', 'Thajština'),
(3275, 'th', 'cy', 'Thai'),
(3276, 'th', 'da', 'Thai'),
(3277, 'th', 'el', 'Thai'),
(3278, 'th', 'eo', 'Thai'),
(3279, 'th', 'et', 'Thai'),
(3280, 'th', 'eu', 'Thai'),
(3281, 'th', 'fa', 'Thai'),
(3282, 'th', 'fi', 'thai'),
(3283, 'th', 'ga', 'Thai'),
(3284, 'th', 'he', 'תאילנדית'),
(3285, 'th', 'hi', 'Thai'),
(3286, 'th', 'hr', 'Thai'),
(3287, 'th', 'hu', 'tájföldi'),
(3288, 'th', 'hy', 'Thai'),
(3289, 'th', 'id', 'Thai'),
(3290, 'th', 'is', 'Thai'),
(3291, 'th', 'it', 'Thai'),
(3292, 'th', 'ja', 'タイ語'),
(3293, 'th', 'ko', '태국어'),
(3294, 'th', 'ku', 'Thai'),
(3295, 'th', 'lv', 'Thai'),
(3296, 'th', 'lt', 'Thai'),
(3297, 'th', 'mk', 'Thai'),
(3298, 'th', 'mt', 'Thai'),
(3299, 'th', 'mn', 'Thai'),
(3300, 'th', 'ne', 'Thai'),
(3301, 'th', 'nl', 'Thai'),
(3302, 'th', 'no', 'Thai'),
(3303, 'th', 'pa', 'Thai'),
(3304, 'th', 'pl', 'tajski'),
(3305, 'th', 'pt-pt', 'Tailandês'),
(3306, 'th', 'pt-br', 'Tailandês'),
(3307, 'th', 'qu', 'Thai'),
(3308, 'th', 'ro', 'Tailandeză'),
(3309, 'th', 'ru', 'Тайский'),
(3310, 'th', 'sl', 'Tajski'),
(3311, 'th', 'so', 'Thai'),
(3312, 'th', 'sq', 'Thai'),
(3313, 'th', 'sr', 'Тајландски'),
(3314, 'th', 'sv', 'Thailändska'),
(3315, 'th', 'ta', 'Thai'),
(3316, 'th', 'th', 'ไทย'),
(3317, 'th', 'tr', 'Tayca'),
(3318, 'th', 'uk', 'Thai'),
(3319, 'th', 'ur', 'Thai'),
(3320, 'th', 'uz', 'Thai'),
(3321, 'th', 'vi', 'Thai'),
(3322, 'th', 'yi', 'Thai'),
(3323, 'th', 'zh-hans', '泰语'),
(3324, 'th', 'zu', 'Thai'),
(3325, 'th', 'zh-hant', '泰語'),
(3326, 'th', 'ms', 'Thai'),
(3327, 'th', 'gl', 'Thai'),
(3328, 'th', 'bn', 'Thai'),
(3329, 'tr', 'en', 'Turkish'),
(3330, 'tr', 'es', 'Turco'),
(3331, 'tr', 'de', 'Türkisch'),
(3332, 'tr', 'fr', 'Turc'),
(3333, 'tr', 'ar', 'التركية'),
(3334, 'tr', 'bs', 'Turkish'),
(3335, 'tr', 'bg', 'Турски'),
(3336, 'tr', 'ca', 'Turkish'),
(3337, 'tr', 'cs', 'Turečtina'),
(3338, 'tr', 'sk', 'Turečtina'),
(3339, 'tr', 'cy', 'Turkish'),
(3340, 'tr', 'da', 'Turkish'),
(3341, 'tr', 'el', 'Τουρκικα'),
(3342, 'tr', 'eo', 'Turkish'),
(3343, 'tr', 'et', 'Turkish'),
(3344, 'tr', 'eu', 'Turkish'),
(3345, 'tr', 'fa', 'Turkish'),
(3346, 'tr', 'fi', 'turkki'),
(3347, 'tr', 'ga', 'Turkish'),
(3348, 'tr', 'he', 'תורכית'),
(3349, 'tr', 'hi', 'Turkish'),
(3350, 'tr', 'hr', 'Turski'),
(3351, 'tr', 'hu', 'török'),
(3352, 'tr', 'hy', 'Turkish'),
(3353, 'tr', 'id', 'Turkish'),
(3354, 'tr', 'is', 'Turkish'),
(3355, 'tr', 'it', 'Turco'),
(3356, 'tr', 'ja', 'トルコ語'),
(3357, 'tr', 'ko', '터어키어'),
(3358, 'tr', 'ku', 'Turkish'),
(3359, 'tr', 'lv', 'Turkish'),
(3360, 'tr', 'lt', 'Turkish'),
(3361, 'tr', 'mk', 'Turkish'),
(3362, 'tr', 'mt', 'Turkish'),
(3363, 'tr', 'mn', 'Turkish'),
(3364, 'tr', 'ne', 'Turkish');
INSERT INTO `wp_icl_languages_translations` (`id`, `language_code`, `display_language_code`, `name`) VALUES
(3365, 'tr', 'nl', 'Turks'),
(3366, 'tr', 'no', 'Turkish'),
(3367, 'tr', 'pa', 'Turkish'),
(3368, 'tr', 'pl', 'turecki'),
(3369, 'tr', 'pt-pt', 'Turco'),
(3370, 'tr', 'pt-br', 'Turco'),
(3371, 'tr', 'qu', 'Turkish'),
(3372, 'tr', 'ro', 'Turcă'),
(3373, 'tr', 'ru', 'Турецкий'),
(3374, 'tr', 'sl', 'Turščina'),
(3375, 'tr', 'so', 'Turkish'),
(3376, 'tr', 'sq', 'Turkish'),
(3377, 'tr', 'sr', 'турски'),
(3378, 'tr', 'sv', 'Turkiska'),
(3379, 'tr', 'ta', 'Turkish'),
(3380, 'tr', 'th', 'ตุรกี'),
(3381, 'tr', 'tr', 'Türkçe'),
(3382, 'tr', 'uk', 'Turkish'),
(3383, 'tr', 'ur', 'Turkish'),
(3384, 'tr', 'uz', 'Turkish'),
(3385, 'tr', 'vi', 'Turkish'),
(3386, 'tr', 'yi', 'Turkish'),
(3387, 'tr', 'zh-hans', '土耳其语'),
(3388, 'tr', 'zu', 'Turkish'),
(3389, 'tr', 'zh-hant', '土耳其語'),
(3390, 'tr', 'ms', 'Turkish'),
(3391, 'tr', 'gl', 'Turkish'),
(3392, 'tr', 'bn', 'Turkish'),
(3393, 'uk', 'en', 'Ukrainian'),
(3394, 'uk', 'es', 'Ucraniano'),
(3395, 'uk', 'de', 'Ukrainisch'),
(3396, 'uk', 'fr', 'Ukrainien'),
(3397, 'uk', 'ar', 'الأوكرانية'),
(3398, 'uk', 'bs', 'Ukrainian'),
(3399, 'uk', 'bg', 'Украински'),
(3400, 'uk', 'ca', 'Ukrainian'),
(3401, 'uk', 'cs', 'Ukrajinský'),
(3402, 'uk', 'sk', 'Ukrajinčina'),
(3403, 'uk', 'cy', 'Ukrainian'),
(3404, 'uk', 'da', 'Ukrainian'),
(3405, 'uk', 'el', 'Ουκρανικα'),
(3406, 'uk', 'eo', 'Ukrainian'),
(3407, 'uk', 'et', 'Ukrainian'),
(3408, 'uk', 'eu', 'Ukrainian'),
(3409, 'uk', 'fa', 'Ukrainian'),
(3410, 'uk', 'fi', 'ukraina'),
(3411, 'uk', 'ga', 'Ukrainian'),
(3412, 'uk', 'he', 'אוקראינית'),
(3413, 'uk', 'hi', 'Ukrainian'),
(3414, 'uk', 'hr', 'Ukrajinski'),
(3415, 'uk', 'hu', 'ukrán'),
(3416, 'uk', 'hy', 'Ukrainian'),
(3417, 'uk', 'id', 'Ukrainian'),
(3418, 'uk', 'is', 'Ukrainian'),
(3419, 'uk', 'it', 'Ucraino'),
(3420, 'uk', 'ja', 'ウクライナ語'),
(3421, 'uk', 'ko', '우크라이나어'),
(3422, 'uk', 'ku', 'Ukrainian'),
(3423, 'uk', 'lv', 'Ukrainian'),
(3424, 'uk', 'lt', 'Ukrainian'),
(3425, 'uk', 'mk', 'Ukrainian'),
(3426, 'uk', 'mt', 'Ukrainian'),
(3427, 'uk', 'mn', 'Ukrainian'),
(3428, 'uk', 'ne', 'Ukrainian'),
(3429, 'uk', 'nl', 'Oekraïens'),
(3430, 'uk', 'no', 'Ukrainsk'),
(3431, 'uk', 'pa', 'Ukrainian'),
(3432, 'uk', 'pl', 'ukraiński'),
(3433, 'uk', 'pt-pt', 'Ucraniano'),
(3434, 'uk', 'pt-br', 'Ucraniano'),
(3435, 'uk', 'qu', 'Ukrainian'),
(3436, 'uk', 'ro', 'Ucrainiană'),
(3437, 'uk', 'ru', 'Украинский'),
(3438, 'uk', 'sl', 'Ukrajinski'),
(3439, 'uk', 'so', 'Ukrainian'),
(3440, 'uk', 'sq', 'Ukrainian'),
(3441, 'uk', 'sr', 'украјински'),
(3442, 'uk', 'sv', 'Ukrainska'),
(3443, 'uk', 'ta', 'Ukrainian'),
(3444, 'uk', 'th', 'ยูเครน'),
(3445, 'uk', 'tr', 'Ukraynaca'),
(3446, 'uk', 'uk', 'Ukrainian'),
(3447, 'uk', 'ur', 'Ukrainian'),
(3448, 'uk', 'uz', 'Ukrainian'),
(3449, 'uk', 'vi', 'Ukrainian'),
(3450, 'uk', 'yi', 'Ukrainian'),
(3451, 'uk', 'zh-hans', '乌克兰语'),
(3452, 'uk', 'zu', 'Ukrainian'),
(3453, 'uk', 'zh-hant', '烏克蘭語'),
(3454, 'uk', 'ms', 'Ukrainian'),
(3455, 'uk', 'gl', 'Ukrainian'),
(3456, 'uk', 'bn', 'Ukrainian'),
(3457, 'ur', 'en', 'Urdu'),
(3458, 'ur', 'es', 'Urdu'),
(3459, 'ur', 'de', 'Urdu'),
(3460, 'ur', 'fr', 'Ourdu'),
(3461, 'ur', 'ar', 'الأردية'),
(3462, 'ur', 'bs', 'Urdu'),
(3463, 'ur', 'bg', 'Урду'),
(3464, 'ur', 'ca', 'Urdu'),
(3465, 'ur', 'cs', 'Urdu'),
(3466, 'ur', 'sk', 'Urdština'),
(3467, 'ur', 'cy', 'Urdu'),
(3468, 'ur', 'da', 'Urdu'),
(3469, 'ur', 'el', 'Ουρντου'),
(3470, 'ur', 'eo', 'Urdu'),
(3471, 'ur', 'et', 'Urdu'),
(3472, 'ur', 'eu', 'Urdu'),
(3473, 'ur', 'fa', 'Urdu'),
(3474, 'ur', 'fi', 'urdu'),
(3475, 'ur', 'ga', 'Urdu'),
(3476, 'ur', 'he', 'אורדו'),
(3477, 'ur', 'hi', 'Urdu'),
(3478, 'ur', 'hr', 'Urdu'),
(3479, 'ur', 'hu', 'urdu'),
(3480, 'ur', 'hy', 'Urdu'),
(3481, 'ur', 'id', 'Urdu'),
(3482, 'ur', 'is', 'Urdu'),
(3483, 'ur', 'it', 'Urdu'),
(3484, 'ur', 'ja', 'ウルドゥー語'),
(3485, 'ur', 'ko', '우르두어'),
(3486, 'ur', 'ku', 'Urdu'),
(3487, 'ur', 'lv', 'Urdu'),
(3488, 'ur', 'lt', 'Urdu'),
(3489, 'ur', 'mk', 'Urdu'),
(3490, 'ur', 'mt', 'Urdu'),
(3491, 'ur', 'mn', 'Urdu'),
(3492, 'ur', 'ne', 'Urdu'),
(3493, 'ur', 'nl', 'Urdu'),
(3494, 'ur', 'no', 'Urdu'),
(3495, 'ur', 'pa', 'Urdu'),
(3496, 'ur', 'pl', 'urdu'),
(3497, 'ur', 'pt-pt', 'Urdu'),
(3498, 'ur', 'pt-br', 'Urdu'),
(3499, 'ur', 'qu', 'Urdu'),
(3500, 'ur', 'ro', 'Urdu'),
(3501, 'ur', 'ru', 'Урду'),
(3502, 'ur', 'sl', 'Urdujščina'),
(3503, 'ur', 'so', 'Urdu'),
(3504, 'ur', 'sq', 'Urdu'),
(3505, 'ur', 'sr', 'урду'),
(3506, 'ur', 'sv', 'Urdu'),
(3507, 'ur', 'ta', 'Urdu'),
(3508, 'ur', 'th', 'อุรดู'),
(3509, 'ur', 'tr', 'Urduca'),
(3510, 'ur', 'uk', 'Urdu'),
(3511, 'ur', 'ur', 'اردو '),
(3512, 'ur', 'uz', 'Urdu'),
(3513, 'ur', 'vi', 'Urdu'),
(3514, 'ur', 'yi', 'Urdu'),
(3515, 'ur', 'zh-hans', '乌尔都语'),
(3516, 'ur', 'zu', 'Urdu'),
(3517, 'ur', 'zh-hant', '烏爾都語'),
(3518, 'ur', 'ms', 'Urdu'),
(3519, 'ur', 'gl', 'Urdu'),
(3520, 'ur', 'bn', 'Urdu'),
(3521, 'uz', 'en', 'Uzbek'),
(3522, 'uz', 'es', 'Uzbeko'),
(3523, 'uz', 'de', 'Usbekisch'),
(3524, 'uz', 'fr', 'Ouzbek'),
(3525, 'uz', 'ar', 'الاوزباكية'),
(3526, 'uz', 'bs', 'Uzbek'),
(3527, 'uz', 'bg', 'Узбекски'),
(3528, 'uz', 'ca', 'Uzbek'),
(3529, 'uz', 'cs', 'Uzbek'),
(3530, 'uz', 'sk', 'Uzbekčina'),
(3531, 'uz', 'cy', 'Uzbek'),
(3532, 'uz', 'da', 'Uzbek'),
(3533, 'uz', 'el', 'Ουζμπεκικα'),
(3534, 'uz', 'eo', 'Uzbek'),
(3535, 'uz', 'et', 'Uzbek'),
(3536, 'uz', 'eu', 'Uzbek'),
(3537, 'uz', 'fa', 'Uzbek'),
(3538, 'uz', 'fi', 'uzbekki'),
(3539, 'uz', 'ga', 'Uzbek'),
(3540, 'uz', 'he', 'אוזבקית'),
(3541, 'uz', 'hi', 'Uzbek'),
(3542, 'uz', 'hr', 'Uzbečki'),
(3543, 'uz', 'hu', 'üzbég'),
(3544, 'uz', 'hy', 'Uzbek'),
(3545, 'uz', 'id', 'Uzbek'),
(3546, 'uz', 'is', 'Uzbek'),
(3547, 'uz', 'it', 'Uzbeco'),
(3548, 'uz', 'ja', 'ウズベク語'),
(3549, 'uz', 'ko', '우즈베크어'),
(3550, 'uz', 'ku', 'Uzbek'),
(3551, 'uz', 'lv', 'Uzbek'),
(3552, 'uz', 'lt', 'Uzbek'),
(3553, 'uz', 'mk', 'Uzbek'),
(3554, 'uz', 'mt', 'Uzbek'),
(3555, 'uz', 'mn', 'Uzbek'),
(3556, 'uz', 'ne', 'Uzbek'),
(3557, 'uz', 'nl', 'Oezbeeks'),
(3558, 'uz', 'no', 'Usbekisk'),
(3559, 'uz', 'pa', 'Uzbek'),
(3560, 'uz', 'pl', 'uzbecki'),
(3561, 'uz', 'pt-pt', 'Uzbeque'),
(3562, 'uz', 'pt-br', 'Uzbeque'),
(3563, 'uz', 'qu', 'Uzbek'),
(3564, 'uz', 'ro', 'Uzbecă'),
(3565, 'uz', 'ru', 'Узбекский'),
(3566, 'uz', 'sl', 'Uzbek'),
(3567, 'uz', 'so', 'Uzbek'),
(3568, 'uz', 'sq', 'Uzbek'),
(3569, 'uz', 'sr', 'Узбек'),
(3570, 'uz', 'sv', 'Uzbekiska'),
(3571, 'uz', 'ta', 'Uzbek'),
(3572, 'uz', 'th', 'อุซเบก'),
(3573, 'uz', 'tr', 'Özbekçe'),
(3574, 'uz', 'uk', 'Uzbek'),
(3575, 'uz', 'ur', 'Uzbek'),
(3576, 'uz', 'uz', 'Uzbek'),
(3577, 'uz', 'vi', 'Uzbek'),
(3578, 'uz', 'yi', 'Uzbek'),
(3579, 'uz', 'zh-hans', '乌兹别克语'),
(3580, 'uz', 'zu', 'Uzbek'),
(3581, 'uz', 'zh-hant', '烏茲別克語'),
(3582, 'uz', 'ms', 'Uzbek'),
(3583, 'uz', 'gl', 'Uzbek'),
(3584, 'uz', 'bn', 'Uzbek'),
(3585, 'vi', 'en', 'Vietnamese'),
(3586, 'vi', 'es', 'Vietnamita'),
(3587, 'vi', 'de', 'Vietnamesisch'),
(3588, 'vi', 'fr', 'Vietnamien'),
(3589, 'vi', 'ar', 'الفيتنامية'),
(3590, 'vi', 'bs', 'Vietnamese'),
(3591, 'vi', 'bg', 'Виетнамски'),
(3592, 'vi', 'ca', 'Vietnamese'),
(3593, 'vi', 'cs', 'Vietnamský'),
(3594, 'vi', 'sk', 'Vietnamčina'),
(3595, 'vi', 'cy', 'Vietnamese'),
(3596, 'vi', 'da', 'Vietnamese'),
(3597, 'vi', 'el', 'Βιετναμεζικα'),
(3598, 'vi', 'eo', 'Vietnamese'),
(3599, 'vi', 'et', 'Vietnamese'),
(3600, 'vi', 'eu', 'Vietnamese'),
(3601, 'vi', 'fa', 'Vietnamese'),
(3602, 'vi', 'fi', 'vietnam'),
(3603, 'vi', 'ga', 'Vietnamese'),
(3604, 'vi', 'he', 'וייטנאמית'),
(3605, 'vi', 'hi', 'Vietnamese'),
(3606, 'vi', 'hr', 'Vijetnamski'),
(3607, 'vi', 'hu', 'vietnámi'),
(3608, 'vi', 'hy', 'Vietnamese'),
(3609, 'vi', 'id', 'Vietnamese'),
(3610, 'vi', 'is', 'Vietnamese'),
(3611, 'vi', 'it', 'Vietnamita'),
(3612, 'vi', 'ja', 'ベトナム語'),
(3613, 'vi', 'ko', '베트남어'),
(3614, 'vi', 'ku', 'Vietnamese'),
(3615, 'vi', 'lv', 'Vietnamese'),
(3616, 'vi', 'lt', 'Vietnamese'),
(3617, 'vi', 'mk', 'Vietnamese'),
(3618, 'vi', 'mt', 'Vietnamese'),
(3619, 'vi', 'mn', 'Vietnamese'),
(3620, 'vi', 'ne', 'Vietnamese'),
(3621, 'vi', 'nl', 'Vietnamees'),
(3622, 'vi', 'no', 'Vietnamesisk'),
(3623, 'vi', 'pa', 'Vietnamese'),
(3624, 'vi', 'pl', 'wietnamski'),
(3625, 'vi', 'pt-pt', 'Vietnamita'),
(3626, 'vi', 'pt-br', 'Vietnamita'),
(3627, 'vi', 'qu', 'Vietnamese'),
(3628, 'vi', 'ro', 'Vietnameză'),
(3629, 'vi', 'ru', 'Вьетнамский'),
(3630, 'vi', 'sl', 'Vietnamščina'),
(3631, 'vi', 'so', 'Vietnamese'),
(3632, 'vi', 'sq', 'Vietnamese'),
(3633, 'vi', 'sr', 'вијетнамски'),
(3634, 'vi', 'sv', 'Vietnamesiska'),
(3635, 'vi', 'ta', 'Vietnamese'),
(3636, 'vi', 'th', 'เวียดนาม'),
(3637, 'vi', 'tr', 'Vietnamca'),
(3638, 'vi', 'uk', 'Vietnamese'),
(3639, 'vi', 'ur', 'Vietnamese'),
(3640, 'vi', 'uz', 'Vietnamese'),
(3641, 'vi', 'vi', 'Tiếng Việt'),
(3642, 'vi', 'yi', 'Vietnamese'),
(3643, 'vi', 'zh-hans', '越南语'),
(3644, 'vi', 'zu', 'Vietnamese'),
(3645, 'vi', 'zh-hant', '越南語'),
(3646, 'vi', 'ms', 'Vietnamese'),
(3647, 'vi', 'gl', 'Vietnamese'),
(3648, 'vi', 'bn', 'Vietnamese'),
(3649, 'yi', 'en', 'Yiddish'),
(3650, 'yi', 'es', 'Yidis'),
(3651, 'yi', 'de', 'Jiddisch'),
(3652, 'yi', 'fr', 'Yiddish'),
(3653, 'yi', 'ar', 'اليديشية'),
(3654, 'yi', 'bs', 'Yiddish'),
(3655, 'yi', 'bg', 'Идиш'),
(3656, 'yi', 'ca', 'Yiddish'),
(3657, 'yi', 'cs', 'Jidiš'),
(3658, 'yi', 'sk', 'Jidiš'),
(3659, 'yi', 'cy', 'Yiddish'),
(3660, 'yi', 'da', 'Yiddish'),
(3661, 'yi', 'el', 'Γιντις'),
(3662, 'yi', 'eo', 'Yiddish'),
(3663, 'yi', 'et', 'Yiddish'),
(3664, 'yi', 'eu', 'Yiddish'),
(3665, 'yi', 'fa', 'Yiddish'),
(3666, 'yi', 'fi', 'jiddi'),
(3667, 'yi', 'ga', 'Yiddish'),
(3668, 'yi', 'he', 'יידיש'),
(3669, 'yi', 'hi', 'Yiddish'),
(3670, 'yi', 'hr', 'Jidiš'),
(3671, 'yi', 'hu', 'jiddis'),
(3672, 'yi', 'hy', 'Yiddish'),
(3673, 'yi', 'id', 'Yiddish'),
(3674, 'yi', 'is', 'Yiddish'),
(3675, 'yi', 'it', 'Yiddish'),
(3676, 'yi', 'ja', 'イディッシュ語'),
(3677, 'yi', 'ko', '이디시어'),
(3678, 'yi', 'ku', 'Yiddish'),
(3679, 'yi', 'lv', 'Yiddish'),
(3680, 'yi', 'lt', 'Yiddish'),
(3681, 'yi', 'mk', 'Yiddish'),
(3682, 'yi', 'mt', 'Yiddish'),
(3683, 'yi', 'mn', 'Yiddish'),
(3684, 'yi', 'ne', 'Yiddish'),
(3685, 'yi', 'nl', 'Jiddisch'),
(3686, 'yi', 'no', 'Yiddish'),
(3687, 'yi', 'pa', 'Yiddish'),
(3688, 'yi', 'pl', 'jidysz'),
(3689, 'yi', 'pt-pt', 'Yiddish'),
(3690, 'yi', 'pt-br', 'Yiddish'),
(3691, 'yi', 'qu', 'Yiddish'),
(3692, 'yi', 'ro', 'Idiş'),
(3693, 'yi', 'ru', 'Идиш'),
(3694, 'yi', 'sl', 'Jidiš'),
(3695, 'yi', 'so', 'Yiddish'),
(3696, 'yi', 'sq', 'Yiddish'),
(3697, 'yi', 'sr', 'јидиш'),
(3698, 'yi', 'sv', 'Jiddisch'),
(3699, 'yi', 'ta', 'Yiddish'),
(3700, 'yi', 'th', 'ยิชดิช'),
(3701, 'yi', 'tr', 'Eski İbranice'),
(3702, 'yi', 'uk', 'Yiddish'),
(3703, 'yi', 'ur', 'Yiddish'),
(3704, 'yi', 'uz', 'Yiddish'),
(3705, 'yi', 'vi', 'Yiddish'),
(3706, 'yi', 'yi', 'Yiddish'),
(3707, 'yi', 'zh-hans', '依地语'),
(3708, 'yi', 'zu', 'Yiddish'),
(3709, 'yi', 'zh-hant', '依地語'),
(3710, 'yi', 'ms', 'Yiddish'),
(3711, 'yi', 'gl', 'Yiddish'),
(3712, 'yi', 'bn', 'Yiddish'),
(3713, 'zh-hans', 'en', 'Chinese (Simplified)'),
(3714, 'zh-hans', 'es', 'Chino simplificado'),
(3715, 'zh-hans', 'de', 'Vereinfachtes Chinesisch'),
(3716, 'zh-hans', 'fr', 'Chinois simplifié'),
(3717, 'zh-hans', 'ar', 'الصينية المبسطة'),
(3718, 'zh-hans', 'bs', 'Chinese (Simplified)'),
(3719, 'zh-hans', 'bg', 'Китайски  (опростен)'),
(3720, 'zh-hans', 'ca', 'Chinese (Simplified)'),
(3721, 'zh-hans', 'cs', 'Čínština ( Zjednodušený )'),
(3722, 'zh-hans', 'sk', 'Zjednodušená Čínština'),
(3723, 'zh-hans', 'cy', 'Chinese (Simplified)'),
(3724, 'zh-hans', 'da', 'Chinese (Simplified)'),
(3725, 'zh-hans', 'el', 'Κινεζικα (Απλοποιημένα)'),
(3726, 'zh-hans', 'eo', 'Chinese (Simplified)'),
(3727, 'zh-hans', 'et', 'Chinese (Simplified)'),
(3728, 'zh-hans', 'eu', 'Chinese (Simplified)'),
(3729, 'zh-hans', 'fa', 'Chinese (Simplified)'),
(3730, 'zh-hans', 'fi', 'kiina'),
(3731, 'zh-hans', 'ga', 'Chinese (Simplified)'),
(3732, 'zh-hans', 'he', 'סינית'),
(3733, 'zh-hans', 'hi', 'Chinese (Simplified)'),
(3734, 'zh-hans', 'hr', 'Kineski (pojednostavljeni)'),
(3735, 'zh-hans', 'hu', 'egyszerűsített kínai'),
(3736, 'zh-hans', 'hy', 'Chinese (Simplified)'),
(3737, 'zh-hans', 'id', 'Chinese (Simplified)'),
(3738, 'zh-hans', 'is', 'Chinese (Simplified)'),
(3739, 'zh-hans', 'it', 'Cinese semplificato'),
(3740, 'zh-hans', 'ja', '簡体中国語'),
(3741, 'zh-hans', 'ko', '중국어 간체'),
(3742, 'zh-hans', 'ku', 'Chinese (Simplified)'),
(3743, 'zh-hans', 'lv', 'Chinese (Simplified)'),
(3744, 'zh-hans', 'lt', 'Chinese (Simplified)'),
(3745, 'zh-hans', 'mk', 'Chinese (Simplified)'),
(3746, 'zh-hans', 'mt', 'Chinese (Simplified)'),
(3747, 'zh-hans', 'mn', 'Chinese (Simplified)'),
(3748, 'zh-hans', 'ne', 'Chinese (Simplified)'),
(3749, 'zh-hans', 'nl', 'Vereenvoudigd Chinees'),
(3750, 'zh-hans', 'no', 'Kinesisk (forenklet)'),
(3751, 'zh-hans', 'pa', 'Chinese (Simplified)'),
(3752, 'zh-hans', 'pl', 'chiński uproszczony'),
(3753, 'zh-hans', 'pt-pt', 'Chinês (Simplificado)'),
(3754, 'zh-hans', 'pt-br', 'Chinês (Simplificado)'),
(3755, 'zh-hans', 'qu', 'Chinese (Simplified)'),
(3756, 'zh-hans', 'ro', 'Chineza simplificată'),
(3757, 'zh-hans', 'ru', 'Китайский (упрощенный)'),
(3758, 'zh-hans', 'sl', 'Kitajščina (poenostavljena )'),
(3759, 'zh-hans', 'so', 'Chinese (Simplified)'),
(3760, 'zh-hans', 'sq', 'Chinese (Simplified)'),
(3761, 'zh-hans', 'sr', 'Кинески (поједностављени)'),
(3762, 'zh-hans', 'sv', 'Förenklad kinesiska'),
(3763, 'zh-hans', 'ta', 'Chinese (Simplified)'),
(3764, 'zh-hans', 'th', 'จีนประยุกต์'),
(3765, 'zh-hans', 'tr', 'Modern Çince'),
(3766, 'zh-hans', 'uk', 'Chinese (Simplified)'),
(3767, 'zh-hans', 'ur', 'Chinese (Simplified)'),
(3768, 'zh-hans', 'uz', 'Chinese (Simplified)'),
(3769, 'zh-hans', 'vi', 'Chinese (Simplified)'),
(3770, 'zh-hans', 'yi', 'Chinese (Simplified)'),
(3771, 'zh-hans', 'zh-hans', '简体中文'),
(3772, 'zh-hans', 'zu', 'Chinese (Simplified)'),
(3773, 'zh-hans', 'zh-hant', '簡體中文'),
(3774, 'zh-hans', 'ms', 'Chinese (Simplified)'),
(3775, 'zh-hans', 'gl', 'Chinese (Simplified)'),
(3776, 'zh-hans', 'bn', 'Chinese (Simplified)'),
(3777, 'zu', 'en', 'Zulu'),
(3778, 'zu', 'es', 'Zulú'),
(3779, 'zu', 'de', 'Zulu'),
(3780, 'zu', 'fr', 'Zoulou'),
(3781, 'zu', 'ar', 'الزولو'),
(3782, 'zu', 'bs', 'Zulu'),
(3783, 'zu', 'bg', 'Зулу'),
(3784, 'zu', 'ca', 'Zulu'),
(3785, 'zu', 'cs', 'Zulu'),
(3786, 'zu', 'sk', 'Jazyk Zulu'),
(3787, 'zu', 'cy', 'Zulu'),
(3788, 'zu', 'da', 'Zulu'),
(3789, 'zu', 'el', 'Ζουλου'),
(3790, 'zu', 'eo', 'Zulu'),
(3791, 'zu', 'et', 'Zulu'),
(3792, 'zu', 'eu', 'Zulu'),
(3793, 'zu', 'fa', 'Zulu'),
(3794, 'zu', 'fi', 'zulu'),
(3795, 'zu', 'ga', 'Zulu'),
(3796, 'zu', 'he', 'זולו '),
(3797, 'zu', 'hi', 'Zulu'),
(3798, 'zu', 'hr', 'Zulu'),
(3799, 'zu', 'hu', 'zulu'),
(3800, 'zu', 'hy', 'Zulu'),
(3801, 'zu', 'id', 'Zulu'),
(3802, 'zu', 'is', 'Zulu'),
(3803, 'zu', 'it', 'Zulu'),
(3804, 'zu', 'ja', 'ズールー語'),
(3805, 'zu', 'ko', '줄루어'),
(3806, 'zu', 'ku', 'Zulu'),
(3807, 'zu', 'lv', 'Zulu'),
(3808, 'zu', 'lt', 'Zulu'),
(3809, 'zu', 'mk', 'Zulu'),
(3810, 'zu', 'mt', 'Zulu'),
(3811, 'zu', 'mn', 'Zulu'),
(3812, 'zu', 'ne', 'Zulu'),
(3813, 'zu', 'nl', 'Zulu'),
(3814, 'zu', 'no', 'Zulu'),
(3815, 'zu', 'pa', 'Zulu'),
(3816, 'zu', 'pl', 'zuluski'),
(3817, 'zu', 'pt-pt', 'Zulu'),
(3818, 'zu', 'pt-br', 'Zulu'),
(3819, 'zu', 'qu', 'Zulu'),
(3820, 'zu', 'ro', 'Zulu'),
(3821, 'zu', 'ru', 'Зулу'),
(3822, 'zu', 'sl', 'Zulu'),
(3823, 'zu', 'so', 'Zulu'),
(3824, 'zu', 'sq', 'Zulu'),
(3825, 'zu', 'sr', 'зулу'),
(3826, 'zu', 'sv', 'Zulu'),
(3827, 'zu', 'ta', 'Zulu'),
(3828, 'zu', 'th', 'ซูลู'),
(3829, 'zu', 'tr', 'Zulu dili'),
(3830, 'zu', 'uk', 'Zulu'),
(3831, 'zu', 'ur', 'Zulu'),
(3832, 'zu', 'uz', 'Zulu'),
(3833, 'zu', 'vi', 'Zulu'),
(3834, 'zu', 'yi', 'Zulu'),
(3835, 'zu', 'zh-hans', '祖鲁语'),
(3836, 'zu', 'zu', 'Zulu'),
(3837, 'zu', 'zh-hant', '祖魯語'),
(3838, 'zu', 'ms', 'Zulu'),
(3839, 'zu', 'gl', 'Zulu'),
(3840, 'zu', 'bn', 'Zulu'),
(3841, 'zh-hant', 'en', 'Chinese (Traditional)'),
(3842, 'zh-hant', 'es', 'Chino tradicional'),
(3843, 'zh-hant', 'de', 'Traditionelles Chinesisch'),
(3844, 'zh-hant', 'fr', 'Chinois traditionnel'),
(3845, 'zh-hant', 'ar', 'الصينية التقليدية'),
(3846, 'zh-hant', 'bs', 'Chinese (Traditional)'),
(3847, 'zh-hant', 'bg', 'Китайски (традиционен)'),
(3848, 'zh-hant', 'ca', 'Chinese (Traditional)'),
(3849, 'zh-hant', 'cs', 'Čínština (tradiční )'),
(3850, 'zh-hant', 'sk', 'Tradičná Čínština'),
(3851, 'zh-hant', 'cy', 'Chinese (Traditional)'),
(3852, 'zh-hant', 'da', 'Chinese (Traditional)'),
(3853, 'zh-hant', 'el', 'Κινεζικα (Παραδοσιακά)'),
(3854, 'zh-hant', 'eo', 'Chinese (Traditional)'),
(3855, 'zh-hant', 'et', 'Chinese (Traditional)'),
(3856, 'zh-hant', 'eu', 'Chinese (Traditional)'),
(3857, 'zh-hant', 'fa', 'Chinese (Traditional)'),
(3858, 'zh-hant', 'fi', 'perinteinen kiina'),
(3859, 'zh-hant', 'ga', 'Chinese (Traditional)'),
(3860, 'zh-hant', 'he', 'סינית מסורתית'),
(3861, 'zh-hant', 'hi', 'Chinese (Traditional)'),
(3862, 'zh-hant', 'hr', 'Kineski (tradicionalni)'),
(3863, 'zh-hant', 'hu', 'hagyományos kínai'),
(3864, 'zh-hant', 'hy', 'Chinese (Traditional)'),
(3865, 'zh-hant', 'id', 'Chinese (Traditional)'),
(3866, 'zh-hant', 'is', 'Chinese (Traditional)'),
(3867, 'zh-hant', 'it', 'Cinese tradizionale'),
(3868, 'zh-hant', 'ja', '繁体中国語'),
(3869, 'zh-hant', 'ko', '중국어 번체'),
(3870, 'zh-hant', 'ku', 'Chinese (Traditional)'),
(3871, 'zh-hant', 'lv', 'Chinese (Traditional)'),
(3872, 'zh-hant', 'lt', 'Chinese (Traditional)'),
(3873, 'zh-hant', 'mk', 'Chinese (Traditional)'),
(3874, 'zh-hant', 'mt', 'Chinese (Traditional)'),
(3875, 'zh-hant', 'mn', 'Chinese (Traditional)'),
(3876, 'zh-hant', 'ne', 'Chinese (Traditional)'),
(3877, 'zh-hant', 'nl', 'Traditioneel Chinees'),
(3878, 'zh-hant', 'no', 'Kinesisk (tradisjonell)'),
(3879, 'zh-hant', 'pa', 'Chinese (Traditional)'),
(3880, 'zh-hant', 'pl', 'chiński tradycyjny'),
(3881, 'zh-hant', 'pt-pt', 'Chinês (Tradicional)'),
(3882, 'zh-hant', 'pt-br', 'Chinês (Tradicional)'),
(3883, 'zh-hant', 'qu', 'Chinese (Traditional)'),
(3884, 'zh-hant', 'ro', 'Chineza tradiţională'),
(3885, 'zh-hant', 'ru', 'Китайский (традиционный)'),
(3886, 'zh-hant', 'sl', 'Kitajščina (tradicionalna)'),
(3887, 'zh-hant', 'so', 'Chinese (Traditional)'),
(3888, 'zh-hant', 'sq', 'Chinese (Traditional)'),
(3889, 'zh-hant', 'sr', 'Кинески (традиционални)'),
(3890, 'zh-hant', 'sv', 'Traditionell kinesiska'),
(3891, 'zh-hant', 'ta', 'Chinese (Traditional)'),
(3892, 'zh-hant', 'th', 'จีนดั้งเดิม'),
(3893, 'zh-hant', 'tr', 'Klasik Çince'),
(3894, 'zh-hant', 'uk', 'Chinese (Traditional)'),
(3895, 'zh-hant', 'ur', 'Chinese (Traditional)'),
(3896, 'zh-hant', 'uz', 'Chinese (Traditional)'),
(3897, 'zh-hant', 'vi', 'Chinese (Traditional)'),
(3898, 'zh-hant', 'yi', 'Chinese (Traditional)'),
(3899, 'zh-hant', 'zh-hans', '繁体中文'),
(3900, 'zh-hant', 'zu', 'Chinese (Traditional)'),
(3901, 'zh-hant', 'zh-hant', '繁體中文'),
(3902, 'zh-hant', 'ms', 'Chinese (Traditional)'),
(3903, 'zh-hant', 'gl', 'Chinese (Traditional)'),
(3904, 'zh-hant', 'bn', 'Chinese (Traditional)'),
(3905, 'ms', 'en', 'Malay'),
(3906, 'ms', 'es', 'Malayo'),
(3907, 'ms', 'de', 'Malaiisch'),
(3908, 'ms', 'fr', 'Malay'),
(3909, 'ms', 'ar', 'لغة الملايو'),
(3910, 'ms', 'bs', 'Malay'),
(3911, 'ms', 'bg', 'Малайски'),
(3912, 'ms', 'ca', 'Malay'),
(3913, 'ms', 'cs', 'Malajský'),
(3914, 'ms', 'sk', 'Malay'),
(3915, 'ms', 'cy', 'Malay'),
(3916, 'ms', 'da', 'Malay'),
(3917, 'ms', 'el', 'Malay'),
(3918, 'ms', 'eo', 'Malay'),
(3919, 'ms', 'et', 'Malay'),
(3920, 'ms', 'eu', 'Malay'),
(3921, 'ms', 'fa', 'Malay'),
(3922, 'ms', 'fi', 'Malay'),
(3923, 'ms', 'ga', 'Malay'),
(3924, 'ms', 'he', 'מלאית'),
(3925, 'ms', 'hi', 'Malay'),
(3926, 'ms', 'hr', 'Malajski'),
(3927, 'ms', 'hu', 'Malay'),
(3928, 'ms', 'hy', 'Malay'),
(3929, 'ms', 'id', 'Malay'),
(3930, 'ms', 'is', 'Malay'),
(3931, 'ms', 'it', 'Malay'),
(3932, 'ms', 'ja', 'Malay'),
(3933, 'ms', 'ko', 'Malay'),
(3934, 'ms', 'ku', 'Malay'),
(3935, 'ms', 'lv', 'Malay'),
(3936, 'ms', 'lt', 'Malay'),
(3937, 'ms', 'mk', 'Malay'),
(3938, 'ms', 'mt', 'Malay'),
(3939, 'ms', 'mn', 'Malay'),
(3940, 'ms', 'ne', 'Malay'),
(3941, 'ms', 'nl', 'Malay'),
(3942, 'ms', 'no', 'Malay'),
(3943, 'ms', 'pa', 'Malay'),
(3944, 'ms', 'pl', 'Malay'),
(3945, 'ms', 'pt-pt', 'Malaio'),
(3946, 'ms', 'pt-br', 'Malaio'),
(3947, 'ms', 'qu', 'Malay'),
(3948, 'ms', 'ro', 'Malay'),
(3949, 'ms', 'ru', 'Малайский'),
(3950, 'ms', 'sl', 'Malajščina'),
(3951, 'ms', 'so', 'Malay'),
(3952, 'ms', 'sq', 'Malay'),
(3953, 'ms', 'sr', 'малајски'),
(3954, 'ms', 'sv', 'Malay'),
(3955, 'ms', 'ta', 'Malay'),
(3956, 'ms', 'th', 'Malay'),
(3957, 'ms', 'tr', 'Malay'),
(3958, 'ms', 'uk', 'Malay'),
(3959, 'ms', 'ur', 'Malay'),
(3960, 'ms', 'uz', 'Malay'),
(3961, 'ms', 'vi', 'Malay'),
(3962, 'ms', 'yi', 'Malay'),
(3963, 'ms', 'zh-hans', 'Malay'),
(3964, 'ms', 'zu', 'Malay'),
(3965, 'ms', 'zh-hant', 'Malay'),
(3966, 'ms', 'ms', 'Melayu'),
(3967, 'ms', 'gl', 'Malay'),
(3968, 'ms', 'bn', 'Malay'),
(3969, 'gl', 'en', 'Galician'),
(3970, 'gl', 'es', 'Gallego'),
(3971, 'gl', 'de', 'Galicisch'),
(3972, 'gl', 'fr', 'Galicien'),
(3973, 'gl', 'ar', 'Galician'),
(3974, 'gl', 'bs', 'Galician'),
(3975, 'gl', 'bg', 'Galician'),
(3976, 'gl', 'ca', 'Galician'),
(3977, 'gl', 'cs', 'Galician'),
(3978, 'gl', 'sk', 'Galician'),
(3979, 'gl', 'cy', 'Galician'),
(3980, 'gl', 'da', 'Galician'),
(3981, 'gl', 'el', 'Galician'),
(3982, 'gl', 'eo', 'Galician'),
(3983, 'gl', 'et', 'Galician'),
(3984, 'gl', 'eu', 'Galician'),
(3985, 'gl', 'fa', 'Galician'),
(3986, 'gl', 'fi', 'Galician'),
(3987, 'gl', 'ga', 'Galician'),
(3988, 'gl', 'he', 'Galician'),
(3989, 'gl', 'hi', 'Galician'),
(3990, 'gl', 'hr', 'Galician'),
(3991, 'gl', 'hu', 'Galician'),
(3992, 'gl', 'hy', 'Galician'),
(3993, 'gl', 'id', 'Galician'),
(3994, 'gl', 'is', 'Galician'),
(3995, 'gl', 'it', 'Gallego'),
(3996, 'gl', 'ja', 'Galician'),
(3997, 'gl', 'ko', 'Galician'),
(3998, 'gl', 'ku', 'Galician'),
(3999, 'gl', 'lv', 'Galician'),
(4000, 'gl', 'lt', 'Galician'),
(4001, 'gl', 'mk', 'Galician'),
(4002, 'gl', 'mt', 'Galician'),
(4003, 'gl', 'mn', 'Galician'),
(4004, 'gl', 'ne', 'Galician'),
(4005, 'gl', 'nl', 'Galician'),
(4006, 'gl', 'no', 'Galician'),
(4007, 'gl', 'pa', 'Galician'),
(4008, 'gl', 'pl', 'Galician'),
(4009, 'gl', 'pt-pt', 'Galego'),
(4010, 'gl', 'pt-br', 'Galego'),
(4011, 'gl', 'qu', 'Galician'),
(4012, 'gl', 'ro', 'Galician'),
(4013, 'gl', 'ru', 'Галисийский'),
(4014, 'gl', 'sl', 'Galician'),
(4015, 'gl', 'so', 'Galician'),
(4016, 'gl', 'sq', 'Galician'),
(4017, 'gl', 'sr', 'Galician'),
(4018, 'gl', 'sv', 'Galician'),
(4019, 'gl', 'ta', 'Galician'),
(4020, 'gl', 'th', 'Galician'),
(4021, 'gl', 'tr', 'Galician'),
(4022, 'gl', 'uk', 'Galician'),
(4023, 'gl', 'ur', 'Galician'),
(4024, 'gl', 'uz', 'Galician'),
(4025, 'gl', 'vi', 'Galician'),
(4026, 'gl', 'yi', 'Galician'),
(4027, 'gl', 'zh-hans', 'Galician'),
(4028, 'gl', 'zu', 'Galician'),
(4029, 'gl', 'zh-hant', 'Galician'),
(4030, 'gl', 'ms', 'Galician'),
(4031, 'gl', 'gl', 'Galego'),
(4032, 'gl', 'bn', 'Galician'),
(4033, 'bn', 'en', 'Bengali'),
(4034, 'bn', 'es', 'Bengalí'),
(4035, 'bn', 'de', 'Bengalisch'),
(4036, 'bn', 'fr', 'Bengali'),
(4037, 'bn', 'ar', 'Bengali'),
(4038, 'bn', 'bs', 'Bengali'),
(4039, 'bn', 'bg', 'Bengali'),
(4040, 'bn', 'ca', 'Bengali'),
(4041, 'bn', 'cs', 'Bengali'),
(4042, 'bn', 'sk', 'Bengali'),
(4043, 'bn', 'cy', 'Bengali'),
(4044, 'bn', 'da', 'Bengali'),
(4045, 'bn', 'el', 'Bengali'),
(4046, 'bn', 'eo', 'Bengali'),
(4047, 'bn', 'et', 'Bengali'),
(4048, 'bn', 'eu', 'Bengali'),
(4049, 'bn', 'fa', 'Bengali'),
(4050, 'bn', 'fi', 'Bengali'),
(4051, 'bn', 'ga', 'Bengali'),
(4052, 'bn', 'he', 'Bengali'),
(4053, 'bn', 'hi', 'Bengali'),
(4054, 'bn', 'hr', 'Bengali'),
(4055, 'bn', 'hu', 'Bengali'),
(4056, 'bn', 'hy', 'Bengali'),
(4057, 'bn', 'id', 'Bengali'),
(4058, 'bn', 'is', 'Bengali'),
(4059, 'bn', 'it', 'Bengalese'),
(4060, 'bn', 'ja', 'Bengali'),
(4061, 'bn', 'ko', 'Bengali'),
(4062, 'bn', 'ku', 'Bengali'),
(4063, 'bn', 'lv', 'Bengali'),
(4064, 'bn', 'lt', 'Bengali'),
(4065, 'bn', 'mk', 'Bengali'),
(4066, 'bn', 'mt', 'Bengali'),
(4067, 'bn', 'mn', 'Bengali'),
(4068, 'bn', 'ne', 'Bengali'),
(4069, 'bn', 'nl', 'Bengali'),
(4070, 'bn', 'no', 'Bengali'),
(4071, 'bn', 'pa', 'Bengali'),
(4072, 'bn', 'pl', 'Bengali'),
(4073, 'bn', 'pt-pt', 'Bengalês'),
(4074, 'bn', 'pt-br', 'Bengalês'),
(4075, 'bn', 'qu', 'Bengali'),
(4076, 'bn', 'ro', 'Bengali'),
(4077, 'bn', 'ru', 'Бенгальский'),
(4078, 'bn', 'sl', 'Bengali'),
(4079, 'bn', 'so', 'Bengali'),
(4080, 'bn', 'sq', 'Bengali'),
(4081, 'bn', 'sr', 'Bengali'),
(4082, 'bn', 'sv', 'Bengali'),
(4083, 'bn', 'ta', 'Bengali'),
(4084, 'bn', 'th', 'Bengali'),
(4085, 'bn', 'tr', 'Bengali'),
(4086, 'bn', 'uk', 'Bengali'),
(4087, 'bn', 'ur', 'Bengali'),
(4088, 'bn', 'uz', 'Bengali'),
(4089, 'bn', 'vi', 'Bengali'),
(4090, 'bn', 'yi', 'Bengali'),
(4091, 'bn', 'zh-hans', 'Bengali'),
(4092, 'bn', 'zu', 'Bengali'),
(4093, 'bn', 'zh-hant', 'Bengali'),
(4094, 'bn', 'ms', 'Bengali'),
(4095, 'bn', 'gl', 'Bengali'),
(4096, 'bn', 'bn', 'हिन्दी');

CREATE TABLE `wp_icl_locale_map` (
  `code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(35) COLLATE utf8mb4_unicode_520_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_message_status` (
  `id` bigint UNSIGNED NOT NULL,
  `rid` bigint UNSIGNED NOT NULL,
  `object_id` bigint UNSIGNED NOT NULL,
  `from_language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `to_language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_type` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` smallint NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_node` (
  `nid` bigint NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `links_fixed` tinyint NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_reminders` (
  `id` bigint NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `can_delete` tinyint NOT NULL,
  `show` tinyint NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_strings` (
  `id` bigint UNSIGNED NOT NULL,
  `language` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `string_package_id` bigint UNSIGNED DEFAULT NULL,
  `location` bigint UNSIGNED DEFAULT NULL,
  `wrap_tag` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'LINE',
  `title` varchar(160) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` tinyint NOT NULL,
  `gettext_context` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `domain_name_context_md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translation_priority` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `word_count` int UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_string_positions` (
  `id` bigint UNSIGNED NOT NULL,
  `string_id` bigint NOT NULL,
  `kind` tinyint DEFAULT NULL,
  `position_in_page` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_string_status` (
  `id` bigint UNSIGNED NOT NULL,
  `rid` bigint NOT NULL,
  `string_translation_id` bigint NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_string_translations` (
  `id` bigint UNSIGNED NOT NULL,
  `string_id` bigint UNSIGNED NOT NULL,
  `language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` tinyint NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `mo_string` longtext COLLATE utf8mb4_unicode_520_ci,
  `translator_id` bigint UNSIGNED DEFAULT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `batch_id` int NOT NULL DEFAULT '0',
  `translation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translate` (
  `tid` bigint UNSIGNED NOT NULL,
  `job_id` bigint UNSIGNED NOT NULL,
  `content_id` bigint UNSIGNED NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `field_type` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_wrap_tag` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_format` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_translate` tinyint NOT NULL,
  `field_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_data_translated` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_finished` tinyint NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translate_job` (
  `job_id` bigint UNSIGNED NOT NULL,
  `rid` bigint UNSIGNED NOT NULL,
  `translator_id` int UNSIGNED NOT NULL,
  `translated` tinyint UNSIGNED NOT NULL DEFAULT '0',
  `manager_id` int UNSIGNED NOT NULL,
  `revision` int UNSIGNED DEFAULT NULL,
  `title` varchar(160) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `deadline_date` datetime DEFAULT NULL,
  `completed_date` datetime DEFAULT NULL,
  `editor` varchar(16) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `editor_job_id` bigint UNSIGNED DEFAULT NULL,
  `edit_timestamp` int UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translations` (
  `translation_id` bigint NOT NULL,
  `element_type` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post_post',
  `element_id` bigint DEFAULT NULL,
  `trid` bigint NOT NULL,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source_language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translation_batches` (
  `id` int NOT NULL,
  `batch_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tp_id` int DEFAULT NULL,
  `ts_url` text COLLATE utf8mb4_unicode_520_ci,
  `last_update` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translation_status` (
  `rid` bigint NOT NULL,
  `translation_id` bigint NOT NULL,
  `status` tinyint NOT NULL,
  `translator_id` bigint NOT NULL,
  `needs_update` tinyint NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `batch_id` int NOT NULL DEFAULT '0',
  `translation_package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `links_fixed` tinyint NOT NULL DEFAULT '0',
  `_prevstate` longtext COLLATE utf8mb4_unicode_520_ci,
  `uuid` varchar(36) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tp_id` int DEFAULT NULL,
  `tp_revision` int NOT NULL DEFAULT '1',
  `ts_status` text COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint UNSIGNED NOT NULL,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint UNSIGNED NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint UNSIGNED NOT NULL,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(1, 'siteurl', 'http://szerzodeskezelo-rc.local', 'yes'),
(2, 'home', 'http://szerzodeskezelo-rc.local', 'yes'),
(3, 'blogname', 'Szerződéskezelő', 'yes'),
(4, 'blogdescription', 'Just another WordPress site', 'yes'),
(5, 'users_can_register', '0', 'yes'),
(6, 'admin_email', 'dev@dev.hu', 'yes'),
(7, 'start_of_week', '1', 'yes'),
(8, 'use_balanceTags', '0', 'yes'),
(9, 'use_smilies', '1', 'yes'),
(10, 'require_name_email', '1', 'yes'),
(11, 'comments_notify', '1', 'yes'),
(12, 'posts_per_rss', '10', 'yes'),
(13, 'rss_use_excerpt', '0', 'yes'),
(14, 'mailserver_url', 'mail.example.com', 'yes'),
(15, 'mailserver_login', 'login@example.com', 'yes'),
(16, 'mailserver_pass', 'password', 'yes'),
(17, 'mailserver_port', '110', 'yes'),
(18, 'default_category', '1', 'yes'),
(19, 'default_comment_status', 'open', 'yes'),
(20, 'default_ping_status', 'open', 'yes'),
(21, 'default_pingback_flag', '0', 'yes'),
(22, 'posts_per_page', '10', 'yes'),
(23, 'date_format', 'F j, Y', 'yes'),
(24, 'time_format', 'g:i a', 'yes'),
(25, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
(26, 'comment_moderation', '0', 'yes'),
(27, 'moderation_notify', '1', 'yes'),
(28, 'permalink_structure', '/index.php/%year%/%monthnum%/%day%/%postname%/', 'yes'),
(29, 'rewrite_rules', 'a:122:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:25:\"tr_json_api/v1/([^/]*)/?$\";s:40:\"index.php?tr_json_controller=$matches[1]\";s:33:\"tr_json_api/v1/([^/]*)/([^/]*)/?$\";s:65:\"index.php?tr_json_controller=$matches[1]&tr_json_item=$matches[2]\";s:43:\"tr_matrix_api/v1/([^/]*)/([^/]*)/([^/]*)/?$\";s:93:\"index.php?tr_matrix_group=$matches[1]&tr_matrix_type=$matches[2]&tr_matrix_folder=$matches[3]\";s:44:\"tr_builder_api/v1/([^/]*)/([^/]*)/([^/]*)/?$\";s:96:\"index.php?tr_builder_group=$matches[1]&tr_builder_type=$matches[2]&tr_builder_folder=$matches[3]\";s:21:\"index.php/contract/?$\";s:28:\"index.php?post_type=contract\";s:51:\"index.php/contract/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=contract&feed=$matches[1]\";s:46:\"index.php/contract/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=contract&feed=$matches[1]\";s:38:\"index.php/contract/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=contract&paged=$matches[1]\";s:57:\"index.php/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:45:\"index.php/category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:54:\"index.php/tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:49:\"index.php/tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:30:\"index.php/tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:42:\"index.php/tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:24:\"index.php/tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:55:\"index.php/type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:50:\"index.php/type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:31:\"index.php/type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:43:\"index.php/type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:25:\"index.php/type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"index.php/contract/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"index.php/contract/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"index.php/contract/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"index.php/contract/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"index.php/contract/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"index.php/contract/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"index.php/contract/([^/]+)/embed/?$\";s:41:\"index.php?contract=$matches[1]&embed=true\";s:39:\"index.php/contract/([^/]+)/trackback/?$\";s:35:\"index.php?contract=$matches[1]&tb=1\";s:59:\"index.php/contract/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?contract=$matches[1]&feed=$matches[2]\";s:54:\"index.php/contract/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?contract=$matches[1]&feed=$matches[2]\";s:47:\"index.php/contract/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?contract=$matches[1]&paged=$matches[2]\";s:54:\"index.php/contract/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?contract=$matches[1]&cpage=$matches[2]\";s:43:\"index.php/contract/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?contract=$matches[1]&page=$matches[2]\";s:35:\"index.php/contract/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"index.php/contract/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"index.php/contract/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"index.php/contract/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"index.php/contract/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"index.php/contract/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"index.php/contract-type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?contract_type=$matches[1]&feed=$matches[2]\";s:59:\"index.php/contract-type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?contract_type=$matches[1]&feed=$matches[2]\";s:40:\"index.php/contract-type/([^/]+)/embed/?$\";s:46:\"index.php?contract_type=$matches[1]&embed=true\";s:52:\"index.php/contract-type/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?contract_type=$matches[1]&paged=$matches[2]\";s:34:\"index.php/contract-type/([^/]+)/?$\";s:35:\"index.php?contract_type=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:42:\"index.php/feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:37:\"index.php/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:18:\"index.php/embed/?$\";s:21:\"index.php?&embed=true\";s:30:\"index.php/page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:51:\"index.php/comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:46:\"index.php/comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:27:\"index.php/comments/embed/?$\";s:21:\"index.php?&embed=true\";s:54:\"index.php/search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:49:\"index.php/search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:30:\"index.php/search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:42:\"index.php/search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:24:\"index.php/search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:57:\"index.php/author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:45:\"index.php/author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:79:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:55:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:49:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:66:\"index.php/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:42:\"index.php/([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:54:\"index.php/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:36:\"index.php/([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:53:\"index.php/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:48:\"index.php/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:29:\"index.php/([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:41:\"index.php/([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:23:\"index.php/([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:68:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:78:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:98:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:74:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:87:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:75:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:71:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:57:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:67:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:87:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:63:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:48:\"index.php/([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:37:\"index.php/.?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"index.php/.?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"index.php/.?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"index.php/.?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"index.php/(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:30:\"index.php/(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:50:\"index.php/(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:45:\"index.php/(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:38:\"index.php/(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:45:\"index.php/(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:34:\"index.php/(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}', 'yes'),
(30, 'hack_file', '0', 'yes'),
(31, 'blog_charset', 'UTF-8', 'yes'),
(32, 'moderation_keys', '', 'no'),
(33, 'active_plugins', 'a:2:{i:0;s:40:\"sitepress-multilingual-cms/sitepress.php\";i:1;s:33:\"onlinecontract/onlinecontract.php\";}', 'yes'),
(34, 'category_base', '', 'yes'),
(35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
(36, 'comment_max_links', '2', 'yes'),
(37, 'gmt_offset', '0', 'yes'),
(38, 'default_email_category', '1', 'yes'),
(39, 'recently_edited', '', 'no'),
(40, 'template', 'twentynineteen', 'yes'),
(41, 'stylesheet', 'twentynineteen', 'yes'),
(42, 'comment_whitelist', '1', 'yes'),
(43, 'blacklist_keys', '', 'no'),
(44, 'comment_registration', '0', 'yes'),
(45, 'html_type', 'text/html', 'yes'),
(46, 'use_trackback', '0', 'yes'),
(47, 'default_role', 'subscriber', 'yes'),
(48, 'db_version', '44719', 'yes'),
(49, 'uploads_use_yearmonth_folders', '1', 'yes'),
(50, 'upload_path', '', 'yes'),
(51, 'blog_public', '0', 'yes'),
(52, 'default_link_category', '2', 'yes'),
(53, 'show_on_front', 'posts', 'yes'),
(54, 'tag_base', '', 'yes'),
(55, 'show_avatars', '1', 'yes'),
(56, 'avatar_rating', 'G', 'yes'),
(57, 'upload_url_path', '', 'yes'),
(58, 'thumbnail_size_w', '150', 'yes'),
(59, 'thumbnail_size_h', '150', 'yes'),
(60, 'thumbnail_crop', '1', 'yes'),
(61, 'medium_size_w', '300', 'yes'),
(62, 'medium_size_h', '300', 'yes'),
(63, 'avatar_default', 'mystery', 'yes'),
(64, 'large_size_w', '1024', 'yes'),
(65, 'large_size_h', '1024', 'yes'),
(66, 'image_default_link_type', 'none', 'yes'),
(67, 'image_default_size', '', 'yes'),
(68, 'image_default_align', '', 'yes'),
(69, 'close_comments_for_old_posts', '0', 'yes'),
(70, 'close_comments_days_old', '14', 'yes'),
(71, 'thread_comments', '1', 'yes'),
(72, 'thread_comments_depth', '5', 'yes'),
(73, 'page_comments', '0', 'yes'),
(74, 'comments_per_page', '50', 'yes'),
(75, 'default_comments_page', 'newest', 'yes'),
(76, 'comment_order', 'asc', 'yes'),
(77, 'sticky_posts', 'a:0:{}', 'yes'),
(78, 'widget_categories', 'a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(79, 'widget_text', 'a:0:{}', 'yes'),
(80, 'widget_rss', 'a:0:{}', 'yes'),
(81, 'uninstall_plugins', 'a:0:{}', 'no'),
(82, 'timezone_string', '', 'yes'),
(83, 'page_for_posts', '0', 'yes'),
(84, 'page_on_front', '0', 'yes'),
(85, 'default_post_format', '0', 'yes'),
(86, 'link_manager_enabled', '0', 'yes'),
(87, 'finished_splitting_shared_terms', '1', 'yes'),
(88, 'site_icon', '0', 'yes'),
(89, 'medium_large_size_w', '768', 'yes'),
(90, 'medium_large_size_h', '0', 'yes'),
(91, 'wp_page_for_privacy_policy', '3', 'yes'),
(92, 'show_comments_cookies_opt_in', '1', 'yes'),
(93, 'initial_db_version', '44719', 'yes'),
(94, 'wp_user_roles', 'a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:76:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:34:\"wpml_manage_translation_management\";b:1;s:21:\"wpml_manage_languages\";b:1;s:41:\"wpml_manage_theme_and_plugin_localization\";b:1;s:19:\"wpml_manage_support\";b:1;s:36:\"wpml_manage_woocommerce_multilingual\";b:1;s:37:\"wpml_operate_woocommerce_multilingual\";b:1;s:29:\"wpml_manage_media_translation\";b:1;s:22:\"wpml_manage_navigation\";b:1;s:24:\"wpml_manage_sticky_links\";b:1;s:30:\"wpml_manage_string_translation\";b:1;s:33:\"wpml_manage_translation_analytics\";b:1;s:25:\"wpml_manage_wp_menus_sync\";b:1;s:32:\"wpml_manage_taxonomy_translation\";b:1;s:27:\"wpml_manage_troubleshooting\";b:1;s:31:\"wpml_manage_translation_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}', 'yes'),
(95, 'fresh_site', '1', 'yes'),
(96, 'widget_search', 'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(97, 'widget_recent-posts', 'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(98, 'widget_recent-comments', 'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(99, 'widget_archives', 'a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(100, 'widget_meta', 'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(101, 'sidebars_widgets', 'a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}', 'yes'),
(102, 'cron', 'a:8:{i:1576590204;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1576629804;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1576673004;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1576673018;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1576673019;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1576673112;a:1:{s:24:\"update_wpml_config_index\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1579265113;a:1:{s:25:\"otgs_send_components_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}', 'yes'),
(103, 'widget_pages', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(104, 'widget_calendar', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(105, 'widget_media_audio', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(106, 'widget_media_image', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(107, 'widget_media_gallery', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(108, 'widget_media_video', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(109, 'widget_tag_cloud', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(110, 'widget_nav_menu', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(111, 'widget_custom_html', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(113, 'recovery_keys', 'a:0:{}', 'yes'),
(117, 'theme_mods_twentynineteen', 'a:1:{s:18:\"custom_css_post_id\";i:-1;}', 'yes'),
(124, 'can_compress_scripts', '0', 'no'),
(129, 'recently_activated', 'a:0:{}', 'yes'),
(130, 'icl_sitepress_version', '4.3.4', 'yes'),
(131, 'icl_sitepress_settings', 'a:45:{s:19:\"hide_upgrade_notice\";s:5:\"4.3.4\";s:25:\"icl_capabilities_verified\";b:1;s:16:\"active_languages\";a:0:{}s:21:\"interview_translators\";i:1;s:34:\"existing_content_language_verified\";i:0;s:25:\"language_negotiation_type\";i:3;s:18:\"icl_lso_link_empty\";i:0;s:18:\"sync_page_ordering\";i:1;s:16:\"sync_page_parent\";i:1;s:18:\"sync_page_template\";i:1;s:16:\"sync_ping_status\";i:1;s:19:\"sync_comment_status\";i:1;s:16:\"sync_sticky_flag\";i:1;s:13:\"sync_password\";i:1;s:17:\"sync_private_flag\";i:1;s:16:\"sync_post_format\";i:1;s:11:\"sync_delete\";i:0;s:15:\"sync_delete_tax\";i:0;s:20:\"sync_post_taxonomies\";i:1;s:14:\"sync_post_date\";i:0;s:21:\"sync_taxonomy_parents\";i:0;s:25:\"translation_pickup_method\";i:0;s:15:\"notify_complete\";i:1;s:26:\"translated_document_status\";i:1;s:17:\"remote_management\";i:0;s:15:\"auto_adjust_ids\";i:1;s:11:\"alert_delay\";i:0;s:12:\"promote_wpml\";i:0;s:18:\"automatic_redirect\";i:0;s:17:\"remember_language\";i:24;s:28:\"icl_lang_sel_copy_parameters\";s:0:\"\";s:28:\"translated_document_page_url\";s:13:\"auto-generate\";s:28:\"sync_comments_on_duplicates \";i:0;s:3:\"seo\";a:3:{s:10:\"head_langs\";i:1;s:27:\"canonicalization_duplicates\";i:1;s:19:\"head_langs_priority\";i:1;}s:22:\"posts_slug_translation\";a:1:{s:2:\"on\";i:1;}s:4:\"urls\";a:5:{s:30:\"directory_for_default_language\";i:0;s:12:\"show_on_root\";s:0:\"\";s:19:\"root_html_file_path\";s:0:\"\";s:9:\"root_page\";i:0;s:23:\"hide_language_switchers\";i:1;}s:12:\"xdomain_data\";i:1;s:24:\"custom_posts_sync_option\";a:2:{s:4:\"post\";i:1;s:4:\"page\";i:1;}s:22:\"taxonomies_sync_option\";a:2:{s:8:\"category\";i:1;s:8:\"post_tag\";i:1;}s:28:\"tm_block_retranslating_terms\";i:1;s:22:\"admin_default_language\";s:9:\"_default_\";s:22:\"taxonomy_names_checked\";b:1;s:18:\"ajx_health_checked\";b:1;s:14:\"setup_complete\";b:0;s:27:\"dont_show_help_admin_notice\";b:1;}', 'yes'),
(132, '_wpml_media', 'a:1:{s:20:\"new_content_settings\";a:3:{s:22:\"always_translate_media\";b:1;s:15:\"duplicate_media\";b:1;s:18:\"duplicate_featured\";b:1;}}', 'yes');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(133, '_icl_cache', 'a:1:{s:25:\"language_name_cache_class\";a:132:{s:19:\"language_details_sq\";a:10:{s:4:\"code\";s:2:\"sq\";s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:8:\"Albanian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sq_AL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sq\";s:12:\"display_name\";s:8:\"Albanian\";}s:19:\"language_details_ar\";a:10:{s:4:\"code\";s:2:\"ar\";s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ar\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ar\";s:12:\"display_name\";s:6:\"Arabic\";}s:19:\"language_details_hy\";a:10:{s:4:\"code\";s:2:\"hy\";s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hy_AM\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hy\";s:12:\"display_name\";s:8:\"Armenian\";}s:19:\"language_details_eu\";a:10:{s:4:\"code\";s:2:\"eu\";s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eu_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eu\";s:12:\"display_name\";s:6:\"Basque\";}s:19:\"language_details_bn\";a:10:{s:4:\"code\";s:2:\"bn\";s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bn_BD\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bn\";s:12:\"display_name\";s:7:\"Bengali\";}s:19:\"language_details_bs\";a:10:{s:4:\"code\";s:2:\"bs\";s:2:\"id\";s:1:\"6\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:7:\"Bosnian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bs_BA\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bs\";s:12:\"display_name\";s:7:\"Bosnian\";}s:19:\"language_details_bg\";a:10:{s:4:\"code\";s:2:\"bg\";s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bg_BG\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bg\";s:12:\"display_name\";s:9:\"Bulgarian\";}s:19:\"language_details_ca\";a:10:{s:4:\"code\";s:2:\"ca\";s:2:\"id\";s:1:\"8\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ca\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ca\";s:12:\"display_name\";s:7:\"Catalan\";}s:24:\"language_details_zh-hans\";a:10:{s:4:\"code\";s:7:\"zh-hans\";s:2:\"id\";s:2:\"59\";s:12:\"english_name\";s:20:\"Chinese (Simplified)\";s:11:\"native_name\";s:12:\"简体中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_CN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hans\";s:12:\"display_name\";s:20:\"Chinese (Simplified)\";}s:24:\"language_details_zh-hant\";a:10:{s:4:\"code\";s:7:\"zh-hant\";s:2:\"id\";s:2:\"61\";s:12:\"english_name\";s:21:\"Chinese (Traditional)\";s:11:\"native_name\";s:12:\"繁體中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_TW\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hant\";s:12:\"display_name\";s:21:\"Chinese (Traditional)\";}s:19:\"language_details_hr\";a:10:{s:4:\"code\";s:2:\"hr\";s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"hr\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hr\";s:12:\"display_name\";s:8:\"Croatian\";}s:19:\"language_details_cs\";a:10:{s:4:\"code\";s:2:\"cs\";s:2:\"id\";s:1:\"9\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cs_CZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cs\";s:12:\"display_name\";s:5:\"Czech\";}s:19:\"language_details_da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:19:\"language_details_nl\";a:10:{s:4:\"code\";s:2:\"nl\";s:2:\"id\";s:2:\"37\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nl_NL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"nl\";s:12:\"display_name\";s:5:\"Dutch\";}s:19:\"language_details_en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:19:\"language_details_eo\";a:10:{s:4:\"code\";s:2:\"eo\";s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanta\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eo_UY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eo\";s:12:\"display_name\";s:9:\"Esperanto\";}s:19:\"language_details_et\";a:10:{s:4:\"code\";s:2:\"et\";s:2:\"id\";s:2:\"15\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"et\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"et\";s:12:\"display_name\";s:8:\"Estonian\";}s:19:\"language_details_fi\";a:10:{s:4:\"code\";s:2:\"fi\";s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"fi\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fi\";s:12:\"display_name\";s:7:\"Finnish\";}s:19:\"language_details_fr\";a:10:{s:4:\"code\";s:2:\"fr\";s:2:\"id\";s:1:\"4\";s:12:\"english_name\";s:6:\"French\";s:11:\"native_name\";s:9:\"Français\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fr_FR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fr\";s:12:\"display_name\";s:6:\"French\";}s:19:\"language_details_gl\";a:10:{s:4:\"code\";s:2:\"gl\";s:2:\"id\";s:2:\"63\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"gl_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"gl\";s:12:\"display_name\";s:8:\"Galician\";}s:19:\"language_details_de\";a:10:{s:4:\"code\";s:2:\"de\";s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"de_DE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"de\";s:12:\"display_name\";s:6:\"German\";}s:19:\"language_details_el\";a:10:{s:4:\"code\";s:2:\"el\";s:2:\"id\";s:2:\"13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικα\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"el\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"el\";s:12:\"display_name\";s:5:\"Greek\";}s:19:\"language_details_he\";a:10:{s:4:\"code\";s:2:\"he\";s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:10:\"עברית\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"he_IL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"he\";s:12:\"display_name\";s:6:\"Hebrew\";}s:19:\"language_details_hi\";a:10:{s:4:\"code\";s:2:\"hi\";s:2:\"id\";s:2:\"21\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hi_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hi\";s:12:\"display_name\";s:5:\"Hindi\";}s:19:\"language_details_hu\";a:10:{s:4:\"code\";s:2:\"hu\";s:2:\"id\";s:2:\"23\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hu_HU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hu\";s:12:\"display_name\";s:9:\"Hungarian\";}s:19:\"language_details_is\";a:10:{s:4:\"code\";s:2:\"is\";s:2:\"id\";s:2:\"26\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"is_IS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"is\";s:12:\"display_name\";s:9:\"Icelandic\";}s:19:\"language_details_id\";a:10:{s:4:\"code\";s:2:\"id\";s:2:\"id\";s:2:\"25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:9:\"Indonesia\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"id_ID\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"id\";s:12:\"display_name\";s:10:\"Indonesian\";}s:19:\"language_details_ga\";a:10:{s:4:\"code\";s:2:\"ga\";s:2:\"id\";s:2:\"19\";s:12:\"english_name\";s:5:\"Irish\";s:11:\"native_name\";s:7:\"Gaeilge\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ga_IE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ga\";s:12:\"display_name\";s:5:\"Irish\";}s:19:\"language_details_it\";a:10:{s:4:\"code\";s:2:\"it\";s:2:\"id\";s:2:\"27\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"it_IT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"it\";s:12:\"display_name\";s:7:\"Italian\";}s:19:\"language_details_ja\";a:10:{s:4:\"code\";s:2:\"ja\";s:2:\"id\";s:2:\"28\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ja\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ja\";s:12:\"display_name\";s:8:\"Japanese\";}s:19:\"language_details_ko\";a:10:{s:4:\"code\";s:2:\"ko\";s:2:\"id\";s:2:\"29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ko_KR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ko\";s:12:\"display_name\";s:6:\"Korean\";}s:19:\"language_details_ku\";a:10:{s:4:\"code\";s:2:\"ku\";s:2:\"id\";s:2:\"30\";s:12:\"english_name\";s:7:\"Kurdish\";s:11:\"native_name\";s:7:\"Kurdish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:3:\"ckb\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ku\";s:12:\"display_name\";s:7:\"Kurdish\";}s:19:\"language_details_lv\";a:10:{s:4:\"code\";s:2:\"lv\";s:2:\"id\";s:2:\"31\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:9:\"Latviešu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lv_LV\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lv\";s:12:\"display_name\";s:7:\"Latvian\";}s:19:\"language_details_lt\";a:10:{s:4:\"code\";s:2:\"lt\";s:2:\"id\";s:2:\"32\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:8:\"Lietuvos\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lt_LT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lt\";s:12:\"display_name\";s:10:\"Lithuanian\";}s:19:\"language_details_mk\";a:10:{s:4:\"code\";s:2:\"mk\";s:2:\"id\";s:2:\"33\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:20:\"македонски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mk_MK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mk\";s:12:\"display_name\";s:10:\"Macedonian\";}s:19:\"language_details_ms\";a:10:{s:4:\"code\";s:2:\"ms\";s:2:\"id\";s:2:\"62\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:6:\"Melayu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ms_MY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ms\";s:12:\"display_name\";s:5:\"Malay\";}s:19:\"language_details_mt\";a:10:{s:4:\"code\";s:2:\"mt\";s:2:\"id\";s:2:\"34\";s:12:\"english_name\";s:7:\"Maltese\";s:11:\"native_name\";s:5:\"Malti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mt_MT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mt\";s:12:\"display_name\";s:7:\"Maltese\";}s:19:\"language_details_mn\";a:10:{s:4:\"code\";s:2:\"mn\";s:2:\"id\";s:2:\"35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:9:\"Mongolian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mn_MN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mn\";s:12:\"display_name\";s:9:\"Mongolian\";}s:19:\"language_details_ne\";a:10:{s:4:\"code\";s:2:\"ne\";s:2:\"id\";s:2:\"36\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:6:\"Nepali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ne\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ne\";s:12:\"display_name\";s:6:\"Nepali\";}s:19:\"language_details_no\";a:10:{s:4:\"code\";s:2:\"no\";s:2:\"id\";s:2:\"38\";s:12:\"english_name\";s:17:\"Norwegian Bokmål\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nb_NO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"no\";s:12:\"display_name\";s:17:\"Norwegian Bokmål\";}s:19:\"language_details_fa\";a:10:{s:4:\"code\";s:2:\"fa\";s:2:\"id\";s:2:\"17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fa_IR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fa\";s:12:\"display_name\";s:7:\"Persian\";}s:19:\"language_details_pl\";a:10:{s:4:\"code\";s:2:\"pl\";s:2:\"id\";s:2:\"40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"polski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pl_PL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pl\";s:12:\"display_name\";s:6:\"Polish\";}s:22:\"language_details_pt-br\";a:10:{s:4:\"code\";s:5:\"pt-br\";s:2:\"id\";s:2:\"42\";s:12:\"english_name\";s:18:\"Portuguese, Brazil\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_BR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-br\";s:12:\"display_name\";s:19:\"Portuguese (Brazil)\";}s:22:\"language_details_pt-pt\";a:10:{s:4:\"code\";s:5:\"pt-pt\";s:2:\"id\";s:2:\"41\";s:12:\"english_name\";s:20:\"Portuguese, Portugal\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_PT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-pt\";s:12:\"display_name\";s:21:\"Portuguese (Portugal)\";}s:19:\"language_details_pa\";a:10:{s:4:\"code\";s:2:\"pa\";s:2:\"id\";s:2:\"39\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:7:\"Punjabi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pa\";s:12:\"display_name\";s:7:\"Punjabi\";}s:19:\"language_details_qu\";a:10:{s:4:\"code\";s:2:\"qu\";s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"Quechua\";s:11:\"native_name\";s:7:\"Quechua\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:6:\"quz_PE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"qu\";s:12:\"display_name\";s:7:\"Quechua\";}s:19:\"language_details_ro\";a:10:{s:4:\"code\";s:2:\"ro\";s:2:\"id\";s:2:\"44\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ro_RO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ro\";s:12:\"display_name\";s:8:\"Romanian\";}s:19:\"language_details_ru\";a:10:{s:4:\"code\";s:2:\"ru\";s:2:\"id\";s:2:\"45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ru_RU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ru\";s:12:\"display_name\";s:7:\"Russian\";}s:19:\"language_details_sr\";a:10:{s:4:\"code\";s:2:\"sr\";s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:12:\"српски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sr_RS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sr\";s:12:\"display_name\";s:7:\"Serbian\";}s:19:\"language_details_sk\";a:10:{s:4:\"code\";s:2:\"sk\";s:2:\"id\";s:2:\"10\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sk_SK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sk\";s:12:\"display_name\";s:6:\"Slovak\";}s:19:\"language_details_sl\";a:10:{s:4:\"code\";s:2:\"sl\";s:2:\"id\";s:2:\"46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sl_SI\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sl\";s:12:\"display_name\";s:9:\"Slovenian\";}s:19:\"language_details_so\";a:10:{s:4:\"code\";s:2:\"so\";s:2:\"id\";s:2:\"47\";s:12:\"english_name\";s:6:\"Somali\";s:11:\"native_name\";s:6:\"Somali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"so_SO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"so\";s:12:\"display_name\";s:6:\"Somali\";}s:19:\"language_details_es\";a:10:{s:4:\"code\";s:2:\"es\";s:2:\"id\";s:1:\"2\";s:12:\"english_name\";s:7:\"Spanish\";s:11:\"native_name\";s:8:\"Español\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"es_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"es\";s:12:\"display_name\";s:7:\"Spanish\";}s:19:\"language_details_sv\";a:10:{s:4:\"code\";s:2:\"sv\";s:2:\"id\";s:2:\"50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sv_SE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sv\";s:12:\"display_name\";s:7:\"Swedish\";}s:19:\"language_details_ta\";a:10:{s:4:\"code\";s:2:\"ta\";s:2:\"id\";s:2:\"51\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:5:\"Tamil\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ta_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ta\";s:12:\"display_name\";s:5:\"Tamil\";}s:19:\"language_details_th\";a:10:{s:4:\"code\";s:2:\"th\";s:2:\"id\";s:2:\"52\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"th\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"th\";s:12:\"display_name\";s:4:\"Thai\";}s:19:\"language_details_tr\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:7:\"Turkish\";}s:19:\"language_details_uk\";a:10:{s:4:\"code\";s:2:\"uk\";s:2:\"id\";s:2:\"54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:9:\"Ukrainian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"uk\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uk\";s:12:\"display_name\";s:9:\"Ukrainian\";}s:19:\"language_details_ur\";a:10:{s:4:\"code\";s:2:\"ur\";s:2:\"id\";s:2:\"55\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:9:\"اردو \";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ur\";s:12:\"display_name\";s:4:\"Urdu\";}s:19:\"language_details_uz\";a:10:{s:4:\"code\";s:2:\"uz\";s:2:\"id\";s:2:\"56\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:5:\"Uzbek\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uz\";s:12:\"display_name\";s:5:\"Uzbek\";}s:19:\"language_details_vi\";a:10:{s:4:\"code\";s:2:\"vi\";s:2:\"id\";s:2:\"57\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"vi_VN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"vi\";s:12:\"display_name\";s:10:\"Vietnamese\";}s:19:\"language_details_cy\";a:10:{s:4:\"code\";s:2:\"cy\";s:2:\"id\";s:2:\"11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cy_GB\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cy\";s:12:\"display_name\";s:5:\"Welsh\";}s:19:\"language_details_yi\";a:10:{s:4:\"code\";s:2:\"yi\";s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:7:\"Yiddish\";s:11:\"native_name\";s:7:\"Yiddish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"yi\";s:12:\"display_name\";s:7:\"Yiddish\";}s:19:\"language_details_zu\";a:10:{s:4:\"code\";s:2:\"zu\";s:2:\"id\";s:2:\"60\";s:12:\"english_name\";s:4:\"Zulu\";s:11:\"native_name\";s:4:\"Zulu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"zu\";s:12:\"display_name\";s:4:\"Zulu\";}s:27:\"all_language___english_name\";a:64:{s:2:\"sq\";a:10:{s:4:\"code\";s:2:\"sq\";s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:8:\"Albanian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sq_AL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sq\";s:12:\"display_name\";s:8:\"Albanian\";}s:2:\"ar\";a:10:{s:4:\"code\";s:2:\"ar\";s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ar\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ar\";s:12:\"display_name\";s:6:\"Arabic\";}s:2:\"hy\";a:10:{s:4:\"code\";s:2:\"hy\";s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hy_AM\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hy\";s:12:\"display_name\";s:8:\"Armenian\";}s:2:\"eu\";a:10:{s:4:\"code\";s:2:\"eu\";s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eu_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eu\";s:12:\"display_name\";s:6:\"Basque\";}s:2:\"bn\";a:10:{s:4:\"code\";s:2:\"bn\";s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bn_BD\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bn\";s:12:\"display_name\";s:7:\"Bengali\";}s:2:\"bs\";a:10:{s:4:\"code\";s:2:\"bs\";s:2:\"id\";s:1:\"6\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:7:\"Bosnian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bs_BA\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bs\";s:12:\"display_name\";s:7:\"Bosnian\";}s:2:\"bg\";a:10:{s:4:\"code\";s:2:\"bg\";s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bg_BG\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bg\";s:12:\"display_name\";s:9:\"Bulgarian\";}s:2:\"ca\";a:10:{s:4:\"code\";s:2:\"ca\";s:2:\"id\";s:1:\"8\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ca\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ca\";s:12:\"display_name\";s:7:\"Catalan\";}s:7:\"zh-hans\";a:10:{s:4:\"code\";s:7:\"zh-hans\";s:2:\"id\";s:2:\"59\";s:12:\"english_name\";s:20:\"Chinese (Simplified)\";s:11:\"native_name\";s:12:\"简体中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_CN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hans\";s:12:\"display_name\";s:20:\"Chinese (Simplified)\";}s:7:\"zh-hant\";a:10:{s:4:\"code\";s:7:\"zh-hant\";s:2:\"id\";s:2:\"61\";s:12:\"english_name\";s:21:\"Chinese (Traditional)\";s:11:\"native_name\";s:12:\"繁體中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_TW\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hant\";s:12:\"display_name\";s:21:\"Chinese (Traditional)\";}s:2:\"hr\";a:10:{s:4:\"code\";s:2:\"hr\";s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"hr\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hr\";s:12:\"display_name\";s:8:\"Croatian\";}s:2:\"cs\";a:10:{s:4:\"code\";s:2:\"cs\";s:2:\"id\";s:1:\"9\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cs_CZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cs\";s:12:\"display_name\";s:5:\"Czech\";}s:2:\"da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:2:\"nl\";a:10:{s:4:\"code\";s:2:\"nl\";s:2:\"id\";s:2:\"37\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nl_NL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"nl\";s:12:\"display_name\";s:5:\"Dutch\";}s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:2:\"eo\";a:10:{s:4:\"code\";s:2:\"eo\";s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanta\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eo_UY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eo\";s:12:\"display_name\";s:9:\"Esperanto\";}s:2:\"et\";a:10:{s:4:\"code\";s:2:\"et\";s:2:\"id\";s:2:\"15\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"et\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"et\";s:12:\"display_name\";s:8:\"Estonian\";}s:2:\"fi\";a:10:{s:4:\"code\";s:2:\"fi\";s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"fi\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fi\";s:12:\"display_name\";s:7:\"Finnish\";}s:2:\"fr\";a:10:{s:4:\"code\";s:2:\"fr\";s:2:\"id\";s:1:\"4\";s:12:\"english_name\";s:6:\"French\";s:11:\"native_name\";s:9:\"Français\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fr_FR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fr\";s:12:\"display_name\";s:6:\"French\";}s:2:\"gl\";a:10:{s:4:\"code\";s:2:\"gl\";s:2:\"id\";s:2:\"63\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"gl_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"gl\";s:12:\"display_name\";s:8:\"Galician\";}s:2:\"de\";a:10:{s:4:\"code\";s:2:\"de\";s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"de_DE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"de\";s:12:\"display_name\";s:6:\"German\";}s:2:\"el\";a:10:{s:4:\"code\";s:2:\"el\";s:2:\"id\";s:2:\"13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικα\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"el\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"el\";s:12:\"display_name\";s:5:\"Greek\";}s:2:\"he\";a:10:{s:4:\"code\";s:2:\"he\";s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:10:\"עברית\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"he_IL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"he\";s:12:\"display_name\";s:6:\"Hebrew\";}s:2:\"hi\";a:10:{s:4:\"code\";s:2:\"hi\";s:2:\"id\";s:2:\"21\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hi_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hi\";s:12:\"display_name\";s:5:\"Hindi\";}s:2:\"hu\";a:10:{s:4:\"code\";s:2:\"hu\";s:2:\"id\";s:2:\"23\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hu_HU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hu\";s:12:\"display_name\";s:9:\"Hungarian\";}s:2:\"is\";a:10:{s:4:\"code\";s:2:\"is\";s:2:\"id\";s:2:\"26\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"is_IS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"is\";s:12:\"display_name\";s:9:\"Icelandic\";}s:2:\"id\";a:10:{s:4:\"code\";s:2:\"id\";s:2:\"id\";s:2:\"25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:9:\"Indonesia\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"id_ID\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"id\";s:12:\"display_name\";s:10:\"Indonesian\";}s:2:\"ga\";a:10:{s:4:\"code\";s:2:\"ga\";s:2:\"id\";s:2:\"19\";s:12:\"english_name\";s:5:\"Irish\";s:11:\"native_name\";s:7:\"Gaeilge\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ga_IE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ga\";s:12:\"display_name\";s:5:\"Irish\";}s:2:\"it\";a:10:{s:4:\"code\";s:2:\"it\";s:2:\"id\";s:2:\"27\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"it_IT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"it\";s:12:\"display_name\";s:7:\"Italian\";}s:2:\"ja\";a:10:{s:4:\"code\";s:2:\"ja\";s:2:\"id\";s:2:\"28\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ja\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ja\";s:12:\"display_name\";s:8:\"Japanese\";}s:2:\"ko\";a:10:{s:4:\"code\";s:2:\"ko\";s:2:\"id\";s:2:\"29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ko_KR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ko\";s:12:\"display_name\";s:6:\"Korean\";}s:2:\"ku\";a:10:{s:4:\"code\";s:2:\"ku\";s:2:\"id\";s:2:\"30\";s:12:\"english_name\";s:7:\"Kurdish\";s:11:\"native_name\";s:7:\"Kurdish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:3:\"ckb\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ku\";s:12:\"display_name\";s:7:\"Kurdish\";}s:2:\"lv\";a:10:{s:4:\"code\";s:2:\"lv\";s:2:\"id\";s:2:\"31\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:9:\"Latviešu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lv_LV\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lv\";s:12:\"display_name\";s:7:\"Latvian\";}s:2:\"lt\";a:10:{s:4:\"code\";s:2:\"lt\";s:2:\"id\";s:2:\"32\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:8:\"Lietuvos\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lt_LT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lt\";s:12:\"display_name\";s:10:\"Lithuanian\";}s:2:\"mk\";a:10:{s:4:\"code\";s:2:\"mk\";s:2:\"id\";s:2:\"33\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:20:\"македонски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mk_MK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mk\";s:12:\"display_name\";s:10:\"Macedonian\";}s:2:\"ms\";a:10:{s:4:\"code\";s:2:\"ms\";s:2:\"id\";s:2:\"62\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:6:\"Melayu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ms_MY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ms\";s:12:\"display_name\";s:5:\"Malay\";}s:2:\"mt\";a:10:{s:4:\"code\";s:2:\"mt\";s:2:\"id\";s:2:\"34\";s:12:\"english_name\";s:7:\"Maltese\";s:11:\"native_name\";s:5:\"Malti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mt_MT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mt\";s:12:\"display_name\";s:7:\"Maltese\";}s:2:\"mn\";a:10:{s:4:\"code\";s:2:\"mn\";s:2:\"id\";s:2:\"35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:9:\"Mongolian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mn_MN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mn\";s:12:\"display_name\";s:9:\"Mongolian\";}s:2:\"ne\";a:10:{s:4:\"code\";s:2:\"ne\";s:2:\"id\";s:2:\"36\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:6:\"Nepali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ne\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ne\";s:12:\"display_name\";s:6:\"Nepali\";}s:2:\"no\";a:10:{s:4:\"code\";s:2:\"no\";s:2:\"id\";s:2:\"38\";s:12:\"english_name\";s:17:\"Norwegian Bokmål\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nb_NO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"no\";s:12:\"display_name\";s:17:\"Norwegian Bokmål\";}s:2:\"fa\";a:10:{s:4:\"code\";s:2:\"fa\";s:2:\"id\";s:2:\"17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fa_IR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fa\";s:12:\"display_name\";s:7:\"Persian\";}s:2:\"pl\";a:10:{s:4:\"code\";s:2:\"pl\";s:2:\"id\";s:2:\"40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"polski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pl_PL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pl\";s:12:\"display_name\";s:6:\"Polish\";}s:5:\"pt-br\";a:10:{s:4:\"code\";s:5:\"pt-br\";s:2:\"id\";s:2:\"42\";s:12:\"english_name\";s:18:\"Portuguese, Brazil\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_BR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-br\";s:12:\"display_name\";s:19:\"Portuguese (Brazil)\";}s:5:\"pt-pt\";a:10:{s:4:\"code\";s:5:\"pt-pt\";s:2:\"id\";s:2:\"41\";s:12:\"english_name\";s:20:\"Portuguese, Portugal\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_PT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-pt\";s:12:\"display_name\";s:21:\"Portuguese (Portugal)\";}s:2:\"pa\";a:10:{s:4:\"code\";s:2:\"pa\";s:2:\"id\";s:2:\"39\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:7:\"Punjabi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pa\";s:12:\"display_name\";s:7:\"Punjabi\";}s:2:\"qu\";a:10:{s:4:\"code\";s:2:\"qu\";s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"Quechua\";s:11:\"native_name\";s:7:\"Quechua\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:6:\"quz_PE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"qu\";s:12:\"display_name\";s:7:\"Quechua\";}s:2:\"ro\";a:10:{s:4:\"code\";s:2:\"ro\";s:2:\"id\";s:2:\"44\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ro_RO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ro\";s:12:\"display_name\";s:8:\"Romanian\";}s:2:\"ru\";a:10:{s:4:\"code\";s:2:\"ru\";s:2:\"id\";s:2:\"45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ru_RU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ru\";s:12:\"display_name\";s:7:\"Russian\";}s:2:\"sr\";a:10:{s:4:\"code\";s:2:\"sr\";s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:12:\"српски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sr_RS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sr\";s:12:\"display_name\";s:7:\"Serbian\";}s:2:\"sk\";a:10:{s:4:\"code\";s:2:\"sk\";s:2:\"id\";s:2:\"10\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sk_SK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sk\";s:12:\"display_name\";s:6:\"Slovak\";}s:2:\"sl\";a:10:{s:4:\"code\";s:2:\"sl\";s:2:\"id\";s:2:\"46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sl_SI\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sl\";s:12:\"display_name\";s:9:\"Slovenian\";}s:2:\"so\";a:10:{s:4:\"code\";s:2:\"so\";s:2:\"id\";s:2:\"47\";s:12:\"english_name\";s:6:\"Somali\";s:11:\"native_name\";s:6:\"Somali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"so_SO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"so\";s:12:\"display_name\";s:6:\"Somali\";}s:2:\"es\";a:10:{s:4:\"code\";s:2:\"es\";s:2:\"id\";s:1:\"2\";s:12:\"english_name\";s:7:\"Spanish\";s:11:\"native_name\";s:8:\"Español\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"es_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"es\";s:12:\"display_name\";s:7:\"Spanish\";}s:2:\"sv\";a:10:{s:4:\"code\";s:2:\"sv\";s:2:\"id\";s:2:\"50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sv_SE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sv\";s:12:\"display_name\";s:7:\"Swedish\";}s:2:\"ta\";a:10:{s:4:\"code\";s:2:\"ta\";s:2:\"id\";s:2:\"51\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:5:\"Tamil\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ta_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ta\";s:12:\"display_name\";s:5:\"Tamil\";}s:2:\"th\";a:10:{s:4:\"code\";s:2:\"th\";s:2:\"id\";s:2:\"52\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"th\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"th\";s:12:\"display_name\";s:4:\"Thai\";}s:2:\"tr\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:7:\"Turkish\";}s:2:\"uk\";a:10:{s:4:\"code\";s:2:\"uk\";s:2:\"id\";s:2:\"54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:9:\"Ukrainian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"uk\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uk\";s:12:\"display_name\";s:9:\"Ukrainian\";}s:2:\"ur\";a:10:{s:4:\"code\";s:2:\"ur\";s:2:\"id\";s:2:\"55\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:9:\"اردو \";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ur\";s:12:\"display_name\";s:4:\"Urdu\";}s:2:\"uz\";a:10:{s:4:\"code\";s:2:\"uz\";s:2:\"id\";s:2:\"56\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:5:\"Uzbek\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uz\";s:12:\"display_name\";s:5:\"Uzbek\";}s:2:\"vi\";a:10:{s:4:\"code\";s:2:\"vi\";s:2:\"id\";s:2:\"57\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"vi_VN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"vi\";s:12:\"display_name\";s:10:\"Vietnamese\";}s:2:\"cy\";a:10:{s:4:\"code\";s:2:\"cy\";s:2:\"id\";s:2:\"11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cy_GB\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cy\";s:12:\"display_name\";s:5:\"Welsh\";}s:2:\"yi\";a:10:{s:4:\"code\";s:2:\"yi\";s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:7:\"Yiddish\";s:11:\"native_name\";s:7:\"Yiddish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"yi\";s:12:\"display_name\";s:7:\"Yiddish\";}s:2:\"zu\";a:10:{s:4:\"code\";s:2:\"zu\";s:2:\"id\";s:2:\"60\";s:12:\"english_name\";s:4:\"Zulu\";s:11:\"native_name\";s:4:\"Zulu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"zu\";s:12:\"display_name\";s:4:\"Zulu\";}}s:28:\"in_language_en__english_name\";a:0:{}s:21:\"language_details_sqen\";a:10:{s:4:\"code\";s:2:\"sq\";s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:8:\"Albanian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sq_AL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sq\";s:12:\"display_name\";s:8:\"Albanian\";}s:21:\"language_details_aren\";a:10:{s:4:\"code\";s:2:\"ar\";s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ar\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ar\";s:12:\"display_name\";s:6:\"Arabic\";}s:21:\"language_details_hyen\";a:10:{s:4:\"code\";s:2:\"hy\";s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hy_AM\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hy\";s:12:\"display_name\";s:8:\"Armenian\";}s:21:\"language_details_euen\";a:10:{s:4:\"code\";s:2:\"eu\";s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eu_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eu\";s:12:\"display_name\";s:6:\"Basque\";}s:21:\"language_details_bnen\";a:10:{s:4:\"code\";s:2:\"bn\";s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bn_BD\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bn\";s:12:\"display_name\";s:7:\"Bengali\";}s:21:\"language_details_bsen\";a:10:{s:4:\"code\";s:2:\"bs\";s:2:\"id\";s:1:\"6\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:7:\"Bosnian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bs_BA\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bs\";s:12:\"display_name\";s:7:\"Bosnian\";}s:21:\"language_details_bgen\";a:10:{s:4:\"code\";s:2:\"bg\";s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bg_BG\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bg\";s:12:\"display_name\";s:9:\"Bulgarian\";}s:21:\"language_details_caen\";a:10:{s:4:\"code\";s:2:\"ca\";s:2:\"id\";s:1:\"8\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ca\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ca\";s:12:\"display_name\";s:7:\"Catalan\";}s:26:\"language_details_zh-hansen\";a:10:{s:4:\"code\";s:7:\"zh-hans\";s:2:\"id\";s:2:\"59\";s:12:\"english_name\";s:20:\"Chinese (Simplified)\";s:11:\"native_name\";s:12:\"简体中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_CN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hans\";s:12:\"display_name\";s:20:\"Chinese (Simplified)\";}s:26:\"language_details_zh-hanten\";a:10:{s:4:\"code\";s:7:\"zh-hant\";s:2:\"id\";s:2:\"61\";s:12:\"english_name\";s:21:\"Chinese (Traditional)\";s:11:\"native_name\";s:12:\"繁體中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_TW\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hant\";s:12:\"display_name\";s:21:\"Chinese (Traditional)\";}s:21:\"language_details_hren\";a:10:{s:4:\"code\";s:2:\"hr\";s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"hr\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hr\";s:12:\"display_name\";s:8:\"Croatian\";}s:21:\"language_details_csen\";a:10:{s:4:\"code\";s:2:\"cs\";s:2:\"id\";s:1:\"9\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cs_CZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cs\";s:12:\"display_name\";s:5:\"Czech\";}s:21:\"language_details_daen\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:21:\"language_details_nlen\";a:10:{s:4:\"code\";s:2:\"nl\";s:2:\"id\";s:2:\"37\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nl_NL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"nl\";s:12:\"display_name\";s:5:\"Dutch\";}s:21:\"language_details_enen\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:21:\"language_details_eoen\";a:10:{s:4:\"code\";s:2:\"eo\";s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanta\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eo_UY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eo\";s:12:\"display_name\";s:9:\"Esperanto\";}s:21:\"language_details_eten\";a:10:{s:4:\"code\";s:2:\"et\";s:2:\"id\";s:2:\"15\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"et\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"et\";s:12:\"display_name\";s:8:\"Estonian\";}s:21:\"language_details_fien\";a:10:{s:4:\"code\";s:2:\"fi\";s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"fi\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fi\";s:12:\"display_name\";s:7:\"Finnish\";}s:21:\"language_details_fren\";a:10:{s:4:\"code\";s:2:\"fr\";s:2:\"id\";s:1:\"4\";s:12:\"english_name\";s:6:\"French\";s:11:\"native_name\";s:9:\"Français\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fr_FR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fr\";s:12:\"display_name\";s:6:\"French\";}s:21:\"language_details_glen\";a:10:{s:4:\"code\";s:2:\"gl\";s:2:\"id\";s:2:\"63\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"gl_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"gl\";s:12:\"display_name\";s:8:\"Galician\";}s:21:\"language_details_deen\";a:10:{s:4:\"code\";s:2:\"de\";s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"de_DE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"de\";s:12:\"display_name\";s:6:\"German\";}s:21:\"language_details_elen\";a:10:{s:4:\"code\";s:2:\"el\";s:2:\"id\";s:2:\"13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικα\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"el\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"el\";s:12:\"display_name\";s:5:\"Greek\";}s:21:\"language_details_heen\";a:10:{s:4:\"code\";s:2:\"he\";s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:10:\"עברית\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"he_IL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"he\";s:12:\"display_name\";s:6:\"Hebrew\";}s:21:\"language_details_hien\";a:10:{s:4:\"code\";s:2:\"hi\";s:2:\"id\";s:2:\"21\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hi_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hi\";s:12:\"display_name\";s:5:\"Hindi\";}s:21:\"language_details_huen\";a:10:{s:4:\"code\";s:2:\"hu\";s:2:\"id\";s:2:\"23\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hu_HU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hu\";s:12:\"display_name\";s:9:\"Hungarian\";}s:21:\"language_details_isen\";a:10:{s:4:\"code\";s:2:\"is\";s:2:\"id\";s:2:\"26\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"is_IS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"is\";s:12:\"display_name\";s:9:\"Icelandic\";}s:21:\"language_details_iden\";a:10:{s:4:\"code\";s:2:\"id\";s:2:\"id\";s:2:\"25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:9:\"Indonesia\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"id_ID\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"id\";s:12:\"display_name\";s:10:\"Indonesian\";}s:21:\"language_details_gaen\";a:10:{s:4:\"code\";s:2:\"ga\";s:2:\"id\";s:2:\"19\";s:12:\"english_name\";s:5:\"Irish\";s:11:\"native_name\";s:7:\"Gaeilge\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ga_IE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ga\";s:12:\"display_name\";s:5:\"Irish\";}s:21:\"language_details_iten\";a:10:{s:4:\"code\";s:2:\"it\";s:2:\"id\";s:2:\"27\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"it_IT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"it\";s:12:\"display_name\";s:7:\"Italian\";}s:21:\"language_details_jaen\";a:10:{s:4:\"code\";s:2:\"ja\";s:2:\"id\";s:2:\"28\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ja\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ja\";s:12:\"display_name\";s:8:\"Japanese\";}s:21:\"language_details_koen\";a:10:{s:4:\"code\";s:2:\"ko\";s:2:\"id\";s:2:\"29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ko_KR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ko\";s:12:\"display_name\";s:6:\"Korean\";}s:21:\"language_details_kuen\";a:10:{s:4:\"code\";s:2:\"ku\";s:2:\"id\";s:2:\"30\";s:12:\"english_name\";s:7:\"Kurdish\";s:11:\"native_name\";s:7:\"Kurdish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:3:\"ckb\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ku\";s:12:\"display_name\";s:7:\"Kurdish\";}s:21:\"language_details_lven\";a:10:{s:4:\"code\";s:2:\"lv\";s:2:\"id\";s:2:\"31\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:9:\"Latviešu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lv_LV\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lv\";s:12:\"display_name\";s:7:\"Latvian\";}s:21:\"language_details_lten\";a:10:{s:4:\"code\";s:2:\"lt\";s:2:\"id\";s:2:\"32\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:8:\"Lietuvos\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lt_LT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lt\";s:12:\"display_name\";s:10:\"Lithuanian\";}s:21:\"language_details_mken\";a:10:{s:4:\"code\";s:2:\"mk\";s:2:\"id\";s:2:\"33\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:20:\"македонски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mk_MK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mk\";s:12:\"display_name\";s:10:\"Macedonian\";}s:21:\"language_details_msen\";a:10:{s:4:\"code\";s:2:\"ms\";s:2:\"id\";s:2:\"62\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:6:\"Melayu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ms_MY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ms\";s:12:\"display_name\";s:5:\"Malay\";}s:21:\"language_details_mten\";a:10:{s:4:\"code\";s:2:\"mt\";s:2:\"id\";s:2:\"34\";s:12:\"english_name\";s:7:\"Maltese\";s:11:\"native_name\";s:5:\"Malti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mt_MT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mt\";s:12:\"display_name\";s:7:\"Maltese\";}s:21:\"language_details_mnen\";a:10:{s:4:\"code\";s:2:\"mn\";s:2:\"id\";s:2:\"35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:9:\"Mongolian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mn_MN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mn\";s:12:\"display_name\";s:9:\"Mongolian\";}s:21:\"language_details_neen\";a:10:{s:4:\"code\";s:2:\"ne\";s:2:\"id\";s:2:\"36\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:6:\"Nepali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ne\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ne\";s:12:\"display_name\";s:6:\"Nepali\";}s:21:\"language_details_noen\";a:10:{s:4:\"code\";s:2:\"no\";s:2:\"id\";s:2:\"38\";s:12:\"english_name\";s:17:\"Norwegian Bokmål\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nb_NO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"no\";s:12:\"display_name\";s:17:\"Norwegian Bokmål\";}s:21:\"language_details_faen\";a:10:{s:4:\"code\";s:2:\"fa\";s:2:\"id\";s:2:\"17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fa_IR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fa\";s:12:\"display_name\";s:7:\"Persian\";}s:21:\"language_details_plen\";a:10:{s:4:\"code\";s:2:\"pl\";s:2:\"id\";s:2:\"40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"polski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pl_PL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pl\";s:12:\"display_name\";s:6:\"Polish\";}s:24:\"language_details_pt-bren\";a:10:{s:4:\"code\";s:5:\"pt-br\";s:2:\"id\";s:2:\"42\";s:12:\"english_name\";s:18:\"Portuguese, Brazil\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_BR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-br\";s:12:\"display_name\";s:19:\"Portuguese (Brazil)\";}s:24:\"language_details_pt-pten\";a:10:{s:4:\"code\";s:5:\"pt-pt\";s:2:\"id\";s:2:\"41\";s:12:\"english_name\";s:20:\"Portuguese, Portugal\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_PT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-pt\";s:12:\"display_name\";s:21:\"Portuguese (Portugal)\";}s:21:\"language_details_paen\";a:10:{s:4:\"code\";s:2:\"pa\";s:2:\"id\";s:2:\"39\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:7:\"Punjabi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pa\";s:12:\"display_name\";s:7:\"Punjabi\";}s:21:\"language_details_quen\";a:10:{s:4:\"code\";s:2:\"qu\";s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"Quechua\";s:11:\"native_name\";s:7:\"Quechua\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:6:\"quz_PE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"qu\";s:12:\"display_name\";s:7:\"Quechua\";}s:21:\"language_details_roen\";a:10:{s:4:\"code\";s:2:\"ro\";s:2:\"id\";s:2:\"44\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ro_RO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ro\";s:12:\"display_name\";s:8:\"Romanian\";}s:21:\"language_details_ruen\";a:10:{s:4:\"code\";s:2:\"ru\";s:2:\"id\";s:2:\"45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ru_RU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ru\";s:12:\"display_name\";s:7:\"Russian\";}s:21:\"language_details_sren\";a:10:{s:4:\"code\";s:2:\"sr\";s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:12:\"српски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sr_RS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sr\";s:12:\"display_name\";s:7:\"Serbian\";}s:21:\"language_details_sken\";a:10:{s:4:\"code\";s:2:\"sk\";s:2:\"id\";s:2:\"10\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sk_SK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sk\";s:12:\"display_name\";s:6:\"Slovak\";}s:21:\"language_details_slen\";a:10:{s:4:\"code\";s:2:\"sl\";s:2:\"id\";s:2:\"46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sl_SI\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sl\";s:12:\"display_name\";s:9:\"Slovenian\";}s:21:\"language_details_soen\";a:10:{s:4:\"code\";s:2:\"so\";s:2:\"id\";s:2:\"47\";s:12:\"english_name\";s:6:\"Somali\";s:11:\"native_name\";s:6:\"Somali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"so_SO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"so\";s:12:\"display_name\";s:6:\"Somali\";}s:21:\"language_details_esen\";a:10:{s:4:\"code\";s:2:\"es\";s:2:\"id\";s:1:\"2\";s:12:\"english_name\";s:7:\"Spanish\";s:11:\"native_name\";s:8:\"Español\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"es_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"es\";s:12:\"display_name\";s:7:\"Spanish\";}s:21:\"language_details_sven\";a:10:{s:4:\"code\";s:2:\"sv\";s:2:\"id\";s:2:\"50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sv_SE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sv\";s:12:\"display_name\";s:7:\"Swedish\";}s:21:\"language_details_taen\";a:10:{s:4:\"code\";s:2:\"ta\";s:2:\"id\";s:2:\"51\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:5:\"Tamil\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ta_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ta\";s:12:\"display_name\";s:5:\"Tamil\";}s:21:\"language_details_then\";a:10:{s:4:\"code\";s:2:\"th\";s:2:\"id\";s:2:\"52\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"th\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"th\";s:12:\"display_name\";s:4:\"Thai\";}s:21:\"language_details_tren\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:7:\"Turkish\";}s:21:\"language_details_uken\";a:10:{s:4:\"code\";s:2:\"uk\";s:2:\"id\";s:2:\"54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:9:\"Ukrainian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"uk\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uk\";s:12:\"display_name\";s:9:\"Ukrainian\";}s:21:\"language_details_uren\";a:10:{s:4:\"code\";s:2:\"ur\";s:2:\"id\";s:2:\"55\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:9:\"اردو \";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ur\";s:12:\"display_name\";s:4:\"Urdu\";}s:21:\"language_details_uzen\";a:10:{s:4:\"code\";s:2:\"uz\";s:2:\"id\";s:2:\"56\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:5:\"Uzbek\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uz\";s:12:\"display_name\";s:5:\"Uzbek\";}s:21:\"language_details_vien\";a:10:{s:4:\"code\";s:2:\"vi\";s:2:\"id\";s:2:\"57\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"vi_VN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"vi\";s:12:\"display_name\";s:10:\"Vietnamese\";}s:21:\"language_details_cyen\";a:10:{s:4:\"code\";s:2:\"cy\";s:2:\"id\";s:2:\"11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cy_GB\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cy\";s:12:\"display_name\";s:5:\"Welsh\";}s:21:\"language_details_yien\";a:10:{s:4:\"code\";s:2:\"yi\";s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:7:\"Yiddish\";s:11:\"native_name\";s:7:\"Yiddish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"yi\";s:12:\"display_name\";s:7:\"Yiddish\";}s:21:\"language_details_zuen\";a:10:{s:4:\"code\";s:2:\"zu\";s:2:\"id\";s:2:\"60\";s:12:\"english_name\";s:4:\"Zulu\";s:11:\"native_name\";s:4:\"Zulu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"zu\";s:12:\"display_name\";s:4:\"Zulu\";}s:29:\"all_language_en__english_name\";a:64:{s:2:\"sq\";a:10:{s:4:\"code\";s:2:\"sq\";s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:8:\"Albanian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sq_AL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sq\";s:12:\"display_name\";s:8:\"Albanian\";}s:2:\"ar\";a:10:{s:4:\"code\";s:2:\"ar\";s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ar\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ar\";s:12:\"display_name\";s:6:\"Arabic\";}s:2:\"hy\";a:10:{s:4:\"code\";s:2:\"hy\";s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hy_AM\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hy\";s:12:\"display_name\";s:8:\"Armenian\";}s:2:\"eu\";a:10:{s:4:\"code\";s:2:\"eu\";s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eu_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eu\";s:12:\"display_name\";s:6:\"Basque\";}s:2:\"bn\";a:10:{s:4:\"code\";s:2:\"bn\";s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bn_BD\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bn\";s:12:\"display_name\";s:7:\"Bengali\";}s:2:\"bs\";a:10:{s:4:\"code\";s:2:\"bs\";s:2:\"id\";s:1:\"6\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:7:\"Bosnian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bs_BA\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bs\";s:12:\"display_name\";s:7:\"Bosnian\";}s:2:\"bg\";a:10:{s:4:\"code\";s:2:\"bg\";s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bg_BG\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bg\";s:12:\"display_name\";s:9:\"Bulgarian\";}s:2:\"ca\";a:10:{s:4:\"code\";s:2:\"ca\";s:2:\"id\";s:1:\"8\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ca\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ca\";s:12:\"display_name\";s:7:\"Catalan\";}s:7:\"zh-hans\";a:10:{s:4:\"code\";s:7:\"zh-hans\";s:2:\"id\";s:2:\"59\";s:12:\"english_name\";s:20:\"Chinese (Simplified)\";s:11:\"native_name\";s:12:\"简体中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_CN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hans\";s:12:\"display_name\";s:20:\"Chinese (Simplified)\";}s:7:\"zh-hant\";a:10:{s:4:\"code\";s:7:\"zh-hant\";s:2:\"id\";s:2:\"61\";s:12:\"english_name\";s:21:\"Chinese (Traditional)\";s:11:\"native_name\";s:12:\"繁體中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_TW\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hant\";s:12:\"display_name\";s:21:\"Chinese (Traditional)\";}s:2:\"hr\";a:10:{s:4:\"code\";s:2:\"hr\";s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"hr\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hr\";s:12:\"display_name\";s:8:\"Croatian\";}s:2:\"cs\";a:10:{s:4:\"code\";s:2:\"cs\";s:2:\"id\";s:1:\"9\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cs_CZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cs\";s:12:\"display_name\";s:5:\"Czech\";}s:2:\"da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:2:\"nl\";a:10:{s:4:\"code\";s:2:\"nl\";s:2:\"id\";s:2:\"37\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nl_NL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"nl\";s:12:\"display_name\";s:5:\"Dutch\";}s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:2:\"eo\";a:10:{s:4:\"code\";s:2:\"eo\";s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanta\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eo_UY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eo\";s:12:\"display_name\";s:9:\"Esperanto\";}s:2:\"et\";a:10:{s:4:\"code\";s:2:\"et\";s:2:\"id\";s:2:\"15\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"et\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"et\";s:12:\"display_name\";s:8:\"Estonian\";}s:2:\"fi\";a:10:{s:4:\"code\";s:2:\"fi\";s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"fi\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fi\";s:12:\"display_name\";s:7:\"Finnish\";}s:2:\"fr\";a:10:{s:4:\"code\";s:2:\"fr\";s:2:\"id\";s:1:\"4\";s:12:\"english_name\";s:6:\"French\";s:11:\"native_name\";s:9:\"Français\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fr_FR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fr\";s:12:\"display_name\";s:6:\"French\";}s:2:\"gl\";a:10:{s:4:\"code\";s:2:\"gl\";s:2:\"id\";s:2:\"63\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"gl_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"gl\";s:12:\"display_name\";s:8:\"Galician\";}s:2:\"de\";a:10:{s:4:\"code\";s:2:\"de\";s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"de_DE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"de\";s:12:\"display_name\";s:6:\"German\";}s:2:\"el\";a:10:{s:4:\"code\";s:2:\"el\";s:2:\"id\";s:2:\"13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικα\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"el\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"el\";s:12:\"display_name\";s:5:\"Greek\";}s:2:\"he\";a:10:{s:4:\"code\";s:2:\"he\";s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:10:\"עברית\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"he_IL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"he\";s:12:\"display_name\";s:6:\"Hebrew\";}s:2:\"hi\";a:10:{s:4:\"code\";s:2:\"hi\";s:2:\"id\";s:2:\"21\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hi_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hi\";s:12:\"display_name\";s:5:\"Hindi\";}s:2:\"hu\";a:10:{s:4:\"code\";s:2:\"hu\";s:2:\"id\";s:2:\"23\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hu_HU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hu\";s:12:\"display_name\";s:9:\"Hungarian\";}s:2:\"is\";a:10:{s:4:\"code\";s:2:\"is\";s:2:\"id\";s:2:\"26\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"is_IS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"is\";s:12:\"display_name\";s:9:\"Icelandic\";}s:2:\"id\";a:10:{s:4:\"code\";s:2:\"id\";s:2:\"id\";s:2:\"25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:9:\"Indonesia\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"id_ID\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"id\";s:12:\"display_name\";s:10:\"Indonesian\";}s:2:\"ga\";a:10:{s:4:\"code\";s:2:\"ga\";s:2:\"id\";s:2:\"19\";s:12:\"english_name\";s:5:\"Irish\";s:11:\"native_name\";s:7:\"Gaeilge\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ga_IE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ga\";s:12:\"display_name\";s:5:\"Irish\";}s:2:\"it\";a:10:{s:4:\"code\";s:2:\"it\";s:2:\"id\";s:2:\"27\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"it_IT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"it\";s:12:\"display_name\";s:7:\"Italian\";}s:2:\"ja\";a:10:{s:4:\"code\";s:2:\"ja\";s:2:\"id\";s:2:\"28\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ja\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ja\";s:12:\"display_name\";s:8:\"Japanese\";}s:2:\"ko\";a:10:{s:4:\"code\";s:2:\"ko\";s:2:\"id\";s:2:\"29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ko_KR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ko\";s:12:\"display_name\";s:6:\"Korean\";}s:2:\"ku\";a:10:{s:4:\"code\";s:2:\"ku\";s:2:\"id\";s:2:\"30\";s:12:\"english_name\";s:7:\"Kurdish\";s:11:\"native_name\";s:7:\"Kurdish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:3:\"ckb\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ku\";s:12:\"display_name\";s:7:\"Kurdish\";}s:2:\"lv\";a:10:{s:4:\"code\";s:2:\"lv\";s:2:\"id\";s:2:\"31\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:9:\"Latviešu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lv_LV\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lv\";s:12:\"display_name\";s:7:\"Latvian\";}s:2:\"lt\";a:10:{s:4:\"code\";s:2:\"lt\";s:2:\"id\";s:2:\"32\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:8:\"Lietuvos\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lt_LT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lt\";s:12:\"display_name\";s:10:\"Lithuanian\";}s:2:\"mk\";a:10:{s:4:\"code\";s:2:\"mk\";s:2:\"id\";s:2:\"33\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:20:\"македонски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mk_MK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mk\";s:12:\"display_name\";s:10:\"Macedonian\";}s:2:\"ms\";a:10:{s:4:\"code\";s:2:\"ms\";s:2:\"id\";s:2:\"62\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:6:\"Melayu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ms_MY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ms\";s:12:\"display_name\";s:5:\"Malay\";}s:2:\"mt\";a:10:{s:4:\"code\";s:2:\"mt\";s:2:\"id\";s:2:\"34\";s:12:\"english_name\";s:7:\"Maltese\";s:11:\"native_name\";s:5:\"Malti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mt_MT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mt\";s:12:\"display_name\";s:7:\"Maltese\";}s:2:\"mn\";a:10:{s:4:\"code\";s:2:\"mn\";s:2:\"id\";s:2:\"35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:9:\"Mongolian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mn_MN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mn\";s:12:\"display_name\";s:9:\"Mongolian\";}s:2:\"ne\";a:10:{s:4:\"code\";s:2:\"ne\";s:2:\"id\";s:2:\"36\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:6:\"Nepali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ne\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ne\";s:12:\"display_name\";s:6:\"Nepali\";}s:2:\"no\";a:10:{s:4:\"code\";s:2:\"no\";s:2:\"id\";s:2:\"38\";s:12:\"english_name\";s:17:\"Norwegian Bokmål\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nb_NO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"no\";s:12:\"display_name\";s:17:\"Norwegian Bokmål\";}s:2:\"fa\";a:10:{s:4:\"code\";s:2:\"fa\";s:2:\"id\";s:2:\"17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fa_IR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fa\";s:12:\"display_name\";s:7:\"Persian\";}s:2:\"pl\";a:10:{s:4:\"code\";s:2:\"pl\";s:2:\"id\";s:2:\"40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"polski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pl_PL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pl\";s:12:\"display_name\";s:6:\"Polish\";}s:5:\"pt-br\";a:10:{s:4:\"code\";s:5:\"pt-br\";s:2:\"id\";s:2:\"42\";s:12:\"english_name\";s:18:\"Portuguese, Brazil\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_BR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-br\";s:12:\"display_name\";s:19:\"Portuguese (Brazil)\";}s:5:\"pt-pt\";a:10:{s:4:\"code\";s:5:\"pt-pt\";s:2:\"id\";s:2:\"41\";s:12:\"english_name\";s:20:\"Portuguese, Portugal\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_PT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-pt\";s:12:\"display_name\";s:21:\"Portuguese (Portugal)\";}s:2:\"pa\";a:10:{s:4:\"code\";s:2:\"pa\";s:2:\"id\";s:2:\"39\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:7:\"Punjabi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pa\";s:12:\"display_name\";s:7:\"Punjabi\";}s:2:\"qu\";a:10:{s:4:\"code\";s:2:\"qu\";s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"Quechua\";s:11:\"native_name\";s:7:\"Quechua\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:6:\"quz_PE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"qu\";s:12:\"display_name\";s:7:\"Quechua\";}s:2:\"ro\";a:10:{s:4:\"code\";s:2:\"ro\";s:2:\"id\";s:2:\"44\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ro_RO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ro\";s:12:\"display_name\";s:8:\"Romanian\";}s:2:\"ru\";a:10:{s:4:\"code\";s:2:\"ru\";s:2:\"id\";s:2:\"45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ru_RU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ru\";s:12:\"display_name\";s:7:\"Russian\";}s:2:\"sr\";a:10:{s:4:\"code\";s:2:\"sr\";s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:12:\"српски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sr_RS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sr\";s:12:\"display_name\";s:7:\"Serbian\";}s:2:\"sk\";a:10:{s:4:\"code\";s:2:\"sk\";s:2:\"id\";s:2:\"10\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sk_SK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sk\";s:12:\"display_name\";s:6:\"Slovak\";}s:2:\"sl\";a:10:{s:4:\"code\";s:2:\"sl\";s:2:\"id\";s:2:\"46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sl_SI\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sl\";s:12:\"display_name\";s:9:\"Slovenian\";}s:2:\"so\";a:10:{s:4:\"code\";s:2:\"so\";s:2:\"id\";s:2:\"47\";s:12:\"english_name\";s:6:\"Somali\";s:11:\"native_name\";s:6:\"Somali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"so_SO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"so\";s:12:\"display_name\";s:6:\"Somali\";}s:2:\"es\";a:10:{s:4:\"code\";s:2:\"es\";s:2:\"id\";s:1:\"2\";s:12:\"english_name\";s:7:\"Spanish\";s:11:\"native_name\";s:8:\"Español\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"es_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"es\";s:12:\"display_name\";s:7:\"Spanish\";}s:2:\"sv\";a:10:{s:4:\"code\";s:2:\"sv\";s:2:\"id\";s:2:\"50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sv_SE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sv\";s:12:\"display_name\";s:7:\"Swedish\";}s:2:\"ta\";a:10:{s:4:\"code\";s:2:\"ta\";s:2:\"id\";s:2:\"51\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:5:\"Tamil\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ta_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ta\";s:12:\"display_name\";s:5:\"Tamil\";}s:2:\"th\";a:10:{s:4:\"code\";s:2:\"th\";s:2:\"id\";s:2:\"52\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"th\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"th\";s:12:\"display_name\";s:4:\"Thai\";}s:2:\"tr\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:7:\"Turkish\";}s:2:\"uk\";a:10:{s:4:\"code\";s:2:\"uk\";s:2:\"id\";s:2:\"54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:9:\"Ukrainian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"uk\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uk\";s:12:\"display_name\";s:9:\"Ukrainian\";}s:2:\"ur\";a:10:{s:4:\"code\";s:2:\"ur\";s:2:\"id\";s:2:\"55\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:9:\"اردو \";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ur\";s:12:\"display_name\";s:4:\"Urdu\";}s:2:\"uz\";a:10:{s:4:\"code\";s:2:\"uz\";s:2:\"id\";s:2:\"56\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:5:\"Uzbek\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uz\";s:12:\"display_name\";s:5:\"Uzbek\";}s:2:\"vi\";a:10:{s:4:\"code\";s:2:\"vi\";s:2:\"id\";s:2:\"57\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"vi_VN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"vi\";s:12:\"display_name\";s:10:\"Vietnamese\";}s:2:\"cy\";a:10:{s:4:\"code\";s:2:\"cy\";s:2:\"id\";s:2:\"11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cy_GB\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cy\";s:12:\"display_name\";s:5:\"Welsh\";}s:2:\"yi\";a:10:{s:4:\"code\";s:2:\"yi\";s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:7:\"Yiddish\";s:11:\"native_name\";s:7:\"Yiddish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"yi\";s:12:\"display_name\";s:7:\"Yiddish\";}s:2:\"zu\";a:10:{s:4:\"code\";s:2:\"zu\";s:2:\"id\";s:2:\"60\";s:12:\"english_name\";s:4:\"Zulu\";s:11:\"native_name\";s:4:\"Zulu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"zu\";s:12:\"display_name\";s:4:\"Zulu\";}}s:29:\"all_language_en__display_name\";a:64:{s:2:\"sq\";a:10:{s:4:\"code\";s:2:\"sq\";s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:8:\"Albanian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sq_AL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sq\";s:12:\"display_name\";s:8:\"Albanian\";}s:2:\"ar\";a:10:{s:4:\"code\";s:2:\"ar\";s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ar\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ar\";s:12:\"display_name\";s:6:\"Arabic\";}s:2:\"hy\";a:10:{s:4:\"code\";s:2:\"hy\";s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hy_AM\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hy\";s:12:\"display_name\";s:8:\"Armenian\";}s:2:\"eu\";a:10:{s:4:\"code\";s:2:\"eu\";s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eu_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eu\";s:12:\"display_name\";s:6:\"Basque\";}s:2:\"bn\";a:10:{s:4:\"code\";s:2:\"bn\";s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bn_BD\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bn\";s:12:\"display_name\";s:7:\"Bengali\";}s:2:\"bs\";a:10:{s:4:\"code\";s:2:\"bs\";s:2:\"id\";s:1:\"6\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:7:\"Bosnian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bs_BA\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bs\";s:12:\"display_name\";s:7:\"Bosnian\";}s:2:\"bg\";a:10:{s:4:\"code\";s:2:\"bg\";s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bg_BG\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bg\";s:12:\"display_name\";s:9:\"Bulgarian\";}s:2:\"ca\";a:10:{s:4:\"code\";s:2:\"ca\";s:2:\"id\";s:1:\"8\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ca\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ca\";s:12:\"display_name\";s:7:\"Catalan\";}s:7:\"zh-hans\";a:10:{s:4:\"code\";s:7:\"zh-hans\";s:2:\"id\";s:2:\"59\";s:12:\"english_name\";s:20:\"Chinese (Simplified)\";s:11:\"native_name\";s:12:\"简体中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_CN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hans\";s:12:\"display_name\";s:20:\"Chinese (Simplified)\";}s:7:\"zh-hant\";a:10:{s:4:\"code\";s:7:\"zh-hant\";s:2:\"id\";s:2:\"61\";s:12:\"english_name\";s:21:\"Chinese (Traditional)\";s:11:\"native_name\";s:12:\"繁體中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_TW\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hant\";s:12:\"display_name\";s:21:\"Chinese (Traditional)\";}s:2:\"hr\";a:10:{s:4:\"code\";s:2:\"hr\";s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"hr\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hr\";s:12:\"display_name\";s:8:\"Croatian\";}s:2:\"cs\";a:10:{s:4:\"code\";s:2:\"cs\";s:2:\"id\";s:1:\"9\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cs_CZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cs\";s:12:\"display_name\";s:5:\"Czech\";}s:2:\"da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:2:\"nl\";a:10:{s:4:\"code\";s:2:\"nl\";s:2:\"id\";s:2:\"37\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nl_NL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"nl\";s:12:\"display_name\";s:5:\"Dutch\";}s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:2:\"eo\";a:10:{s:4:\"code\";s:2:\"eo\";s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanta\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eo_UY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eo\";s:12:\"display_name\";s:9:\"Esperanto\";}s:2:\"et\";a:10:{s:4:\"code\";s:2:\"et\";s:2:\"id\";s:2:\"15\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"et\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"et\";s:12:\"display_name\";s:8:\"Estonian\";}s:2:\"fi\";a:10:{s:4:\"code\";s:2:\"fi\";s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"fi\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fi\";s:12:\"display_name\";s:7:\"Finnish\";}s:2:\"fr\";a:10:{s:4:\"code\";s:2:\"fr\";s:2:\"id\";s:1:\"4\";s:12:\"english_name\";s:6:\"French\";s:11:\"native_name\";s:9:\"Français\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fr_FR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fr\";s:12:\"display_name\";s:6:\"French\";}s:2:\"gl\";a:10:{s:4:\"code\";s:2:\"gl\";s:2:\"id\";s:2:\"63\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"gl_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"gl\";s:12:\"display_name\";s:8:\"Galician\";}s:2:\"de\";a:10:{s:4:\"code\";s:2:\"de\";s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"de_DE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"de\";s:12:\"display_name\";s:6:\"German\";}s:2:\"el\";a:10:{s:4:\"code\";s:2:\"el\";s:2:\"id\";s:2:\"13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικα\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"el\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"el\";s:12:\"display_name\";s:5:\"Greek\";}s:2:\"he\";a:10:{s:4:\"code\";s:2:\"he\";s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:10:\"עברית\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"he_IL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"he\";s:12:\"display_name\";s:6:\"Hebrew\";}s:2:\"hi\";a:10:{s:4:\"code\";s:2:\"hi\";s:2:\"id\";s:2:\"21\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hi_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hi\";s:12:\"display_name\";s:5:\"Hindi\";}s:2:\"hu\";a:10:{s:4:\"code\";s:2:\"hu\";s:2:\"id\";s:2:\"23\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hu_HU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hu\";s:12:\"display_name\";s:9:\"Hungarian\";}s:2:\"is\";a:10:{s:4:\"code\";s:2:\"is\";s:2:\"id\";s:2:\"26\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"is_IS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"is\";s:12:\"display_name\";s:9:\"Icelandic\";}s:2:\"id\";a:10:{s:4:\"code\";s:2:\"id\";s:2:\"id\";s:2:\"25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:9:\"Indonesia\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"id_ID\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"id\";s:12:\"display_name\";s:10:\"Indonesian\";}s:2:\"ga\";a:10:{s:4:\"code\";s:2:\"ga\";s:2:\"id\";s:2:\"19\";s:12:\"english_name\";s:5:\"Irish\";s:11:\"native_name\";s:7:\"Gaeilge\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ga_IE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ga\";s:12:\"display_name\";s:5:\"Irish\";}s:2:\"it\";a:10:{s:4:\"code\";s:2:\"it\";s:2:\"id\";s:2:\"27\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"it_IT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"it\";s:12:\"display_name\";s:7:\"Italian\";}s:2:\"ja\";a:10:{s:4:\"code\";s:2:\"ja\";s:2:\"id\";s:2:\"28\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ja\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ja\";s:12:\"display_name\";s:8:\"Japanese\";}s:2:\"ko\";a:10:{s:4:\"code\";s:2:\"ko\";s:2:\"id\";s:2:\"29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ko_KR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ko\";s:12:\"display_name\";s:6:\"Korean\";}s:2:\"ku\";a:10:{s:4:\"code\";s:2:\"ku\";s:2:\"id\";s:2:\"30\";s:12:\"english_name\";s:7:\"Kurdish\";s:11:\"native_name\";s:7:\"Kurdish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:3:\"ckb\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ku\";s:12:\"display_name\";s:7:\"Kurdish\";}s:2:\"lv\";a:10:{s:4:\"code\";s:2:\"lv\";s:2:\"id\";s:2:\"31\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:9:\"Latviešu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lv_LV\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lv\";s:12:\"display_name\";s:7:\"Latvian\";}s:2:\"lt\";a:10:{s:4:\"code\";s:2:\"lt\";s:2:\"id\";s:2:\"32\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:8:\"Lietuvos\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lt_LT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lt\";s:12:\"display_name\";s:10:\"Lithuanian\";}s:2:\"mk\";a:10:{s:4:\"code\";s:2:\"mk\";s:2:\"id\";s:2:\"33\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:20:\"македонски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mk_MK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mk\";s:12:\"display_name\";s:10:\"Macedonian\";}s:2:\"ms\";a:10:{s:4:\"code\";s:2:\"ms\";s:2:\"id\";s:2:\"62\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:6:\"Melayu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ms_MY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ms\";s:12:\"display_name\";s:5:\"Malay\";}s:2:\"mt\";a:10:{s:4:\"code\";s:2:\"mt\";s:2:\"id\";s:2:\"34\";s:12:\"english_name\";s:7:\"Maltese\";s:11:\"native_name\";s:5:\"Malti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mt_MT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mt\";s:12:\"display_name\";s:7:\"Maltese\";}s:2:\"mn\";a:10:{s:4:\"code\";s:2:\"mn\";s:2:\"id\";s:2:\"35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:9:\"Mongolian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mn_MN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mn\";s:12:\"display_name\";s:9:\"Mongolian\";}s:2:\"ne\";a:10:{s:4:\"code\";s:2:\"ne\";s:2:\"id\";s:2:\"36\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:6:\"Nepali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ne\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ne\";s:12:\"display_name\";s:6:\"Nepali\";}s:2:\"no\";a:10:{s:4:\"code\";s:2:\"no\";s:2:\"id\";s:2:\"38\";s:12:\"english_name\";s:17:\"Norwegian Bokmål\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nb_NO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"no\";s:12:\"display_name\";s:17:\"Norwegian Bokmål\";}s:2:\"fa\";a:10:{s:4:\"code\";s:2:\"fa\";s:2:\"id\";s:2:\"17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fa_IR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fa\";s:12:\"display_name\";s:7:\"Persian\";}s:2:\"pl\";a:10:{s:4:\"code\";s:2:\"pl\";s:2:\"id\";s:2:\"40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"polski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pl_PL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pl\";s:12:\"display_name\";s:6:\"Polish\";}s:5:\"pt-br\";a:10:{s:4:\"code\";s:5:\"pt-br\";s:2:\"id\";s:2:\"42\";s:12:\"english_name\";s:18:\"Portuguese, Brazil\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_BR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-br\";s:12:\"display_name\";s:19:\"Portuguese (Brazil)\";}s:5:\"pt-pt\";a:10:{s:4:\"code\";s:5:\"pt-pt\";s:2:\"id\";s:2:\"41\";s:12:\"english_name\";s:20:\"Portuguese, Portugal\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_PT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-pt\";s:12:\"display_name\";s:21:\"Portuguese (Portugal)\";}s:2:\"pa\";a:10:{s:4:\"code\";s:2:\"pa\";s:2:\"id\";s:2:\"39\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:7:\"Punjabi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pa\";s:12:\"display_name\";s:7:\"Punjabi\";}s:2:\"qu\";a:10:{s:4:\"code\";s:2:\"qu\";s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"Quechua\";s:11:\"native_name\";s:7:\"Quechua\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:6:\"quz_PE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"qu\";s:12:\"display_name\";s:7:\"Quechua\";}s:2:\"ro\";a:10:{s:4:\"code\";s:2:\"ro\";s:2:\"id\";s:2:\"44\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ro_RO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ro\";s:12:\"display_name\";s:8:\"Romanian\";}s:2:\"ru\";a:10:{s:4:\"code\";s:2:\"ru\";s:2:\"id\";s:2:\"45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ru_RU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ru\";s:12:\"display_name\";s:7:\"Russian\";}s:2:\"sr\";a:10:{s:4:\"code\";s:2:\"sr\";s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:12:\"српски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sr_RS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sr\";s:12:\"display_name\";s:7:\"Serbian\";}s:2:\"sk\";a:10:{s:4:\"code\";s:2:\"sk\";s:2:\"id\";s:2:\"10\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sk_SK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sk\";s:12:\"display_name\";s:6:\"Slovak\";}s:2:\"sl\";a:10:{s:4:\"code\";s:2:\"sl\";s:2:\"id\";s:2:\"46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sl_SI\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sl\";s:12:\"display_name\";s:9:\"Slovenian\";}s:2:\"so\";a:10:{s:4:\"code\";s:2:\"so\";s:2:\"id\";s:2:\"47\";s:12:\"english_name\";s:6:\"Somali\";s:11:\"native_name\";s:6:\"Somali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"so_SO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"so\";s:12:\"display_name\";s:6:\"Somali\";}s:2:\"es\";a:10:{s:4:\"code\";s:2:\"es\";s:2:\"id\";s:1:\"2\";s:12:\"english_name\";s:7:\"Spanish\";s:11:\"native_name\";s:8:\"Español\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"es_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"es\";s:12:\"display_name\";s:7:\"Spanish\";}s:2:\"sv\";a:10:{s:4:\"code\";s:2:\"sv\";s:2:\"id\";s:2:\"50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sv_SE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sv\";s:12:\"display_name\";s:7:\"Swedish\";}s:2:\"ta\";a:10:{s:4:\"code\";s:2:\"ta\";s:2:\"id\";s:2:\"51\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:5:\"Tamil\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ta_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ta\";s:12:\"display_name\";s:5:\"Tamil\";}s:2:\"th\";a:10:{s:4:\"code\";s:2:\"th\";s:2:\"id\";s:2:\"52\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"th\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"th\";s:12:\"display_name\";s:4:\"Thai\";}s:2:\"tr\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:7:\"Turkish\";}s:2:\"uk\";a:10:{s:4:\"code\";s:2:\"uk\";s:2:\"id\";s:2:\"54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:9:\"Ukrainian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"uk\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uk\";s:12:\"display_name\";s:9:\"Ukrainian\";}s:2:\"ur\";a:10:{s:4:\"code\";s:2:\"ur\";s:2:\"id\";s:2:\"55\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:9:\"اردو \";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ur\";s:12:\"display_name\";s:4:\"Urdu\";}s:2:\"uz\";a:10:{s:4:\"code\";s:2:\"uz\";s:2:\"id\";s:2:\"56\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:5:\"Uzbek\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uz\";s:12:\"display_name\";s:5:\"Uzbek\";}s:2:\"vi\";a:10:{s:4:\"code\";s:2:\"vi\";s:2:\"id\";s:2:\"57\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"vi_VN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"vi\";s:12:\"display_name\";s:10:\"Vietnamese\";}s:2:\"cy\";a:10:{s:4:\"code\";s:2:\"cy\";s:2:\"id\";s:2:\"11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cy_GB\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cy\";s:12:\"display_name\";s:5:\"Welsh\";}s:2:\"yi\";a:10:{s:4:\"code\";s:2:\"yi\";s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:7:\"Yiddish\";s:11:\"native_name\";s:7:\"Yiddish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"yi\";s:12:\"display_name\";s:7:\"Yiddish\";}s:2:\"zu\";a:10:{s:4:\"code\";s:2:\"zu\";s:2:\"id\";s:2:\"60\";s:12:\"english_name\";s:4:\"Zulu\";s:11:\"native_name\";s:4:\"Zulu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"zu\";s:12:\"display_name\";s:4:\"Zulu\";}}}}', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(134, 'wpml_dependencies:needs_validation', '', 'yes'),
(135, 'wpml_dependencies:valid_plugins', 'a:1:{i:0;s:26:\"sitepress-multilingual-cms\";}', 'yes'),
(136, 'wpml_dependencies:invalid_plugins', 'a:0:{}', 'yes'),
(137, 'wpml_config_index', 'O:8:\"stdClass\":2:{s:7:\"plugins\";a:79:{i:0;O:8:\"stdClass\":5:{s:4:\"name\";s:11:\"Popup Maker\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/popup-maker/wpml-config.xml\";s:7:\"updated\";i:1620036189;s:4:\"hash\";s:32:\"49bdd09f6b77d62749a7a052f5163e57\";}i:1;O:8:\"stdClass\":5:{s:4:\"name\";s:33:\"10bit WooCommerce Gateway Yaadpay\";s:14:\"override_local\";b:1;s:4:\"path\";s:61:\"wpml-config/10bit-woocommerce-gateway-yaadpay/wpml-config.xml\";s:7:\"updated\";i:1464939780;s:4:\"hash\";s:32:\"ebdce80f3b6bfa13112b1d4c6a31b560\";}i:2;O:8:\"stdClass\":5:{s:4:\"name\";s:18:\"Advanced Gutenberg\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/advanced-gutenberg/wpml-config.xml\";s:7:\"updated\";i:1620206304;s:4:\"hash\";s:32:\"965305688fa93fe758789b1be81c1f9f\";}i:3;O:8:\"stdClass\":5:{s:4:\"name\";s:19:\"PublishPress Blocks\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/advanced-gutenberg/wpml-config.xml\";s:7:\"updated\";i:1620206304;s:4:\"hash\";s:32:\"965305688fa93fe758789b1be81c1f9f\";}i:4;O:8:\"stdClass\":5:{s:4:\"name\";s:16:\"Ajax Search Lite\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/ajax-search-lite/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"79dc60103bbc2eaaf6ac2ff25ca8dfa7\";}i:5;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Atomic Blocks\";s:14:\"override_local\";b:1;s:4:\"path\";s:41:\"wpml-config/atomic-blocks/wpml-config.xml\";s:7:\"updated\";i:1585156226;s:4:\"hash\";s:32:\"8d93d53d0fa037f291aaf9aa5980c287\";}i:6;O:8:\"stdClass\":5:{s:4:\"name\";s:36:\"Beaver Builder Plugin (Lite Version)\";s:14:\"override_local\";b:1;s:4:\"path\";s:42:\"wpml-config/beaver-builder/wpml-config.xml\";s:7:\"updated\";i:1605029057;s:4:\"hash\";s:32:\"63175e4d72e6069035ea9c118b6d7386\";}i:7;O:8:\"stdClass\":5:{s:4:\"name\";s:35:\"Beaver Builder Plugin (Pro Version)\";s:14:\"override_local\";b:1;s:4:\"path\";s:42:\"wpml-config/beaver-builder/wpml-config.xml\";s:7:\"updated\";i:1605029057;s:4:\"hash\";s:32:\"63175e4d72e6069035ea9c118b6d7386\";}i:8;O:8:\"stdClass\":5:{s:4:\"name\";s:8:\"Book Now\";s:14:\"override_local\";b:0;s:4:\"path\";s:36:\"wpml-config/book-now/wpml-config.xml\";s:7:\"updated\";i:1505319840;s:4:\"hash\";s:32:\"d123c0bb22d447095c3c443cb41c273a\";}i:9;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Click to Chat\";s:14:\"override_local\";b:1;s:4:\"path\";s:54:\"wpml-config/click-to-chat-for-whatsapp/wpml-config.xml\";s:7:\"updated\";i:1595252694;s:4:\"hash\";s:32:\"ddd29301ed98494707ce5145d2f25ecd\";}i:10;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"Advanced Comment Form\";s:14:\"override_local\";b:1;s:4:\"path\";s:40:\"wpml-config/comment-form/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"a84c0e28e4c97dec1a3053c316c27892\";}i:11;O:8:\"stdClass\":5:{s:4:\"name\";s:11:\"Cornerstone\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/cornerstone/wpml-config.xml\";s:7:\"updated\";i:1620206304;s:4:\"hash\";s:32:\"ba675e6cde0ed800e416cb21a28ffd9e\";}i:12;O:8:\"stdClass\":5:{s:4:\"name\";s:19:\"Custom Post Type UI\";s:14:\"override_local\";b:1;s:4:\"path\";s:47:\"wpml-config/custom-post-type-ui/wpml-config.xml\";s:7:\"updated\";i:1604075857;s:4:\"hash\";s:32:\"c35b9664bea4b9d9b83b5748e14be9b0\";}i:13;O:8:\"stdClass\":5:{s:4:\"name\";s:12:\"Divi Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:40:\"wpml-config/divi-builder/wpml-config.xml\";s:7:\"updated\";i:1618826946;s:4:\"hash\";s:32:\"6c2c50dafeb044c0c6dc19f22a6ef9fa\";}i:14;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Elementor\";s:14:\"override_local\";b:1;s:4:\"path\";s:37:\"wpml-config/elementor/wpml-config.xml\";s:7:\"updated\";i:1619521680;s:4:\"hash\";s:32:\"7be23ac73145635fdbbf962edd76995c\";}i:15;O:8:\"stdClass\":5:{s:4:\"name\";s:18:\"Event Tickets Plus\";s:14:\"override_local\";b:0;s:4:\"path\";s:46:\"wpml-config/event-tickets-plus/wpml-config.xml\";s:7:\"updated\";i:1477310580;s:4:\"hash\";s:32:\"f333802d6c6c9836466d3ff52cfe2bd7\";}i:16;O:8:\"stdClass\":5:{s:4:\"name\";s:31:\"The Events Calendar: Filter Bar\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/events-filterbar/wpml-config.xml\";s:7:\"updated\";i:1529671740;s:4:\"hash\";s:32:\"787231e7b7cdb54ca447512234be0768\";}i:17;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Exit Popup\";s:14:\"override_local\";b:0;s:4:\"path\";s:38:\"wpml-config/exit-popup/wpml-config.xml\";s:7:\"updated\";i:1532441340;s:4:\"hash\";s:32:\"9759f24db8621dfa772d7222c9c336dd\";}i:18;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Forminator\";s:14:\"override_local\";b:1;s:4:\"path\";s:38:\"wpml-config/forminator/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"ae0a6b1f1bc9fc80ada4833f9ee8917c\";}i:19;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"Google Analytics Opt-Out\";s:14:\"override_local\";b:1;s:4:\"path\";s:52:\"wpml-config/google-analytics-opt-out/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"823965222ce323c88eadbcf95dcde0ff\";}i:20;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"WPBakery Page Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/js_composer/wpml-config.xml\";s:7:\"updated\";i:1591616888;s:4:\"hash\";s:32:\"8ae0f8b6e9e2a4f4320e5fb325adf900\";}i:21;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"WPBakery Visual Composer\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/js_composer/wpml-config.xml\";s:7:\"updated\";i:1591616888;s:4:\"hash\";s:32:\"8ae0f8b6e9e2a4f4320e5fb325adf900\";}i:22;O:8:\"stdClass\":5:{s:4:\"name\";s:26:\"The7 WPBakery Page Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:47:\"wpml-config/js_composer-dt-the7/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"caf05daa7509c1127194c88dee427879\";}i:23;O:8:\"stdClass\":5:{s:4:\"name\";s:47:\"Kadence Blocks - Gutenberg Page Builder Toolkit\";s:14:\"override_local\";b:1;s:4:\"path\";s:42:\"wpml-config/kadence-blocks/wpml-config.xml\";s:7:\"updated\";i:1589279268;s:4:\"hash\";s:32:\"e3fa847064d1728f8cc936efdbb8077d\";}i:24;O:8:\"stdClass\":5:{s:4:\"name\";s:12:\"KingComposer\";s:14:\"override_local\";b:1;s:4:\"path\";s:40:\"wpml-config/kingcomposer/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"cadb27cc7ba0e61d3fd2acaf27fef4df\";}i:25;O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"MailChimp for WordPress\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/mailchimp-for-wp/wpml-config.xml\";s:7:\"updated\";i:1509614640;s:4:\"hash\";s:32:\"c4f8573312cdf0f71d9329ae82d4ec49\";}i:26;O:8:\"stdClass\":5:{s:4:\"name\";s:12:\"MasterSlider\";s:14:\"override_local\";b:1;s:4:\"path\";s:41:\"wpml-config/master-slider/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"2b5b8d5c1d934ee19a547b66d6c76b69\";}i:27;O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Members\";s:14:\"override_local\";b:0;s:4:\"path\";s:35:\"wpml-config/members/wpml-config.xml\";s:7:\"updated\";i:1497367620;s:4:\"hash\";s:32:\"37e638f5a56f59208150c3649c291e41\";}i:28;O:8:\"stdClass\":5:{s:4:\"name\";s:46:\"Multibanco (IfthenPay gateway) for WooCommerce\";s:14:\"override_local\";b:0;s:4:\"path\";s:72:\"wpml-config/multibanco-ifthenpay-gateway-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1441014780;s:4:\"hash\";s:32:\"3cddef77fd163e090472f995aa2388d4\";}i:29;O:8:\"stdClass\":5:{s:4:\"name\";s:11:\"Ninja Forms\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/ninja-forms/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"7b3321902299b49238e59d0741ce1f8d\";}i:30;O:8:\"stdClass\":5:{s:4:\"name\";s:25:\"NW ADCart for WooCommerce\";s:14:\"override_local\";b:1;s:4:\"path\";s:53:\"wpml-config/nw-adcart-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1409734260;s:4:\"hash\";s:32:\"91d62df0659fc7b561a3932a7a52de6a\";}i:31;O:8:\"stdClass\":5:{s:4:\"name\";s:14:\"Oxygen Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/oxygen/wpml-config.xml\";s:7:\"updated\";i:1619521680;s:4:\"hash\";s:32:\"97caa8ae95747f8e3c27e065362b0976\";}i:32;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"Paid Memberships Pro\";s:14:\"override_local\";b:1;s:4:\"path\";s:48:\"wpml-config/paid-memberships-pro/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"a26838992708887d6825bd1fbdceca59\";}i:33;O:8:\"stdClass\":5:{s:4:\"name\";s:22:\"PayPal for WooCommerce\";s:14:\"override_local\";b:1;s:4:\"path\";s:50:\"wpml-config/paypal-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1504696980;s:4:\"hash\";s:32:\"8d98b39c86e95094e6b7727fda7a6f00\";}i:34;O:8:\"stdClass\":5:{s:4:\"name\";s:35:\"Product Enquiry Pro for WooCommerce\";s:14:\"override_local\";b:1;s:4:\"path\";s:63:\"wpml-config/product-enquiry-pro-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1409734500;s:4:\"hash\";s:32:\"305232f06370d52a29c346d6b711f50a\";}i:35;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"Rezgo Online Booking\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/rezgo/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"6f3433a4c5eafa13eaf125eea7d84239\";}i:36;O:8:\"stdClass\":5:{s:4:\"name\";s:15:\"Search & Filter\";s:14:\"override_local\";b:1;s:4:\"path\";s:41:\"wpml-config/search-filter/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"104b64d62b408a4ae7c5da7ff0acd0b2\";}i:37;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Sensei LMS\";s:14:\"override_local\";b:0;s:4:\"path\";s:34:\"wpml-config/sensei/wpml-config.xml\";s:7:\"updated\";i:1620379210;s:4:\"hash\";s:32:\"383f9e0ed491f2e4b752ccd88e9a8e7c\";}i:38;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Sensei\";s:14:\"override_local\";b:0;s:4:\"path\";s:34:\"wpml-config/sensei/wpml-config.xml\";s:7:\"updated\";i:1620379210;s:4:\"hash\";s:32:\"383f9e0ed491f2e4b752ccd88e9a8e7c\";}i:39;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Rank Math SEO\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/seo-by-rank-math/wpml-config.xml\";s:7:\"updated\";i:1595411877;s:4:\"hash\";s:32:\"0afae267f73a47afd09ae1d322c41735\";}i:40;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"WPML Multilingual CMS\";s:14:\"override_local\";b:1;s:4:\"path\";s:54:\"wpml-config/sitepress-multilingual-cms/wpml-config.xml\";s:7:\"updated\";i:1611515848;s:4:\"hash\";s:32:\"262f1fffdf41236fd99cfab04ed45b26\";}i:41;O:8:\"stdClass\":5:{s:4:\"name\";s:28:\"Stackable - Gutenberg Blocks\";s:14:\"override_local\";b:1;s:4:\"path\";s:63:\"wpml-config/stackable-ultimate-gutenberg-blocks/wpml-config.xml\";s:7:\"updated\";i:1610535270;s:4:\"hash\";s:32:\"81a1302839deec3105eb9bebcedb4270\";}i:42;O:8:\"stdClass\":5:{s:4:\"name\";s:11:\"Subscriptio\";s:14:\"override_local\";b:0;s:4:\"path\";s:39:\"wpml-config/subscriptio/wpml-config.xml\";s:7:\"updated\";i:1519647600;s:4:\"hash\";s:32:\"a23128c1dde651ef63093336042948e5\";}i:43;O:8:\"stdClass\":5:{s:4:\"name\";s:19:\"The Events Calendar\";s:14:\"override_local\";b:1;s:4:\"path\";s:47:\"wpml-config/the-events-calendar/wpml-config.xml\";s:7:\"updated\";i:1597940433;s:4:\"hash\";s:32:\"9dc1b1aa9bdd03cb5f8057ebb4976651\";}i:44;O:8:\"stdClass\":5:{s:4:\"name\";s:29:\"Ultimate Addons for Gutenberg\";s:14:\"override_local\";b:1;s:4:\"path\";s:57:\"wpml-config/ultimate-addons-for-gutenberg/wpml-config.xml\";s:7:\"updated\";i:1611145301;s:4:\"hash\";s:32:\"af52385e3657708d91a1d28c046342a1\";}i:45;O:8:\"stdClass\":5:{s:4:\"name\";s:15:\"Ultimate Member\";s:14:\"override_local\";b:1;s:4:\"path\";s:43:\"wpml-config/ultimate-member/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"c80a46117b6be17e1099cb0640f8e722\";}i:46;O:8:\"stdClass\":5:{s:4:\"name\";s:37:\"Uncode Page Builder (Visual Composer)\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/uncode-js_composer/wpml-config.xml\";s:7:\"updated\";i:1580467972;s:4:\"hash\";s:32:\"3d429187f051bcc1910b6549c06e93d8\";}i:47;O:8:\"stdClass\":5:{s:4:\"name\";s:28:\"Uncode WPBakery Page Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/uncode-js_composer/wpml-config.xml\";s:7:\"updated\";i:1580467972;s:4:\"hash\";s:32:\"3d429187f051bcc1910b6549c06e93d8\";}i:48;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"Woocomerce Brands Pro\";s:14:\"override_local\";b:0;s:4:\"path\";s:37:\"wpml-config/woo-brand/wpml-config.xml\";s:7:\"updated\";i:1442243400;s:4:\"hash\";s:32:\"dc7eeb10cd6e0eb80b7960eb8b6058a4\";}i:49;O:8:\"stdClass\":5:{s:4:\"name\";s:39:\"WooCommerce Additional Variation Images\";s:14:\"override_local\";b:1;s:4:\"path\";s:67:\"wpml-config/woocommerce-additional-variation-images/wpml-config.xml\";s:7:\"updated\";i:1479214860;s:4:\"hash\";s:32:\"39b5f72684021b09b12b53b7ff9c7100\";}i:50;O:8:\"stdClass\":5:{s:4:\"name\";s:35:\"WooCommerce Advanced Product Labels\";s:14:\"override_local\";b:0;s:4:\"path\";s:63:\"wpml-config/woocommerce-advanced-product-labels/wpml-config.xml\";s:7:\"updated\";i:1441177080;s:4:\"hash\";s:32:\"4b29c29516a1a33b328d90ffc5c4aad7\";}i:51;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"WooCommerce Bookings\";s:14:\"override_local\";b:1;s:4:\"path\";s:48:\"wpml-config/woocommerce-bookings/wpml-config.xml\";s:7:\"updated\";i:1518696060;s:4:\"hash\";s:32:\"cf704fa60399163e82de88dfca25b644\";}i:52;O:8:\"stdClass\":5:{s:4:\"name\";s:38:\"WooCommerce Catalog Visibility Options\";s:14:\"override_local\";b:1;s:4:\"path\";s:66:\"wpml-config/woocommerce-catalog-visibility-options/wpml-config.xml\";s:7:\"updated\";i:1408625580;s:4:\"hash\";s:32:\"d10bd6388a88521e488f7e4ba295c94c\";}i:53;O:8:\"stdClass\":5:{s:4:\"name\";s:30:\"WooCommerce Composite Products\";s:14:\"override_local\";b:0;s:4:\"path\";s:58:\"wpml-config/woocommerce-composite-products/wpml-config.xml\";s:7:\"updated\";i:1491207900;s:4:\"hash\";s:32:\"a6c0ed6554be69f56779f64506ab96d1\";}i:54;O:8:\"stdClass\":5:{s:4:\"name\";s:30:\"WooCommerce Currency Converter\";s:14:\"override_local\";b:1;s:4:\"path\";s:58:\"wpml-config/woocommerce-currency-converter/wpml-config.xml\";s:7:\"updated\";i:1452009180;s:4:\"hash\";s:32:\"b2191d7affaf1efe74e6a3ca4b0494c6\";}i:55;O:8:\"stdClass\":5:{s:4:\"name\";s:32:\"WooCommerce DIBS FlexWin Gateway\";s:14:\"override_local\";b:1;s:4:\"path\";s:60:\"wpml-config/woocommerce-dibs-flexwin-gateway/wpml-config.xml\";s:7:\"updated\";i:1459514460;s:4:\"hash\";s:32:\"d9237f895f0f133c8e11f4753d96eeca\";}i:56;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"WooCommerce Embed Slides\";s:14:\"override_local\";b:1;s:4:\"path\";s:52:\"wpml-config/woocommerce-embed-slides/wpml-config.xml\";s:7:\"updated\";i:1499457300;s:4:\"hash\";s:32:\"243e3a54d920cc2ddf96f17f4ff38f2d\";}i:57;O:8:\"stdClass\":5:{s:4:\"name\";s:26:\"WooCommerce Stripe Gateway\";s:14:\"override_local\";b:1;s:4:\"path\";s:54:\"wpml-config/woocommerce-gateway-stripe/wpml-config.xml\";s:7:\"updated\";i:1409061480;s:4:\"hash\";s:32:\"4139e23bcdd0bb3e78cb079fa851ce85\";}i:58;O:8:\"stdClass\":5:{s:4:\"name\";s:29:\"WooCommerce Local Pickup Plus\";s:14:\"override_local\";b:1;s:4:\"path\";s:57:\"wpml-config/woocommerce-local-pickup-plus/wpml-config.xml\";s:7:\"updated\";i:1442582820;s:4:\"hash\";s:32:\"816774f477bfa1c481cdba021d33f705\";}i:59;O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"WooCommerce Memberships\";s:14:\"override_local\";b:1;s:4:\"path\";s:51:\"wpml-config/woocommerce-memberships/wpml-config.xml\";s:7:\"updated\";i:1585587094;s:4:\"hash\";s:32:\"b12275a5491bc1858f181f56158b7a91\";}i:60;O:8:\"stdClass\":5:{s:4:\"name\";s:25:\"WooCommerce Mix and Match\";s:14:\"override_local\";b:1;s:4:\"path\";s:62:\"wpml-config/woocommerce-mix-and-match-products/wpml-config.xml\";s:7:\"updated\";i:1578929211;s:4:\"hash\";s:32:\"82f7fa28a3b0a601056911af209995a2\";}i:61;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"WooCommerce Multilingual\";s:14:\"override_local\";b:1;s:4:\"path\";s:52:\"wpml-config/woocommerce-multilingual/wpml-config.xml\";s:7:\"updated\";i:1582106737;s:4:\"hash\";s:32:\"11b7488184353144fae7147f143b5150\";}i:62;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Name Your Price\";s:14:\"override_local\";b:1;s:4:\"path\";s:55:\"wpml-config/woocommerce-name-your-price/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"055de38e55802236ee636eec63bdde5e\";}i:63;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Paymill Gateway\";s:14:\"override_local\";b:1;s:4:\"path\";s:55:\"wpml-config/woocommerce-paymill-gateway/wpml-config.xml\";s:7:\"updated\";i:1408626540;s:4:\"hash\";s:32:\"46409842584ff8df43a2aa922ad1d388\";}i:64;O:8:\"stdClass\":5:{s:4:\"name\";s:40:\"WooCommerce PDF Invoices & Packing Slips\";s:14:\"override_local\";b:1;s:4:\"path\";s:66:\"wpml-config/woocommerce-pdf-invoices-packing-slips/wpml-config.xml\";s:7:\"updated\";i:1461579300;s:4:\"hash\";s:32:\"34ecf8066c5c9042a0bd60b5d40c4c55\";}i:65;O:8:\"stdClass\":5:{s:4:\"name\";s:17:\"WooCommerce Plivo\";s:14:\"override_local\";b:1;s:4:\"path\";s:45:\"wpml-config/woocommerce-plivo/wpml-config.xml\";s:7:\"updated\";i:1409734680;s:4:\"hash\";s:32:\"539d172825c4714d69b8a42ad1826c5d\";}i:66;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"WooCommerce PostePay\";s:14:\"override_local\";b:1;s:4:\"path\";s:48:\"wpml-config/woocommerce-postepay/wpml-config.xml\";s:7:\"updated\";i:1409063100;s:4:\"hash\";s:32:\"b08722979a25b15ba4a02a16fb555ccc\";}i:67;O:8:\"stdClass\":5:{s:4:\"name\";s:28:\"WooCommerce Price by Country\";s:14:\"override_local\";b:1;s:4:\"path\";s:56:\"wpml-config/woocommerce-price-by-country/wpml-config.xml\";s:7:\"updated\";i:1415282880;s:4:\"hash\";s:32:\"9b296d64ba8afee80cb1ff4fac80144b\";}i:68;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Product Add-ons\";s:14:\"override_local\";b:1;s:4:\"path\";s:55:\"wpml-config/woocommerce-product-add-ons/wpml-config.xml\";s:7:\"updated\";i:1476961740;s:4:\"hash\";s:32:\"69f94bed6e4b3546cc7be2fbd2bf392b\";}i:69;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Product Bundles\";s:14:\"override_local\";b:0;s:4:\"path\";s:55:\"wpml-config/woocommerce-product-bundles/wpml-config.xml\";s:7:\"updated\";i:1487080740;s:4:\"hash\";s:32:\"7cddba745169acd899b12f24e3580dcc\";}i:70;O:8:\"stdClass\":5:{s:4:\"name\";s:29:\"WooCommerce Product Gift Wrap\";s:14:\"override_local\";b:1;s:4:\"path\";s:57:\"wpml-config/woocommerce-product-gift-wrap/wpml-config.xml\";s:7:\"updated\";i:1429639980;s:4:\"hash\";s:32:\"dd3371d64d2ee01e6e42fd7e0bd134cf\";}i:71;O:8:\"stdClass\":5:{s:4:\"name\";s:38:\"Woocommerce Social Media Share Buttons\";s:14:\"override_local\";b:1;s:4:\"path\";s:66:\"wpml-config/woocommerce-social-media-share-buttons/wpml-config.xml\";s:7:\"updated\";i:1464934800;s:4:\"hash\";s:32:\"3130bbf2a35424d9ecd8d6c3255bf817\";}i:72;O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"WooCommerce Tab Manager\";s:14:\"override_local\";b:1;s:4:\"path\";s:51:\"wpml-config/woocommerce-tab-manager/wpml-config.xml\";s:7:\"updated\";i:1505158140;s:4:\"hash\";s:32:\"477be025d13abe1c1b89bb7666564ed6\";}i:73;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"WooCommerce Video Tab\";s:14:\"override_local\";b:1;s:4:\"path\";s:49:\"wpml-config/woocommerce-video-tab/wpml-config.xml\";s:7:\"updated\";i:1415284320;s:4:\"hash\";s:32:\"7f9769bc2769e07ae730f3b4cd307741\";}i:74;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Yoast SEO\";s:14:\"override_local\";b:1;s:4:\"path\";s:41:\"wpml-config/wordpress-seo/wpml-config.xml\";s:7:\"updated\";i:1592553706;s:4:\"hash\";s:32:\"207e931d1df921957c81fe2554bbf4e9\";}i:75;O:8:\"stdClass\":5:{s:4:\"name\";s:17:\"Yoast SEO Premium\";s:14:\"override_local\";b:1;s:4:\"path\";s:49:\"wpml-config/wordpress-seo-premium/wpml-config.xml\";s:7:\"updated\";i:1592553706;s:4:\"hash\";s:32:\"207e931d1df921957c81fe2554bbf4e9\";}i:76;O:8:\"stdClass\":5:{s:4:\"name\";s:14:\"WP Job Manager\";s:14:\"override_local\";b:0;s:4:\"path\";s:42:\"wpml-config/wp-job-manager/wpml-config.xml\";s:7:\"updated\";i:1499098260;s:4:\"hash\";s:32:\"36842c6b8a11a733ef00ef8d9bc410b9\";}i:77;O:8:\"stdClass\":5:{s:4:\"name\";s:16:\"WPML Test Config\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/wpml-test-config/wpml-config.xml\";s:7:\"updated\";i:1429103280;s:4:\"hash\";s:32:\"9c3bb313d5a4f028bebfa8fc8af990a3\";}i:78;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Yoast SEO\";s:14:\"override_local\";b:1;s:4:\"path\";s:37:\"wpml-config/yoast-seo/wpml-config.xml\";s:7:\"updated\";i:1530098880;s:4:\"hash\";s:32:\"4014a9b37ac42f0cc726390fb9088ebc\";}}s:6:\"themes\";a:25:{i:0;O:8:\"stdClass\":5:{s:4:\"name\";s:5:\"Astra\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/astra/wpml-config.xml\";s:7:\"updated\";i:1611238423;s:4:\"hash\";s:32:\"fcaa309ae11fe39ec0e9c99c34bc3efb\";}i:1;O:8:\"stdClass\":5:{s:4:\"name\";s:5:\"Avada\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/avada/wpml-config.xml\";s:7:\"updated\";i:1617612951;s:4:\"hash\";s:32:\"57f25f9087aafe2c8f171f8734107152\";}i:2;O:8:\"stdClass\":5:{s:4:\"name\";s:8:\"Brooklyn\";s:14:\"override_local\";b:1;s:4:\"path\";s:36:\"wpml-config/brooklyn/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"960edb3057ad96e2863221e82a4c69d2\";}i:3;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Canvas\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/canvas/wpml-config.xml\";s:7:\"updated\";i:1476729660;s:4:\"hash\";s:32:\"ea1da43b18f87c4aa73982113067cd95\";}i:4;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Customizr\";s:14:\"override_local\";b:0;s:4:\"path\";s:37:\"wpml-config/customizr/wpml-config.xml\";s:7:\"updated\";i:1440909000;s:4:\"hash\";s:32:\"d63f73a0df72ab558bdbfaadaeb9c737\";}i:5;O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"Divi\";s:14:\"override_local\";b:1;s:4:\"path\";s:32:\"wpml-config/Divi/wpml-config.xml\";s:7:\"updated\";i:1619533548;s:4:\"hash\";s:32:\"7a3281072864f6c7f6193e3c8051597e\";}i:6;O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"The7\";s:14:\"override_local\";b:1;s:4:\"path\";s:35:\"wpml-config/dt-the7/wpml-config.xml\";s:7:\"updated\";i:1534160160;s:4:\"hash\";s:32:\"b99fe39e5d53275b0237a65894036893\";}i:7;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Emerald CV\";s:14:\"override_local\";b:1;s:4:\"path\";s:38:\"wpml-config/emerald-cv/wpml-config.xml\";s:7:\"updated\";i:1460387160;s:4:\"hash\";s:32:\"3ab5fd101b71e7b306e48a07801c7557\";}i:8;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Enfold\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/enfold/wpml-config.xml\";s:7:\"updated\";i:1617117834;s:4:\"hash\";s:32:\"a9a32a365b8191be61a5151099f07559\";}i:9;O:8:\"stdClass\":5:{s:4:\"name\";s:5:\"Extra\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/extra/wpml-config.xml\";s:7:\"updated\";i:1576677617;s:4:\"hash\";s:32:\"6f40ff074142d6392f49267cbb1176f2\";}i:10;O:8:\"stdClass\":5:{s:4:\"name\";s:8:\"Function\";s:14:\"override_local\";b:1;s:4:\"path\";s:36:\"wpml-config/function/wpml-config.xml\";s:7:\"updated\";i:1476729720;s:4:\"hash\";s:32:\"bb6dd583fb2a28ee5c4e2a264a770d60\";}i:11;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"GeneratePress\";s:14:\"override_local\";b:0;s:4:\"path\";s:41:\"wpml-config/generatepress/wpml-config.xml\";s:7:\"updated\";i:1591094953;s:4:\"hash\";s:32:\"4fba6e5837b20c7b3e763a4edb85dc47\";}i:12;O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Genesis\";s:14:\"override_local\";b:1;s:4:\"path\";s:35:\"wpml-config/genesis/wpml-config.xml\";s:7:\"updated\";i:1456825680;s:4:\"hash\";s:32:\"795657d127a84e450ad21218284bdd28\";}i:13;O:8:\"stdClass\":5:{s:4:\"name\";s:36:\"IDStore - Responsive WordPress Theme\";s:14:\"override_local\";b:1;s:4:\"path\";s:62:\"wpml-config/idstore-responsive-wordpress-theme/wpml-config.xml\";s:7:\"updated\";i:1499457240;s:4:\"hash\";s:32:\"1c49e6754e661e5eb1c301f8874829da\";}i:14;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Luster\";s:14:\"override_local\";b:0;s:4:\"path\";s:34:\"wpml-config/luster/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"82a924b258dea8a7d87ba0002b561b1a\";}i:15;O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"Port\";s:14:\"override_local\";b:1;s:4:\"path\";s:32:\"wpml-config/port/wpml-config.xml\";s:7:\"updated\";i:1426496160;s:4:\"hash\";s:32:\"788cce209545b94cfede660d543d7013\";}i:16;O:8:\"stdClass\":5:{s:4:\"name\";s:3:\"Pro\";s:14:\"override_local\";b:1;s:4:\"path\";s:31:\"wpml-config/pro/wpml-config.xml\";s:7:\"updated\";i:1620206304;s:4:\"hash\";s:32:\"841f7306ed0eed57072de5c5ee360f54\";}i:17;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Relevanssi\";s:14:\"override_local\";b:1;s:4:\"path\";s:38:\"wpml-config/relevanssi/wpml-config.xml\";s:7:\"updated\";i:1519735440;s:4:\"hash\";s:32:\"c630dfd3df777607e8f43ea201b413d0\";}i:18;O:8:\"stdClass\":5:{s:4:\"name\";s:18:\"Relevanssi Premium\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/relevanssi-premium/wpml-config.xml\";s:7:\"updated\";i:1519735440;s:4:\"hash\";s:32:\"c630dfd3df777607e8f43ea201b413d0\";}i:19;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Resort\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/resort/wpml-config.xml\";s:7:\"updated\";i:1491314280;s:4:\"hash\";s:32:\"363adea9467157a4e0b49d50c2be3b3f\";}i:20;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Reveal\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/reveal/wpml-config.xml\";s:7:\"updated\";i:1461595980;s:4:\"hash\";s:32:\"58db88b09a090c9fcff3d65bd031d14a\";}i:21;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"ReWalk Parent\";s:14:\"override_local\";b:0;s:4:\"path\";s:41:\"wpml-config/rewalk-parent/wpml-config.xml\";s:7:\"updated\";i:1480345020;s:4:\"hash\";s:32:\"7b17377ed5e4226bc7e3d44270bc7924\";}i:22;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Scrollider\";s:14:\"override_local\";b:0;s:4:\"path\";s:38:\"wpml-config/scrollider/wpml-config.xml\";s:7:\"updated\";i:1479395940;s:4:\"hash\";s:32:\"83fbe85052a8e7eb7ac61496187c7271\";}i:23;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Uncode\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/uncode/wpml-config.xml\";s:7:\"updated\";i:1612368753;s:4:\"hash\";s:32:\"5fc00f036d83b26035262343c7d3d2db\";}i:24;O:8:\"stdClass\":5:{s:4:\"name\";s:1:\"X\";s:14:\"override_local\";b:1;s:4:\"path\";s:29:\"wpml-config/x/wpml-config.xml\";s:7:\"updated\";i:1534248540;s:4:\"hash\";s:32:\"0d41ca410c22810705838d664c5fa296\";}}}', 'no'),
(138, 'wpml_config_index_updated', '1576586726', 'no'),
(139, 'wpml_config_files_arr', 'O:8:\"stdClass\":2:{s:6:\"themes\";a:0:{}s:7:\"plugins\";a:1:{s:21:\"WPML Multilingual CMS\";s:13980:\"<wpml-config>\n	<custom-fields>\n		<custom-field action=\"translate\">title</custom-field>\n		<custom-field action=\"translate\">description</custom-field>\n		<custom-field action=\"translate\">keywords</custom-field>\n		<custom-field action=\"ignore\">_edit_last</custom-field>\n		<custom-field action=\"ignore\">_edit_lock</custom-field>\n		<custom-field action=\"ignore\">_wp_page_template</custom-field>\n		<custom-field action=\"ignore\">_wp_attachment_metadata</custom-field>\n		<custom-field action=\"ignore\">original_post_id</custom-field>\n		<custom-field action=\"ignore\">_wpml_original_post_id</custom-field>\n		<custom-field action=\"ignore\">_wp_old_slug</custom-field>\n		<custom-field action=\"ignore\">_icl_translator_note</custom-field>\n		<custom-field action=\"ignore\">_alp_processed</custom-field>\n		<custom-field action=\"ignore\">_pingme</custom-field>\n		<custom-field action=\"ignore\">_encloseme</custom-field>\n		<custom-field action=\"ignore\">_icl_lang_duplicate_of</custom-field>\n		<custom-field action=\"ignore\">_thumbnail_id</custom-field>\n		<custom-field action=\"ignore\">_wp_attached_file</custom-field>\n		<custom-field action=\"translate\">_wp_attachment_image_alt</custom-field>\n	</custom-fields>\n	<taxonomies>\n		<taxonomy translate=\"1\">translation_priority</taxonomy>\n	</taxonomies>\n	<language-switcher-settings>\n		<key name=\"link_empty\">0</key>\n		<key name=\"statics\">\n			<key name=\"footer\">\n				<key name=\"show\">0</key>\n				<key name=\"display_flags\">1</key>\n				<key name=\"display_names_in_current_lang\">1</key>\n				<key name=\"display_names_in_native_lang\">1</key>\n				<key name=\"display_link_for_current_lang\">1</key>\n				<key name=\"font_current_normal\">#444444</key>\n				<key name=\"font_current_hover\">#000000</key>\n				<key name=\"background_current_normal\">#ffffff</key>\n				<key name=\"background_current_hover\">#eeeeee</key>\n				<key name=\"font_other_normal\">#444444</key>\n				<key name=\"font_other_hover\">#000000</key>\n				<key name=\"background_other_normal\">#ffffff</key>\n				<key name=\"background_other_hover\">#eeeeee</key>\n				<key name=\"border\">#cdcdcd</key>\n			</key>\n			<key name=\"post_translations\">\n				<key name=\"show\">0</key>\n				<key name=\"display_flags\">0</key>\n				<key name=\"display_names_in_current_lang\">1</key>\n				<key name=\"display_names_in_native_lang\">1</key>\n				<key name=\"display_link_for_current_lang\">0</key>\n				<key name=\"display_before_content\">1</key>\n				<key name=\"display_after_content\">0</key>\n				<key name=\"availability_text\">This post is also available in: %s</key>\n			</key>\n			<key name=\"shortcode_actions\">\n				<key name=\"show\">0</key>\n				<key name=\"display_flags\">0</key>\n				<key name=\"display_names_in_current_lang\">1</key>\n				<key name=\"display_names_in_native_lang\">1</key>\n				<key name=\"display_link_for_current_lang\">1</key>\n			</key>\n		</key>\n	</language-switcher-settings>\n	<custom-types>\n		<custom-type translate=\"1\">attachment</custom-type>\n		<custom-type translate=\"1\">wp_block</custom-type>\n	</custom-types>\n	<shortcode-list>call_to_action,newsletter,tours_shortcode,cta_button,woocommerce_thankyou,woocommerce_shop,table,custom_profile,symple_heading,row,tagcloud,sform,nano,add_eventon_list,che,era,essa,nel,gli,per,come,anima,ella,quel,show_gd_mylist_btn,su_spoiler,email,vul,wpv-view,wpv-post-field,accordion_item,citation,gallery,foogallery,user-submitted-posts,chronologie,adresse,get_unit_label,get_reference_label,woocommerce_api_manager_lost_api_key,wp-knowledgebase,testimonials_slider,rpwe,posts,nowotworu,intima-media,dostarcza,standaryzowany,jako,czarny,ekstrakt,kwas,std,dwuwodzian,stm_icon_box,ess_grid,rev_slider,linkview,dropcap,permalinklist,testimonial_slider,woocommerce_software_lost_license,text-blocks,wp_sitemap_page,wcmp_vendor,vendor_registration,efsrow,efscolumn,efsbutton,md_rev_slider,md_live_text,md_imagebox_full,flagallery,pbr_quicklinksmenu,rev_slider_vc,opalhotel_reservation_form,pbr_title_heading,pbr_testimonials,embedyt,yith_wcwl_wishlist,wcm_content_restricted,feature_box,woocommerce_en_check,wc_box,wc_row,wc_column,wc_fullwidth,wc_center,wp_social_sharing,infoboxes,testimonials,woocommerce_social_media_share_buttons,wcv_vendor_dashboard,wcv_shop_settings,wcv_orders,inplayer,useyourdrive,wp_blog_designer,us_blog,tt_address,tt_dashboard,envira-gallery,hotspotitem,woocommerce_klarna_checkout,wpml_mailto,contact-field,ux_banner,advanced_iframe,siteorigin_widget,ec_store,simpay_payment_receipt,su-mensaje,borlabs_cookie,contact_info,stm_boats_video,packages_orderdata,yith_ywraq_request_quote,woocommerce_pay,button,supsystic-tables,clean-login,woocommerce_pay,pdf-embedder,insertgenerator,youzer_register,wysija_form,video,customer-area,customer-area-dashboard,customer-area-private-files-home,customer-area-private-files,customer-account-home,customer-area-account,customer-area-logout,bookly-form,bookly-cancellation-confirmation,stm_classic_filter,popup_trigger,mainwp_archived_lists,wcv_vendorslist,dotpay_content,formularz,cyberactive_school_courses_selection_form,cyberactive_school_session_timeout,ditty_news_ticker,donationcampaign,das-list-events,event_embed,sectiontitle,learn_press_profile,ticket-submit,tickets,aanduiding,datum,thim-icon-box,ngg_images,wpdomainchecker,visualizer,mk_page_section,rssreviews,animate_this,simple-sitemap,gravityform,stm_tech_info,fep_submission_form,ucaddon_diagonal_event_box,wcv_feedback_form,newsletters_management,wcv_pro_dashboard,tm_pb_section,wwof_product_listing,res_map,jssupportticket,socialbar,socialbar_service,front-end-pm,stm_sidebar,give_receipt,donation_history,simpay_error,tm_pb_contact_field,jwp,woocommerce_checkout,mk_custom_list,sg_popup,icon,extra_wrap,frontier-post,invierno,appbox,highlight,ci_alert,vc_mad_products,dt_list,geoip-continent,geoip-country,geoip-region,geoip-city,geoip-postalcode,geoip-latitude,geoip-longitude,geoip-location,woocommerce_notices,stm_icon_box,post-timeline,tt_address,private-message,visualizer,ga_optout,manage_serial_key_usage,ut_header,site_name,bfname,order_id,menu-country,menu-prefer,accordion-item,mini-icon,gvlogic,stm_gmap,contact-form,iconbox,woocommerce_my_account,super_form,wpdm-all-packages,photoblocks,et_pb_map_pin,ginger_reset_cookie,su_divider,fbl_login_button,gmw_single_location,one_full,recent_products,custom_list,endif,jours,wpuf-login,lyte,product_table,wpuf-registration,wpuf_dashboard,amazon,member-pricing-table,rozinky,ngg_images,add_to_cart_url,srizonfbgallery,wysija_form,cl-itext,embedyt,icon_counter,text_block,vtftable,header_static,bookingcalendar,flexslider,anova-geoip-meta,zp_vc_slideshow_element,zp_scrollto,my_calendar_upcoming,wpv-post-url,fusion_button,su_tab,freeconsultation_technical_forum_link,vc_images_carousel,otgs_logo_url,wpv-conditional,wpv-view,teaser,dt_fancy_image,fusion_tagline_box,contact_us_add,content_box,tagline_box,us_iconbox,fusion_tab,fisicamente,one_half_sidebar,action-btn,invicta_contacts,pricing_price,button,icon_link,slideshow,vcex_milestone,secondary-demo,vh_pricing_table,category_name,blogurl,q_team,tab_nav_item</shortcode-list>\n\n	<built-with-page-builder><![CDATA[/<!-- wp:/]]></built-with-page-builder>\n\n	<gutenberg-blocks>\n		<gutenberg-block type=\"core/paragraph\" translate=\"1\">\n			<xpath>//p</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/heading\" translate=\"1\">\n			<xpath>//*[self::h1 or self::h2 or self::h3 or self::h4 or self::h5 or self::h6]</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/button\" translate=\"1\">\n			<xpath>//a</xpath>\n			<xpath type=\'link\'>//a/@href</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/image\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n			<xpath>//figure//img/@alt</xpath>\n			<xpath>//figure//img/@title</xpath>\n			<xpath type=\'link\'>//figure/a/@href</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/gallery\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n			<xpath>//figure/img/@alt</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/media-text\" translate=\"1\">\n			<xpath>//figure/img/@alt</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/list\" translate=\"1\">\n			<xpath>//ul/li|//ol/li</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/quote\" translate=\"1\">\n			<xpath>//blockquote/p</xpath>\n			<xpath>//blockquote/cite</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/audio\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/video\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/file\" translate=\"1\">\n			<xpath>//div/a</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/cover\" translate=\"1\">\n			<xpath>//div/p</xpath>\n		</gutenberg-block>\n		<!-- Since WP 5.0.0 core/cover-image is replaced with core/cover -->\n		<gutenberg-block type=\"core/cover-image\" translate=\"1\">\n			<xpath>//div/p</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/subhead\" translate=\"1\">\n			<xpath>//p</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/verse\" translate=\"1\">\n			<xpath>//pre</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/table\" translate=\"1\">\n			<xpath>//th</xpath>\n			<xpath>//td</xpath>\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/preformatted\" translate=\"1\">\n			<xpath>//pre</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/pullquote\" translate=\"1\">\n			<xpath>//blockquote/p</xpath>\n			<xpath>//blockquote/cite</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/column\" translate=\"0\" />\n		<gutenberg-block type=\"core/columns\" translate=\"0\" />\n		<gutenberg-block type=\"core/code\" translate=\"0\" />\n		<gutenberg-block type=\"core/more\" translate=\"0\" />\n		<gutenberg-block type=\"core/nextpage\" translate=\"0\" />\n		<gutenberg-block type=\"core/separator\" translate=\"0\" />\n		<gutenberg-block type=\"core/spacer\" translate=\"0\" />\n		<gutenberg-block type=\"core/shortcode\" translate=\"0\" />\n		<gutenberg-block type=\"core-embed/twitter\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/youtube\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/facebook\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/instagram\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/vimeo\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/soundcloud\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/spotify\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/flickr\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/animoto\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/collegehumor\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/dailymotion\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/funnyordie\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/hulu\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/imgur\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/issuu\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/kickstarter\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/meetup-com\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/mixcloud\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/photobucket\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/photobucket\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/polldaddy\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/reddit\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/reverbnation\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/screencast\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/scribd\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/slideshare\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/smugmug\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/speaker\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/ted\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/tumblr\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/videopress\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/wordpress\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/wordpress-tv\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/html\" translate=\"1\">\n			<xpath>/*</xpath>\n		</gutenberg-block>\n	</gutenberg-blocks>\n</wpml-config>\n\";}}', 'no'),
(140, 'icl_admin_messages', 'a:2:{s:8:\"messages\";a:0:{}s:16:\"instant_messages\";a:0:{}}', 'yes');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(141, 'wp_installer_settings', 'eJzs/dtyI9mVJghfd5v1O7ihuyoiegiS4DmozCxjMiJSVMWBCjIypb9nDHICTtAVgDvkDgSDOVNmdTUPMFfTZtNm/Sz9KPUk/zruvbb7dgAMpVKqquwuSZkEsH37Pqzjt76Vnu6f/p/16WDvtFdl87LOF2WVZ3XvV+npHn5wcNq7n8+m+O8D+fdxukjp3w/xD/DDfNz7VX26f8Jf7S/usv59WY3nVVbX/dlyusineTFZptP+fLqc5AV+G8Yp0llG/7h72vvh8s3rpJ9c32XJD/DTS/xp8sb8NLl0P8W5zqtyvBwt+m4MHoLmcdpbVlP64tFp726xmNenOzs4s+2ymuDf9+Db8KLZ8GP2UA9naZFOsllWLIbyu/1B+3c76WhULovFDv6w3tF51Mv5vKwWw0U6qWWN8tNds3grJ7j/PPKg27JazuqdRTnPR30Ylz6BB/7TP9WnsMTzdPQR5ktP28en7R3sHx0d7cO/Hgf74Xauax4DeM1xVo+qfL7IS17aXXgCbsKonM2n2SJL5HHbyWVW3WajRQLTS9LiIbH7muCibMGfx0k6rcskL0bTJQwdfumHsjwvZ7OsGmWJrNs2PhQWIZ/BM3T5j2LLfz/vj8piAbu0s5xPy3Rc7+ztDg52dk/oO/1pOSkH/d3B9rygPT487cE5yqrer3A/YFBcuQp+rn84cYeIlvKA1g6enBXj/rLOqn69vDFrA1u739xSf24XG53b9nrDCDLZeZWPMp3b4BhPln/8cPEwpw8Hg/0BfmFvL/KF4SL7vOjxq72ErfhQ4+tHRsuL25I+gJX/fZZW04ckfFl4wEnsAdmflvmndEqr6CY/2MXXgss+ShcZnLwbegV/yA9OItvpVnl0l40+lsvFzj/AEZp9fXg42D/aH8hbwH5l93CicPl3T/9PvgDL+aRKx5n5I7wfCxa+gsd8B+EljvieRwTRaFbTeuK39kVu1YsKPu0vqrSopymvBFwv/Mqxijb/Wd/LDfzavuwKfW2WjfO0OdCBSJ77shzJNQjmhN85xO/AaYA3/JQvHuCuzerWl45kRngfUpCB+K3+cetrxyIBaUZFXvwxpW/Se5+I+KLP7ufu789lPW6W4/FDe9loyXb5wKaj2xn/ARcRdAEPlk6n/XyGd5s+o9Ub6LKk+XR0B5/iROCx9I19OYhwweusbD/ugB+H54+37FCOtOxZPvr40IcffORPj+ybwS6DhvgEspOkzLi8L0h06NH5J350cDJgT4vRQ/TC74nwDC/4mfxg0ws+OHy+8oofDwYna684TrtrFn+h6w4vf3S8N9jkyu8fR678P6TjcX9R9kdptfialdYv9/yXe/5z3fOTxj3H3+zFr/kgds3P31xtfsePV17xo+PB8/U3/Khxw3UCf11tvunV3v3lav9ytf9KKvwGnIGuu70Xu9vfwg82v9x76y73Bur7uHG53Qz+Vdzuw+d/zu1+7OVeeSX31h/3/e7DfbDubB+uPtpHwcnuOqL/9E/wpMPBLhyMppOOt7v94sGR7VQEv7jv3n2ndZZVPmqv8nFEQjSXufNKttf5cI+X+Sat81FC8uRTVtXw6VYyKcsxrXKwePjA+m9suSLHlUJ8bV28/qqmqPMeYUZhBA6e0dtACsRPOt4KPukVnHKabrJYVkVt4jB2rO3kYpGAIKspVsMbZ0RJgstdldNabsG0vK/958Ukke3QLRzdpcUkkxOyd3SyCyfiq7uDbw62D7YHu1/twD9+dbf/zasshUllNfxh/5v/9B+/Wk7hv//DV9P8m7PxOBsnJb1QsiiTep6N8tuHZLSsF+UsuZ2mkxru5Y9wC+/vsiKBzYT9xZng/KcpvtQELuJ9vhjdZdX2VzswKDxhhx6B/5+en3+OPRz/PKaBbvOqXiQgKhZZlYzSOkvKW/oAd7HWf9HH1XbJan1mY8g6w4WewX64WaZ1ArKb1tH9DT7/Csy1sph8g4Gqr3bkX5J/+b//H/fJZVXe5tPMf4gXqy5ndkrT/GOWfJ9nC5pyFpnVLK9rfPb5XV7AN2RxSz+BlzA5P6J/2hxFZ3u82wzWHAecl/UC9idf3Lmh7ufDSbYYphV845MdC2cum4s/S0hn0GLB7uuvX5TFk0VyLYvs3zsyCf0JnK7FEEcc3pXlR/NAFOSLZFxmNY4JRz8pliC98xHcQtjtWY1bkFVVWUVGT4sEFm2Z4eHDC0YvelvB5EvY48os/z1+XpQL1Rpju7OwGtMc5xeuK8wZriYfbPfqeT2fpg94VvSQZWP/E7kp9ymtWcdxB/00h7N5A5d+8dB17N2rwQIt7tJFcv7i7PoM/kZvkdK9xAu5eJhmJA1Y8CQY4sd3wzNuJQee7MYa/reXU/Iqyur/SPiii8KkU6BvDGPBIZmal1xkoLbhvVHa4H0xl4zeVCXMcy9gVl1wFOt4TOEWv395dY3LXi5BfYtIIfHYR9GLz7vNJ8uK34gO9Di/vc1QhZi9hjVa1tk4eFd+P1yUKpuVYHHi49wrjqZD9smGNykKKnMIcGnt98yaDp1SMl+v4TrCCsLopFXeZ3h3St4PHee6Kpc306yGq4DSZsVNfo+ThYkvWeTpABm8gP+VOcluEbb/WK+6lmkCehamMONV5ItDB2s+B/OdtqOAwwXvOZJPcW68IyINbvhC6YKkMFzkSQUM8cmoAjxa32bFJJ3mkW/T5uDTSXrSWabrbE8yzUEFdVnloFNhO0laLUmA6mL8dgkuW4JSM74Uuri0UaN0ntKNzPXgpbjq1ZM6AYWb4aFibUrXLuU/0sUcwVUtSjjG8CHYU+SsiyCo/ywJsAQpTBtg3x5OAfmgvHEqqkFQpvhnVjO6ADt/hw7UpKwe/m7n73CBUPf83c7Kg+EkKg7/Ety66RiW4OxTnibfLkEMwCvS6uB5pjVHWZcXsG5gjjzQvsAw9OvvlmCL3GTVJPKc13oersQ0wFOFO1rTCXGSCZ8D+rJjHT/U6eo1rGA+FTkUeIroCMMCikLE1+ATw1+CdaKHj7PbFAW/ntmocDvZQLglt3Atpqy91D66r3JyeKp0hmfqFlwZsjJSr2+jzzvustYib41KQSTq+TSt0Yh8SeIfHjRfLrZgLvnojnbupio/wrxgAt4gPdw+Wnsy3N7qyKyBrZS7oogJvZaxL8CooQej6LjJ2Gad53yrvEalX0UmIdNdccOdCva7e22uzxsXS9vAFg1NYbS2cXHTT7K2I7BkUFrgmbm6ekcLUy4XfgHgtl3lxj6SbXf3h5Samj4o4q+uXke0lo73xz8ts+qhv8z7Y7hspdEb42yOhncxeghU9x/rHbYK1qkDMqVBF4HPzIfVqJQrdXpOT0dzAh8MF+UwH+M/bSZJ6GSw0LKbnMAuLGu4ezUrnYbG5lFoCBF2FQaLKjwcuIwZWIe49rgttCG076jYiyxm9H8CtYY6iq4YvuDlry9fvDvvULciKYyFyN7bEESFX3cwSEBHFrGTep9WhRNn8yr/xG8MJwScu1lafcQlgk9JeaGRAQ+uqhw2vAhGu0JlC9vjhFIJlnGGCzlPhxdvafjLZfFHEISosovsHt4NJjWd1mqExDY81Chs/JCZYkyTtjnyJh37+41DD89u6nIKsmD4Ac7FJUYXari+p6fD4X36MVvOnz4zpx9GBlFEe7m4q3jbukx7t37pDd4pXqfmOsIq8AHAzUxO0GApxmk1ju3/TTr6CIOOKerklC/Phn9dZSx7YFQffXSv+z67nYKSgBW71ON3egpOFEnYp89kTqstDXdGwX7DY01aKa0mSxRINZsT5Kn4o15ln/JyWU8fIoJBPcY1Agenyo6dCKxA86n9PAZjA27F3LhNvDjeDqnzSdHPi0cYNRHlhGstmyt21nhsX6JIPw1RMviXyNgYIOGBXo24H1GzNtxcq7DKcgL3Bpcn+cdcvDqOS2i4ohEOgMf14Br1IgsPWnuK5wlu4wTts5KkN45xn4/hTPAVLEaZt2rwL1k61ljFZFreUEhznN2kDePnMaGTpgUUWXDRmcYosDc4HtG4Tj+XRTl7sIIicDii1kJjbmeXF92zUv9jwm/e1P1JPlYrvBmOSO5SDo/VcLQpAoSC1H1vIVOPWlFHm7mkoa3jYxhkvA2r5dR6iOIEoMsJsyCdjo75HUgljKdqTA6lKxwbEqqt45COFhh21PBdbOqH0anr5BP4f13zdxoW15mcHfEgrCOFs8Brp88OB1yjPBtP1634HfpV5LOjwMvHrG94ZtnnOUpTeHKaXL/83fXZ+5dndlXw3zuGD15uOR9z6JPyLsl4OQcdI4qNfTDWwC4GhtokXSzS0R0J3a5XCPxjFbRwQOs79AMrGIKWLCvGLnABBlFztL+0wgxn/dPozHDMv7Da9C/L82tO4tGa0ytMp0Q7thjUWr9pB+HlNZeDdSTu89n4E8rzceBMvAxiauHwNg+lazF76As+1782Pw1ulIZ9m17nqsMP+risAgvgYz53vrUJsoqQbcZ09D7E4uUrL4S3i2fToYs+mAfe8WEllYh/8iGKjcZ3cSBNNOTZdAyXbVSSraDvg1EJL2QkMNh8AKvsVP2EX1/DD9gFM4kTDjWb9M26aYobaNQWDsED57C0mDdCB98pKlFaLmCFX99oLfRJ3rqIBibWx5ZaUvons5Xi74FSE/7Hx3LwataxM8ZbBJO5cyHowFOk7adb4geTtUCY/yZX5exTOk6f1MlrjEZyMJxiELDUcDQRryBHtmZp1XUP4vcPDnYGhlaWftwg+B6O6N/IpZPwbvq7JC8KdkNemAgoBbPsQ7yp2UrYXJsYbdJnY9X8Mr9N0k9pPqWPYSLOvCWRHgbDvIMjL7Ji50E5zsu8WIQPKySLCFKIUnl8F+/BZMpnMIfK/awGIyH3YSB9xMvPCwx2cNQCbz+txI0EJ8XeQAtMThIlEOZTPUXgwPQRxJ2Uo9GyAtdnlLX2+mIGx+KTPOI+faD/HYHJQHHgSVZkFV35mwdREWUx5S9dvNjk3KRiBJD0xylLXt6Hhj68J6m2AJcMbdv/jXyv+ND49fOygjmBqIRjeH51xWkhqxbxqFfZLVjsd5z7ahzRqCiJh1e9aobnVTIBlx8T+8son5vlAuYVBKbWZNF85jFqCR9sZsSjdSJBLRZgLEfJAHZ35Sa7xdQ8mEp5TcLt+g1s0Y9g8MTSRxhawqP1XZVlHwOtSXF5l3yxP70oRiAX8DrM0s/5bDnDBOcNnFQfiMYjQSchGJE2L6XJ4euMl5VVOJKQP2zEGWBZ0UoZUxQn+dOyXGj0DM+p/xOcgKvfviZrIBMTqgQhUObGikSZgmkYWKzlvCuPzqda3ZjQg1bflU6fM9TTW4xHOEOdPAB2+Ypm2jaMhKUguTlXI3EMyrLCJY6FApxo/uFy+FuMm/o9p9NAsVSyMDhFkmdxc4jkVYaZzhTG8FgBsPvFScZfWquwLX5/GnkbT2fKDcWfktGUefeLjSbOfNCNsq8lhgqmt8TE5kSbNVHoV/imjMHA0SIKZ4W+WQkNSPGKI4wL3vkGjaXitozHdJyWsEZ1gNfBjILmkeVK00nByTvnDc/yrSRPviwxd+2tvXwcWsJnxQOa8LBE726DADFnyGP4DJMcuqWYOxxEyW2P0DvKvAzABAG+XyNGzvm5MDvXTxoaR4MRbOmEAiT7vJD7CF+nG5pt6dHw+uc7tN3h89kUnKY6kRDV3yf1w+ymnEZeDTxhl+pyKi0djylgBMeF1DtJs5LNZgGisCqnE4d/zSmsQ4sKAiYtWDpYwzk4J7+5Iu0PYgXMQn5xH94UDevAQnWGbukeyN2bCm72+hg5XtBJBc4b7P1MYjjGeLNGyNp4WCRPWVNqJYo5eW3ASJqpzG0EKryIUZ25v5nOtOkWimnAnOH+YTKBpvRQLiuyTRDIDUezffVfNALKdRBRDnEVxsd2JmGdVZ+cGSceXdwM2Fv3Smd84OC1LjgjQtl8NAluNURE98ul4kZpgZoKnl1gzhjeitInZTWxKVMfS5uhnCnh+tBAdGfgpi2nsURWKxW8YPVDcluS1BLgVoG8cEHY+IlnABzBKxpnFT95DXu4TIs8bbtpwTIOVixj0ljHUVnPMgwfsGSB8+hWVtJ8OabEaHPNfZGUBizbgo1PkuhfgTOffXN1/v7i8nr44uW3H777aof+pPAp9gGX3rtszIYEOlp5b8nKqwUVpQplG4OvIgc0ioWXNhLImkyXDp4JO4EqphiLohSNEbxsOCOjFUTzTuhbsHH5YtoUFJdVmYS/jyIvgu/XGQpI9QTp+OAl9LfPYhhTn/WJbngn7jOC/EwLA/7MCjRYdjCcTKFgGz7BlEWJy4dbX2UT8NtElbWSiJpIx1jAwgav7ud9GiPEQ2n40+RE5uDJ5J9xWXEVaDncZxsKJ4MWiwvVaP4Oj6dIAk65k5FsVYvPi/DXUvG9xBmlJX1AuREd/z6bjvBQq9tiDYzXcAaKBBV5I4k+ztMwnBixFM9+zKqbNP8jyIOWNGgYlIwtSG7Kz5I9yMAImNK94nUN/FSESGH2gmLMtZvst1V5X9tMosq4EGnqsb2LfBZOyLngoD7ouZhNU4+E/QzOpODfcufl3IDv7/0rnF2XqdcJ9PDC1djWjP1ikeuGl8QkYRjQn+XZRk58zFr3W+ixNBygGaUheMzM6mD3QHRIGbrwWeTWNWPYX3AL9PaLEwCHmQ+0s+4oF2a8Gd1VDq20Q5WRDKDmqHAFFa6cZLDGLk7B/teqg6s2/rwC2wwEb16Ms88hjHU0HTJ2YjhL551+SQL6CoRLQQ+HMU7dAB78T8EVv0R8WSMv6Dbqh8v++esLjLfOcCGzz+C0egirM3287MBviacbCWzH8JKc/TJ5LadmOYvqPtBgAIfaKHtKUbY6zOoinr1+qBdZy/DwZ7BW7Yo6tSILRsJWGs6aS36rWFD0DCYaeYcgZRfERJph1D+WNzTNOKCLjbk7jBLcZBm+PYgMFFzsEAZPfsE6bGxiFQvQhTXZL3q36A4hMNxJ8RFM9COd85gUD461YpZgK8EgAIk6oTjhkvLAkYBCvbxRg5l27IrDNVcIueCgAknZ9U80Nwm0N90jgnZz3gec/IKBPQw6XHW1miKnYbZSpi27J3tjIljYnCVJBT4lx5aijlrLFhYF4sJzLvJEJzAmCO1bJjcw/Y8IgMdtp9KxpFL8UuhKkWie380NdK7MGIxIt8BFRhF1uiqqFAAdH5d0c0ZNV+ZtVRUAFsV5KB1M4g7XSffTaANFHeDRZcd+TGJFAvJlU3u4cWIHLGXpmhoTzAGLMPYAh7cv+CEYmRzH99mfwJOMIeMawEBTXrMGh2tTIhhE12X1S3CPzhdjMeBjTjyq5eETJxVszINPSNa0Rg1L0eClV8WwzBl25qxFsgiMkNbaeXMspmqWUuMMKyDHDXNQwriEllWVelaB9TBadVX5hd0ecXEUpparEhYqXalAQFjeoUinKKAzq93i8ZW/aZh1qy/m1ct3bj3vwGTHX1nTomgcYB+SbJntnC54jTbmImnkxwg8KSEmqWcKDvJjYWprrDWWeqFT1+GcBzFfcozJFZBEo6gQ2l/KTibHCguDlwXhEBUI3VnbHy6/TT+i13mJi6nhQDptKKrJKBD/VNJDArDi4LtNxXigzLoaIuv7IrABgfzLW/TOSNiwo+bs5DVrVtG59+ZMY0LJG/qr1f5lMwT3JcCNTiecEro6kCLp2+PwI1XgmqzdIp00bVUdzS0JnC2MqQWG3pYT93U2ve3flQgRAgEzzsqEDUhYZwzQY8SQ/4xFKDeBQN+sBix6WF0p0DTXpQ8rQRpxzs4FtA/3gH83cFBHoutHkrEMSgxuwHD/yFZxkOuFm1Qt0CeP3xRFPMbDKu/fYe306CMlxGKp0P8QJJut91sWBqDLNcguCNDI/S2onBlFeT7Fy4HVjyF6BlfjYViD2Tr0VvowZRCCQRlq/EWgKrgYNs8DQvMBRDh8Of/R+OhpYPtjRAQe1FUaF+SSSAVxThvD3Xz+k4sXJK+8o0CxcAfRbZnthB2cLmM+m67COW98/wpTefD4/mUJZvaDf/W7LCVJVmImtGHtclazX4uZrME6NSDx6rBfWOI9qQLxEHq/bHx/Ccz2XOvCzGmXbBmiJXG9/Fkm+BEdaK4j4xQMCBq9sN1yxs3NnfGmPjb1TlhEBUuT13fJ0w//+IxLRMXrYz+4611XwnZJpF5eSI6Gym0xfcWHOzjXWF+M5hVWi6DgsZWTq0wqY0CA5eRdy0A+qbdWJA6pbNdLJYvEK0jNUoR+sLu7q5ZYHoUX7G8PNqxb/SOnlTVdfkpFp97TqMq5RUw7YKt+Aa5lFRoxHmeM0cCz4HO2lYssa6YAeS6cogkRmDK/22Ux6nIvftZXcMGcxXLewFiE67+2tE5SAFw81rKGRDJYhPqhV+XtwkOFCaM/jHHF+KSOV8Kvbe6zYGgz7gqyRmIg9Sa7Sz/lJmIiC89RRQ69XOI8488+6orYx3F9LrBGZ8YpSanykVp4jZh1mgnePCQNh1a5G4lCZJTXBnU9ZkcmU00pzpmkU4RmpyFrOtJNK2GQXE7IHputHsRoE642uYweWKRHMQIw2gh22f0gKrs3k1F8uZAlONxOV3W0PvacJZuNQuFQL/JPuTNxPly4bWvoh1Xg47iXAAO8Au1wSwdycY+b9vsyFYjH6mGdikPED5L2oLZ3ITut4RiBWQdGAOVS0YW8gY2Y3qcPtehfNX7VsacclmYDFUexuiTJiJNaDKIufDfsCdoVOZbZiGkRq+oQIEDn4WBjRbVQO9/K+//hYwVTNT72Kvhfs24LfcNPJjMiErsrDGbuULIe7dtmdngFhmxytcjm7cxk/OXtj1+XsNdZ8oPWOa39ffDrsyX4lVXyLSWXcIS4wFtd69JIAzeglSLFNYdmqhNszG6a33yeTW3eLICBhNMRwGGrSgijYLUpmcVc9OH2kQp5mB+CGcZ+QyncrlOA9XgJhnnr4IXPVuDGgVuKg9YWf5D4XsPwbuYEEHcW4LvQHUBLcGxCL0zk1H2pWrFbRzOTKo1XM2bfNZTCv3BOIFo9KoOr6iRuFuA140Op0cPUK6a0EL0tCV056gw0RZUWYYg+nduALW/YjMfIlR5+jLgntaCNmUV8NtsrwNDmcHoXTWsOsOwlxY1x6gr+ONRY4TAfxyLVf0LIW/CDvFu5vcgWrGRkmWsR2l03gRwFTDOneoVgdnQ0yuWCzllLDh20gmrtMxo7P+ZuOikCzxk/wD1BdHhYDddGPTu1Ca/TVpRWj3aPwa6Y/pQutJgwv7tMjZrYQUdtfb1SW2AG0GwspJJX7TjL9qf4BrAe15iM0IDeJvqF3twDQhEiqNGVFpsK5tTWjcnkSvHIi4eX69ppVEcfSZgp0HmfqcLK/1CQIku8T7i4XaVfJLIQMI9MgRYkKRGdFI0xsvTj72EKJ1yxlaWXMMfYuvmRI1xWIz15GGhvBKjoJWoHt7QmKHyALn7dcoZGYnW1zW8jkicVAqcq9mBPdqn+cKXEsYoO3XCKGBn7gr11Zt6CdUNvRYuTcHNFTegI9Mebh8DyisMMQV3trXFVGhEn2Ic6j0XZVQb4yh8OkR9t77XgYPGxLOiaTGwKqTeyZJyRWzt6K47vY/avZVw8zVeN0qHVzs6KZAFjcP7ln/97TbQQt1itSWkgjzhnH6VcEOooCATGwGX4AOFjec0+iwTKfG0suS24aP/yz//fnwNY/5d//h8d9XjdOcBcpIQgw/AKZQ0j2yEDCGPmGAilRJbjQbEnUX5NgknGFCJ8g5dVvR/uNBfnCxK2JDkXTiRFkTed9hpcbx6zgR7xPq4ShZ10KYyXFzsfK+z4DTCCHidHhUhUSyI3R3CrKqQdmQOxNTmftuvMcMYF1FYJR2IqRSpUVCQUPo8YL5x8NpvDPf02SxHt65JVrfoXyabwe6EKlQzZrBwvp9n6xzQewMct5Si4DOLexfrqktOpMpd9Yo4msjb4zBCUoo8F4I3yPoufdPboDPSTS3J6EAX+tJFlaw3v6xeTV0sy35q2gH19zjG1anBIMcmlERwpqaRwjKdS+olldVj+OUvn9TMqKPDUFAZhGWRwdmhx2nWvowoEc7zEmJ75j1k2j2LGlG2Osrpo0qtt01hpKmYPIjLMTodJz0pSYWQSydnJmgZYd/7qjsCmdUbgw5Bl1Fc3iS5H9gRXO5ErqIRDgV33ywd+WCf7gFJ4cEkVKPFJvTMqp8tZUe9g+H+HT/Gat6FzHxkzuE5hhJDQBKYwNhIpBONRl0Uz+F6aK/So6901VgcDOElGc8KgD1hWhPiEia2+5ZopLcr7LZh3ck/cpAuEVkk9kFjRBOkxZaI2PkZBTTF7wu/JPvIhWERnkmDxkmTY5VYTt4AIQ0TNoNj08uPG8ug51QeXcdwpQR0NwuPs4EASYfIM50bXxYK3o5UtdGHknHXtoMAIAsK+J/6crrjz4us4KjWvymgGTxxSQbCwEY3ZUZzaeZc16Gbq/eJIPG8UjGNlqj06k5HwY2gID5oxI95CLMLNuOi4ka554oISeFyeiESID767QYaqkQZoiC0y4uFiGyg3g8hCVdjxds/jATGMf73y/v1p8qEYpcvJ3SJ5yf9+jgQ4lPacZQSidpEx0EdPn+GG3JRwwFNGHP/AuvMUzuMwrar0Ab7CErU2ALQ9Eff0jaCmCGOngjuNxlD1dVYlnLoPFAgEki9LrBZC7V4x5QhlRaV26Ak7BtfwUmAjInzi8kJKnOJT6aR5tLMhVhkRaxy+xpg0BpdCeV43TBpVaSs4TDqx93VQRJ0KxtP60Y3fFmXRb+B/m5U8JIk44IiDMuE1ViZ//51YGI/2pFKPs9Oawj9xGjR0nwRh1nXFXXVa6ioRjdd4s+SiMSpNrPBbbF2vNygIzzOalhgoOTt/JciWuFrpBHrhD1sEJqlADlCQz/1WS77CJ0NjtmqzXp7yNQxbuXlw9h1n81VKNeQTD/QOhPUs/zFrVG1QhmjIhZ4FQ02p2JGHiL4+QxnT8R9BDZDDhu5b4h6eG+CQJ78VZOV8njF+XyVA3bSOAn4HlRD4BMvL0LEthlaAOJkKrcw33mUETWQHQYYGrdJTsUxxYMwV21cj78BiGYP9wm9cU8qRF1JeonnDDUL+RVrf3ZQYhIS/X6YFfBVTuAySiV5Oh6MjTIcqkSFLnbIaiivhU8PivVRN/sj2Iop011V05eeu7lRAHpRF13HJw76SGGn3+Ofv3l/ZJIWynKWWJ5rgX4rhY0IpxcNz5jEc+yWrew6UuaI40N99FGAoKchyfPOOggvEZlAJbukOjv00k9OmNRmc2hOLGyUI55mtnOFK9h6OT015eFo9IqPGEkO9n7MNPGFprIEXOKwsDQR7By1I97C2JF/50EnbaCMPZ/36Sh5rbkWRe5+WU6RYUdFXxB2vLwijiK/IOlN8AxfCk+fYu+MuTJeIRkuwwJAgqbmRmyySxtxnnByjP6CrhOA5PmZtqJjUs/kIO1OyYlC9dTdtvm9M6R1lBqc36XBw26mJZgXnNcf3bhOB5NWxJC0v9KWX75262OqAhlMNp2Y8Q578yOF9n7HqcSS8TLwDFmPZSNCudwSEWMpRRypSt/CY9piTEphka9A3gX9GbgMJMKmSBVtClAV1bBk3oaSSliax9o0TbN8kF/Ad+B+vtx0zghww5syw7FcBdc9K5FoqsfKpd8JdmKCgehoUjIjuym+W3HdBIc1O0EfurRoP1q8ILBR6BxnM6hVpiGeTQyY1eMUfXrel0oa8Zw0bR6vFRe9EC5DOUe46jsPj7YOomOrGJzm4meYxmmDmyHj4JJvJ1uV8+ocPXH2D/g02Ax9ywR77S+XNH8kfymvjTP7hWaBVr+9zSYhX4KzgWN1vJZ+4p0fwskHki0i8VxwGXWWzlnbMH86Td6Qlr1jZs7ESinZsXnR82pPcdY8bR3ELI/kXRKJmY2kxdbh9vD2Q7k0oJ7Uv3d7u3qC/u98fHCa7J9g9fXcv7HN+EGnEvvMPqtS+Pto9Ofl7mcTX/vEDGOC2yrI++Dv3c+rdLn3j9uADSZT0o9/AnyqWv4997U0PvJPT3g2YCq5N1dr2U9TMEWx/WRLshle6ht6O1ABXiRvWYa855D0Ykn0ljQHpucpqrm3dzLcIy61tsy7OXw+vLq5fXoLAuxp+//L91cW7t649IN7lYdAPS/vsNZ6sHba0+V/4qS6AfIrtKEOGhqEl9PAP2R/4pmHDxi+E4k+fxh0cQXyUBSo9OhT219JEM0+nQ3Ck7a9lUsfcaavIptq9UIwffcgB7XOVDuVrpukgngEQdsgQ1i+Qmou3bPcYO3X90prrl9Zcwcx/ac3FU/ulNRfhRh/dmou6f67sQxxpkYhNqdtGWLM/4qpBo80R9/elOWJ7bAWPa4dDiwzBzEd1i7VJ6jtzycv0gY+X5GoNEYvUMt6Jh8vQkO1ZySCAbdz7jabhy0gwKhXYtlKJTAgg7uGIHUpBKtZImWVmj4wkfU8gKpAhRYyjG5qPTY8iLXmDQV/BxmefUwRfb0lB8YRoZwl58vId+wKxxo+gTI6ec+PH/e3BRp2LQtiivYxYOgRKZchb2dkT4DgiEhwfRmylfb6XP3Q+B5E+w6+pcApTbItY4Q6+2JrYeRj5c2yQ1nknpxhDIoKgkKja4z0sLT2k1kDtt8WtQutOqyMUHRBZNAodSWSPcutB6ODP4VSN6DcDlTMyuLtNRPvVNuoIpHKTI/OISyCchT1nq1rycTYjrxkUAi4N/EOUgCU15BXMckj3omUDcWy5oVqfMId39KTF20g0IgJSw+8r2MblaOnrJlpMTVoD/WVNjtzzXNjE5BZdmk1XmEwM5NvG6rxoj4/mxffhx6EQDRlEIMEYIy8TOsjN08tsDC42Q5/fEVhU7AwuHcWjmMeIJIK+CpeMPR++/DzK5o1XiUBuuqiPdYc3qECQhK4j98djGinioAZN1CghSOhE3kfoGyiTUQpkT+/XiKMJwQnqMC5/c+Ul7RmZ0axlOPrCfUqQuBpO0Cidk7Cip3BnhQ7DaIM+Mz4JQSEUKQaIi+q1FM5XCKF9gvWOtdCXPGFuntxpCHuUPlyg3Gs2fLAFklJpR3tQ5TWPFBY98UHxkRrlReCehn+WxfiTcJMGK7jfTMH/mnIM4pQFRRrEQyct1lxVOEsSEHJ8xxwfiTa5JFsK/BzyLoqsblVyB7PZiwMCUPItTT8+BXyYiksvhf16kI1lK1Wiz1xFXBnWE3PehviIbOXDued0s6qAV9/di45esPpja8NUeUlVZqsHIUXkUxCNqoWItdBurarhZlibUdBeVVysyCDObI7pScYMOvQX0/6FsF5x22hrtLBcpJR9zLdp/TGCDcf9egzvpDFE9LCQIwUekIbtidsDpduVTJuXKXGlimQlVOI/EC3YLVtUWY6QFCbSmAt7DDF7Rdd4WSyZ+nSc8eIGTw1+4ozLUTl/qOgpsqv8m2uSw3a5mLMqPohr2LV6iJYW0AXofCaTifoOvhi16ddZgfxFn2JMDQ1uiBDz+7TKnqlDo0aU5EBrwdQ9cBW+GJmomeKVRBtSM7p6u/YxN5DurovkPYvgvDMvfiwiZdy8gOaetSrSoUhGy+VBr9S3uGzujW8GQFInKyaI2b7VSleXCrSshbNySIs55C817WAH6XORLaUk8Xx4VK4iz6Ag1ypbjeI1msUO7LWgbavvV0lJ6AbfB1FqiJfzCM0Z2e0G/5y2LYw4OwzM436bkntmEiL6l4QcLlDnO/KHnb8zKfG/24lfQlLHTcM1RObgA/crMtgXko2XB/M+fIlFZdxUuqzRwy7Uixgz43iDGEbcEq+Qoq/PMdM5MMwjI5ulplwDlXQTmb6l0kDeN+Jejcj7XVc2u05BP4a7InxAnNT8L87JQM/2hU7JBkQGf1Yl+vpcd6v6qyG0Uj0arj2VqwH24XTX4Dz+wi1A689TBE3PVtNhVRG0wpxnWYopztvllB0GYqopS+wB5CB9jW4di3w6FakGF2NEZeWR6sBNi1y9xy+jyS5wPXabtCp415O4XZ9MwAfM4KWkz1CrDPs3L1+IzkVd6yKM0WdsBDLluuGGssdCsMIpBwGziGJh6ns0KhQTFVnF9fjNNmoExu6Rj8+CamgEFbUS1ECRQ6exJ9ozzq7fkgYPrX224lB9QV3b03SsKO7eSEPm3EHW8cCh0bhs+C2PLPTivTV1BbTaNfYoaHq/jWI2vIFa6I1RMuUBLJJj2PzYgdggnuVli5wtgRx5i+9VbjgFZeUonFNIsZeTOexHYph8REeGIZvM3EqmVR0xrl21Bbez1TAJ1oTBNJBDrx0d0U6Y9kxRvHecxTpLPMqnj0M1XhlA+3AGXsxoyJblcDIfPX3Wgml8ISpjDcTGlK1p0Y/iyvB0vrs8115my6ao0yMRD4CtwMQTrqV5Mhm0FTkUobkdSgAXHbe0wwQVGkbsYXH8mkS+D1kUjt3Mvbnm54ZymsrW2IpFpLePSyihKuVoCKA9K4sGVjRYxIONXF7XSE1VZNquh45gA9XXv04+XDSNV84e8n3h1LzNI6gnZmiHpmMONFdNFy50B5nNR61vqhB9R+LeCAXp9+YSnb6hvKQYfIlNhVH2FOEDSEOEV1mbOK8Be60RU77skqw4wtYxiwIe/0vxj15zLiukjNOc333qOmOtcgrDI9QkLP0Dnlf3xz/4h4SiUFPHFEJu5pv0LNmAX3hf2nTaqpTcBovPS1+X/gVPs+3JdtK7rfaHr973nm1QPhjVhpq8Z4nUrl31KT22TDh5kFW6ROSaBj5p8NbezN44NV8QNxkq5nLuV6XiQF9P3NZs2AJVSwkmc0gLb1WVwa0F8wPb0PS2EtTFWicIB5+xd84vjpg8zoLdsO94qymYz6n6ILHX54cw9G5Y3ubMbJCWNdpGlKe1OZ64WtULQ5n+0cK3hT4laB5SMcjI29vbvRasz3SB/3PNGB3yq05zZdf4XqsI8dQlaMogJldl76RvhVnPiDIXA6l72hNFK0Rbc4aDzU/F/yeM3r6ggeu9tqOEHV1T9LiuEZXDLefMcy0FNlJ+aQKfLoDcEXXZzFPV/ZLae2Occf89xcZuRYIGW1zqFq880ZgUyQsJWmsZlTBCyi3C4AouYHy9olXaZUl9XwTyRoIoL0ykbp4W2VSw3x4dJ9S15B5P0wqxcLiyahSt4Ve558plp1Z9X01hFZpw9ydaFIN8oeS3VxNWNPouMuKsTB/WzSK0xS817CpiuOd1nq7/1Oi8HseOk7dSOq2xJEqr68RuMpTQEnRPfV6DpeaWpQXF4s7ANFESyPAt1tLXzTtfEP+yfbdIRyPtUWL0tufzd516b6dL7HcLV2GuTzSFCx1Co1H41DuDk4araN6OgqqaBVFd7hhBSmYoccoXw3Qcz7OOSHxrg8Bjo4hOwSLSR6bdtdizTafuGsFWFtm9O67wapFwH9cnuYg4uWZkk9xT1JQyJM7DMzvumqii0PEC74WKIDC6YJi7bDpnXqR8UhBUt0C0VkV1Hg3frF50MBv5TMQbF5C0vcIRcSrvGXlBVM0+4M+b6yxcvgBM2uAKI5jZBvFVJi9pLR9kpaRZKC8GuQ38iPgrfKeKBSPFGAx0aRJbjGOFAkYSaqYksPSmjbRhA1AZ3smRBqAC3bDq7Lm1dEgSn87pSq3UajabvtvedDE7hqK+eW6vgmORB6F3/FGjAxjHprWbsFaubwllD3V/sckYDf+7HimqFmIKcnV8lcG13ExVqA7XZ2+pQ1or++rsmb3tgQvIdQJNSc2ZvkuN88KhDj7Vo6wiwhzrMNbJ03qJIICaSF3ekcB6ZqxiynCQy30fZlTYSbAplWfxN4hHkGI2him3tUceZkB6y6cbDMc8912MtWl3jm6jkpcBwrxSHDuEB4SRQ2lhNqQWZhIzVCfANcNGjfeJAMzmEPpUmYdWSORLKv2TM1ZRciu0e5ONyOpLvPzMWrcowSnRun3Ti01cKGcwk0rHDRGNHuj6ep2yX11Xc3jaI4Tol5fV7B2c7p80ymoO15TVPN9zZTXu6T9TVc1q0PJPVFKjhS0dpTT6cVfRzADh2PDWGZc+wdfOGI9MyGIbJGJFwK1shXzxJsNgVa3R0EIo77YJCP5LIc66Qpy93X2pw/m3AZVm/P+xLLU57v2Z89WiNQB47eKuXbMOYN3g8VqAXRjiB9dhmonEMfwyynK2SPIKbRLkmJPgtq2BozO/xb+9L6uPCbVmlaaVufztJqNsPAYCV3upYrByzhstBaSkKrjHHY4WYCJgZBoSOwkjuQ2GiwpUFFPuPoqq399RUN5bRBzDvQzZcOWU0QJBnqhaJnQuFAoIk2DyL4vgYbbDKNb/6PnxEWP91+rlFvQ0TFfSKeLrunA1ZBy8swYofMOFdVote4Iq80gst1VMHoOCLso5wlQxE6kpOlyauyz99OARzURQsZgP03k+fF1OJrYirIyRSHUBMdaYYYgYnZAqlliCqW0LNlo1s87QnrnfwO7Hq8RCs2pVFiY2Q0qICWdbK1Y1z0cfl3Ohr7pt5MExSEVkz9pokgvWlzBIgdnfZo+62NIsC2PRSZsi1yw9NCwdLm6z7lyBWxxQHqA6Pzroq+hzMTE14MBWqKn8jMBt63ospq4baebgvxTdDqvsLgp3Uf0uwtvn06B/XbMhF/eMztDNiW/3ZvmiRqwuQlsRpXy5LKcUqSLyfbJcyxFRLo7bDVOOOu7KmrxLQP7lijMfQwJmA9VDkJFc5F4sp9NVlSXawEY8FTK0haAbZXf1EdcLA0aYcqE4qgOvxTGf6vkadc66YQiWual7kErpyJRsK5o/u6ZjTMFhjTGaxleNsOPVb19zTKajslZBvQyFxsXChSCkjjk91o5bX9URUtorc5Fw94S+ehrTBUEZUoHn2QsUX6UsfEP0pqQ6I/R4KxVKcFqVQKUpmjNiR06uMRpsW0y6E+rkK/bba0dsvrx4orNvHqgREBqSylwjMk0wFLtUlrABSDuDPr1aTabooVvkhkJpY5SdUgiFuVHf5YCFjicTIb4+coO2EoozKDaPGK2yaahwOPiiMWrTO6EInqjNi6hpAWkzYdZsUxpGSomu6JxhrNdcckUMNjpP/3aZLf9MbGt3t0S5P6h73PWx7TrvU61L6eALDrlG4zu790jrwgeMzNF3nGwOdmqzHeN87GJmj9T5j3r4mmeuP/MNSenbiATVMyuvj0IepVrGcvOE9Simv52+ABgNdJq5CEunbVsBhBX+HvfbPN2+ND9eZ96qiM+FYq2rCfEmygcVDykV19SUrS+nmEvlO8MAcJecXJPijxYjYG/qpFUFE6FYWik3A5qrLy/c6kLydlZy0TWMgwM2u4hWV5NCF55gZDieY5NVwmd7/CPoLo1XUr0AfWo46gO1y0mOWGdMN/fHFPVwq0sC5OkSjvj4gBct/YNdZzJKNYtf3HJSfDvPiPEbliCZ5ysFO0+BiU+CaqJ1itUg7cQ5lg4nihzbULVuYE+rJdquGVZ5fyVrMaW29bdCs1cz1rLjJnuA/ZsHvLJgWlToqyZP/q//6wm/xpN3758Ev8ZKTPjBHZd6mEIz+Fnb5+AtweAsaKLIhQJ7BETdNL3JptHNC5Sq+V17gwMT02HJRByGvq3pQcWv5GxWA+VCo0EL0+9dJIqCQLgVLNQoL/bh/WuKNVHTZaompq8GRtsXN6DGbsAtlFXgibhwtWFqcfSbNhrzRQ72GNaPaCUkEyKnDe1IPmmG1tLLFENw2RggLE1zHQ+XddO/qtPbbKj9ax9FI2B0H+f/tfmiawDANZcB8E69ey4uXh3bEPQbHTeYNK6F0Ang2k41FIjxP0qZI8pNIJ3MEMq2uLY6DHwt6ugqs1jzsnYLKc+EyB8O2FDYjlgRbtfKMhfhWWEHXxtzoowXwF63rNVmh6HoBY+FJrpLUlOikfb82sicS7APi8TjDKti8CYTstO+qOpKCYg6STKVN9Wam9wKWd0RQkJ8arSpl5Vv4qNEhIc+tpZvpnTO5NRRpVffBYctyrMV4qvR8fFZ9i/zTFDCzJ2iW6STNabvpxzrHUK3zVgKz1390F+kGoweECfF/4tXg+Gzn3dZQWEC3Is/RZA1pbw1Iv+bEfX/xzpZf379svN4kTxkCd3uVyctlxTEYizrBqGcJJu86t5AtTwKexjGlTgjoUy2Jo6MnGNgkE7DMJUzAx4YYlhTk6cw+yBCWyO8uR2/eWO9mFq1YoawVKoCWhmQZhi4OdxPUyLY6HjHCynOmiPhH2WKjFspljtK+PGcx6mjokBm29xTGHBN0QpZ9xzHr3WlgqoVAVGOPjbY0YLpaB3bgb12kcpAQvS52D2yVl6/v3j73fD6/dnbq9dn1xfv3g5f/P7t2ZuL8+H5u7fXL393baqsaQPbAWNTGNhdlBgL88hQLSPPXmcF20UQLz4PEmIjFQDeLNwIpzKj6MMoU059x45hYm/UYW3RD2gngnVf14+cDoLSpfeIv4nixD1FXjeNStXmrPPy2qEXv6SAsHF/xALD9+2xdOrF/RZaeDqEVEQNhn6PKBSQ6yilnxlXIV65FEgwhS3YjYZv/e71xatXHqdLURFh4N9kVDY5SRK3tH/Qy7M7gZncLSceIWJwWIwuYGCbCyVbojRClgmpSyPC1f08R3a5VNpye+of46n8Gd1/zKXzUTeHrtKgKsW2jEyvuVFc9BIcbnIJmgi14OBxbZztxAh2SVk1DonCU20Vd1o7r2JqY39bVNsd4BO4tJlqtOblfBlkX6OPC/ZTwdDSP65JndXkXgzi0FuOefETAvrUHybgFoapiTn28ffbpbrR9ZObnTlqUqHQYG5UFt1zV4LeiuKs7ZuZqgEekvxLY7qiKcQdqiOl2rFF5iJWgkUhvAi180R0eppbghcGvfTJjJDOD4i+yBdm6eAmrSvUInanVf4filiVTVz+vhy5Bg1/wviL2sBIEyVMLf4XlreuWVnpk5pcx4RlPJIN7rXSwOhMJE8InIlwiOHv3rx+f3k+fIXiAhEcT8ihu8W+ZL0OwehspliQ0GAXSLCJFJV3y4tP6TQfC3I9aDbUfCs2NxFJKC6hJk2tvLVEaKaGS/Z2wbDQ7RESlGZEmgFzzhGlkrlOQ+THggNbt93X9S0XXHsxgQTL4aQDyUR7WB9REPig2eg09uJ3+eQueQ8XXsspOCeOtfj/O+3Z9ZshmlIWBH56amVDLyo2PcRho4K+Bo288Es4Evmg+Fm7+M4ZqgXiQWQrUgp+x42xtBCyK+9jJYLJbZsa0XxBBcwEPwPhrhkboqeK9lCx4cdgKfY3ip1f4jVxWPiP2YOLV4PLx4mLJ8xiuqiWoy5T2af6VsCdNPQwKqd4dNkd1XJeId/rjrSH3vhGTTP6oGXzSZE1ZCO5VgGugI+xOgabBjVBeyli3vSTWCUbOXJ4L/1hiZ+uzhC1sdBqdLif0RfetCYxKNIhI7MV1utxXK/LSUPyODajU5W2ggTWKGxQoLvBokkrdglz36EUYb1u0meKqKZjuP3o2qV1M6ANbty3FlK+YMKrO99pSE8nFa6rzyCDlWK3YJSe+/CwAao2Z1tltHymN+51Vsz9iQDtSUPU+BesnisrKf3iXcZvcLY1XqUZa3qvFBe9VQun5nnPlbr//WTxK09BRv/2Z0Rl/rqVlpGMJ0VFG4K5XBnQ6NMaeCCctKHB4lasJGCELm4TqPW+6E0qHpf4sjv62JRsnI8lt1DPy+IRpZoNWIyABAgEY7hbWPEQlALj9FQqRgtHYBmQ/h1+fbtvsc9XsFft2na3IQPEJ14k3OO2HTWbpHmhBmwhDihsW/IKrxFKS6z9hc/qTOX0dGpyQ2CCewiek3YZGHUbV/gazEQqkUETHJdcDDI4uqLNc2oap1+AuWOXusA6UdGx+uyEp0YKGnlmrtGg2zwHtpIlchXOqn3U59YtuEvZv5cEkUXHPe5SPOJ9cYIUWaORuE8nrR0JV9x88NkqpW4kcY89ffOZo6n47s11OL21Fb1rS83DtVQ+HHz+bz02D/QLuqtEaSt6YDWO32e6VpSUkgNQpwV4qD8GgBE79mVVfn4gd2xZqEOBlvrjawi16akpXxyBumU/hq9r4dPYFn4d01hNYWA7wxGqQ0Ewgn2oTZH5CgPjJjDsovrdZsA4J2qRtr23hrm5F7tj6PK5OxUOhyKF+AwdVDDI3MohZxKp9jlkg+wkIFKTYIw3vZw3zaKW+1zrxlNIsmvKoLa3vJA17XfQOUwLpcHWxqn+IaGTFaylAlMChRpw1nn2cpYtTHSiFg8LHkKqcXuTYsGWx4oTE6zVcTSuv9oeINnzm6t3b13ZEcXQOJbieWGUZFxoj7V9cId/1MyK2CzCBImMPi+avTnj0zNR35BUxTgCEbyqo3DW5rEVegRhB9kGc8etbasexHzvslZ+TwONLRpG1Qw5thkZ57CK7VRd44Fj7kLSMC0k/lUS2gomn3bxnKehryvE+2iqInhjdAdOz8g2+I3PQhdZg2G2ATY6qPA/qIkQjzdzthqbyzZ6YsN/6xldyFmkcp8Z1ggM6Q2Gee2KB1iV+VJe2hubd7mjXivzJdlWHM+Qjjs2oKFNBU5Peawh6MrgGcNG5LCxRnqvScWJ4K2bF5pjqi1oCl9n1GD3qQRP29j5qGRGMJ0WWLMMoURDXPjGpMFRF507ppgIZINgxlwwYOd8in7HeDjCEbZrvfzQawIDoZpUFEjxwMExzl8oX1gPl446V9XI9TjX3DWdZHsnuHqvajp3rK3uMrqulPbiODhK8XM+uzmcaioGwgY7nr4CI3AbhK0D2gBF7DZUIylOVcVvrL3J1VoITiBkZKdjIYI/c6An13hEg9DNCHXX6fFNozS7fa+35eI8LYQvDZm8J5J3ZK9P8rtUGeHheBRMcWXvnh8p5ng3ZnRpOUB5dmTXIVR03ldXc9L6nS1mVP3pLB+b6XGOTmSFbNOJ6PhWAXYYoHBGEIHucYaWOPnQbkJwPQ59QrudUu5gh2cz3RDmoyqpEB220upam7Yjp55qHWeNNKGpbYyOLSsddvBD4suwwYPw58RmQnuO2GOTpDSeIxhXPbXZvuhZwaJ3Ft21GwmnphIIZXqVIdVcTreCrVRWbasCNiZKBC5WmExletAFYYQaibixVShlQUw+0sosdqG8/73l/VOSodanaApKTZ0oGoibO6Lv9+V5OkP9tihVKZPU09yImQCnn2jCGOevEdZIzR+UZZCBec3V2eSRiqSOnt2ox//nToMlBAchPUSc1CXMB65oxlKb5BUC8/mM1faideWkNC05kuDn6vhkEP9hJXEL5/wuGz8u/BF/29VgU9NXmjIYOAVXZMshCCT+dJ85BHR4NJ8yFgFVlDJcYACPUoSuyfo4m+afKKVmfrqG2hI3hjp2Y3SP0YcOsRCAVHwWzaOMFT7TlZ8UVO7tNL33R6A3MsGaXlLP86JABOtobTRqvH47RPt1DFBhbsPg5kUdUqm3g34QuxktN/rGFy82QKX4CLDYAiqp2Dhx3Ly4XoTkQ9lHDhZJAr+XN2pdZDa0GpmAUXiMcsOnMbVpnUwISiYkmYPd3d31R8DteTntQqjAG9+yJIhnnANqNFIGKGIXQV3van0bV6eycBoBhUW+QDqpAvyql5/nUzAsqmQwiO8SHFa0pCST6iqFPrx/vU5srKEKOjrtMcHEn8UV9OgW3M8PHFeQf/zPRBa0ntnkb5EwaLB72GQMwla+1piDP/liFyWd8xSCYWLWptz9r8RQ+4VXaDNeoYP9vQ14hX5hZfmbYmVh8qQ9OU/UzWN972Q4Om+o78e1/WZImbRiyChb0gBPL2WiwgbFvujMc3l8B59hIQP2Y3I+kVuc7eT3UscmXqPGnWbsMmMmTwmSCaCYjnx5aJSA6Ohkf1f5h47W93nkvUQj21dce7vkjsxVLqwJQ21fcFoCgnSH90R8Ih6lmTiO0RRoR6qks5DJ+JdHHfwJ7Rlqo5VmpjhdjvOSxDLWvJbSRkYrF6KPXM2aHsXrB+YcI++5I44C5WLNJnARQUAsqTeMsKo2D3t0goNHTzC47bwEAc5VfVy0bJpVsMGjN6tYfoNEu/UM4QEcaGd5iweDSkAvHNyizdD2Zdw5hHATHJs9qt4dQk8EXSpKg/KfPHBXk2X891EqZNOuWIilpLZiuXiRcISlsUiPrhPjaCM+lPeEHiPSg5bPWeGHu8ln+u/558i+HG7KVPaF9WGHGzQ0OaONhvFoX12rFQm0GZJh/ZNy5COCRDOLLSql/ehsvGBco2b/Brhxdc6rBFk7LG26KcWc0UWR3KZKcZoKTIJaZnaFmzbLC5kCNsvsj52zRMjTGt1hNojXCHzGIs2ntbvRm4iwQydju2O1jVRZVtTLKnPnCsMHDDP0cXPXwLhBnC1U2WRiJsRaq9yB2OZBO6R2Fewcrmw/0e2RLue6h3KhG2qRmT++/64Bnw6eHC/KbD+ZcFaYCcMoCOJNJHov1lprS7qyVwft3BWnkm4eHPtVaiwhPhLUf5zTAa46Kjr4aqqOToQLYZfHS98cm99HCN3bGMC6nH6SEbSdeeNq44Vm2C8zUBAixgzdKvIOXqNTB4aIcjRieWu+ymbfbM/Kr3bgf6X3G7zYh48VapzUhN7BBhhhWFO0JsbyF7W2o0EGPRhg+ZHG6QBEhM01kX28tfc+4OMIri0tAcgV/DGm7ZrNj5qEImheLRZg1HbZUvu25rFpLyQBmJnFmeJFf3P2O5m5z5aJJxfRuBtZCI3AcqoSrTYlryIVvMPjauvQ93fdG5jEjAp8weC0Aarg3eO4kPhxt5hhhnMZ0rI2apw3sb230mqFbU8sHAKZ1pn65NsLJl/dzIKagrt2P7ngHVcyl3fKRnbN+fkMZg1oyBrxPozXSVDT3NFF80gLBIFsPByY2cDjgT2CwhhxhfmwaV4bb4XHEEswHORFSYsERx/NQY+3MxOCTcCTcUv4QDL0Xa00kcJvJd9V6Se8oq9A+teNILsH7QUlVtZIVWO9tEykCDLAtYnulFhw4p/Lbsm/mVP5HwIZGooTL06VZwhnn48JMEIvglA/EhN+o1ob4LQTbUJeRPwRVGOtDF7mO5FGfzTnXmyh76mOOcM3Y/VGJsfCjCfeHEe+QoWVaE2Z4mTlmPSuMNzfmoziRaM7sZan1Fc7KF3fZ/GejLiNcZRJDiLel3GVEJL6p54ff4hpmh7tZY+6hKYYzhy6DE7P0ZQIyVvl6dQQMwWLFX35jfkQU1jCScOqpGunZRuurhL5Yq1VInVLY7nDelbdVlo1limle+fB8PLKymgG6ethCOwsbsgU5HMQyXzHeDnSHZiyc0pf6NfkTVefUA98Ig5NmroeBLNO9ajKpCWoSfxZ16CDClea7Gq7BM82EGFSJ5xAmMBbd62agkoNSH/PomdmFdOilesYCLNoxSdKlrssuBvN2DZ4m02HeLBpo4biVzx99qTRqwteBMEovEmxyW3qHTQnRweLO/NeIufu6GF4zvZoz5duxifjSsHL5IAbujUk7MHuftJ7C4OcLRd3sLQ/ZuMeV44aiImzhnkr8IyO+Bn0/AM3bvC6Gxm/zhxt1DExnpd50zxQiott5Oj64GrwVsijpmJWfc52UE2+QOKyUW0XpuW0STMlaJy6rznNj6KMLSiHBiPZa4+vF5ThkI55TmlS2Ezmd6Mqx4y89ZmUVztAeT+t+378cNBz4fbA6ImHb7XySRF1+z5zNYJGPNw8GIao7J5Ha8tVNx1dnblplISDcMyy4Q42a+DHqyihxN1qm7mmtA4dwOXkbiX307+u/eQ14TGuhJu5eV4N7KC9M6O7sqwVHiDmMDdRqO9YIxbjpin0WAgSal9sAd6q9FcS01k+TSuuAJjIFcawEAZYFlnh0/JTRJtyp9ZIgK1kFPaDtMojqdbcAnXoI93NeUSXudF8zac8u48Y/q6K3luyTy44Qn9WTQjg9FI/eaLgOLooropNDlZar3BYWvaDHJcFKFEQs4Lm4COJKEcH8Hd5FCYnjijDvTUGVOjl/cXedzW64RDRDUfbB38GuGH/dHD0qEZIxwfHFtwgT/+ZsA0rU5B/i7CG4/0mqkFESlOYS22wlFfEs6C/oBY264Z0cLQBauHfZDKXc/+wYPdlKQuf9W0Lomj2fx+2wOZbvqrnafHNG/Ozr3boT01EwMoHdXRQ2sO8+/wbyhz8/X8+2Rsc/QoPLP3j8a8UKjBLP2bEEGk7XVbLgjIkD2FXpayvMxCiaFZTX6XJXZXdfu2FWVmNkWWnJokm3ed2zAvs9L4xy/DVTipUonYgIxR7WKX1da8omU8GfgyWH/5qWxu5Hnzzj6Bwo6xvYfgJ3adIxgs7IuYYDtgCvV7l6AJuJSTjsBpaheYzPQHw3y/TOqBrTDzyK+iPuGXJpQhX6XSmGe0fs2xee4ylbxUrliLVb6KgwRMtYWPz8yvqb0W8NGxNSb8seh53rOJTnntz1/xc5GZefKJo4wP3nqL7KpfoBux1+oNbLyqSdxLTLkzB7ac1iJgqO7xddmLDldy9EqdQ75lilGd107A7CLPPmlP1w72EDSpqVuO89XN4qVnJVHLwQu1ng+VZM+I0cz/eDr5nryXRM9GF0PjhVKbPJFqVGWVLSnvgl6dyPt1BdCd85x/QRRnm468Hg8HR86Pn7TNupvJtWeLq13jmzVLHRzve3d1dOdo1RTffUxnTXT5HWteNBj56PjheOfDV8sbJoM3mevT8YH/lkJeSkT4jG2PDQU8ODtYtgJY22wHluM2/ec3LzdxOWLtkdtc7YAthbCjGrUOB8ukfwBHKpPBacJOR6R4dHe8+32vNlkuOb4PzGJtD7MENwfiBcNcXQgcU3pFXGKxYZHN0fel/c/M1YiMUNwjDf40Oe3flfAuUCFoEyaSkXF6H+N4JSOt3pOIW2Yv/iHyfO12abWflJgbX8w2BjkiRSCJ4LlKAvRBuGAtf3hJOMimaQKmrNLvZ7BvpPJ//COqec5tB0IB/g9Jjzo2VXaMEsDzShXWHYHkQwh5QvYIi8Yw19KJ9kXkP3ISNah/ovCmLi3+RazBt6IHwd65nxlFEr8stqVW3k9wvHozq2ULO5qYC4nOE5vKyNmumfRep8o1AB1vrdhhuynJW7yzKeT7qw5NCZb/xNpqgynLWOMcvxM41x5dMG/GQmrclGBcBy3VbbRAPzD6HAOXdEf5IKEciHKAFeLRVAmtdTjLaRxcyiESblQKwI0YirX+3TDZCyV/ouHZtxXxZgfleR5Y9WJLzN1dyXSjBYhb6TV7ks+XMNzPRnsk0Y5mW34TORSd7Rc4YQW4cGaBtk+L7epB14v0bXy6atdQoR/4aryPlpHQHBr+y0V79RWQT7C/2MLcf/qJjb/wvjlrK4wcxmSQ7QvF64sIRg2hrxTHljgFU9ZJ6U1z2Joau3Tt4PhB47cH2YKAp0dVoSVM7wuqJymqM/UVhUYZPaCbGTJk/8KVHYbMcF9mh+WyI95VqGtL0RJ1PBVhMX9Zod4Qfg+KM9yCgD5WUP/xWZSIBsZRRkMkQhA4efJqJsBigRvwhL8ZoLBOFaBXLsoWLHfLW6UtScWe7tVsYTUQOcnx8NPe5hi3x0hGhEjPILdalIu8QbDJJS5OxwVsxx0DjIkMKelzPyzLnItsrhOlgeUgz02yJZWYiMOwhUakMJ3h/+7keI3YFn9RUZE/lvLMAaNM4EkphbTSWDCS7gpRbNacNHFGzLjH5cbKsKoVdzyxBAgY9SP1hQWUcXfT1kYjkYPfABiMsU5VCklwBGbtp2K6DWh3lSrCMuU3sbuGA9dG7tSmOHOtBKq5T0wAJYjikMwbVAHPvo6w2KVw4BQG4XwhBFDOnhsuXnM1GNhzjQyeOXIBX0GWDwLGd42Fcf9Hs/r7N7nmt/Z66HgEapVZSHJbPeDXyeR5FfdFqu4xtAlZ77xZXvMcL/7/+Z/CKXTLFIdKdzScSlmPnDL9GFJaRpWYoF56RVdNjfrNEIdnJlYhD/JpbPdgaeMQ3wvXmGZQ3ZIfjqHSv0nnOs6XWoc4Rwu9GCFpoPQJUTS88AJuuD1ln58nZCKVCORZwmHi+8U0ZNNXdG+4Y6ikiOn64JudrclquFNgm/Gal8b1MTEJUD9nbbTm0JZzB8A/ZYrRBVUBrMgJfjDxZgmxsbc3SImdqbz5wYDZudH10yq6LIp+PJruiwk9aie2Vg9cSamD2kupB7iEyPto6WXipqf2WoGQ1+BU86qJAqY8DrFdB27uRWfLJwx01KDKbRDVKhNxW/Cd4D1MVBv+D7RBBfJWcMAzgdfQsO6mzIp0+LPJRbUrpkd/MmX4OpG7gPBpzU+rZadjPjc+GvkFRYmPpz26GO/4DtsCDVhYo/pBuMLvn4mJ2Ebmg3aGDGJ+TL5KnjJBKXbzB9esazaZDefIQxhzKmMM5RRrDPlDPNjuM6QPZ2hOxSxb5YtqqfW41EWcwgURCtTonFF2MvsgWTpc5FefFnB47CRykrT111fWS2OCIjOmkWKXMt0rUnvfT6IbGRtQCbHcHK3S3bFbYHqfxQ5HO8hHylGHRzSNqd9b1nuXSzbG+Q2+e5pSA70nqnHyDTyViwWS1vW5towTMc/TIIBmzxi38CeFKM4TodlpBUfL/Uum8MsLCzuYk/Qiaxp1/lenCN25RACRuXeQ+hUJ2ROz05Am/e/cq6SeRIGWNPVpQPrMwXnnKCbEt5m+Mvta3nddUpeNMGJXzMKCNGbRWc9nVKBVluWd/myuHRPjXo6wAqVcmFy/qyIipIgDpRDaiWNq7AvP90u6FQ1EKCWTqeE/H2SS3eVTJMa8pYixccRHRklp5fimFqg1r8AcfnmpXjjwu8wj219L3B8Z0gHA0TjNP/95YJ9dDZd4817LIcuoU7uh/yIY6s9gxcUbpfeM3D+pLxKuWG+6V8km3u3ggctPGy1eTQYhVtbseBszYL3exfCrHl8cdMdjaPP1g+yT+uE0doDY9LnhElLRBsZl5Jj4kKsWgNzi9vVAG+dhIZC1/c+WbO+hW2AP2L//3/+P5t/FfXpLAXLtHkYkzbLdlSuWorGHBCwGCGf8uL5RxyGuQFLZ+Rr3CG0o2vs4btgVXb93YTDiX76jPBO3qC7BL67u23Rg+buP2xz9t376DaPviLku8UVroe+O5GBq+sC6vVuTdkLEqjJcblgZ3tMAQfJW9KOcqJYhzmns3RI4VHhlvioBvkBNX/S2Cc9lLFsXPaMAleYcbmWyxlKUMKZ2KvI2giF8X9JD7wUDvqK2FgQKrfALMubjRNZGLUs+cQHB6+geTWlkdBBScWzVKx+VlOiGalL6nZAoSn53y3Etb7peySY/bIKQJ34p/YZF+zISqXuJHLNlEDDA8UUyc7DNRhsY8ICr/dgE2bufYKuxs/jBoBGMESyS+dt0RX+O8qQbtUge7UDtk3QkgnDWm70Mkp4aR5Fidr23A3dglIYfzfg0h6mVOQ4wvG7nNi006HoPWiPIJOJ8QvrPeOXYAiN5rYuMCA7jXtqnhAGQ5YkaFSDooy7ZjN7aygXRSaVxzY7xHmNjekU9pl3ATiNCZiX5j6pJsbwK00G+42QYBLygEKv5X5KFIIyQqCRdUKBWdcWzuBhp+9mhxQ8Evj0p2irEqm6F3W4k8c+x5deYjt6ydH7WYK0SmPrG2EUt3WNDSXXm23N3iK+4YeCZcpjdEw3qIfoCxQ4i/A/F4pQ8wRoiBum2UovTRinvKgCu9W1dsm4AEQjhwK6R9Dbfcf8MRwJO+xYTxw+ymnHZX0Hb1yAqpTloYbLEdHK0SS4Wmg81Ww/N2FPJDrLGh5G1/OH/zGsU2PDMdtc5IKw8Fp6wc0XUyfSUCABv7UureOn7d6EzXlbp49gSpo1CHjsMbAbwWNS1zvXh7lKRCvc503ogkudME1nPpBR2KWX9atCELGxjaDAStIXXGuFNAtIi4+TzjMntI/ip+S2YupLbuag9rJ0I/YW4Rtm4GKiIwttnHGC6sOh6NUTodLS3NDTuFrEabeZkmgb7S+tCGYjGEBjmN6tVGieVy0S9v+6SR9HL2qGyJ4ir+olMfUlbDq09ATxsk+ADBRvvguOmxEZb2BW5Hwwyuq1kSuVHbK71E0u1LxZHvRNEkEuogeLBka6Osoi6pYjxqnJ47bLnWAywZhuQYSj6m+QzPHkIWCoWiQJYM4WeSuq1PT9FY4eVeDEWBDvVmPH220VpPuDEerHSjBXPXSrsae0NvPRYGCmmpENEllN1esyGb3VGsGIbpsLmjW6juReP6566RRzQEs+4qslFNFepyIP2ltu/GCtvWDlFYwYWDPLV/aOyuf9GQq8JH7yigxyFyPFr20NL+2LnwmgRFSxtOKPlN+im9opGpwyBSFrtKW+diSenp9h9JcbYWlw+yD7qrbuUjbQ6Zz5BckQhioElMjTyiyZBd0RrBwfDSs4xoYjGxI1bLTebOfgQB88Z9vxHqNcr2ZGOqm2BV4Q4t0s8+nuRCy4gIpau0EVk7czozDSR82IM1JyJ/REppSa445oLwJOoCPhnM8s3HNV47SEQ0yD0EZ7G+84AGLNITO8fIXox6sJKmpsXMOk6HII+2Gg09uoYDExHbeG6+90EnLsB7mG+wTC6Vce56BRrzntpb1LFoSJuqIwxYbsAvbCivnbdExGzYUfVFA2XRS8ZVOe9jqY+rzN8gotz9dG9ba7Fmqw+UkI1idak+89KTXT/yeVw1Kc808tPhzISEmlfffdM3HUcXQNp2sAcpDP60K/rPEgPy6YamK7aClt1idxvpmFn6wAUQnengDcYP7SOvM9XUaNCFtDjRkdsa3kh4EDJlU3cUPhtMwfmO5JJ7Zw+7CPKM2om7zYRsIzDqlklLP3o6MJp8veYFL1uqzYNSY+8U6xOHFdSm+gC2B9wXkHZoZVymD5eeh2HFAuE0Xn4ij+88nWIdHjwmHyE7ES1U1D4MRAFy2WNYEuvRY+XdEUVxvP38ixiHtMPSsigyLAdCS9t2W0L86hM2NK+52zT8GwFZQuRiMJVOcis7mzcYeSRnwKiVkaoVaThlNpyBXBTQ2swFNO9s6o0Iq+DjuF5giXRCf/VGKjc8p8AmV7/1FqzR2GTHJ42JMIMjGdapCEu1N7Fku6PNDXJPe6yI6LNg743saAEbcc8MDIo6RPXx9oC2HNt1R5taszfXFHG8HC6myspdfJXIIOSNgtk5YzxGxqqT/R38SPkjOUBru6WZQc7Q+JpQIRI5cmTdaQq9ud1RqMTMsbxhSaoBL5IZEygWTodERqH7LEFj79GSW+0DUxgtBQ97Kr1ixcSB9y0WO3f4jh1xfwXzgHoimpBbi10RP82rf3aZpFydcCtFbFCw033iiXK3TyTMD4NTJuCJXMKSFYWsRMccfQYF+01Y34kaRqXTPiXVzVnftN02j6+Zce0A4e+t1AWwoTErWySLm6kdH7dVMIy1xYThvMEGB2+KBD7e2NG9WGUwUK0GHIn3FsMjTondV8fS7gTXalTvaqspqKkTkQSCHCTR9MFpOY7G50jOhiaqV4PygTcT3HTgcK+fgLMYiL6QqXZF2tLht3FbafDlA9QknuZZ0VFk30xUU5Y6dn6CoDp5vQ3Xm+bk5Y6tcWgAxCjxpMgUW6Ubee73GhULFrSHTY57LOoC9ADxdZuDJSvvk0Eya3OnA827mlrRyl7rd9OrsytwHnUFKAODAYIlJS+oQjsm0JvRjHbyKNC3DtyaK9mOeVMTE5FSDB4uJiAbjg5aUKhrK3E0aZ27XJ1mbCcErazI8/KRQuuFO6hWC9cNmRgIQfdUIO4/SZ1fHI7GErHnlQ4ueAWW9YLr93qdD+ZsLR2/lO5EA3ebZw2psSql1PCjbLbdJ6fWJqb4CwJIR72ej53+1lxLlx7vfUu+EVodZzclriVDFskVU4MmvoS4BpFq5A41jZ4nHj+c5ZDRiJQzC2LX+luxdnyuMi9aUS7hvNO6eu8rxG2XtdnEyG1FanAWUO0r45nQXOYmusOKBOX8MjoTzjJhHATHJDAbT0vdiq2bwf5ASF0maAYxNaS1+YMGlZvo2pY84wVrGi4E5OOLHDdZ0ER9KzzXuGumqtuVPT0RkMwTQjpSu8SMb0mK34qM6qLKlBbBra7ZT+uohWhafTZcrfPnCC/1MXWx1cvG0Qrk9oY09YJ/abUoEGuvV2ObKewu+ikfI6mHeznfJxJZeVkgrpIKGqKbZpNUQ0r4Os1OxO4Ooq+9ElrLFQUYmVpQrwFPE4KFYd7XF1Ea6FUxI9w77O+aGMqfl6W3FgEhJ64YOUH8nm9L968GEB6H/GCa0ztitRb/BZ3n8QAfbx8w1W3yh1f++6eekuol/7tSNKYSV/YMjcQ6ymrp6TO8yMVyOv3DM4bCcC7u5iHYuXkqjX6kROcGbT6ypNq5YzrF3AMhL5Wos06e/uGVff4sneSj4Z+WyOEznMxHMBG6vto8AaYTe/P4HaIH6HrhTus6Wbg6Jry1uMeFaZOr+5RLzqje8K5clLHt2fAZIbx2HXSoHeqkgn/K0SAJQs/6NSKVeltoSfHTGkvyuArB0P2AVe8701xELDsUGigME7zRsjsVRYebBG/iRJa2PDMSNrn6mM89vPBKQciqcfDGv4Vffj5HQNijYzzvr1/79rUFH5grdtvBOIh5KQKDZZk65TbEDh1EijuouUHnJQ1bgdjRzjGHgRYud4t8SHqXgtsEbXJXjgNWjF6ETpw9yLYdFn2awgKciCyDUEPRlO4+KoOkjO5IUDoF7MQx926dcguUEDnzxd50wws0GsyUiHpsmu0U0rCPMf6wGuC3IjDndYtT9ZThxDAruHL5be4yvP6KhLpBYIDqHG7RAivPPWj3ZTfbYdsXJ9uJi3aHzvi5AwvUrAVavHk2jluQSasezGG+wnKTPjYJwTl8gmOk4R72GyxvJ0eMVmZySb7e6FMoAsLKfKWD0b0OXDw8S2W1/RZRgLJZOmf22xisTsDS5/1W02JMh/CLT/GFEqU1jJ3xHjv1eCRijj29vkAajF+KOM6ulMdGBzJIsKcWqGnyNrw9bsN0ueyioJ1QMOdLfA9c1Q32GVJSUn4uCYaAXgC3psVI3dwYefSTmmM4/azY5NXbQRd8vHufb6kM2dh9GmqzGm6T08WiXSOZqhXHRmmHxnnT7zOyrrN6KEgwGDUo1fHTtHK9YwnGq/A2VgfS6ZfptyOPjZsAK5LQxhqQm+J9rYCtVkshXQSEyabpBreAXyu20mPJTCVJrbvm57O4l7CiPD94rsPn0o9suRcj8O75WhtApxOZhD72RWN+sMhqnl1erEBOiEVnqi81LeO7onFPtJBnwyDWQnIJH/FABdF2/9XWihObROy9gPmSRlcIGG/tH9AoJ3n0B8e29weNm/0BjhqT2kYnsbIBV8v6jTstr7Gvh6PMPU3OvLsygwUiKpqC62CF8vx/v77PJ0N1Ki4UyoqCmj+6IiZF/cJPcEPa2GpvFIkRWDaCf3quw2BoEy4ZGiw+k+fhEWLqRpd/w7qojox1yPXic3u2aWe7mL2cjrWD3j42L1xbxUIPxZUiwHjX4ykKdbA92N7V1DH8274f/stcdFdS6roOdsPAjbSjsglf+6jhL3dRo5NaXSr6XmnSKW19Px/2QMyBTYRzBEH+WXoX3M/7vehWr2qJsDqlu4pRUhNtkr5bwTjV6RqLsBub4ifxQJxqpniurQ8O3syj1JKm1zj3y0ZXDS+3q60WITpHdDhKF//3tJZKGkKRoUO9KEEKjmspUJqVn+D1sQ0gjjfO5sgVrQDxuYiI5AuQ4V6ZYdVPV9ze2CaKpEbzIk4zsfKZ6vIpaJBBd1SmE3RXd9F8ZdpqWXprYKdsD0iMVuIDNm8NewYnizESqxKN6xbQ2Rfi6kkFx5TUvMIJ8SkOcBX2t0eD7EnddkPl0Zu9LBeV3U6X9Z3uSkMcW1jimsE62UlDz6pbLLF3KZx6KpiDjKD81vldj3trWnuVkxzg7+hZ5j3sRmxh7bWQ3VSBqtszD4IcgckuVERmAupIOw7ix70hid1Xm3Gr9Do4VcjPIvERckzYiPKqGVmYrcPXMjcjSl/qGrfw8SZjryRfiC8mzKQjb/Gtd8VfRFZKEz5Zf3E1tk9IBBSe7AYhG59KUTKu8wXZ37CqOSeM6MsOpUt6hhrjhOjlVZdJo1YeLVJwEkkd0aZzHRo7kSqcsH7nkWfp27PzKyeuAtLa2O2Rnk19hcwF8TorqSV96laKiywfJ77UrTE9osrg3iE+8JHqhpooF6o+WB2Im6bxV3PWFLi2ZlRthaKtwKiPrORuJajmKxZ80p36jtca1dOgZWpibhTNIBPVvPYjN5jdU35TlT0tqhK26eU2VdhdKuqQJ522YQhbZbtQDELhRmIrEZnC5USXDMPnlA27ERiWqLAauvCik7krKWTrZjT922jfLIsSd8Jwklq9TXGQyvUUXdEmuVUgYQ1dJwHboEw7n6aj39wbYpjK7oec/uceZ3Rdhz4UKCYS713pA2bNfKFUVzsOQKbI93RRzjKPkN6x4XzUAdjZQCv88Purix9+/12AgmYGD4To4Pdr7ecpn0WrHhrgU8H4JtcPcyRw3ViwK1qNsk0tTK2LEFr6Qo4FGWRFrZ7HqJzd5IUpi0ip6DupLPjSzGaFfRbGw82Ez1Vwvxfw24WloSKayjBWECuho/sd0K3hGfs10kYoW/u459l2nEJ4fI0aTnlIoNuhQFGb2NsgjhpCUHvcTEFAu6bDROpBQ1PQM9NetBSgYf+gD0i1OM76scv/nrkJNVBCPZ1dadbNQytts+qIXxqHhVSMgiTHzvBpwrUompHwDUSDRiqwPW3LnZC2y1hE6b3RZEw1gj+zDsqftRrC1D7Te7OcfmxQCrQ7zLfCm5Z06wUxdyTfpsVHPjy3WdWK4270Goh+6kohBA4I6iFCE7jI08auApILusYwgtfVlYKbQkbgTbuiLx7JNxl3kSayGDe4GAtdjA0KMf1IYleSkSe4Ueba6lycWEuzlTWBHyWI4Ir1f2B0gB7e0bSUuLZGYIgReuM1HpXLuTgzJKfADtCcIYFGPDYNIcuKhbrDprz5ZrfPsN1ZtI60NuVShcsLLPthCjgW6Nlnvmx8COqwXmW9c/eOgk7pJM1dq2BXqvZApK6YvPwm+R7hb+8cIL1ueUNRcbiZ1GHsnibvtSranzDsdZQsC7mfmam88+lGWKh5ysQl7mtosa+Xr+FkPEYP111TEy21mgdGcjPuEJh+VxYksJnD2CGc2wTZ0RJuInmIp4eD8SOqupZnaR6PH0GgvjsE8jg7uYPX8oVA+S+Z17LFCfctXGsqHeM+C10aT9kO6Cm0fq5oXfkyZM9bHHibyLhgRBC/d6q3FfUQG9DCYtaRcJDRiwki007DIw8kre3yNfAaE0Nr+sO5P98Ca0Qz5sW3UU2W8sP0rgyX+ZDO4FCHS91DWuXz3uB2/TwRGqiI93l0QeWxRdhXuhUzb56Ev09n81+BJtFzJdoKDJT3uAFMI5jXytzKx5iDFbDZJbUEbh/XYHPa7R+PTnvcXuHx/R8P+oP9ZDDAFm2D/Ub/x5OV/R+P9o/3j3ddB0g/gS9sATl4ZAvINT3nbBPIA+6F+PgWkPBMrGdYgD+8qhUkdib84Xx4+frDdxdvh68uXr98TGfIk2ZnSN/R5wGZptrNwYj9nk3vSHuyle0h8f3Nsq1oFYnfNI/esG1k491gjLcZH/K1b8VQ6hYXKau5f6CX2rAd5eHeaUj53pekdl+4wfvUrBKWsU/RIP34b6Bn5WAPruZfvUEKt4+kK0RsXCie6g36R8Lcv+NfJK/wJ5t3kFz9rGgLyYG5OZYJKZjBduJaJpmuNUyekRDH8AzXiI5k0F3C9OJesHna7sOavJUeTPA5ePdE/uVYO+g9tsg4s228t2N9cvb3nx9xmxyQoSu70qwpD+9doSGO8z+XVlxKpIEWhSFqsyybX1xMz2ZSk/WFgqFnl9fnvz7jCFErPoUvuZYdN0pk6nelp9U4PS3UJ/NBNp/3PvZcj4r4grSJ4KFcPbayOkr0lW7jHUZ7ntRi02BtLicoET8fndGq5H04ETLFKWDlqZnS4Lyru1mbrJwNCrW6xeoDXgpAKsLiQ+fqXBlsX2OpXM+HnHrn2OOmkGBgbzOPzCTuOHfGlGPe0KdiA3g7YUmzaz5FRFC7e40dFK9edKk35rwxxO3kldWOZY566mlmiZgvbIJGohKMwdMoLcN6Ar4aM6uDtbR3EebtVt8/SQtwRFYTLr23KJh9QfSr1m1cjX/35KgN4eL6/OGHyLlvF8VV90n630V+GrxygnxB5cHjY4vD7VnJnQ1vc2Fm+PCxArGapwYJBf4Y2uKYPfjjko86UhAh0J62DAdafqRxIgu+vz1YGRxvoIRefJvUYBnNUhPtW5CS5ysWKrw9GL7xgoJLCJUK5z7G6A48Ycp8uQJhg45w2lLMpb1A3GGRP7Sb0mtG1uRfXR/O5BKX8ttljpCtLcrL1pSXBSuBmbkXZaQlXRPcBP/oe5OsnIxUmhHqPOqSk8+6rD5lD9RP9V0RXYTDcBEaDw1AVeBj1HcKwRPSFko4Cw2lf52AF5OmaIE/W8I42GxnSnHNgkljx8zd/eZ1/1xN9FSbwkbe4mDlW0SwW9IL6daRqovuQSFv+bJjvOX0RFW48q+iB+fffHWjj7/5hgFO4U24KrlnARxuMFaZcLTBVxCwqWzRIcIob9BdVGrT4kYKaBWSIxyYexbeoE7smkJ+cldsI4foQ5ETkgEubAVbHUuR0RoMNj1KPAVsbSVNlWvThYhlLk+mald0vqN884w6P+EIt/yYyHR2gx16Hvzbifu3+HSDnuKWjUPVbpGkNpdn6tfZCj4V+Btvli5nSjt8rz+w74Ut/PJyySn3AtOBvHv+R9yR2h6O2GuzLKZeqeINGR5dPHtu0Ziz3rLh2kZaeG7PsCsqt7duBf7cjf3tMv9R7ib9yPVBVot8ezZm9RO0BcQGoSQpVbvi6yXaCVl0w7a+1ZEj3WVRVJdTXHD2O5eLsk/M0NX2/G4u8o/WJlgZlnQ/mOawKLaxIexAv3IQHBK+4lcmv4NddnnXGUGK1ikorrqXPCXOAwFMkOp5psPsdTx3Dz7Rs9r5FZ0afeFDnTGsEvPWlyyAA3tUZCb9kn+4J49vN4gJFe1g+/n2523cPfB7qRkJHpHtdnAMPEtyqh4ZG9vt7+719w4S8OAPD093DxuxscOVsbGTk5M9FxlzT//CwNjuIwNj61zpnyQyBn8lGOuqsBjsw3evaLceEQ47PO4Oh7EWClhfQ2d/ZeRrL1yXVaGv/UYc44uCXwf7seAXv4P1VfkR/14CXHu45v9GYxscNjumoPECDI8+bnb/eH3g7ADW9Zx/w2788eaRs3WPi8fODnejsbPGJG45hHZhaIKUtt/Hw+REI4me7ci6pVE2/rwsmOTk/NVx2xWaeSUSjY8dPN/X8Jjr9xNEisL2l0z7brfuaUenbHJ5qEcXpsiyPy3zKhu3GwCyEvNNzySBLPaB80uR3eOm/Nzxc+n9s6z0IHFmaVHOk5u0aqLII0U9+PKDNbGCVryoAkMM8307ROwiZeax0JBZlVaUKJjC+iAK3yDB8VobTE2nxjGLsBR36HHY/cfr8UF/73kC4h/U7OHJo3Jc+4PDo6Pnz40qlwn8TKp8/d3+WdNcMPMfLuECD79/+f7q4t3bR6j1o4NHqfWoHFqp3Q+aS7VKvx80xe2XKfiDNQo+fMa/Gw2/H6aw/j2IZz6acG9oV4q8+GPaFyszlieDNX+L33lkliz+gI7k2FFUwZvH/utIje0dHLPqB90XqP4mq3OEoDkZwdEs+st5S4/hYK2+OI57BpZgnDqqC5CLlW/oQctCPB91E5npHssfRx+623oot4/S2Md6JUjr8HgluN8f7CVwu3f3Tw+fP0oJHu4f7B2cHDsl6Cbw8yjBrkP/s7mxOCJdm+GjfdnDRyk9ezfXYTiaEqAbw2FG/TItF8VwGC1nHvDvRcUd7auG+2IpxBu8J2f7fr5CW5DZ9UhN0Rq4Q0vsRbWEPO5fiYY4Ovo3rSFWZH51n/6CSmOAnhNct73BI5XG0cnz54d/NaUROf8/q6t0SHf23fs3V1/gLB0OHqU39BSs0hmyTB16Qj59tG4gQ3aVbpCpPUovyGT+jYj4PRjnZjkeP8wx178Bhg5O1Lf4fYYKbxwGXPWYjhDgCfz+q/k31z7FJS0UbxAU4IgrtVDyqzS5q7Lbr/21L6sxPY7uvmjnHT+Lnd43/k2+2km/oSJSSRgFo1kZ0kNT+OteUd6WjNmejHrfYCwJR9hOLqS2SrqM5NjApU/FqehaEnaU/s2soWCtBeeefFtq50LSOPhlwrRQA4UbUCpcK1sti+D9lf1j/s132MTEfHN0V0rNTd7Qg6Iqg2WUHh4wEd+eZPqwxcHTCQ0dDtrkAfI0vNOHxM/qPbvHlAw9lb+6SlVJsh1tf8Zlku4bpN2JRUnAxH//n0/2Bke/8lQkqHu5uTPRftPnx7/CIeJfLXFJ5VtBXTG7/7XdFdcTZIkMLMne9udmqP7AxjgPgveBpaubLrnUsmNZtHkMV/E8PUPEB+jPreQ71AFgW1xWJSV5cZ8cSAe//cxMXG2jUqprwoACpdUxroqPpr5hcx60NkP8Y5bN6/B3qEHweYVSfE/z0UehiTKmEnWyeoq9esZtXmSYEn0hPlsvjDlDEvC9RCeHPJ1VcG3wmt3iDexoQpE8leNNWnVLUuBYqwTmUJ1ki9H2s/aWkrqQ8/APuq/zby45818vb2ZgMmq4yDYMUtxDp+AAtbOc1fw/OxlTwPRlpG6pktD3UbY4LMU2nAfhRobnVlR42rpRKDXdES5vzcJtceSba4KqMS8mYQdBmcvlqITOy16SM2L3hyeSPY1yaUuyX/cZiYQ6cy1mqWyI6Stao1juR5jYvTw5yT7PM67HxIFSKppuTgo+EcqPOSJnmi2h/tN/jBrgey47c9SdoAjAKT4Hp8gMv1SHMEo773AUN4ttYPFtufyUpUvP9RRE+trfpy17USEfEguFKGaUH9yRjzhi4/lRVvVgr797jDU3YG7t7T7Kqt4Dmbt3aPMRMoGfqeZmtZHx80Vkdq2N9JgsxH7TsG5q+aQuqZtEkS2MmeEftjows2vXZ1VcpvUCjza9D09ipneghBgvxc1s0Bj3T/z3Eqc5PhKswU8kimjZYEvT0e2sI5OPNSmKt2YuCIZdb27K+/HjdjsCfAgu9y///P/i2fqXf/7vrig+/ZgRvxIsQ87qy58Nj9PSNnIYzMjHDF0VOGngWMZfJBqEeX6875TASTtFf07fRfE7mZCgDL0o1zSA5PL7bI6TYMj0q2n2mRC3vh2jWgLnCJt+B79ympvsv09lPg4wxa7CmdHo1CM7p8nc8KARuX/SDv7EikEYWyfQbSWhyjvJSfjrJCSVliSt3ftY2mn/SoK3R4ORDA1X8cdz3xK8IxMAI6Fy+E7drKXRDVAgTT4pyopLKRwYFOtYtV+ZvBAhYXP9kRQ8RJezs8ghuIzfZosFpfpG5aTI1YSRdqln56+co8qdfPEvBKQcK60jgknYuGGeJ2WzneY3VVqFvRdMecOc+IUZuKr5xllafeSBMUzJZd5akOIWIF0u7oisBHyx+m55ezul6KAc4NYJC57bXHl8vOFacAeGVh5f9bslXFswSyfJt7QPLaZRBjh9u5x0UoBqo218HRySNrTd94X29eKFtqytsxjFZwDIJnkBA4qoeKFkLtQ/qcaWjVlRN7HRAUbZ36euoxlSAHja4mxhxcKLEgv5ndzzZv3KJ8NhJ0dXvMgVTQSl9ii7AVmWdzc0sjBcO8ileaHwdtXI7+POjmy9MBCwkMYFDrfemLazfFJ5yp7YeTGNt6Q8XjR4MthmVBbcVPVqgifIvSTaMGXB0J5BxOgUTK5VnfXhohUJj7JGhW/ljqdOW4oKTOdwhJnjMSPqCj0A/2X43cvr//YEfjR+8n94QUpSOnIILH0LT9z0Imqxc1O3U9s3nkb6njVAzlQveoxhZehSG8ryEq5WzrRezbINNtdQEG1yRwS+3WiJFefFMmqHpYwonnSN6mm1KjcSPejnEq/gfJ/JWy8L5EtiDD9Zovjzg+igB38h99Gxka/W51Y8dkkhPMnRW2q/RLUxuMylUZTE4sEtsqNTbJlNWr/FG3iXF8rg4So5PCUa1kpwuKDBcEhWG3u4jvkjnISYaFLhiQECz7MSUWZaKEZKz09AikzoTe/odIWrtJEOxMW9VZMPL0RzpfH4IsEjfY50PsGwznRsspiN9O2Q5YzpcqhLNj9iRtUmZLchHTl9hSluuHjhs5AWolSI7txaY5E2Bg1PV+iXKsuzmMZUb6f3ETtv+XuosEn9lPbSfOykTXRua8pLw3XD9bhtmtyr7JWpchg1LfPAKAfdv6w8VYGcZ9UmQjfaSK6E2jTCSldlVBSn96NGZx4tDYSB5UhgWWoneuzaB5tcuHY8FMx1BArm5I/h8Jdr4kboDCObp1n4OlDRG9pp62j5jVzCzilaTnzxgo6qtFWUV48vIf+4rWfjreYMI1rI7InvJDQ5fA9U6klDiK4D0jQbXYGlSpInnT+lwGs915B7KAVwY5tzir0Skc42XmpRPYiJx5xK5lrhkO/mEiJ3OrCJaYjdgpiNfLUowekcB9pZK6Fl/ZgiAMV6TKms9eDQHSlG5TzXG6CsA1ZJeIW/0nPuOKJreimYFaNy4vrUFb1bzmzjuzPViys1NJRNcp7XcNHbiHAgdVc1lIG3zaXJFy64Gr04e+9gEdaECjtFIOM0Pjm7zt4scRhZZKfJb67eve1P84/KZR6d60ZF/piQQyOXKmhxjwISVlUcNcUoXZSGvP6wZPbXKQjGwjNGpCzjnOUe+FD2GZ3CfktqfufIG41mCNlx2oXRSdFmqEM2NaAJTBtq4OJFOPm2wF1liekhbyyKa+1MdN+xB3Qyi3CPIOZdDdqbeod53YRXu7FiErYuzyOYGS4sNTMzYjA7BW4CXX+2AUvf/9u1+mGaMRJZqTcuOya7YSk2hRUlWBB2CrY/jMkEbjg5V6HcikQsfOv2YC+0Uhnbh8QTNxvduHNtQGtctoqqdXFCd1RYhiEG7BnEDf34HpieFh0VyY0zcv6KGinfUyN2ZMoYUf4eBHNNJ6F+qLERipeUPVyV3pbeOLq7huhmjeP3iLP0vmFhW2b6uPngKrzlIgduQNdM5CA0bEtGcczTEUtZbjERGd53rYOlCRvSNc7oC78o5leGLQHrjzDDBHcm8mpyiF1uFUuo8eTFzjMOZfTx2+Usq2BUkdO+517Aj+Dq0FeQNdMzvkN+QEv0EI0PtddKLAKxCElRmaaM4TNMCDQIK3z5BpsRy5ezGzew+IyPGfAxNZtekAtwxuMoOCouy0cPCs5gOP0f2Eb0UFjjPVPvIBcTAZWIVOKfMhN7yNwZkgiLdhdYQftj3uKSg9sjjELo7VsWaKVmJipkTyBatyLXu7iH08UiHd0xbwd1mwyPFe50ThHGJm8NmWpRFgX/wpSMIAhVCLKKED10AHOt2lzlO+msNJAWU6Deo1SbEokPFMbylGWNwwq1Knr0IL4zbsWzyKu0McYx67wGWYCNfzNd8jyQCe74r9ewI+nYjQ0kqKuj51RNR7fDWfpwkxEN6+W7q+unUfYUmw5bzqaggzQA4vp2TKO9Gf/iKjsJ8oMMcaox3FKBKlhkrhoLLYwh7PiQLuTwSiLYp6c0KcYGDMX5ePosYJ29ycRTJBBf1BD87u2H5LvL1wlIyayosyDA25T4VjrYI0ie4tN84Sx4eO4Y31v4gy+pb3STT2kDshu61+WI8FcBmxhHFuGxOw32e3NYW5Ep9TGIWn6lncoJEY6jxAKJsSjiJTF6O2F8hzKXbR9+VlrA6RFa5xtHMZ8oppq/O/z1xYuXw1cXL1+/GJ69ffvu+uz64t3bK9rLskSoLcx5GfMJdzWA3EopOgco57QhEvNxWhEbDRBHejSEENb/N0XOmqyY5tWTdOxeOzrrjuB0aLJjFz6qsC/Ldr1CtDJeCLC7Xn1VhXlzkJbJb7KxQt0eLRePj6ap8nZcp+Fji8zqqRvjs5N5vb29/cT5N9gYKLIbxkzOxg1XtyxaYXke/3UpdH7cbeg+JefVmy6V0PlE4oQ2Uq8q7bIKI4q/Xs4QX0wlJNPMhyHE+oUFDRrUnAtaA0QeXDwQis0aVs0S2EQW+QhYeWsvbeS+njW9EZlK0832wf9+6OlGbSlriLuGMt4Ej5jd/ZYhYFbN1Mc8b54nC6mwZ6GWzJvumSbWbTzBnTGQ1nbmLRdts1yQXyOXknSfEdacPrUP0gmHgUEJU5mQLrNuCAVJOHk7HP9aYn2oofvMulGbdXCxH5yhRsKcKxWO9tmHL4n7g2+Pt4A5LsqRlpxPbmAvCGYazquGJAVnUYx3cBv8L02M0l311LqiPTszF9xZ5Ro19l+8ItTLHZ5RM/dsDWd50FNuNrXlLbotMhVQFD2jaEHQ3nyRUuytjPX55KB1+4B7ordd7eFkhWfg89UPo8LtZYrcZ/JqqEvHyO3MAU09PdwjC2bZwwBwz4aszQxaSNsLz3cZpEGmaNzwymxA3XHy6AI0S0+/f3qw9yio7GD3+fHhiYXKnvycBWgWxPez4WIR3Xr+6jF42KMVhWYCCIQLWkxUn3TgAbshsbioqfyszwKkzyOvgMfij+LP+jKobJyIywTT4g/794KSHZzsBYQd/4rAmu7o8eJOp/18hgKqk57+h8sEDnxyQd/avJw69oQoOvcYfiWDx6q+qH25Rk+wzoRqtuoknNbfMxNWvNpicDKQeue97b2VZEyrME78EkT5dfU96zBJKnqttzYBGexVaFsLGCTW/rELLtoRrvAz7Wy7tNmLBvocTpaxYyRah1l2G6vdCCwGt2nhaiURl8veCT12/RJyU25pGiytLNUv4fXpAg90Yjk+FPmfkHl+jFmD25ybQFD0QQhwcAeIL5z6z7h4tGnCI4zizO/Kr9IyFPYaBfJJkOKnDG86z5UFGcaFW0id9eAKiFJOBjiGZFRuHROPOoc3YLd8ZDQOsQGptTpKkVb0CR7aJyR2ntDCPYlNsWnL6Pw2m9tuZEg10WJuMZHGugPH26m/OlbCZXUUP7OV7gxU7faOnZGsaexwSDxy8hQlUZr3j0+2Ev3HwTOsT9NHbVAr5We5SKVtrsDG3JNXn/7oyhza8xBQ0QlCgsFn8r9DaunkkjTD8nbomyHiWdUWcKaDduyprZCPCBGQuFW1nFPIkZcOnJh2K8s8Zp63LPO97igNrsorOgcvtXOlkwoiB+JL+dYKErqh99zMT5JQtzmY9nch7bIeYLnl/5hRnE3+7cLfeZPOib3KnjnD8dPLfbL5bgbtJ8lXSxFlz7iJVmd5fcag4xnKvq747VD5pTdI4qljsH6TxAh1Xab4C2I0F5SXRTvEX9ndqPNBivLx7BfP+3vgfOyf7p+c7jf5f49XOh/HMMDewPke7vk/E/lF3FqxbsgRWuUo+zockd1uR0SZJDp8EP34S5ku5KaqvZQXXrH6hO/Pz3SBVE7qQ+Qr7DspsjIH+l8j9wU2V/vFpvzFpvw5bUpmSxmI6ELWgtEdfA05zkASxh06uJRv4Ivn+MXNqVK6nxEvuMQ78tMXXPqJ48HxKXUhw426frsDZbqKGCNvqMWEVFkoGYrKp0iTNx1oz0QcVWlH1Sg99XFqdHDS3z3p7+0mu8+RLnXvcfS7g4ODvb2954ZESibwM9Hvrjoof4valE7qmvp25gMZpbN5mk+KWhvV+NaoQUtB+RqYbPCnsUdW5AEn28+tjONtJYvsvp5ysreGOS/nloiq47b9K1TOhyG77mNvPe/WczzZ/Tor1xNSnWDQDKELL981o2Jdo0TFKAYZSYr2WIb+jwbpFBPIsxQNk+7EhwKPd2LUAyri3RSfHx9rhGx3w8JjC0CReeECULxO3r6lNLuAacHAlwzf5MMK14jJYLLkfVp8fJNixyt4MURQzdK5V5SRfJHyMD3E9H+kOZJAs0kJvQZ7quCYYwSZtVGFkLZhNq3EGPHdaJHHSJ2EmmCpX0YJSG2dFV3GR5TCwKNLnMqH969Zeo1SsLEwV0v/pvHmcnIKSsYEmzsKizyuZ7NxuL7TmnrgEINy+NRZgUJcj8GZ1nquOsOfOizxvAkoaYdt5o48kiaJxlfA9xPcnEJb2BMei+CV0qDdFWxprhXJzCK1p4os0OJoD7DLb9Wgm+XLmd1ptD5dd+uN70xr02l99FqghPPTxzfnCdNq2NgEm+eLJ3XQlwyGe8BSzMoa5Tmc4s8dFnmaHOweyG3C4kFt9TV3rF/EGI4QjlG1nN24kBaedJEklBunY6U/5haNvv1WDFq4svlrN9aQF8oQMzixgZxSBE+npppYlekEiTuH2kN9RbHNXjz4VQe/NwsSP/Qb3Jk61oK09TshR0NGCvfMmGzb68JERR5CBSEyvHmTXDynrtZ6kSCzfwRPnNaC7qo0zoMjqJXGGMW6efBf1hnQjx4n6r0PgTpFr+S8yktyTAYHkXj2IMwhrRH/jZoZxJKIGAA3s3rwZx2jJIugmKhdBLn2jFPMG28ppQJvw5vO6FVYOTIDIu5+AUZ07kWXobbBNbvPtBhp8+sQwGJFINJDQuyrv3vcMc4QRDzmER1sLZIXkcPJ14BETcAovNE4wlFM9U5eh9QdN5W+J1Uq7buwoWx3DUl9ZYaTXZbjklcudt1iSSe9GZG2ovzWGGGJ8wIMHl+Yh96SRFXEXTJ65g47FrKSLawOe0Q9jr7NPRocJL9lKOYBlWJW6u6nODV/yqNo4rBqtPUjv+mOhqIF9YoBp1OQaajt8npGxBZs6SpbpacGhc+aUbDIyDE87Aar1AJKc+WO3nPOqqTrKtOovxilXLCwu8fjdaWGVmFv18k0Iy9E5ZhdiCPFWpeaSxuoH2xeaF2m8BylVaaMSE/ZKbRxT3dM2j1Uxo57XX4QEOL4Aw7GcHwB1nSmogclzM2DQQkslZ33ncIIry51b/W2nOKL7ZwT4qtAO1Q1JnNOkH1+k91SE97xuKmG9MrKtQxGFDTG2DV6xjuxnAsC6vcl1iWIO/4IXZacEcYF7zHzwNROWVhgdup1Sn1XLpGKOFOVFWxW0oHH5vmJAY4EhJhFi+zTWsTIG5DQCSjdWpD5rY3BZeGnoZ1BJdB1hgUbi2zjVl7kmX8JHnBvD1ty7u6eHuw/Kpa4f3h0NDg+Njm53Z81J9cdK/n5W3jBtn0BKz32PA2A6YFjWs6X05TDNCKLVlNlwkQcfzguy4owIb6MP2+cC/6iuOGRAQJiRdAM+W0ouuSH1xiTi6UFmce/NUggrMAElF3FJ+mnb+XFgbRfQmet0JkygZIJQ3HTo0bclLJGZTnFkMM1f6tJ87nQP0fCpXsg4npXGWbs2tbYViMzanD4D+0oMLHubycviz+WDwKSd9Xkwgq2xYMH6H1DoljeI6JEzsCWsmUgwAYp57ASQVpk6yZgRLAiusrOKO3e/smJhGn3tw/ahR26PRU8A1ZflGZFLWVushGeMMwi1kwFReWRHJB0PWSmiGyS2jUsM0ku8R1xL4JQm9OOOA2B32MtSfV1D23lHhFo9GsQEyMQ8fXXvcHpoA//2e0hF3k+/rqHuZO+CI6+LlMvIbw2DALzKquesJb/Z/85pp77dznY0sXXPSxogwGRh1wbvLs753q8z/WKrJreHkxv/xRmJyZu9xcUS6TH1PX9ZHb5eqHNOrVPgatFulaK7QbN+Zk6i1QzNM9GKI07yDjUFVq51gcw14PT446lRgOmc535w3WLzDbQ41b4EA/A4enxSfca41cOT5/DIrtzTJXW5IdxoTYZeSygMaZpJZAnKeJmiVS/AgIbjEN05hDYRlXtGFUkoYA2GFhguDXoF0ozC/ws8HY2mOZv0k/pFQkiH/+kYmshWCFnEbSQui8Mctl5+ZlMAXuv4k88gicene7v7vWM68XluXRoYKu06um91AvroVOoAbuqFbiwZHIYzMXT1m3nGu7kQ7GgLgj3Wyg+fL9orQojKjsNzhCJ9v1dKTEmH8dDySGcU9vJWcHCEc49F+PCglB5Znp7Cxsl5Vn8I7TKM9RfuGOEmRszWACf/yBqS8CRIKz79/l4zTIewzIenz4/8JdYXB8YFNYt+wQeTw0/K0dLRKeI74PnjtE1vgUwLZyrHKOi6tWPPoFHw38Gx/7ZQWQOl/FqjmGBu63kFVYKwP+imPguQ5YUpdxj+prmD7HUfRW9R2s2z2E2zxEZ0cOoBAohjnhk40nWR6RwMoJNyTQeKOSjJiCGu7u8mYKYaqvAs8uL1U8HGwtEwe7pcxAFnpMnjCurzcyJi1Y1JJWucRUFRUYs4cSah5MiQk10opdJ+R07xnMxSpIn1HEt1dJbdEGLss/kx33n/1lawY5poD7B/xrwHtBZRFuyh/CoKr9ZLsxa94qyxPgMCGoBB8GuU5JCiOxcsW5aS3iT69/nGZHGFtk9ip91S7OPc9qnCxLlBDPHvvbgvSwggE455s0BA+8hnIEifKjzdTNAzYX/hffkJdEfjvlNXPRGhEZ8r5glQWBVIJCYqyEWHsKFus+m0zXzMUorFhYMmMbyYr4MYtvwZEfMEbWbBN0e1aoNqhZ7S20Oi6Uoc2Raizcs+1lBuKGYPAqTjsrpcsYkA4Xw8mwwEJNopUTmKDQ+aMM+4s7ieZmALTXFqbuUgKd8L4m+hFgkp9N0XrdypLqGl3FaqRXLqkZaByEVrQUKw4AaKRR4f1pSVWt0i9t1oZaEzD4UlgwHeuAqW7xa2FIjtRbEUw6AsVFD+64Ch7LQz6Sy2k/Ns03K2RilCEhKKSw1BVe+kbp+kwrbz1iZyJdzcFbG5LZoOSvWopMggPdL0NmEU3ibVafJW2x7RNG0wMOQhlxEeFPg206Jm8rVaYPRwFBS8lV1wmkBbldef6Qa6pTBK1QYjNwr0glq9LANSpPtZe4H5kCgqDKnmPJ5EIpvko1uLV1ZzOK+dJQJ3LETJgL2j7JmMZXtvV8QPruap7ZD0gD1In3gWWRjU4Wiy6hviREO/E6cU9RYvQzvDR/OOXG03P4L/WHIf3gmF1F01BJMlop0OeO72Ot483D129cJicZKlESVgcdUyNiOTWGK7iv+fDshABKs4p1wEcpVl45KtVdTrVPDC+BOyxbjlT6n+PLdb96ZkcJnfFuV6XhEbDdS30B+QVq7U9LlFdz4X5bSHmuUVQvtZ4d0sHRgtZIqYgJJW4lbkALu2iG1bPRd6LV3mOQPnQ9QxlUavJSbOmWtpg/++OLAQ0p+t4w9i+S+7MZfp3Dx0vYSBpTf2iprld/AxyL7PMqyce24cwx0f4zQ8AKuY0r20ERM8jQBvzL/EQ/jFDk0Sq9r1+kQ1RwdbKhT3zfQErd2isWoXD7cWC63ZarI++SmpFdPMNaNtPFEA13RwrRhKvjQVs1V8FB3e3xPAlCAC7SB1cnCQT5Hew24kSLMY3/8LeoV+PEh/Jjqj7D3CUvyKAX82hEJyENdBoS8bVGW05u0ckmgUF18+UOu7+GQPcj/YPhsQa1KqmySMrKWcsp6OAgpn0UpiVLXAI7Ghg2ma+7gT15M/GmZy3s57q3uY9TC96hzF/qQZJKHlE9W83NU3dxxyo9zfGkYnr0fLoe8m643iCYpa21U5z1onzymZd30/qn6EpshEjkhgU5s0+wYq19sPsVIWBOXpxo/tcSD1P+Qyh5yR4KFflU0ZINv5eKlgXygDWuBATeQMp5hp8v/Iza0EWIUlgWuM5ofn1S5iQHNzjoovbyMiyoKs2LCeGFKSZrQvcXDVPybNAEPcMFORBTGsKmFFrfvNHjZGkWeIHZ23oH0i60nxsh58YI7Sd7ye7tTqmko1CRpGVwsqiUOYkq3eVULLrIYxUPPK5BqaJ5GZCoRDJENOk2rSSaB/siGGNAPtoloHhjDGGTzXzNxVaW+k47tKsCSl0ukxCrJM6RkdfpDz0WgbOAgMOe4sbP+tRm3uFDa6sashXGffDEJRkp7qixgUw0WOYbVW4Uc4ss5whXxEQDX99NZPVSqrjIhmKfjBO28lLF5dmrXlvml1r/rOdqKYtWnCdWESO8CZ1q08DjeY6kICaHv0wSrOWghkuh/bgrHtWAsWU7bPNUagm5NOTTOJwhlwEtvCXvfKIhxB2pLYkdlqL+Cr16bl/PBKBJfmA5XsANiZ30kS/G9JLt7TFL49uzNy9OE//n7s9cfXvaIycr+IbLL+9uDltJdZUVY2+MwPt7exmGYtdukiCIGVZXlR6a7X5iGCTf5ZEgScljnP2bDxR1MDjzgsW1NMoXzGp/r4JFzXThW+TAwFVpvenoQBYNimGxnujEgJvNb16cD3vsmL0yXjJFJc/FjJBS5PmDUPK2tjDILO1q6m2/UGpo0LaKnz77aufkGg86G4BVutIulCE44bkysD5CJEUSSwiMtKUva4KQN6vpxb/EPWCqLtZvwFWHrvm4jAw26WpJ+fSbDs8trOOV8hE/7U5XNhqxWqYVnl1xsUSF2P4yDP1dDIlV7QKwQf5nYHkHXGVXjKK9AXLCaXhN0JIcTdBtm5wRbHKblx/nYdT3gM+jEDW2CTRREcy9rgJZhXYyDLMZej1WyiaoGFmcYlWEUoWNhWS7E7iNZnwmjYApPhjO4nZyReueLbo/3bG82rD/m8yEHdtyPGdxDJ136udGVbABI5aRwjEe9VLJ3KLflW4NvJz7yiWGzxlqNwfynrCkzrpTVHD5TPRrxBJ7SARqXvlsFBu/sWhH9VeVLIWfPfJsA7BJAsdbMsZpfw6nGNQUJyn58E3kQjfh2CMKrfFJQhBBLYeJR3oAf2DCopmIjFktqbA5XTzDMeRGe2kccwJuqvMdcKalCRMj5noyeAzpN7pbBcy3zv5MKzrqOmUgd6/VBo0Idq+V06b3UroqV2HtBXmEyzW4XWIbRPgx1z8UrVmyjXQoMpS1tKEMY3ZVfFjE5aE44Gvx5noUt0/KAPBIPLKyI0lybkq3eZcY5715jp9DGM6QJiDMSppRMGFEbDAUN9k7yADjgSiYQImxg07EPPIVcayNUsKFLx668LO7wTK7KVfyQPSGI6YKQjZ16MRsPaTNEL8LxXbo8Bny/R0m0m4dhVU6zHn2FsdBSUIoFKhRRf8AfSNsOjM8HCTgB2zJqXNISMiF+QC94OG4Eyqtn28nFbfjFYCb2+waQu8VuSgaiBatytC+OhA40FM/OosOHY0wbvdJySnBulpe4l/oScftqd2P7SqsyENApublxBv8kLMjKTWGpIHFmGbZ3wA28vs8n2mFXGwXJuhIr6U3FdtGMapVXCi62lDgu9KYs1HVycYMOQ4Bdipgt67IjQQ7XtBEOMHrtEHwTD1PbeW6Stg8o0S6kMFKayBVCCZhyTjTA6t9m0qdA5iphjZi7uK/ouS7kWCtVyHaMwG6wWIvjqImASd2iuEaxAVokY7CPJclvCAGu5OMcQ4DyjE+I3FNe0u9eXnvyf3ouFfqqvnJMvHAJbpdThgyVteFbMwptKjze9VZC7bnOZumP8L5X+89iO/RTb1DSBLGi6rmfL7533ssr5CfYni/rO9c7yVn+vU4kVghuaqlribd8hd7rNyToh3WKvbTBQ+NeCdzj5asd+oZabviStA1cbKH+ivzUgVkCmIA2i3GtELUhX6l5KMnKcQ+BOzZKfn1NjChjMcUxrsgDbSeXhD/GlRBLXh2nvNZ5cs/TUbms0omIQXzdTi8hIhNqaQXie4N/ZFBxoqjiILv3TMOCNw/kL3PODBfDJ9GzAqzRpdgYkqTw+4z9j8FezjYpz/L9STiQDO9GhkMnUEQ52jBdm41drQxhZDFhDT9cFoxkk5TGFqe6OegL2p0BhmIy+rQH5yjJuY61J7JiLaoJrHmkTlpErXRIkPOyBhGQj7qEmOslKb2hNcFBoXy3Tq1j6S6QhWzES3tRrp5srEPlnsNae6SfeJzSvSFCVG/MX4VZwgV+C3vecb/1KeMKdo+k4veYJYp0AmthepsDSUiEKvoz6svIjLuOiX6aOdGrhRB9jpI1o+I2MLX/xcrvdlkR8C8YLXp/40bA2t/FgzVfKGbhkT3K4NU9BVcQYhpW62P2gB4HnkkBbmGZsnfITX9B35XPPvVa8dJcSMrFYTIUmfViBAqeQRaQFC7hHokhtR0z3HcGphgIY91J0TkMpll7839QG1nPmHR9Fz3o2otsce05qR5E05Cv9Tp9KLH70GbH9MLCl2Ri3hUNekNy5E1OLZ0r2/sKu0zyajHeBPTF0nJGkIHpv/3dh4sX3jpHNiTMlTkYDQtNflq9vJmj2iDEe0kZ3bQGPzBhL4cM4FS86KYX6VJGBMwVt6WC3Uhdc2L1ighGMVnm42E+FiRDzlS4Ercqies0L5nh37ULIkfShCVSgS0rEAzjfaT99fqJSR6Y6VwWg95a1cxUR8VmiAY838AE3EBOuB7SKwPj+82b+sdlzXriQTuDzdLF6M7BocIbIl+LHHjRj6it/etrbIXlooCW9LTUsVO4pe/hsKBcGRr8KMi78eM054L7SdwmCPn/KpVqBy18xLqbbVdXRyWQMHS2s7c7eL4z2N3Zfb6jyVV4mb7SufTL2/5NPumzBd3Pi76vzTvs7++AiMPg0eLr3vBmCoZSD9Xt1x7K+009SsHm6GPFGpYGYYWFOoIj8gOniKlBg8A6f2yMrWv/J+fFNI1ZZxMEtCO5Rj4QWi4li5geilZzNzyYtbkTtlGCILs0E0fcAJvHXrPvkHTHWFNMp3AOXk6ZNhhuieIt9KzvfTibjQtNSkUMC9/c1AXYOROCMHCSUGoByiDhtN51yGl6gy2JlLJo8Ck3bq1tQksk3ypCu2AYuFJrGix7GqpaRNMshKmE1yF8OIYdWMJzs+UQsRxEz7gxs712LMLYvdXMIUNstpMzENFbIBXGQmLFF04ROPKKGRzxuSIgbpAlIKWYNJnSpKLBHZ32OVkyE5alZd1cTi6Aly0k/QE+RAl3QzASlKNts566spSgk7L9vYEBbScvnHkB2gnJZ8ij4qPS/j4/QksH4gvcYXPFbkBKOgvsRRspSRldQHAQ2+TIBZNaNNJBZjfQLkePCXZgCWXzDpnOnOpAtnM4XdwXphsOe9qmeInigd7xVhfbZ5N9Gpm/hgeB6py/fpLfYt1tn/DvT/SXbLEiGhe2DjH5unpUYUs32YTb0fLidQ1snUYWUASUw/b4u4mXOBvLjmkMhYUYnUvB/aAKkmJLRQGBS+0Xkq0d99J1I9pioz28Cv2Bvm9Ks+3lBVKfLx56jOxGOSjLuipGzEMI9FUL0scZKBuwlH9d3mNd6BYHE+D/7vLJHbehdcEE4zJbPTXCLlpVi8FoE03B8TLawIJjK3IvQVghs7uI+VvmuVCYNwpaSoeQ+/He9Vt51e5Xy56IGnNKbuGWHg1ZJ/WayYkujLZoK3bKpB4kX1AzU5d0x+8YVCzFKbpDFB1hD+pzi3KVqdMCF80hapA65jXKbJuM4IxT4NzLpHraIwsOKfnGPVj1dFpO1oderCvRUdwRtpGmJO66Ns4uUDHFrPQUQfw1WkPk9LHoMHeMCm6DGxofbYYhBir+Yf0fya77XrPg4eZTjofgI9D+oDtcuzbS4UPg5e+qVEp04KZPM7pInmZQUhMiIphTegjXqFgMR8KY8b/+p6v65beMn73JFMNdYqSo4mkFcKgeSUQVyBsy4HyHbroqkgI4v6vQG2rgiu0ztTwcJHQZ914OH6NfXlIWy0p+EVGCtGqKJ4fsEF05DxumasbKFH04CHg7Z01mLdYIP/QXZX/WzFXH5O7GctR20JW6ipWValLZJBgVrluWQleRZ86IoRe5TUfZCs0qNZkEhiHYOijO7JNRTCF9gSB2MtIbHPKX5rYu1alHKYrtaFNt0lsoAQjlDaVyn5AvYg6fMSsFEQW52yST+gJ14ZMFNox4nRcPb85fNqUwK/6ldIgNSMc6KiC2kyhAF36pSChMAMO71hbvM9UKBCbzggu2nBBKUBahtYnEh6PE59ZZB3PkFA8RAoh8ihH+kQ9lPpoOOVc+HN0OcYKZswuK+JfQDAoTGU1rzQaQBA8Chm+Rua5DxjPyxEseCcVXzCFYmwj1hRAhGI+rIXQQVH0rNd6gwFBbI18B8bARU1cVYF88qEkig1ERFWt5swrMhwcBVGeCGafkmAWpQKPqABrVYMrzY7tKJGrHG2lFjqKEYk6gBLjR7NNnPS2OYzsoZP33Mvk0OV+Fv3XZBY2BwJm1iYb2ZLkUXi/Dy6trkiMOTDHOVJMFP/11LpByjqlzBSmbGm33F2y2Rviz1VbZzEfQX6FLytgkd5VTr0/ZQ8Oooqb7nzIUAImCWfvmtS5TKopR0p8R0Fk6XXiOSO+D1B70hh21IpxwpyLnI2GFOL6yaOvuUBiysCVGtMD6Cy2hRqIRvAsfVtni0oRnGsLwlezwf3hHYTJ3MYT9frvE5con24jFDHzU8Jhx4U48pxXNLMqhzatxn6IasL63C7jJccC8MbzJgaOibWXY1pRRZPFlj6nMwC4+GcCID0LHoRcAjxo4VJJBoF9DqHwwOVfJ52Sh+vU2VyEdM8lTaebUorjsjghvdMNsSUTSKjZyNqyzJ8QUrU1nyrYvIkWg1LkDMziwPtjRCgxXVw+7rDXATp9xietn+E5WoFKE80hgOrhZMzR66cDi3m0ZyjA4JHySi6zmshr3mRYI8OJjPnYx2n4WXYEVHfaiQU4qXaI8zJN6pbEVBbMGppU1+D1jisUIE6mFE9MGExDHEErLu4iqE/3TKF8Tyq+UXEDBjy6sDCWNLAVWMzF/pFg1eJW468FoJHFA6C067FtKubWQ55FL0HX+w+eqOaeFIbT+LMw0hhNWkAh2bBVCkvUDDwXCgaSzQNpIJk8oFhKxnJ/F59gMCdiUx+JuObspwKOsEye+KVOlf9fw6EPsRLfOs7H6GwV1CDOqG2HIplIPp/+9mKymXtjaf83gqvqV9Ircob2Ez3FrgxQXSwzBSOFFoCYj4yqdEHnfGCRwmEPdEh2e2x5OfEmRygSEFxfZoXTZ4FoGxZvMUkJhK3IwFUZKupA+09iSi612FUQ/RWw3CKfpdIt/RDkSDnHbYu1nGiO/577jd2QomQhWbZjfZGx8PbJB8iYKl+j7FQGJt1f5khBak2O1DV4vDto0wVQdzBanie58WIBKrivxa1G2z0GQHd5dkeWMU1rSrcb4wIPiy5OnCASivzCQntws+fDZprO70AQsGhmUjYXT1J9lM6K+leCdz2szQ7kYV4w1s26KJZBSYYrqy0XRahVnygPVSGfaXUSL4c2D82PqXrM89SXPvKz8Hvd+4Fp73z+C7FEjjzTopoXks02S/TIv5btJbO0ZqrIntccjUt2oU0Vy6LR+PkyiPao4piXmo3ZuA6zj+gNs+WxNkG+IpoJis0CbuO+kqtHAW2y8b3H1zR0TyzNzu61faxrOGwgXSiJ41HFXjEe9NxU3pgde8gbk99Slv8kaRy0W0YocQgnE4uNCxmattECFqtypiy0GZgLlWkfqRuMK72Y54fk74ETDGOFKcu+kWTgXV7ROs0k6eojUX3LH1AWTsuBw7bPAvet0MoyWi2KYtqWnXcfFYcfEVd4WQqfE2oxZQHy/A/Y6Fwtqsc5vyaFepMjjbrALSjjSJSADDPuobHCmyKnMPgs3gyk5II1ApTKY+ZLgbRz3FJUNPoHSTn/zWQxqdchyC7Jkck+IK1zz3jSfaPJbN4Tkf4mhoeXE89gYT63lo7XT7rbAXCA43qGjuvwkn4BF2pxDY3NTpy/MVbjKFxleG5AH74TX2JRCyk9XpDWkEwQJaj6iBBiNLUbQRrMAqeySxiuJB5j0LwwNMFRbeGvidH+Rh8ZKQFfQ3VXErYkhalcWym8I1mVK5SdlYUejKBdbZzabyTFu/2v5BUVqkVpyoZQRed29do1bgr9pZPhaL6dzXlT5ZELZ2fXwPD4wtikXlrTB+k6jWQSWTyHR04qkAiGw+cvr3rFgz0zUxoy1hFEQHadR+sDe0qIsRMZSwptakMCdbmFZuatmSpo65YvAgVvHWuclvK3u8MRP8ao5b1igG0WMThgq206usoxl9v/6nyqRm1isCQywvNkGIb7jMGY7E53PDp/pncHh/tHxGnwVco1R1SFCrb5geIRjMS10SekLrmnvysmFh1Sx40wJ6EOW0mLBw9W7t9MSWhEdR+7JXs4+peOU9vV99qmcLmnsKzj+WbX+dBnUM6bK+iTpPW1fcz61FUaxi+e8y0ipUfxWNdkIYsYB5/k6FkdouD6JHM2Vy7dpRHDhmKf1FSqNFVELlljM9lJLOi3ikO8pWLO7wxidg8CYE5UmjDnjTDq6+6pXmzMKYUBtAssO8g/wHpCzEe18ydlwcekjsjYNkuDgQS9t9aFNNoofXyc2R8qFM/zAp884mB7/WD4NQ28RFJ7PSJqk5XZyseAeQ4wFdpX/8iPEzNXY3NRaVcGmRpttEL/6FzXbOEmQN3TvdHfvcY17908On+8euWYbbgJf2Gxj0NVsA15V9iHSc8My7MMX87oPdnSmT7RtN7ADhu9QKX0YHt+E4ydt5vv8oNnLF96yv0E3APevDoARp4X5azTuhR9K7L9Zd1kK/i72epEuB4/pw4GNS7TzBjZwHmNovkQPu88P61P1WB+lKbXk+Bvo8jvA5tN/tW4IfDKOpf01iPLRx4c+oXujLYJBQPSu6EvJa/5S2Cc4PlC87cXRAbYJzhI7nlaWfMwyCn8JwoDhxuS04Es6yBhJUdfmjFw8WHlM0eIvsrEgGWBA6v1CbK54tnh4PJtIzEq1zvyI5RwtYRSQ2wnVAuCFlJptxNGmlG6uFxVsOJgGW8ldDmteje746hFEmDQhrgic5+gjqAQ1n5FlvsimD9v/6T9G22YcHu5z14zB9uGm3UJxEQT+4DAXUqXo9F3LNsDxfR+2JNKIDf6f2N8jrhpv0J9wpEeBL1ejtPDMQLbH7nvcvoX/jKhlxwi6ik7KN6zXOR205nTONlWmPFDU163FdQHmXEWI1trNRYyx4aIc8nF103L2YOsR/EUPf3dnom7Zqe0GGq4tJdpyKhS/t9yPwcsPVux4EzqvVZcSK2m0x8PncSNcgRVlvgOA5r4jtzA6q1VNxXhWrxHI60y7VPk4fnOFqAaiKZfKBMGwBk/2offI0x0D6oqnvyejQGB62eyb7Vn51Q78L0PoiYL+YwVeaZ6aJpRgsWJSEt0BKSLCZnJYVM4iFgdafqRxotOKX87mSX0Ppk41wcC/zI+AU6DIlmGnCELvuUCXjY3zdzHCofV9/CvZQ3IEohNc32XxPezN9FPWbJNkim11Rc9uanTfMtowXlvCGLTgWK4SzUWAQZ2CpGB8WPTKO27Ebkhme1Wl0ahvV86lYri4l7i73y5zDKJvEY0ss7KAjp9o9cjVgoFLPg0Wm9cmHGYhChgjo25SOVo3HPvz5qfPqJdF5mgOaeZ9aquOu5yO0d2tY3PahPfDQZNMS0K0ML0gs8lSU8kTbQ4aYHuoCw/HlDBw5XnwjZsrbR+FdQYEYS7EsnYk3sJQEISVqlRyyfXfTchVQJH7/vq1i9BiEt1JE5HPjcJV2qgiWxC8BluxNAcX8LUEnwXoKO8rwUXT7zflk05mhjRGb2/b/vbguVNr9K8n4b96Lz24l9xBDmydPmMJt+d3cwmX0kPCR3DlzA/wXrW5DgyN0u8cdn5nz33nIJwby5EX/qqx6SkBP6G2mCKWA3dL6LjGWTrVKBsI3tlyJrSTHoG17Z6w1zGpPTOpQed3Bu47u13f0W/wJphmClxCA6eUauGd0nyJ0dT6ztQk6Ai8b1cq09iw0w+PO54/2D4BdSFf6tol/FLUvydL8JH+/W5/96S/t5vsPj89PDo9HDT8+8OV/v3R7vNd59y7p/9MnTS7vAnr0MNCsITscOJ3/2JOvPh0f1mvmh+yofsrw/6VHdqTPekk+ZP6Keyo7smJGM3qfpF+ivuo8M/nb66St+mnfJK60IDxUlujRB3UwdFzdlDDwRyj1Bi8isL9GS2mqaCPOHT5IJ3Esc6MlM8N2iGObidfZE24UWoavlOVaz7dShBzxOXWaP1Jc3ZQVchc7x8fb7x4+PzIe5CrbGeD3lN+R7EjcKHg3H6Cx+nh8UYG19h/pNiEDUlgO2YyHkmvc3xa+5L4Kcfci5/PzY1Z6uYJyyL7PBe0klZpKZbJdd2QRxomnR8uo5S9xpk1D1oiTsDsOOHAUYOG4W2NMWCEo7tmNeo7Hth+rm3f2fEm2iJI7B2E4AA230Z3tvqUuuiN0ptpzD3bxDlskuqWniQhM/7h0/Orq53fXD2zXc79LNR6iDsQq47QX9FH3Ft99P4GnMQ909k+3gVYJxmvoeq5YnRbot/TaqqwSKrdSb35EAfYqcqPKD3dReFKbjAsAl7z88trtqHu0nqoneKVIyv+vg2f7m/G19zb2LH7GZ3NwGs5CL2WA+e1dE47kD809z/8FxRi/W+oRg8hXH9gSLRP8HLWjBQeZ/7Y7cLYVTuTiFl/hnRZatqEGrv2MbPdI59PkBbS+ZnhH5qzplUEbd9/e/Y9urM1N++S6OZcGV7hX9qPt3zq6G8+kVvnPUWpJcvG0dVlV4DsAbGoPH5CaH/GGQnmYjnfxqN5lWWSKhaVvz0bswTTxibSqrnkE+kaVKDaUQYrUV3bbh6+x9CjvE94HbcUVE6SSHn9m4eLq7M3IOUnXIpn+0WQOBpNh2CHoYkxZG1D17np0h6oK7rCpT1Q/3SFS3vgmPP1Xwd/WZf2YIUr6if1vNujdeOcrPZotTNj1B89WOlqHnQ7m4ePdzafw/+hs3mwf3p4+Fhn8yhwNg9/Rmcz4hT8bfiZYWL16KSZLEZj21vVrnk7k11a89J4Dj9PSvhfofM6OBys9F7/mj4SbNk/wbz39lsLrw/Fl9snd/jxifAUT7U/aeBYN/xqXBmyFoxNocSqNoQcluFrwIYZtnGFT3v7dPjw9lbugHd9ZZyt/Uq+WP0VXItF/2b9s7J67Veq5dqvpOsfdLfmpeBY/3iHnG3rJ/THdNVX5I6zYNMCzHqDzcZfubp+/VXrEYP1GzlYv5GD9Rs52GgjB+s3crB+IwfrN3KwfiMHG27kYP1GDngjD/c8dInqBPp6w4X5vM9GWgFaClHn+vEGu72HIbOgBGHltu+t3/a99du+t37b9zba9r312763ftv31m/73vpt39tw2/fWb/ueynve91nW1IO120p4nvC5Nw2G9l7Dd7/T77aeuctHDSwVrnFZPxx89bV8NS6BUASBzVIvb5xVU1OXWDc2qu3s8zyvLJYshzO7P9jVJ6J5Nk4f6qFwZTTMFPnrUPJ17lN+PPyW4jRSLWhMAPiEgCHojgxH8/ATMSXq/iylT/Z2dbYkGd8gfkfNDrp6M/3LPkzpbPwJPdtxgKetkzem45EsWTq6ZSTaHizmdxUof7iAxBjf+jYs/ES/DP9su6lFvno/4q86YQ6GI1YogpHpFo5ExnTaz/2f9+TbEvfuso73BroQtokT/EhC0aJ0KpfLoS830WMux8Mvte++1gyUBF9eqAXaIuZ6kxZwADAOb3+wmNG27NuN6pvC1x1BvIBXG99RPMK0Tzu8YqNb/a7dwH008XkDMZwKJ8csTeMZZivRWrsvS7F2s/BX9Dzzqfm97u9+eyN3Gv/u3iy+53v74f421yOy/QewRmhEMnesnTJ+a8d9pGM0T8TeSSS713hueDj2D9wv8HCs2L/wnOzrk8wPsNpFzknHb/HI/BMt811a39E4sAqHR/uHR4NBdnv0/Pb44CY7OB6Pbg5Oxtnt/v7J0eCQ5acFK4uQY1eZhd6hSNScHOqDgft239rsnphXrHc91Eb6go/dUyRZP7k01rjp4BP+2ki2vtEJ1x5c7f11dOrVX5cpYhmKih/c4+HHDKSyX82h/BQ3K/LTnXRE7HF0PuodnZCEkodY3Bn66HNw7jGehgt3jGph//D54GiX/82s4uDEmLmciEurh8Zy7ans7hMPUfC1SAZQZgGLwL0P5dWO9uOvdj/vS0/VHSYFqJGNeW9n92CHCS7603JSDrbnrL68skRdx6p0nla0Tfnp3uHu0eBE1kAUkdeYHS+bosMb6mf8qjPk173wAAUYw7T/N8d4VmXIHEy7xieLRpvmaBxuJ78vl8x6eYMoGXZtQ3z3QpgxEfRI/2ha8ggLmRKAIIWRKxaRNZpX+chB+SlIYiwJibHkp3Apj37FtlLr8+Ei+7xobH97NZojY/GUapkr84EiQxIyWR5UlLWfivHAT+lUrp0aK7u46Jqz7P3qhl7L37j9+I3b+QcMPi3K/iitFl/vHw6OOLR2gqGAIrtPbWAD/qgdavwfj11AQKw4VxshlRNS77Anf+jzlpAMfO5DMmZEjApyWwQ74J6RZkzgWPWpmMlWVDS+QHbaP8GZPxk8PzlsXW2Y+pR7CTSuM3zw2n8QOc94U19kWEaTYFlsJY2TDVNx8SkrcumzYTg+PJVOVAB0yLYVAkBeYIUE2N9UAuDq42IdDg5223IQ45Syc007/cz9PbJUiDU/l9t4T2WkriwTK5xqgjLINS0Nnj6+QH8BCbn7+PXZf/68tT6wJCCexo3VgSeRwd2xOMfwglwESvk9ahUsQS9fgT92xNquszZ3SxS2e9d8hgaKLtvg0cuG77Ji0fa+ZNGOW4sGYxJDenvVvtc/x1btwN0+RzoS9ETRdcIk1TT7zFlKcPJcd2psaYgLevnry/g523vMgg12YM3oPX4KRexWbPdor30NbUVauGLX+uco5AhdGiGWq4VDX1rAY7QfqW9zIvKne8g4gASvImlph5/YEkyRJ2RkdhbOGM4yq7e5b59X3hMwJe+y6ZzgBkvibZstkaLb5vuXs59qP1jZdO7HyRdsB3wcUSGmejBUIcbyjW3JAXyFb72okPvshrWIY7tpteCNHF+Ges1he+4wt+swX9dc+Eb3aIu9/i0xvbaUboV9WmaBEYX3E4jd453dI/0abcB2/am1/geHzQ3Yba89+TOo15fFlIs/OL0QN0jhex/0e8Rn0XUbxGSyNuAeSPQVVuDx4d7JWiuwawJdBiA6Qb/PUmQDsp9vavjBqx8e7x9vYvyhS73W+BvsnjwHQ+nPsf4G3ebfgTfOqNs6fbIntjMpG9JnoM76TLyDn++r4Si/nKVz+t1B1KAEY53nDsdStEp+eiQ7YMMg7sPjX3G2jp6vH6t0sNZhforHA4MZOpVUonB97mTpLAl0X2c5LNMi66ty6ptxSA/gzt9ig0qsD+jnSmX5s9nE9HL7K+4SfvzYKzQ4WHeFjtdeocZz/6I35/lPfHN2f7k5/x5uDow3oJsTvTj4KR3gze/N0bprsz7+ED71L3RrNgw0bH5jjp//WTdm99/0jfnrH3S8s2CMITjvrqz64ZGJ2V+wuJdVmZzR9x9heq3WG4dHzzcwvdrP/uvego3CbceDg5PdXwyufxdqA2ew6U3CkNojL9Fgtf8Cl2i98RU+9i9pex3s/pR3aPB8f9M7xJCD1YLteCO5hoVCe2kTNrjJZtErDk6Oo6vckHpfLFBwYBeqGVJGQeGk//SLFPlXKkUIdNJ8kOJ0Gvtp9zJWy2jyu9cmnqhIXRtmjAX1d1GUuL6qAQ/TNMNGdBhVRCTqOqopSwdg232WsQDYdnIWpFZcKxV4Jj9S837Et70gVkGKppVFxrzH27beZZx/YoqJr3vUIQaO2Cwre9TZKPu6h4Kxn07zSXGaYGuwrPpV75uvcjoCSV2NPFEjFdVV2/RzupbIJlnuDI6PDvZODo8HPSQBWNx93TsC0ZfcZdjH7eve/hH8C412Q3Gxr3vw71SAhaUU3AHn617jDzCDHZ4C/AO8AL7H3cE35+/eXL5+ef0yefHu/MObl2+vz64v3r3dSi7f/fDy/asPr5GZbiu5usBvUUu/V+/eJ2/fve2fv3vx8v2VVNFc3OIq/ss//3fmPMVKxSrPCG2ETDCS8ceiD/4ahnnnKMGRcEjbJpQz+MtdVtQYUXacljv/gGmKYT7++mjPkVPelvhyvW/kLMAckWiSqlBcHPk2p7qIRZojHQL2r+aOv5GRDwbHu4Pj1uhwDk3XrzW0YHr0XHqFOxE7YXoalvzFZnH4/GCw35rFuatOcTkLYp+AP00DzrIanxhyO3c8ZLDpQ5qvnkgd28aP2j3qfpT2HEK+QtCrROS78bjP4+NmZj+o2WB7vlLvRyxQGx8FpC91R8zIr2S2xIbe2eiuoGrYerG8vcWjgAWrxT940P21Fjq1yFotjqX5WJGQxKIqwBMvs6h8W4ADCyvzTDYAI/+WWdTLvm25/x+urt+9SV5dvHz94oou9/m7t9cgB7aS67PfvXv77s3vk+uX799cJWdvXyQfrvydd1K7JbTlduABYkLbp7Ms5eo2P0n6ZEu4UIww1xwc3bRnW+F+1o7hUjJGlAQeY02eVuctlNQvzBe7EybvfXZ+/vLqil72/bvX9OK8BvJ2H7hJbPuAHO4e7J4c/GexQpobxokSvvoPMSSKzWgrWVkksU1trPFduU805Wru04ctV8TPbLBYhxdwe5paRby+wnBN43JpIZ7BB7K5XFdOpgTnRcXj/Qr7TnxO8VhJVwF/2tJkhhqvYo5zOGdbjjzA5Zoab8xkdeZn0p/oVttboI5128q/rzPtd21+p0LXvKVs5vuXry/OvgUFdfXh8vLd+2s9oZw8tGXBkt2ac0HjH0vJKa66lDuUXqx3Wnttbr1NRJKY8OlMTZHqd5gEHzeI7Itl5bUjTAwTnXjwcMXH2TRHcsEJCja51EiWlAsd9aiseKjYVQ4uqUvu2aVIiWDIF14GzRsaykp59Ejn9Kn5Eho5ppg26CjAfyQY7qZflk4JXmA+9aLi+7xGJC8zjj+L/lwb124yI+bhP3dt3Vb/5j22fOPrtfqLLxwvxlU2hX1Z/e1XvoH66i9eYELVLEtjR9OkKm+WtfTg68N6YRt4LiJmdmyudI0v2wssyPRjm1F/c4W1xll/no8+Zh2L/nIGttXq2b+lxjerv3N5BxJg9VeuPsJbr/7Kh/evV3/hDMywcvVXvkfre/VXXmpHSEJir/7ueTktK17ANSvADLnCCG42hHFhvOWXlPFOduDkoiQO+3x4vOuz0MxptySjUntpxJoiH/a4oZX7WAzBVc9bqGeEHXxUlXVta+2YXrx4YAgH1g4KcDnxJFbTB+YclSej5gLdoO/NbRm4iwN+7gkvA4l2+e7qOrn+/eVLNkLELrl42WGJgGjPp9TKPEZZbI32PDNmhIBEXb/VhVw04Q13pocYU1JM4WgrUdXRs/D+Sdsmqq9vyFIiWVEzAJvuyJdDUgppX1fXJbtIxsW1PYNaRHi+Ey7FJMbhkxokqYJ64oZGaoO0htQmwrDU3364eP0iAW1LTuLZa/ALr7t2gbu0JnM9taPWqU2kTCz6cNoX9hSD/QRR4XpDUB+zrmYRvF9stczL+6wCy4eVqByuNx9eX1+8vnj73Qd4kfcvz178PtSZtXBTwKPbkQdzQgQ9jBSnMN+aHrlIgvoD6qZN3MC44AQrvmUjgDYzsD5MJXrL4kCssDMveHGMpeUoTkwUwwKvUAnz7KXXqfaSb6CF1BbrO9ggd+ACt5Z4UP1ZuCa7+er67FtYyOvW+iEJPrVZS27TGW4hdnzmcJOdFyGg8aHi7Ww5i2gsW5wT70RGLb5bi3V/vw1Tu8smZf1QE5dMzJN6V4AH9l15xV/hRXy3rFzBMB0RviWHu7tbu7u7iS/25nOzJTBds161dD4mB+z8zRWSNKNiv0eSoE+ub3dN/es+IvmKNpLnssYtS3S0ZZoHUmm8EidQ8w+EboGtuU01U6WZ+aTUztiNEMpCu3/+9qwxHgjmhzqvtZOGtp0jozhO3LX/fFeYu/YdO8RfjSNcpyGML3O0qb8mXpUed0di1CE87+ve4HTQh//s9jCSAO5bz57svu5PT8N5KXGI9uSI/Wf/eVrlaf8uB9VffN1bVMsM42lpN1fPVztz5etZNb09mN7+KcxORHf3F5RZp90PGqMNaMTj0p1rYyesfGsRPuMp8Kf3TGIjHE4CVYVcCQ1/u9lJfuVaH8BcD06PO5Ya+Qs615k/XLfIDQKfjVb4EA/A4enxSfca41cOT5/DIkeakHKzFWL7kbblpiN52KgNbjG39ZL+mEQr1ux5JF1WWC2SG+ZbqwSMxRtM8zfpp/SK4usyIe0OKHZDTs1E0hul2uJSy52XlMNotzprPfEInnh0ur+7p48kjTh3XcZgq5Q2p6vRJwWBwmYoojeftm47TujZdvKB2lqBsNyidnCu/y9xvSnvmpIHUWzn/q7k1le+GRZFK3mqYEucFRzkgHPPjZZgQTLwj3wHUP8jZNjJMIqDOxZQnMHzuV+hGH2kFvroRa9exmNYxuPT5wf+EkubeBjUd8pMxuVoSQVAtL507rjNjdPUrFk54KOG5+pHn8Cj4T+D416sezNf/as5srvdbSWv0P244zjRd0gkX0jzNCYZa/2QsN60rvEWaq3ZPIfZwH92Bz3kLamYuZ+iXeC6johiihiX8sI2WfNEVqZhTqupSKslb1sV7KIo2D19DqLAEQ3aXtbIDiVmG7vQYftGpFDGiMkmbSPbDydFhJroRC+TVmesaCFXNPrMy96TTVUg9RWo6IobVNNFbPYbbU8D9Qn+14D3gM4iss70sB1jld8sF2atXRuwnjQvJCrC968bHgS3MZAeBNTJUro/oy8FL7ZuafZxTvt0QaINoMyxr118mPoNF6D6aA2kV57kYH5fpnA6rl6+g4vPps6aGaDmwv/Ce/KS+B/H/CaOrVCExsqOV3ntOsiOveNoG06RyXifTadr5mOU1tqOsdweLexK6HrPRe2m4w3Y/Fz/dH9LzQREinKLT+uLbtL7lQbQDq7kcYzK6XJWUJOpAkRghd231g9k21r61muPubNaXuKZ4nG/J9p2tubugRhIBy8indcN3kafCerqv9y9rGqkzTt+SaynEsEbL4nkdJGFAk86SEe3+KhpoXuBd5cFD4Ulc72+5iVeLXR4UmtBPFUSfTRquIGlNlnDJM4zEguh760VJ5rUSbEBN1PnU6GDmzVN7k0q/aBdd2wB36D5pC3ascUuCQJ4P25sU6e3WXWavAW3Kqf2l4GHoUEuTE0U+LZomQl1In4ARgMSRnEHGTdhCiPk9UcKiQsNI5EuYtccOEvgPhYj8OWvxF7mEJfvwwdCekrufiKwkLFdSxfyWNyXrtkje/HY4Tmd2N4WKD3dgvDZVQJVOyQnTBbpQ6ORJllHsoz6luqrhssfsXpdp1nzcJBtTEn/9L/QH4b8h2dB92V4JJwu0uVTalbPXsebh6vfvk5INFba8zwDj6mQsRFfQmbOFP1w/LkkvWYIeeDmvXLVfeNMVVOtU8ML4E4LU01KSqv7zSM9j/0zvq3KdDxCtWLiPWGDyQ6v4Mb/kjYcA4WSl+OcjnA3a1PpiAkklem3IAXctUsuXsR3kV57h4Iq5HxgZikNXspNnYgxpw/++OLAQw7/No09S+1yKbVW0ef7IIZZQu91Hm4fbZkutF1+Ax+L7PMoy8YciaM2Vk77IyyGelrAXcO7OhGTPE3Ar8x/xMMIt2JUlV7XrtMhqjkCIStqBH3sstakpGib1WIxKpcPN5bLbZkq8j65KenVE6SZxDJeaXRPaLroQw9WPtTdHhZYeN5AAS7QBlYnCwf57HlEzXK6kcLLQ3suZOT724fw49TlrJjl156HjUfEuRCcUJqsUydM5J33hOdWXXz5Q67v4ZA9yP9gfppTHFU2IUU2kbbmcjiwy7XtmhVch6AdDLbnyik+VjfFBPWS57y/9jjqPkb7zR1V5y70IckkD2ZlDZWS+3WbO46vrs1Fw7P3w+WQdxPZSwvfRFc4hKmXjvOgPQ02Leum90/Vl9gMkciJQjtAwXL/VyUW9p9iJCx44NnYxShULnlUArVlz2vdf/SroiEbfCtXXRvIB9owG0nZVMr4tr9d/h8RZmMP3WRZ4DqXHNZl5SYGNDvrFeWoo6KKwqzUKA57CMb73SJsUfybNAEPcMFOhAcNSRc3ShRtaKHF7TsNXrZGkSeInZ3fxPV0bD0xh8iLF9xJ8pbf251STUOhJmGsw8WiXktBTOk2rzChjjjdYhQPPbd7J7jVRPM0IlNRrGZkg06x4bakoiIboopX+b8bBwaXj4BEc89XgFdaXNV8kpNbgS+5os2xkUsBA3Ya5j+xcwjiFGqpGseefh2HiDt7czIXzYVw1sLuTr6YBCMZFy6SPLrIg8giS8Kl005DuA2siI8AiNaqvdWjzTo5+WXnqWql+1LG5tmpXVvml1r/LuPVbo17mhCZMsO3vGkRdBbwXeLRY2Ge72bTBdcmwvRYI/skehg6l1SW0y0iOtjGEHRryqFxPkEoA156S9j0KG+1wla15fpXBvor+Oq1eTkfjCLxhSTVxEbPZ9BEsljMj1l29wgZNXx79ublKaOkht+fvf7wsocP7tk/RHbZ9RqLbXTEirC2R7v9yr7vLLZJGGbtNmkukPtsluVH7u5A/URkxJt8MmRyBkQIDRd3MDnwgD36SEik43PdpNtgswcoX6kwMBVab3p6kNEexTDZznRjQEzmt64nBLz3DYg1z3Y1MmkuaWXOocj1AaPmabXNJU27eFq6m29sq/Xgnj599tXOzTdB33a60S6WcsOpgrgxsT5AJkYQSQp3lzlLytkQH3ulHIXIfUJ/wR8+pVVeLmuuXaidZo49l4w+Sfr1UWmNg+VVlAjm7l2ET+Gm8NIW6BAqtfDskoutbWHNfhgHf66GRKr2QAdCAV1nakGRVyAuWE2vCTqSwwm6DbNz0va2iYYZF0/8RJD5TcUNbYJNFERzLy6cPstQ7OT1jKziCkNVi8bu0nHrBGCwSjZR1cDiDKMy3O5SYwcg9MTuI1mfUVQRg841SNUxlsGgele2eH+8Z3uzYf0xnw85sON+zEz7dNIFukVX0r6XD2VyjEe9VLJ3KLfFKipDX6aJDAvXagzmv/SzuAVNX1Zz+Ez1aMQTeEoHaFy6fWtigBhTV4mHhT7cM+zGA++B+QnTEFZSkddwqnFNQYKyH99EHkQjvh2C8CqfFBQhRFxTPMrLOy3BdK/VMT1INmJB6Em8eiS561YX6UccwJuqvMdcqXCAZdmPti0N1u3gf5K7ZfBcuRyh0HXWdcxE6livDxoV6lgtp0uRZVScEe7hRF5hMs1uF4TOaR0GBOFLvGLFNtqlwFDa0oYyeAqX2k8HNMEMzQnplwSmNqadud8Yn7/cNpSiA5sj7FeggLmz0nuXGee8e42dQhvP1MBg+RwcVuRnAhN2Oc189UQUtailBKlIkBoRNr4hKEZbDN9qmbVwHIpmLe7wTK7KVfyQPfmUsds/1hZlEb2YjYe0GaIX4fguXR4Dvs8ETjcPw6qcZj36CjclTLl1CHYApoj6A/6AP8Kvhgk46brEjcQlLSETEoao4OG4ESivnm0nF7fhF4OZ2O+jKUJJvGLBpQ3aY4+WESWNhA40FM/OopxWjmmjV1pOGQNH8pKqLOQl4vbVJg22tFccZ+MRyi+5OS2GRtXEipMi/a6IEWeWKW75+j6fgL19A/r4YUtWWtaVmdcqtovg53gCVwkutpQ4LvSmLNR1cnGDDkOAXYqYLeuyI0EO19CzhhWjrRB8Ew9T23lukrb3IAlEy2ihrm8+IH1S6FpxsykWjbfZglN1MletHY9u9vN1Xd4aqUK2YwR2AxOQOGoiDPtuURwUOUCLcMEy9eHqEAJ02iTHYPaka0LknvKSfvfyGsE9IHxI6sBzqVWx6ivVHk/hEiD6liBDJYfIWwoNCfFJuWxxo6CzWfojvO/V/rPYDv3UGyQagBWE7H/vfr743nkvxIS3PV/WdyomUmf59zqRWCG4qaWuJd7yFXqv35CgH9aguRfoodHiDRmq+9UOfUMtN9dvkdsJuhau/FMHZglgAoL5dX1wFByFM+U8lGTlEKdboD2Fw/76mpiax2KKY1yRB9pOLrmGCjsV8U/VccprnWdOEJFRuazSiYhBfN1OLyEiEzD7bD1cOhvv0+Jj8gabk4J8CLJ7zzQsCFokdTkzXAyfRM8KsEaXYmNIksLvc/LhAu3lbLEJigH+m48VB5Lh3chw6ASKaCteTNdmY9cNkjCy0p9uWTCSTVIaW5zq5qAvaHcGGIrJaPq8Uo6SnOuXQUCtLdaimsCaR+qkRdRKhwQ5L2sQAfmoS4i5rpDEk1+7BAeF8t06tY6lu0AWsjG3MLNArp5srEPlnsNae6SfeJzpDcbUjJNryWHV/FWYJVzgt7DnHfdbnzKuYPdIKhKppg5IB7AIwuIO09scSEIisN3jKcbrS8YjqddPTRZV9JJDDldB6tyaUXEbmNr/YuV3u6wI+BeMFr2/cSNg7e/iwZovFLPwSOXTUHCFlj1+zB7Q48AzKcAtkBzGITfswGkiXV2Cp14rXpq8jPyWLBwZisx6MQIFzyALSAqXcI8JYSVaMcN9Z2CKgTDWnRSdw2CatTf/B7WR9Yx9y2F30YM4IxjuU7YF6wxWLqkeRNOQryXcrhse0wsLX5KJeVeUorUmt5G6U0vnqsCobTq6I+vy4oWsFuNNQF8sJUvpTH7z7e8+XLzw1jkWxWKuzMFoWGjy0+rlDfW0JsR7SRndtAY/MGEvhwzgVLzophfpUkYEzBW3pYLd8L1D1SsiGAUyTgzzsSAZ0NDBjZbWqVW1ZHsOwxHcJVYdSROWSAW2rEAwYgvB99LrJyZ5YKZLR+pCfCZ7/6NiM0QDnm9gAm4gJ6SJ9prA+H7zpkoja01IEqZ+MbpzcKjwhsjXIgde9CNqa//6GlthuSigJT0tdewUbvlm4IIFxePa+FGQd+PHac4F9xMtRYL8t2rMsYR/2zVVodaj2IsGqZCf7wx2d3af72hyFbvLkPDHfyhv+zf5pM8WdD8vTGOWw/7+Dog4DB4tvu4Nb6ZgKLlSKIHyflNjh/AxlypT5S2SFbBdMiI/cIqYGjQIrPPHxphIAkdy0mEQmAZI62wCG1clggYHLZdidUwPNeHlMQ9mbe6EbZQgyO5qwNU89pp9h6Q7kYhEdArn4OWUSUyoLYq30LO+9+FsNi40KRUxLKjSLgywcyYEYeAkodQClEHCab3rkNP0BlsSKWXR4FNuhGCwoSWSb1UmbO9ZpdY0WPY0VLWIplkIUwmvQ/hwDDuwhO+TxR4iloPoGWWqgmvHIozdW80cMsQGq9/qEquSxyjMKzVvFIEjr5jBEZ8rAgLWHEHY+GpkSpOKRhqMPidLaABV0sF7vaDBZAtvfcG+YiQMQ47GSVU9UVmK6iSKTdvfGxjQduKa1KN2WkzFo+Kj0v4+P0JLB+IL3GFzxW5ASjoL7EUbKUkZXcCVm5rEWxoEjBN3LjNlM7uBdjl6TLDjKlu07hDGMjURIw5kO4dj6oabhdAmpwQKxBQvUTzQO97qYvtssk8j89fwIFDT4a+f5LfYobdP+Pcn+ku2WHMqz1wgJl9XD3/DN9mE26m1PK1rYOs0soAioBy2x99NvMTZWHZMYygsxOhcCu6HinmLAAUELrVfSLZ23EvXjWiLjfbwKvQH+r4pzbaXF7c5tmPoMbIb5aAs66oYMQ8h0Nd5OafqsHEGygYs5V+X91gXusXBBPi/u3xyhzhVE0wwLrPVUyBMR1lVfImmuJa+UFMqPjNmPwir+k7weCg+ciSqU5g3ClpKh5D78V5JHNhnjXkiasyJ6eCXnujVVOo1kxNdGG3RVuyUST1IjhB+jQOJWjKoWIpTdIcoOsIe6BCQXCWjMnTRHKKmKIv+a5TZNhnBGafAuZdJ9V75inpu3AKrnk7LyfrQi3UlOoo7vM9LSdZmY8ZVcZJ6ilnpKYL4a7SGyOlj0WHuGBXcBjc0Ppo0Aa1V/0ey62glSpXjpzSfOm4mJjGTgvyodIeXv6tSKdGBm47EY4mhXdTUhLKt0ZyG1D1tOJJm9f/rf7qqX37L+NmbTDHcJUaKKp5WAIfqkURUMQmlZmzo5BQ+BXB+V6E31MAV22dqeThI6DLuvRw+Rr+8pCyWlfwiogRp1RRPDtkhupLrSxyIVDNWpujDQcDbOWvmXOrkq4jJ3Y3lqJsoRdSormJlpZpUNglGheuWpdBV5JkzYnznsW7NKjWZBIYh2DoozuyTUUzWpt1SxE5GeoND/pa7zYeoFYIZzXNbLit6C4l7cd5QKvcJ+SLmsPYPLCtzm2RSX6AufLLAhhGv8+LhzfnLphRmxb/k8FEqsaJiVQXEdhIF6MIvFQkl1C61xftMtQKB5I3wQqDQkUVobSLoSth615DRO+tgjpziIUIAkU8xwj/yocxH0yHnyoej2yERnzq7oIh/Cc2gMJHRtNZsAEnwIGD4Fpl4p4FnJDnLm8wgofiKOQRrE6Gu3JbG42oIHQRV30qNNygw1NbIV5AgtQBa4hx9cdgXD2qSyGBURLUAomtgrHgQQHVS76XkmAWpQKPqABqFD25WNtDYrhIJh+uB+0NcPGMvJlCUUMwJlADTwz591tPiOOFv4Ta9LbToaXK+Cn/rsgsaA4EzaxMN7clyKbxehpdX1yRHHJhinKkmC37661wg5RxT5wpSNjXa7i/YbI3wp4t7RuYj6K/QJWVskrvKqden7KFhVFHT/U8ZClCjy0LaN691mVJRjJL+jIDO0ikjoBY5+oLOB6k96A2UvTfT7ca8skhIG1aI4yuLtu4OhSEL209lPg6tv9ASanIHJk99WGWLSxOeaQjDV7LD/+EdhcncxRD2++0SlyufbMNwGngC8/CYceFOPKcVzSzKoc2rcZ+iGrC+twu4yXHAvDG8yYGjom2Qi+iJFZoyiiy+7DGVGdjFJwMY8UHoOPQC4FEDh0oyCPRrCJUPJucq+ZwsVL/e5iqk8zt5Ks2cWhSX3RHhjW6YLYlIWsVGzoZ19oSYoqyQu3wRKQJNP5I2y2YJEvEmGMF09bDLWgPs9BmXuH6G72QFKkU4jwSmg5s1Q6OXDizu3Za3GISRFD4olDPJfaYFArz4mI9djLafRVdg0FqB1UFOKl2iPMyTeqWxFQWzBqaVNfg9Y4rFCBOphRPTBhMQxxAiADOu6kT/NMrXpANkSi6g4EcXVoaSRpYCq5mYP6lSf5tXibsejEYSB4TeosO+pZRbC3keuQRd5z98rppzWhhC68/CTGM4YQWJYMdWISRZP/BQIBxIOgukjWTyhGIhEcv5WXyOzZCATXks7pazmwI8yjpx4psyVfp3DY8+xE60nmdlbbrPPyKha73whFXWEWjU2CHyqG5EJpt6Pnyj78WKNSXE1iRsxlvV1aS3RpY4+AZ8jrsdZL1YiDhy0xuqS280WA7Sqlui1nG1nCDge4vsJsTVRsx0ZbXJTQ3qOZm4hCJZ5HMqspTUI32m4SYXbu2qkX6KcG+QV9PpFv+I0iYc9bb12880bH6fUWTrjmwnE9QyrUN1bHw9MkvyJjCXaBUVFIkXWimUEG2TYwEO3jiO4zTxVR1kF6eJ7nxYk0reLFFuUQLQoZIdBF7B5gxdWtJFVzY7gpwnT5VlWrD15HnJh882nd2F5mTR7qAELZym/iyD/fcsHT7VTfup9hbDz6znYjmlVL6iRnOBtVolnFJDNTKcdhfRiHjz4Gn7e82K1Zc887Lye9z7gcvvS2eukIlqRJTG4bS2fLZJ/l/mpRQ4iS1HQ+32pPYQReYcVe0kh05L6sO82qPqZVqSP2r6NvA7cwWObPkETpCCiGaHYrNAM7nvBK1Ryltsz29xQQ7WXUn73LCkrcXDvV64UF7BA5G7wj7q0Km44X/jZZauvpbGAxVbRFFyVCUQi4+LIpu10poVKnxfpIxbDfVtHSkljevAm+WE5++wFA37hIvLvd9mEV5c5DrNJunoIVKSSZY/iVkxq9pngXux62QYQBeFNW1Lt/WOi8O+im/hLgxLrM2YGIT541HwsCO6wKu/kLfk6C+y5tEr5QvKQdIlIJsseWiGgKJnivzM7LPQNZgqBNIIVD2DyTCJ58ahUFHZ4HMq7Yw4n8WgfIeMuSBxJvcEUTMuFU7ziebDdUNI/pcYLVpOPLWNcd5abls7E29rzgWV4308KtVP8gkYqc05NDY3dfrCXAVswYnXBuTBO1aAmamOlJ+uyHSQbBElzkeUMKSxxbAKBq55Vrk88kouAuYBDKMFjN4WKps4A2DkobGq0BUMeNxQCKPWrlKU3xCsy5QqUsrCjkaBL7bObIKTw97+1/ILCt4i2+RCWSSwdqdr7Rq3BH/TSPq1Xk7nvKjyyYQStusRe3xguMGHAx+NYX2n0cQCy6eQ+2lFnoFA2fzlde9YsLMmamPGWsIoiI7TyBfMcXqzjKUcOLEQw51uwVux7RWFMUBTp3wROJbriOy8hLcFH54LKl5I5w0L9KyI5AmjZ9vJVZaxzP5f/1MlchOeNYEBljfUAcTBznYmOp8dPtM7g8P9o+M1kCukH6NCRERffcHw1P7nloJDlNHgMveuNF14SBVOziyBPoop1M8ewd69nZbjihg6cs//cvYpHae0r++zT+V0SWNfwfHPqvWnywChfd8az+TXnE9thVHs4jnvMlJ9FL9VTYKCmHHAqb+OxRFmrk8iR3Ol920aEVxL5pl+hV1jRSCDJRYTwNSSYYv46HuK32yRcYfnIDDmRKUJic44o1B4agphbRopRAa1OS07+EDAe0AaR7TzJY3D9aaPSOQ0eIODB720BYk2/yh+fJ3YtCnX0vADnz7j+Hr8Y/k0jMZFgHk+SWnymETxj8dM4MGODEB+hDA6MHonhbWqgk2VZvYS1ZaOikS5Lp1WkdQdO3LSB4fbx9sD6cCI2kz7rO7t7g36uwf9vZNkcHC6v3t6cNgLm20fd3QF1RaRXx8dHv69zOJr93zs/oilw3BT+/dz7FDwK+lMuQcfCJig3/rGQH6KRaSYbuyDJVGaHqcnpz305rXHpO0hCf9Ma9folVplRM6PB0CngL0vJyA6uGRdGqL6Hx0Fn5KQsR9jP1UE4gyDhpXajrMxtja71B+Hn+pryKd7x2a6JA+GaPtiYXj4kP2B79A5bPxCsOdm2ODbvlMBFvBHvn3MfP5FNtXOtJxQ1K9hv1bYnSodytdML1LcOekNgKA36e2JvUj/ag0AqHNqrMdsrGPpge9Y+q18LWhZGhsn2rz0BM7QiwyvL7xSCqoOaxpd4GXL9Rr0cCZVHrb3aBB1lIxOrOXC4OjkZI9bLgy2D6NcSFmbEyZgm+vID0d+ZnyRF/mnfMtWaJGgQiLGah4lDwrDMOq7EtiyckBVh4tpNyXgfin062ti2aOeLQgc8xkw8c3RPLwFybp2Gl18JnVQhmJCqut6JKx9YnsgjW8ETJoWPx+jaxy0GSIFNWhAY6xDZtqapfXoMH/bAsuM6Qzj1L6sF0SQJ7rPf5QeFNi6zieY+CBwYnbNcrZneLYEWyVFqPKLB7jH8L9XRI5NBt4/pmMy+fiubjEdJuocZtSqymDwdUyPOhofPa25+umeYdiy4r8h+6XB+6nyCtaM3zty/FRwgl9Ua+EQj+i6y0ROVydzXYo8iIgCkxwbLPQF5wxfGWh7swEOGiCxh3RIq0aCiOz9Ev1EeBuUng4f6qHU2nOD4RR0AATxIQhwTHbSLnXYoQ2Cf/6xPK6BQlr9S/zTrwULyjRWsiQ8CTJX00mVzu86xrsquZcQAot4hI4vUutout5uwjHYF8oSL8nidbGDCD2drylqXa+XGCkjxX3a3CzEWuu51EZYCCTEH7LUkAM5zxEMh7PDCX/SS+VqR2LbZecUHLtNpsEFJMTbTb14Py/aSIVAZqFu4mWVmIYm41H3qfqJ/LIxFQRRwmg4khwIKpMJGOzXj+JTMM3jteJQrZQebcqo2DkPhlB9ZDKvOBL6cFzFNgedgwlA02iQ2PZWjKmgRV3cb7loht+t1Fwt97hFRgCtToiaKwFbpRoVtk7F7IILedOnkhL1NSv0zSaDV/xhAdBc1Df2m5AQk4TCeCp+AhuMiZWEZ9+xiftdlY9l5hpUF2urSzBJeUmoWd+LApcQiGowKnteOSPdH2o0KhOhaFkxLmfINcDhv+87GI4pV8BKQ/N3M0+vec5LBBJebkjGRF214P7Wb7asLEb8KfwFqqFInuuRpjYJsYxZ94BBxUw+km0VNtJ8FaFd94aqPkHEpuowTlnc20bU/oxw0HZe5ZZ+jFicuriEw5dQNgtz9lQhygEQk9kzmm70XgHamAdSIBnFZDwcUQnXJV5HuYeGOoloo/22fWseLEOCVMTrqzw3XL1Q+QaRuTsV07Kcd7wFheSwObPXpiTSXJ2nk3kbGQN8HZBQDnkzHXWaF0VGAKFuwi7V/BNhau66On56kiVxlSXh1en6ve6WMwvw93LGcBVVptBLENdixoiAzjfFFsL4C2GbYCZabtAiDL74NS+2otvczYq7AVP8XDMCARfDz80UH7xPN/lrU/2yZSH5icer4g+/cydAbBRkKKge4ior+GnHOnCSqf7HXHtXbGZKiMlL9lRwRXwyVv6sNNQuNeTqNhyLH7Y0/a9M/9LzJW8bT0TBWHZt8WsTPIRTYqloutZ4dpaF/tCWaFCxQscydizhci58at2n0V8glQkw75uq/Ahr1Q4OGNPBevZdNx21FFa1WFYzn71li9bo7/XxESq+C4hFeslYpLfY9Byqv0+phJm8NL4rIupIHVgKEwXcrn041lMr7yEfIAcL6l3hh+QX+jo4VahE85SSbwrmT4+iQXVwWeTK0yZWHL1KVRHi52unZteUBiQSB073M4ukQQGormQ6Rs4tZ+KTUbZvvNE+8L5xzqzlWJr1RgWLP6I/nW9waNqPalpjPo+N9fD/lZuqMAI9Fe4B33QxGrj6wscp6mmecneGBgn0RqOP0qC+0Rz/Lekbo1KC4TP0dmtHNuW4nB4jsFNJnORVrkgUxlqpcJF6Lvq9aF5pHBXcqPVBRFm0cGeD00DqV06E4LWWU6khIW3d++rrnlyAvNZbQ4x53fZxaw7dh9HBvoyI38B4bT3hDQIYkhfZJwQB1WCRIKSpZa9o83IinkJuGPorH1OJZH5clHOVAbNM+TvRfHBGj7IQRxLnK+coW6kGFlH++dugASkGXGh8xksOPgFnvzn73RdKga2Gr+fksYssm44kP9lcyGJRhW5C87IY+uh84RfmLzEN+UVDEMLOT7A/uKDUWPam1AdSeU0kedwZEgwfI/pZzHYez1k3PANCP4Bvu17kfUdVMhLfIoYA5FWZ+EVrWigMWmGmYIxruXYeuKBfIjvAzPr0X7FWcW6MrKRdpo/f/c0V8zoGjTPd1OTYSYFweBM2moqJajBYnIyw7POcsOIqRxs6zgjB6RTvg5h2tDMbPRaHgaXHM2Zjpi1+LEfLayKosvxR59vkNfFXRIupk7eMAJowcQupcQp1z1a+RQhZFWtbXcsHRUc68ACzn1t8ZzC6MgVb6DYz1xi8v8RoLzXMuMKla2UONsphSMElxvk6wgMbOjI+gCyi3rsB53CQZzmVvMbKTIOxA3J0TLBMPwUkHBrP17hGGPVAe4OsQf+LDi/AURLhCMY4qTv1eUcww6ncQL7Y138jHmLoCK1SyGaCgrXx4tZzA6yKZfM41BpagLvlvT9V7eCARYMyYUwm7flEMnYnCYND2JkHb/XxEFCTLpIQHrJ2KQgNbEuUA2LpAP4dv7HmQQqWCst8FDC1Mi5MVQgNWeVjCLLRpTQM2jAwaS6PxQPcKUHvt1mK3I7fRtIcjbeTgyRGCXUFjx1BqWUWzi+7Ch1vfFOOH6SwXrqK+OVquspqDhAUnEuntY6L64FWiJFINMN4iUH8LnekF9JVMXb4HtX/B3fsBqM2hbNEzcNR35r04qIEuwbFim9z7r1NF1VZxF+16+m+W2GrmeemsAcXVG4axZFS5GDp7TozQuBGUr1yU7QxiHDAEdiRuiDi8WJgvggG7zXSoLkWt8rU4nMADdO0oAKtJK9x8yDHiexY8IG51y8d5WgXxvZTziNsPi4bKKCGIMwDTyVQCl71TZ+od9uXwLmMixxbvZm4j21f4rGjme3zkilyJfbg/3dIZApOyzIzFxDx6NVKfpqN/Q3k1WjLN8Ub4Gm+WuSjjw/Ja9vSMpzJT9eeaxB7reB8h3nSls9880DZLa09Cppylo1C9WXdaUMIiYxT1SLEZqG+D8PFq1QNsi4RxYTNiIzLRRRf0JUdQoslo5rPWjtGUhmQsDlxOSjVoNgt7IDBtM0RjJryqbnLwTUh2x0EAgcK8h83+HmQFgkqDkmAmTR01zJJZAlVwYSrEUbltKUQVw0RnIaodWN8Vq9EYycxjgfjmG+gj+kVeZwtrYnmg8IodetSxcFcOGQwcz9i5Pv47RVP8IZM57P8Q34Pv1jeIIf+OCu7HmaaoMIW8QWUZjiNVFr0DAcXuCSwyrTtGTYyeib40T1YU9M0WCbJWwO3/E76p/55A1Ewb/UwBqRh7J7ae6VcSugtzdVgqpZmr1vJU/Urb5jKDkYWxvabRdH3NQNk9CEyt3t8fyWiyEGKBRIlDW256Toa0s037uMd8ZnjKWXaHw32xMApa9LibjMaEqcTqNWVuUXxcp8i93wUwxtA7tBd4QeIhnbXJ2qLRaEZnRHmlXADrtB0NSJSFaLvmEdF2ybYvK6oB1pnP2ZV6XxwT9beTHV3bJRgtBlRLPYeXIXKse64w8uUAJgWLsMccKzJ7QrM9A+XL7F+lRqQoU045YJygUy10p1Guke8CrN3ASSTrTPNcEmy33c7Mb1A1r5JsPSm969EnG4iVdDWMuw2MjpH/h7luuLaEGc298kTPMok9zcDTkVFmTZn0+4+JCRdjr9unB9aqrXTl9xUqghYakCF2XCHkVq30DbVFcGjiGxeGSxZvwASquV1KAuh/guwaZvc+Lb6cZIuAN+IHrt4sd4QQ9ZOCip68IKaUM3U4IaLaTFqXlEEBWrNLLZ0SUZ8KLMtrwf7Ig5xiTdpjBAr06gz4jaTBLHlctEQLNXjjlMq2/+uLCcEqykWPjRP5ILjloC6edDzE5UdXVjuoOGtlI9TPnNKUrah+yK6kd7NtoPvPp4mMi69c4xKlnJM1Qt8VNefckMT3EJpIejUJy3STeszOA+szji8mqtIUbXKhZuu4NGDS23ogb3VDbRD8D7UO0zJrlOllmyEqoOd/ZJyH9uYm19qb/skOvpui6gscCpa8sh+hxp4KUJQ4frUj6wRXNkyoRXmmOTuxJrtrRvFKMa6jzQIsxNspLYwbl5zwxoGLNEJqWuE27vYVZpMcmT/Zxnmu/rUEn9RbAn+OnxyGyjdV71Dr/ZQLwRFy4tOF6lxLFeOFFi8acvO1axgXvyReZYoKafZkDzOuBAx/Wyuk65WW5px/N+VhLtwfogllVxhN4NB4/6ZWrJRVc4dB5lvAUjrEbY5audXult6h5wvIYBgWXBDVGTrck0jTBNFArm4eKRpPub3hyVPaNbG4vrdE2R2N52gk8MkG8ef0PcUolnjzNoUwMonMN1CgAduBdElyXyTabjNlfphkR4V8UcExW538MHyDdKBd3q/IQu+XeNOYka4yjN2v4mGR+xCgvdReANdfGcldIKQNon86zhN6xSFigJaqHtlV+bCGDcO02DzeK2Fz6QPTAgq4Pi2M4aYf4qH9kaAjtExFaYQ8xMR4o8iOTv7XcJcMy6dRzUlzLpThDk9CRXImeaAcFS7WerFSMzA5TUXDZZX5XqUBRqp3Rd5SEPVu9ihdoW1qCZ9uNBY8Iz24cTGF6s9tIakkXqAS9DikkDgXugXySrempbYLjfL2eK1qUJ+IVMb7I3emwwZ3w+jr7DC9cS38wDfOobwXWM6hO43L6xXQ0TAZQwLqRtfm3qEJ9gjIz0lo0JmRbGgg6iy4f8CVbUY9pH+gJ6dlAV+gzyJgjji2XC6xRGyFw9N9IedYVcFXTZuohyY4QizOg0T6VS542mAVdB+66spCidifEc80uAbQSlZ8MkV/NkRPjNzy1wkIf9tp5HmDX7dGSjrgh+fgQVYRv5uIgLh9BZplUjfp9jqgEKnzmXtzy6rcsKNf9Vxiw3fWYSp1P/2nUJuU183aAr0JEaDna+Qvc9zt41dKJl+E56A77jNCzOtyLkxYTUiSvKJw3a0y/0+cIvY0pWCtyXNS2xS31QkUn/wOv+UNXNMjH5eLpB+ZkuZ9NNpEHjebMUi8UGzfKvWzQkhXuNpA9UTPooa/8wpqNKsaq3L5j0dpY59yORfW7EOJc1E+cCwH7VlWY50zYctCsG4u1TFg5Wv8pphgqSbAoYoIP4MCpjB6aBBAXM4WEcBM9jb2z8+2Hc0MG4OX0gDs/s4Gpg4L8cvhDB/m4QwB8fHUUKYX+hJ/q3QkxDpzh6cFFjEcV+/0mcPJ069s++pdygE1mDe6R4syr9zBF9/mda5a/+3xSKUaXSJ3jVAUHsPnrkRoiw7eye7u8yyswdH8eQnYtlZh2bF37RDcziDOJsbUVDziBIAJbr9POT5sN/Xk+0b4YQBlpq6iLO3ef7iLZE5/HCJGiB5ygf7N9liDnI82mmkSbhp2CI993weNMmLDUO/MmPdIlG9kq9nY6ElvWfmXSK3xSDKMoKSPeXGeaD0my0TtQknji2FczURgOfU2BTMa3SbQhpmDPQi8W7sOX9altqNhQKZTI2KXU5sr8zIjTwlLnMQ4IUn0CByeE4RSDuWRU4heOoWytLh1vCvNNcq9pTRtCwkTz3zTjl3K9D7wTEj6m8tLxQbSWOoAkHA0bgaUBvQS2M7n90h4UG1UYt8RuRf6IMFhKodxwjMNrcp5FXz6kbn9YG6d3FMne890fUh2af0ZtCGzzxdifX59ErpY7zB5TvquHxWPwuBf+0CLOjhq/rw/MFa0Wa5ou2QQW/lQjIEEmCVRIEW3nd0TsJRerpmPThLk+VMOk/w2midtycF0e0n6zOiMjVdpVTYnqvcVAxgl0o3IjEeBMsTXdgVRf9BSYOrBCsZiOMfEh/3Z6gyb2hTxnWoh+4q4nnFHRw+X9TNgEJnmtnXnBKrr982Oa1Op3EHTWrKi6vepGtvBNADyH6waHHEwalzOOkeOdZc12q4lE7YijmglkP8585XPTXZBERxYgsARP67vsFB3nfsGnah/K89//krc2Ht4HL7A5yC7a0c+YkgqnogQ8it40LE19IxisSuTf6zBsJiHGdMcPckMmeIlYSKfm9x9Og9T8mdVGoLvDj+ruNfVrDu4lfwg9i49s41JZKHsJkzE8fjn5pkGttidjH7uLt9RLL2OEutmFZEXND2x+tLhLXJ9U/u8b0eIpdATyMMjQczCWuv0RxcWzZED3JH+pu7pEUq5uvlzSxf6NLgwQ2DuPQPfAlXFctai0c2U0D9laARpcW6vahFScxB8FdSFivIN2CUkQKF2RLTKTmOdxuoINWnRcmuIig81dKNXYPgIWAsWNKuvHMkis09LKgFDaPcM1dRQ9gBsHFjj/iSIgrvadkGvm88ylHbRZiyiizCT2XOR9gCLkuu6Gwo3IHqey1rR8dQFkPfjD7zyYsswWHbzfhyqDoO1/IZOEtneRMctc4do6j1ErqoX6NlUgSxW6jsFJAeOb5Y+ugu9COXMES+igHOI96Kb259OxQ+FMujFNO4zRHEHRNlMq4rUUcdkpEFzu6sXCDcCoHEWb9sz0Xv2Oon2OEsLKKd997yT+vKvDxiCqqcvbnCWcIOQWgrs4MD1rq0Fo3B/aCopZYBZpTayTyjbDHtIBlzLdYvDysJzezQ+iT+bXAstuCECIKD8iwk/lYjiusHsJGom91tlql/5maomVA6WnIKOUB8g4hy/mPukveOBz3KYeMFubVwuHI/fLs00Nh2QwquCKRtodJolIL9eXmfOd9Ii2Tusxs0pzqmQFbZ54XRww42RYKV6XhC5Juvg21hQ6M2GKeinVyAG4/dUINAukNUBaeuJRsi7ADBGWy5EOtiLI0aON1kRkIQtmtBndLkPBAAzAbDOld1RW1yTpDAce4ex6PeuTprlgSzcpxOO8Y3uQL2DKKLJXC1KN5A4R1h9i5YzFhL4gx9wnleSUViPrNcCOYTxGuUY9snnF0D36GYwLcls1ZUHVBb6dXhW8UaaWs13v72gC97Wd2bjmNmJA+XzxeaCLMdWPQVqEGg+YBji2hvSrRJ2nERc4/aTOcv3kYXsAO1vQojbl+KCXtBzlANja1Ix0ZwKD2qSRarvFkBDnemjCL02mDw/a6xwpIDj5N85dOK9D3iPUBpO0ZEPVff8CHIq84MOq5XJ+tw53r57nfoq8vhkONNYtFTLJACy4QGxDV5q7J+DmZ41C9ruOB8aEx2jtaQLevM0YugleCqyRXc31UZH4bfux+wFUEqRrT+FhOaqjjGX9YY6xKZykGMaTmZ8OrQ59GNaBn459w4K8QUkdq0lXNZAY4ou6vn6RwOXLr9n/5jX1rUq79ZhUCCWmeywnwOIumSynGShtsDY6SVKgnpOwUIdJKkKKB+LIuN2DlZ1jQD4KUOjGFMwpHrDZosc+XYIMec6Q/XhIX4rsizpG+b5cFrrs7j8l5IcfGGKS5CPuU8YMIQNROtDLLnIG7QWQ72b8tyARZCOk8Ouk0rjQX6GJaswjp2jDDyi4cEpUrjxBBmDTupCDZJjf0RdS5yTiccxiodreDuVEMIZ8q2CshNiV1r7zbfeya9zRYRE1kwfONS2yh38Rh176EEIAPmG3b3iXQtGOyFVrhx52Oh6kEOLA4OcstlkBLlWHxd7n2ObdEZek9xSU2/oTyJVHDvtS2BKEk1shPhn7wyCewZbbiOpc3Wc7L4/bYM4CeJ6+C+Z1Mc2PLKjhc6YNEpbPLIxssxTgOd4gbEc/W7bJG6pqJ2dZ7lt1uSgpgSlmErkToL8lcowvjh/euYhy3WAOdUXIjdtSNySuSGgmf3VH1H1IvW3iYybe5ZSoxleH/Y6NdNbFny66CzUlUltZ0K0M2JaSaVmD26cC4UIhwapuXuCs9fs+ZUlOEjl6jUCQYVwtG5dRP98Eyh02/ibli7ACSmYDwFiTcu8Lv6DmWgfpzWMazOxEj94fp87RTCRqamG6GjLts47hSM29K7fmRnDXEXuE3HVy5/GyUjpDCMuWVlY1m5C1uYprCKnqJzS4EcuTLSjXEdgXNk6wKDKyouykB3cKSDYkWU+k3djvqfbPRkDZ1xdROSEnCmb8aCmO4AObm+OW7EY1v7KKwbNe43alY8eqgCXCwhwGpIlpDj8OzL+ybvqx5H8WgjFyRuR++aSk21OwHsB2J96TQfueB/GOrD4Vwj0HqebWBxe8AxcaDrhVecuMRARoIlU2/MkIBtgcT/mOnSCyZHBfAjHh+G6g2/db0kiIWTx5hEESbYjfaT7MhpeYP0HS73+llbDvrOh+Gy86nNuQ+ps+3j9saHosomeb0gyUHhQBsb0tDAVbZYzl1bd1pIioyURVS9cNY1ykWxB/5jPEO+GqDuidtYkai9KubQCiOoZc03ejqXHGzgXvDL+aRKqaLHomHBZiSelYV3aKIv1pGhbngSNhnaKkKAYdCbY5lDfmNY1Ymtv/7etv2KzaM7o80xjIDYgQECmxU/hptN28wRdRcg4R6m7ZgSxmAZ2uEkOWN3TXPWzvLQUVnD2ctHLfZeZYIwxZwUXYCzAP4u+Gm1dufUAkGzq6uWc4UfaKKb5Gl7Xj/coqxeNIK02SwOskla1aSxq9TiztroAHRFltosrZGbizkwf+heYm0VXytjEqTSgY8NKzWmNppbRzlYpW1YOVPOwBznTymMwcaD5aExpoYIOQORN0QNZpMj8H1MXqjdqhsgyaRMlgtroIJt7g5TyHPAbneFQWJiyRsIYocy7NxvWh/KPiNGALKUUvDEX+xyTV2Ri4Zh17TVEENGDeCpSsAncwjwsBXymXHOf0d/sYOX28Ua1wQz2hFnW/YERv+cO8SBcL3RogVcBJdq4Kj6lrJ9iaabkU0DpuhaDZ2qmeWrYbQRe6naWhqBO7PdnPf1woCEjSuGJbXfYuK3lnQHiK0lY4iVhtdK7huLt3sksDKXjcPNjxFfsWsaGr2nyM5QauLNQwc1hukI+DhgG9S4+RLRVXC51arRiiNULplQ8EcCmmGsVn0LCWwKf4fTTPP0gXTepFwkqs433gtzeE3m9b5MCN+eLIt7uNZjqwz0AH7BqbLbPy1rv9aa3w7WXLGfDtTR2l5pSKjTSSdpvLjPXF2zB8SnzgHJIKKLm6ItFrGuxudqzfzXPKa534hcYVSoviqKbZ8gaL+bbm9eeauTtpg12ONes3G0SXOblJIPUljclGzGZm6gKnuDqqjKqU9c5RtjRtonhg+hv7EaFnDmva0LUN4ltOLjuKb1T41oFjkDfg0ttE/kV4wg4HvOQ8GZsvYG6ya5rK4cX5uCMido1MZYzbvoGy/EAlUYP1tpFl6oaAve3zNSqMQTePZY0KF6ojWXu+4xQYozstQtldURwYpoP9G/Pvrko26+jGTLOrIbzjaibGK/dH2/4L5ni+aBSMPID8tePCQucwVLqE7UKr71YC4NnMbEY5l8+l4iBM7E33gJumvuqCDkz6i52zsdHDTarj9fW3P3/Pnekau4czP4eSruVtXj/FJ397dZdzfABf1rFCxxD/Y9X6M5S+cdHdj3fBnYG/pS2H+9NUa0+mv/cM+Vf2npLgK48XwRZ4fv7oIKX1i28HnbMONx/olDDl/30imBavC/+/cpEQD0SJPLR71vzG/JADv7EUlj6F9Bqn0ihOdXaXIHfu/XvZ1/QLtlmI+/PjnZPxgM/jMGpPrIhUoGR39xB9dmcgf/m/Xta/Y5GNaTsMvXveHNNEWgNWzx172iLJExBlviVAxJqXrfyKAu1Gpe+aud9BuJUD9gJFmQYU9qsag9Nwd2nMR0qRfzOBvYWliib2Ilcs+Pnz/XCrndn6xCLoYrJisxFxoW4SL0kEJYJDT1jKEesR92OwropEWmcDa5RigvGk8zbSGD2b5Of3xwiS9Yr+Ts8oKsBR8CE/WIhpqkNK2B8pSa6JZYsgfnF35NZVep2Ah1WGT3Xuw+Z/FRyEZD/HnRWqQsraZ5Vimyb0tQshXuP6xYkYkFSRa2YPQirxqsY0ekFw8LGdwmhE32qDBVEwFwyREPT1EoiYybqryvlY7ph8tos0V8djfW76co6wketaKCCJUIJ0vgXXELapQBjopIEQ9iZ3T0edCSKjHzcSvg386vrnAfG8cv+kPmCsqK0QODTMDkO7vPGMPeGoHrWmZ4VkWrSY4mcvd6/78STKZp9knw1ghsmKXVR5A0UgbJh7MBS6CVGJuD79Kwou1oML9QfcxmjFKsw8NMb6uiw8zI/whfjzNPlPKfS36RpITkePgm4nSJP9cniMPeA1j0bXsNRg9BR8wVrhBFiVyA+g09L7ks5x/m0imGmnOcGRKalMSdKJbgJV8WvHTwAgopdtv3SjprKr1SZ0TdVhlICUqEtZMXhpJI4vhuUaUGIR9GCyLY528LTEAn9AA6+iloJmFMDXwsUMUz8NvU/2SBFykPTq7mSCF+++Dl7Cvq9U01G3OngQQzDA+g0eFdLkCh/ZAXY19CH2yThJ9BEJbF5BvhBqq/2pE/BAQrr+UCcLPIIFBMaTh673vMKfpiI5awQdDWniyQ2sG0/tN/hH/QycCLd8zkwwWmClCmzDKl/LzLpnPHTYSO0O2ydmDV1LFNui5Vsp+8Z1skPnHKFYdqTRApwkCKZheqLKbA43MBXhTS6r/kUsPSYTc1HfoU69lqd7/8dQxaz6EuiO1/A5GrWqChtUBLzafCgOLx/KRAJP5HL17gYU3/mH6Wvzbfjvo3Rdr2kC9v7S19fF+EWycr857npNroqHmxBXdIWJmwfgDxNigbJJTc2sdIpoGpo5gs0zc/nEw4Y+Mf9OGLTqLPXTFoAMzh5cw10aR9uBgLfyulZamQLm33pyjGQSvz1puh0YEcsPAHxEeNs2zOxif16iNXGsfnbHqEZOo9gg+I15pax4lZhYsz5MUZ6uJ483CeVuBv4COfUov5fOGMhalpPGttezTDuCE9CYPwKL/BlG6GldBSMI2ZDLS+kbEIk8/4rBmSfue3rHbfPCSvndqVAhLGaXWZlWo72+5yeLEG2yenYbmJu0QvmpcIxXqj6SWf+iGe+qGe+iFSFIAM/vD+tV+qLYcJE6Z1ajzIwS73y+gaGxFJpa/JYfJx1uQqZnvq1tcI5D6yWWMfRyqv4UBSUM6o1ksnY7Ng96XnKTqaJESnufo1r0AS0PFdEGcLU46PmTMGZvPHGjy08mOeRYvrf2ApDAYqAXinEnPFRi3IoNjXcCACT6nXuza/cOYPRsGojJpM9y3XvdTuDFgVuOlDJu42+DxCgzj616vfvm6UEtIcrzi4KIMwiRXGztkGWi5KB3vAlCOmtjkLOGXIIz5zO7m+y+uERT0tlmvmzEKMNUstITQ2gRBzUdDNwcyB00IxIRpPFt8zwEdknSdDZ/kWo5aXJKwHbHo5CP9Clz1mCHaYUa3RaAAfwxdBBn4iuJt/Dzs5X7IycU8NhnvHVlFgvf7mKuhUY6gET7pwJv7H0UomW7sRDNdyXz6YU97kQVOMrPFRpawm9tQ2M5k+tNtcbhm0lpeWUZawksJ/6eWbBzDqeQ5TUMHTO0pJZN8uxtZcsY8vu7bQz973P3DCz0BsmULFgcDcd1P1MLpqQdYPzawIuSKjwM/I0xffogH05gEFgJKDHnc2nW/xpEeeJ5Wxvt6Eu63JVx2XAdtcmJUtxzm8U6wX3klXpXho+7mwP8akZJUcYIvDGhobCDi/7ZNaXOXOQ29kgPTswJ0GsbQzxRQDyTkZlH/9Zokd5DuGaJioXI855roY48415hEQeKsoshKjwTMg9EiuOCTSG9U6GwHrM1Jaz7nMOVoAFnt8bKDuEjKOdjadHd6M426B8+Kq8zcteeGEVFe5ZUtIsxPDrxZpj9yQG3KNVqwp61AElmH8v0C1WM+I9TSU4wKyzW38KbdNkIMX7aTLvr9DLgoqzMsIuie1SLWqs1VQujA2z5eoGfcZ5+m0nLhK43u6zUHJ/iz9aKKr0gmOT6IHJVEL9rXYHDVK52y6tYIYJCq1DsHZckggQll6GA/9XipfE7FHQIWsIog68vj/+vr68mrNPKQpZI/DfyDo/JpQxjFmUPYcL1NaU2Di6uq1ZYyhq8hSUZuZE3gmnd5jq4De2zK5oFaVr7ArXG9DY/6YLxZG/xBSnPLo+Y8iMS7ffucc89EmcATmR+NSEopSchjSRDsdDwfySXMB7V0+oQajdEKoFwCc73dvuVKUx+Jxw+e/yGCXR3Rbkb+kvywoKOHg2eG3vwfFVWLwCO+SWJZU6uoDIA46RxtDsaDbtOEM/2NB1S34xqf+PjYQlWQt4uLCIcPLN2CiONxcCjQyAsHFDuGpdEW3k1+X9+hfbsHWJhQ+EOqVEtFFyG3EcAI4lrzmRCWNT9R+wTSOrUre4q+75zPfP6WnsNVjVFa09CfLimnJbRUfIyDegz8yYja/3nuK7mvYV+WCSoQiH8GafIiK6c6eII1Ha3y3q7nF1fffYbmZMSd9fEBUjDjhII85lpXV8wyTplP+7gUeigIky8vPcCIrmPFg0PEwyTvwXZJklivhygunFxRyRAEpOpbaZ6Hh8wS8bP7UxnWxueoskOJerJhkT/nuibStWcg9i8pFZxKyqMVvRmcQikN892ZqyEIAORjBSB7B5zSKxgJh7SIcMQOwixKkCNggkGDdSVJsConOn4B1JCBhIgmSSbFpjVftxIgeSx+WuOUAZrsNr/bZbb7emvG0ri/IR1L9R2hnMLhR+8rkDSgLj3snPOx0tghwbYCGpJbF2JYQQb2osgw3pFHF0rKIuFY7yG24lbZWP+kgt6+CZeUuCKGvstYoc5fuw4VEp/7ln/+/Rr7pX/75fxDPJBYLYdJBryIeTXSeAtShRGQi+k7KitXuDl6IEkqSR0uDlKbdt94ZMVHIj3pyKiMHuZMMI2Jr+KPNq2+nRdcYW0h4rnW+Y2aGkTeNeBx/799bqnyX0qp3nZ/ctO+5djjADXY1ycRMvEpCoQdtSJKUiXTXFJcxIEyCUxQtc+SYOue4l8Gn3MDZ2IbAk4DyessqibwIgOd+wOiB/ogdSSiZi2vYfC3GPJNv1sewVgoKvYNMyOiGU02HwZ/BTcC1wZyuQASix6y7fbzBl+AMRPVjtNUFYxph69NG+sH2EfaW1mlQ0F+PqnI6hf1BfAkonN4WqpvqYXEn5mMPR/qxlCJb9hB6mtWFLy9GYYBck0PyDBFFZMKiwRH5skbT0BzRn1GGNQYFPJPjEgQzyzb4wUU+zLnS7ht8JtvkjD7xJYaByikOZnccqFdUwB3uTsPAyHGeOHRTaUbOpcns35rW9JzLgmPZbGejiAA8I3imaYNcuFNr60jcPL3J2JK9d0QJYkrsMXSlle7QwcNAoFOvHLL7KkFEYvJUu8sdUUInRTmTz5YzNW1ca3FBUD2A8xTLEzZaWDlNq9IPj2HvdT4THrh3t7ewPirKXSBxQyfs0BhJutvqDNr6a0/ZKHUQdUvvR6/3ul6MDm4VIXjy7eh8kAPB/2FQwwa3sZETmBGfcpfJj8XOInQvG8wKke4ORmE0XNPa2RJn0vUGznyHaNPMZBOg7e6fBbQdnO43gLaHu+uAtvuHR8eH+wZpu/tzIm1jmMdfELZ/owjbg5+ys8VPB3j0AFxUGH3uCBAH4B54AO6ZfK0NwQ1GiTdggKv3HgOZ/C2HUDBVyWxhaW0CUyiRPqNCJml7Ee/EsLs/OFGc6cn2YEVXsLAK2jxEathuSyQ3IKLm2rffyaOAUXhSK1Hpn8SrRSXR+KLMNfDgeb7JTwd35uMDOXpkDnFqmvOnggnDr91l+eSOF4gTH///9r5tuY0jy/Z5OqL/oQYPY7mbIAmCF4lte0KiLq0eyWKIkt0dJ04wCkCRKAtAYVCAKLrDEfMP5+m8+Vv8KedLTu5b5s4bANqWxzGheZg2oarMrLzs3Je11wYsZCaYY70aNrES5P18NTBmlf5eYjecoFI9rjAsZWEWUtjPDJe/wvfuenPw4OPzqNvUmySBYlWcvX55SmWhh0tN7XsBKhWGoYy5+X+Kt+9Wq/OqQZKRXKk77dAN9mZyHtPn1Ma4IV6O5oPMceneBaM2munkFOc5fzGRCxyh1wttz1BTBRn+AjlwHeuPrK+8MYFKkx2U+kjMuvOsw6FktmHydQ38X8sQeZDZGlKlkTcbsqQ/o5wlQvu+THEeiViypPf3oko1O4l6NzvFi/IW/EmfE0YOgAmsQFm6fE5Cam0JcDdjpMpA6TV061DVazsELoIjQ3tsWenTZOeBMgWEEwQU0itkxf1DPbGIEoLVovzHBSpRHCdHNY9CzTk2v/sJp63cTlfl0qiGdNckiuTq7QJasEo1ZDYLN+kA1Lh1MinhDoShHOeG4rtRHsrVsZqMsJRItXT8NundjaquAmmC/6gYN9NKr8cdu5Q1wrOnO2Mh0ZXzE0uJfBHe0sIjQQHAdJPCr/9rSb2ij2SUTuXKO3c9zpSf8Z0UnXPdCQtz8LVsueY3mW9F5AYwc6EodUMlqjHYBhJWiK0gjtELm48JuDMjHOfMafuZVT0yA86eCs+7n6vPLHkePJ8hbUyRkN56TrUX0u5sSpEkwK4ub0BHvVl4kQO7a94jkhJKKHk9CJIb59lMEe4cEGsY9BVHDJ19swfra+XCD0bvxHSOQnmXnkHTxLZGAlT6X3r87fzFGAxDgB/waM/NHU6veRxW9+rdajeakM83HzWx4L1vRT6bzIf60Ua9ETIv6K0iBAkEY/JFk0fInS1cH5rY1dIbOu0BLDXXhagVXXNZHiYf96VnKUvDFBTgLUI1IJQKjx6R8N9S/qlqvF69XZvxjQwparexwETopvcyxI8hNtCSKBS4lXt1i+klyRecX1pFdNHz1FP6PgX4R6PwjGzBbFXR6c8UpfD1U2/5+hsFKk7PrFjNJDMDVLMlYJE/e35xef761dPnL55cnj989uQzC6Hytsuai6Kk02CUDyaIiC8FckJKwjUTr2ih9ALiEAnq1a27JeNvXcfc7/Y3n+BVAerQpcQmEqcWD9oGWUBr2sQtNbIxRdgruEdtMlApMsVn+MHvcunpItebWVpVcbjlQIGO7hWmAin+0ZRULn5ar6brNtlB7P17RKjPgEZsXOkrW1dGR6SMuRvLBe7EhdMx8PpNd7vV3q5nV6BRVsgAKWwoEsTAFIX5+y6MCnPQsQZREPHl+SdWaMcqoLR8VXkXJq/0bJ3vmkEB/vcI1nfOWTlwictgOhdVwqTqCLyC40qc3uUGIFwhfEcyNzK5rNJbcOSgZjzVkCoUMb3l55UpXK2hA2OCqlvkpCAiazEByA8BSgO6EJDHtM/PbNEVfU7YWe4CLoGDcNyMqPCG1ktBY15NSo4wTlZAO4nMcJtaAuvcGTQs1D3T3Jk1adePJ4gjrB3tfIn+B36e2p7UaAYIGuS4riFRdFhOOALHVHaaVbYE2A+ifrxKd2vVEXe7ueqV2tfl2xqeA057wsJvDvSkK6tCevyudHNSzsIi4umW6kAdUF5BbhI1W03F36JY/AapPnfqp2dRo4DCDEM41+2Y6QyF13JCUec27ia8cojmmUF1vJlwGohXp+UqX+sLlMBmyhY52GiMU5YK24BtxkREKoJwTlr/Eawqw/FeVAkaVWssGG4uNvQrDZf9COBBk1sDLOKKRulzPPkj+9njAsOdaAPpasAtYivSMCHC64sLLASU6lt6Fq6Im/pd3YWdtN+xcuiLdl7OWO8MTotYpRax7J8Xd2uZvrGVzXZOsFfblfmFvrElnZqKpcJN6puyjCIT/eOeevNznh4LhXVGnX5FlxbaboS6LLfL0g7Nu0STWR37xcrI3G/PizeUK3Al7KQtKz4JW8BWwqQJobBKi/KglWIDuELVB6kd1gjmhdaJobJ4H+oJ4ZXbMCGRuQ4qVsrkv6bTQ0FUfyvHFgUtV8Up5AjoLRnlE2g1eDUZiY4B8JSx9PbdojS6lxl1ilg68UIHdKsOhePJidSJNmbs9t0tvm5udpTWj0dim7ZAzk4C2UXjeQO3Cr122dzM9KsEI0e8rQO068sI3f7t2HtH6ZGw9JtNXK596ssiKrr5QehgfbsztQKlAh+x3uhxJAplp5zIzktUOQEH1lEFtXjkoMD5vm1H4lw0i0gxWq/aBd7vUTVYXTNpq5qA0LYGe4jsBK9wtpaY1I/HKO+LRw1W4vYRkCXlTiKHqBahSoqf5JLs6KKP3PI8jYx+56cYi/qIgOf4nMNBA5IRgwYpQF8zxDrMdB49l5SG5wGWDQhUsevwAKzx/3rfuRG5mJRH0MPrJxdvmIamWtRBCOw8jYEmzwoU+eK9JY5SyLXbiAkUNLHnIBbKDuf9djZbEtfzt/J9eUERVqUH+P5bIwW03puMhVruZFuz1avMhMb3tfY2efO+iaNZ3YOxWRpp5tqvMutOAseKq6+lTKONUajkovuxJ8/hn881QaWXRciEgm463NbRbsyOCJ2ZjfWnfZnpXQL3IPsPWbfiarrg1tFhMX3LpNYnUsQzO3rj12eUG8JtWNPfGUglGyroHlLX2MaOJDOckRXO00E4gmAxyWEqrL7Kuf4QeDJEL4/7DBnEI88vnh+KR4uIS83vxniQfyrFS07ZXpRS3/pGHqnqwJV2k7pcCbY+q5aQ2dO1cLO0R01VC1i4i0wUFP21iRmkXQbKYuU4srDut9kwq+R2Czfby/I7qdi04Mwcm0iqOHQS0XByNWk/Q0dhziN3Qxt4XFRL+i61B4lS5b1Ld7c4R7gTTIPc8KTtTm4lB4roJYi7jFCAuN/D69sVZuKButyu4jk5SXcAuo+egpZD24Jada0GPlewI+EmJhYC4KgyIkieZYs8h28I/AkODRAEANAFY8zU6DgMrROU/gn3xmrG3rIK0b9Q/QSmEF28mw+75wl3PtYRVcC1KfJ4CdkIPGohFmJ8ZU8omwOJDrWaZUVxcNIXlT8PbjgcKTadGT16+K5LQJHIeeS75ZLdIBFduRTQ6g2rl7cuV45Q0NZtkwgY+928jJQ4521LT3O44uGygvOWPhhVv3S3mPAokjWbHuBdt1IiaMPy8GPx62ptEmLneDvE8eH+oR8ktcG2hOATN1vmqu54USE13g67klmd1mEjivBh7qFVbiYYhUh/VByyWBBXcBI0hgAhRnEwlHcD3PgY4MYAL/w5eOPeYbH/APCVRw/uijfu9e6faGJfGcJviDcOAJ6f8Ma/T7zxg14CbvzrwV4RNmy2x828Cw66DGK47xDD39BTHmDYez+JFe7dPw6aEFPTIfRs1QNhBFGJEC0WwYJQlTmH79H9dYtX/3DcNG21i5Rn1fSrCC74xZ751TEEWy0cPBjQPryE4/EftO5BEn5JhPL93mGfEMr9NakVPxMYnveBPq7f1zueb5XKGA6rxXyzZWEpWEClYLgXlk2RtLxoBgmHwlV50NPP5dW0jgfEaMNbW7xxs4HD2kGXknIdV71X2sD8SzwchI9GENCNPcYNCTrPgyCxvyvLhZsoDUYqts44Jn3Uooyjrjdo6K7GVfyd5BEVd5FVssCZkuRM4doKqO9D6NhV3FJQnA3TGY/woSTuRqQq5oz+RwlZbFJ1eKcYNEj7WNGBMwdgG/ywHae09sYyt+lff3kfytGaUWSDKqg6Oc/MmZ9tpX16XDJxsLr2WC8Qs+r7tNTuOsyHDT16Hpjo57MJEA4+5Zx+x8WiYfcnyU7WpFPopHJARyEZgaSUC4SB1EZQ2ul6q2yyuSX0EnaOsk1xOrr+dLyCeSdbn7Zqyzfhp79yfj3zLNnSyoiEtLjRTHsXQIQFJJLgJFxHDOZo6uyAXYKbC/sF4M4kei9V4g9e51SR8Hg9gRRdNGdOw8WC/E5bNY0rlrSaBVg25LyuhuSV45LJfgXx29Ry6TF5226bYRjLv0H2kwW49JBvFw6iMZCTHAnkc6VpnZpOLWKgwrtPrp+MwySXuYgbAunZZqupqx+yuRVRCeLttWZTrZUeeGH7dWAS+9wvdCNZzau2VDQqRhUBfCim4nNBXD/DZbqmTcmKlsl9RBwx9G0YDQOWZmgcCTNIcIW3V8LLNlN1m4fN/JYC02oVRg0zeeO/Yk4NOHMWNRyhCT0ZwqzTneElEVzfwEvEnhM4iWXNrti1PNqJcjdvHz4Tz3I9EiJyBoGxtpUTTM1qCSzT/s36mi9wRn/JDYbgibUjspUMsai48M0X5rNHzRSYyqjufS77GYPCjtNtjJR+tnTvGU2REO8yAS5tbYhWbV5snlmw6THainHyBzbQPrj1+BC32D1ejIFykGRbEiVnFmKdX1C5TwC449Vcg8pvLkNR0xjDJYDViMnza6lYc2k//kdoqkmeIbkQeQOwyixuvC2/Sx9cHhWjASn24NhkpC6SrogUXCeJ2yhb+nbpKsaBVITjyxnxHihCkgDWF/T2cHDuNkWRVg4qujvTHJa5SaHjAC52c9zGtjyAE0VKACFLbyuvcCm33NFxw2M3nZzH4Ojk3pfVsmoBYvtdPUkNLF1gUqiknuW+VMjimO+YnIuI0tRVrpzYSi7zmkoXv1qO5wbVfqD92LCLobor2dioNJBmOfK57FKVO/qpQrlJrKQjryAp8zOu4rd/tzuAdZSybWZmdpJX1qZKSvDzEyrV+x91mCSwXpVglRf1KZ/m1aYX8s/iYuH7sFVko9xI52Y+nfyJKh50YjL8jQOR2L+eW3jsGjYhxYlD0xr2zmomL2o2ROQg3CrL1E7has50GPnd6A6QyAQzbmQ+nCWcA0p1iOrAJpqFWwpiCZy+gwvgasKQRqvu783+EVgTrjMAlqN5sxOSnFKE/KZsIbtPKOOc6MXrQNM4tcNqBoSMGzuHdDWfScwCezoXY4zaeMRWugZmVaJtatSfDnqDWu+waFJrBmSVchF+E3KcpfME3Jxig1D3mHOCIlSS3JWE6KDavRXbZFhEa21RUbsOtG4Xk3pktSRnWKr5hgsWXsKfzrbYNHFXoTbmck8g6/ZPN/UIcFIQSnb8YhyzyTiufmZ3NsGcCy9LhAiWdBPll/UwlXNtmqvtv4MKdDUSKYH7u8Cv29iyqtpOEDNEojeIsVpANThcG1cYlLlpqYPlWG5eElH+idqu8mu0st5uwOuXdwTtRcm/5du688WXHT4AdSunBuubbK6za8eQ34w2Cq9E/BbKa9QDxVUfV1DezlZEjfQVV5TE1jQY80KKJ/PdspmLDJAKTqo4BeozXEtdFbDbaoy8lKJg6Qhm43gmLe0e+mec5Ijx+3eUAjuBrWflsV8Wh1W2X2ssqLHIha5c8zwZ0jUkKlgD/yMMg98IBKFZ+esKmaCqhZW9JcNqLK2WU4A3dsP3M6vt1J7Vbr4R0i7kdd8s8p4ho/etzRovoYZvee0mLdRQdCV08Gt5oaqfIzuMmvX+T8BgN+9oglGJwdsCWfDs3y4INGQzDL2h8bYb3CZOwlZDUV4NKquDSlj1YY71wUSOBnecEoKTCdb2I9UOV2arbqEZM/WIn1A+0yifyda6Uh7UdRWCNcNbsyAaQRk8m5TEtcMBEzuR4qcIKQSyyNXl4pZtYGHCtNxopQ3LUTgWiwWKswsjbF7rQrKnAdZCdWDPLPtoz33Og6QJFEUOtophMKY5UXXgjoaMcyCzqHdmwJnZyNOas/LjCjte29MKTMC6nXLqNlb0Ure++PPFr+F7PRqpI+XeyFgBnJJCLSjlpM3e5xlnhr1yPfmiP/8lW4i+IbTuQlYD5KwEJ27Z37fBl03tWGqqEgim3K6KnQMajiTJuC5DsZmtCRJ6m3CrdC1yHBJuUyaJTF+b6t5MRpZh3VyuPh2mV9otfWJVR5z75x1OWZ4NfmHELwayyvkQeKEbBslu6ZhUh0fjAcbCyfmoKgHh8CgR5gi+jjcSKyVwgpNbENXr1oHr3SxkvnjQjG6ZsIahJW66QlNZ1AHAghQ+USaR964RIwlvhq7Wqf13taUWAQRUOjKfdwFlyEzgDLWU9B127lOTQNU9IvtyWdXO2rRelWX6U3O9E19bBEFIQgYysAe/BoJSBfyq9vHUe1VRESEw4FAvnxRSyWWz1FjmwkwKVcMglCYLBmc1SqFKwmfz0NJjgApAgQbl3Ur8GYNb3k6oxwLhLpY2w63sHed8L2cpKniJBjKowXPztI4pfuse5Ww7vmobceFtKycT1jG2Je7amlq+DLUqHYmDFO2Dck7zNAvJww1crECGtZrjppITWDnUviffBG8Au5mB6i90ipM/kjsdT+XHO0o2F31WkLiu46SRzTy4xegWK3J+khZ8KQSyiGX6Axb6ywhKW+ear2oWYlP/vvfdxeuuGq7D40dERlADJIEvyEWHQGOpzEkeLjknGFL2zL45Gy8wnoH/BF/uLWEGBhOrI+A1pV0zro1pgrq7EQjkKFB17vKve2ER61qUWRqoMHRumtizBFcBgFap4GJ0Ia5rwtsNSe1G2azuEk3txFyVJ/D5evcxfiK1syPluWij2JKR1qRKg7mgSW/krsXE8zOstJDtwSky2b5cJ/8wb6wGUMdpVDW5zsz8zY38BHvF456Q4ipuXyf3sHeAGwSrTGLLMIjoKedHvrHwpuEsGtlyaK0Zs3xMrrgM5n/bhtCZt76ZmHGHZIO1SqkKqNM014Opopu9jYKnYlcawQf72rTM5ckHy1m3reDyg9ALKn1RSqHXvlfeLnFsbKlSXHLy6JEKlys2Aa2OsdAX8vIQ/yY7e1LglA1hcbsYgcTJArVykVsQL1DPqU1jeD3IHZgr1AHf0Pb4JHWxJDQj62FeCzcoB3DHWNZ1jGq6b6yTom0bbF7O6wHa2ffVorE2uKMXCUPdmYV6jPhWRhQL46t541bmzm5eYu+AsHDjx4APk1OSxUx/e/4EWLgwnR10wgnmFglkKl/7ux9wAoVrF1ZMrMVVaYP9HIoCFIwNbG/+Ep9IUyDblifAtBYHrpVmmFcysi1/A3JdcG1YHtkFT2Aro9zfDjiVFGVCM0tGPld0tzH+Ntg/OFUbh8+xqVIQsDDuNxANtxipTROtQ10JPArL5rXOks0TwK5amgfwdaI17mHTtjnx8fVjJZ0HvuF77PnjzYrY8nbeoFPRgRdEhQpDg1tOpsaouYvCKxMZRrGZjhnwobn63ghzUNY44BCxVtgIIFaNzYpPmc0oQcQDFHnbxAVbwpU8grZupbjOVTNbOtc8ERRFAgoKYvhVzj3ZsSknD5vnHHeMZ05QygZ3X+JuxG9j5X7txeh5xumq0FcyfU4p9wJt1c27XDHZRSgtpIFztIjb5mdQHFiMcfNpNiNFrlUimVV0JwIu1a4Hsla3uB287yHuOq7uWhICfBS6qr2V/TnpPprTRWrm3E+2vh9l1HtGRSSP9DNYVlYQggLXbxBm6ztXdpRrpTVXAbiWjf1mo71tkIyitPsssS0NMAhtgd+8pUquBFjCHeLqTrMHUWrJgAzTmV/kfxFsCbzt9xwDpbty7+Cn3bZLRtHSpONBCrbl2pY8jbeM9FyJCtaz7zB2Zim7MRpSh51kVT8d68SjFUsz8v8jebQX2PWxpBwrpDTxJ57ymaRnULlkw0Uzn3uwDCtbrzw0UiK+kqd+8NmsfADBaobhN1iUqRGxRYtUXY0FlyLIxfojZUN7VAxcv9BTa1N+/S24KUiyiBxG2Th6D7bnyNLViTGrQwBre6ByVh4eOHKic5B5UIm7zab6QZLew/flqEwIiv2880HlXzLbqdz7gSx4tMGchIjwoq7I/IaywJbmB+B96N4AE99qCVkQ0jaef2kn1E5nWL7Vld6sc5ELpdxYTIOO40UTT0dmJwAVkH/bKkNERUBNOyVA2sgMhWpCuoEQ6AIqiTz8e0Gcsjachzklt0RZ6Mf0LFkR7mlyCCdvN04Lw32T8BnYuOYS6BZY+cQ9iqfZTtBQ9L5EJ8FVb32HQlWsUU3SOdM+0ojCEnZusuKmNe8wpaClJQHDvaRapplFqXHrcYpRtHhjqJA+iEYb+KEHFaRTHyU/YQMtuAP4tvkyNVnVwTe/hZhK54NqxYLTzTeGHk0PessEhPCekFmTLGghqqT4P4armhV7ReMumWPQCaTkDzmelWCIF8uGwi1QMBglwMxWckmNMJdBV41ClANVfIaoTqAinZoWXQProP3aVhMUTkL5Tlik3hNeKpn3Lxc1pqjT8YcWXts6r/TbXhDm9d7OOspy8OOHRgNsEr8rj4A/vGW5KBY0ntTsmAsd6BIS/3bOLJTOcEs1n03CxBWH/1Hf5BZafG76GkGZyT4aIAwwwthdKrORdSXjO/4OeGbUgQUcNGICIOidc6vB260LHMbeLvu+ZxZZbiEKUa04261VYOpU/sELZEzzY0yEfl4ZFWxa7ViWt4nneN5uxhL+QTV96+bNCiGa40mA6vG7MtM0rOboVAmzWtsmPKfADyrBWhd/jXwdzYJRDUY+EOxHdFmSI7nxkEbBGHfFC6/kK39mIkDiKTLLejmpwrJiseLOWp2DBCVdw4r65sGaBB3fRdoi5zdrZTswlzdVMWqsm5+z2AqYS9rMyyQPgdf8s7fP6fPGlhXqajUbCvfYoPL0KpUhsUUuHu14ccn4FAZcyLl2CYByykqF1RvQ02Bf5fCAa3qcVqMSIGPGPqQKX9d0VhkpzseMFRe0rqAmASAgci780A0cRbD7gloJclu8Bc/DV9AO0eViUKS8fvqMABIYHo5mIvd2fKywIWqhLTzI293Cc+DkFqObc81diXKk7DEC5RqgMku8At7XIycBTdvzyjOXQ9UeDrxFopfAdre4rlx0nWfFc4MTHhkfcTWe75l7KFl/WOknodYFrSiUoS266zupksu6FS8XJ9ghhN3l1cwCKLIbDx1p3HzIJuTK1THKK1o98XTShoXOIGTFjgP0twCtZBQFSVboRb6bX1Sh9+DIZ8yCoqobKvTu37d8Wbb/34YuK6A3+sSU9cuYssxn07b7KHxZhye/Zn3eTzRMvz8aJqp0bFb5pml4l1VryMsOFPOYNpRJ0wxLH6ebTdc/Nj89JPZSXApcv668qgu66G5h3tjnlmIVu394cCikYpFd+7pa1rYiEohvq8nZ1HxisnZes5KYmir9LMayfAfPy2pxrazleJ5cgHBO/qKl09kvUonP6Ig85VGc05kuLpZgV1xQ+C4TsjotnkcE+xesBHIaJ+xv2CLS7MP1pNKncGCKtpwApAPSYdWrZBWTq9zSYE5uMO5AihKeCywPKkkxrI3UVJ0XiAQgbT/Vr9+Ly2JaB4c5hRq/aImUC5cPgvvoP1flbEmQKiArhqxCjoGT7xM0KAUataBdwswtkkP0OiM0nHjWuAueB4yfUhd+DT1rzkD8La8+cn8d1WEn6BGBJBwd4G+9pWTiVEsvHICT7wwOrdfh8grOmXNzNfaZsqc5rZW/b5Igmz8tnpK/hpCVsjGlYw6VcAEHKn0QeCalvnDeQWcWI4Qe8GSdudWhDXFHi/G3onSYiuOW7c9RNZxgESLFHZdAmq43g+ga8WZCMxVZuMZ22vcmJgEzvNEUOllGxDw+EpBhI0Gs3m5bctXVM72M7pBtFQ7Xb6EfUDndWpu/lPzsbHgaK+cBtRvg7zXsOdlMdAO5EDNN/hRTsiAXDqtC42SY0+RujySXyWtUrdmsI0SQd6HE109+HawsUj6YIExKGzPfRH4vT+p3ZhmgRALrO83opZKj21bQyiqRaDXu6BS8uyER1tbH+pi9pveFpTykluVM+E5GzfqSaNoYkOuR/UbADtH7wB9GkhIKH1kFB0nWWDKvA6D4ZkBCx1WlsERs8+aihFkWGAGqYwqhtZANxv/E6GDZlA9yP7BLSsAEmM9wXVE00TriRpWRAUPhlNLj6CetmbWgVs1BrhqWzjhCj5UWzd4xRspkYqvyYsNseySRD5uwT+omdSFljgEJ9iK8m70JfbCNk8VXKRxDlvpcUbcoWKvi/JgESDitjbL7fbmo0YFj9wyTHuD4XUR3iz68j4xOXRaBCNVSjWbYXTZduD26U2DW0aCN9GlQvjwv+jgol1iLpQGGHl4L+rBtON1kUBbqK8UT6DKS8mxM3IqbgAF+mrpsvdpwEtfdcGSO+mQEbgC6fKi4BnAB7BRUrgUSjD7E9kxOaVDYXgF2Hav0vkwu8ltEwSZrRJFDoaYqS8ohlvz04/wtrfKmkXUBThLFrJLfYewzIFAD5KM12calrVeS+OdzFRMbjcIyDTFzcLgeF6uBNapbasJr4ckMYxjxQjJPLMVKFaTL7iHw6iyVKMfqAKjpcu0SDvht6SSiOssXT16FlX9g84BgLIlLokabLFFndG3rCF41BipkYdTfV8+X/xqWct7mYodWzML4qittlbtCFv7Ol6r6WJULtWzlzGBYpmmWuURlnULAgsmoh11epC4z/5Sc1u8IJBuszZRMlM/jwV2VaMxgdjBE24E1T2WXCHhvjT6SIUT0ZX5ia7qjp+jACEYz9QSipjSyCQ+YEJEcjzbzYDhfVzdoxquTZhN1v3W+LAIktUoF1HsLG/EVa24Ls3ya5Xg1HbRUlYaEJjvj293iXnForMj94s/F56rFt5KBeVq8LN9VmQPMGQ1UHISRO1Dgqgton910c48b5ZagQiIQobOhXzedjchj5EK7XbI5UC4dulQKA5Ouv4bkYN0Y1vT/gpPtEmHhYCSIb5L6BIGTYG3velYJdZYeStA2nl37+YMKXRrmbH9G+gqcl+T+cwa68ly8min/mvWBMMa8/K40D3UZP6GUPX/yzWjn6pxna7jZ/fpqxlKKbL0dJOkBlOAIEtrjzSY2u28p1FMs9LMMlIPodJjeeOtLqlUz2xEHK2SOTCD+ORmu6KIx+rEeAW90X2GybV+oK1ImB1iXWTjzSu8UDVFNtehHlfUPlH+LykBCLpzZema/PaVHWSFC3mzns8oMR/dm4/ei+0Q31mnx7dk3/vdbTqgVq0DNzOl+5fsq0UZK/2oSqqkRfU+fcybBzx5LnslDtXQ2aZCKBvRWsyyqYQn2SwcAgb+BmG2z4CA81wJwaeqJ9tnd0y4XZlpAQ4ZICdwRLkuTbhbW2x1y0StKrj2YloGF7yRVltldiXhBpElIsmX//iXdTTFake0WnhtNUbqAjixNEtJPD9++fgGB7WqGeSvZwmbmahG+M4tVtzJFF0Q4s/tfgfkJvEfpMKm2HxEgn8DA1QwA9oQUDS/8IagtZxcXabdxQHsjkZpFeeMgBbDphAXRNG6N4IzHHpwzVOsqRZ1whkDbPl7W39nUJUsutrbx80k5rMYNLLoA/YlsGIQMNvzn5JiMFOwiMbGAwm9lSRq3JMnQjPj8zh8Wr/DyenQradWDW0n+AbVlhrAgTCPxLAiQmwM+QP/CjUdCVWQlaTP2ZZiU0XBhdBulLepNlK7aANt/fY7OF+bYNrPrr26G6KS9NFv9Uq4dDMd/scdPCPIlqJK8Zc2SAofyZ+/Vzemw4fuSROwiPaVdxsT6rSn/ruMhlE7kVZiDHCJMktm+KfSmUC4zbSgXl+MocSq7L98u5rCXN3L8oX7DFIoRS2t25VKmils1u13+33/93zBxLt+5+xjlnpF4Bn9YshVxDLp84tRYB6vbbrPoEkoqMdZ145QeaCt8e3bJJv7pKczvpUM/7TDTZd1qz5mRs8PKMnbhrkocm+OMpy5QIP92wXSpQIyfOAByVbOlla0VYS7prJPzUdOgOPy34uEcXS0YOjinm2pzoOo44447lcga5zgzvWvpvI+UNK8zmCXIE2Sq+h/kfcmpslQOEzV+YHwnoYAiveHLzrzXoSLs8kNrfggi1mdm7NeNSPHixjM4AmrI6B3WQHezNdmP2WcVo8v6gC7b/wXVGE9O+727Yst6x/2jI4Uu2/8NSzHmACefUGa/DGVmOqcgyuSjwMx6+0f3PZzZJ2zOJ2zOJ2zOJ2xOVHKYJchwUY0sODANVDxwQEUKyJ/Zx32QYtxcEqB4aMQcDHJe3jLp1mRS2RwOW6QNq4SlsIgHJw/uExaxt3s/Rhc5aL4ZS72ohpZrwCJW8F5oVrL4HPFcDaY1ScS4QhlHqqXQ0Fhq4lA2iNQ2IWo+Rx27MkIGSlywHwirQlCxJ4xbXJvlRaLmGSUEx/4M+MAM8ChIn1i1LsSEnzipK8quEbuZaDFwAfV9F1uR0Omd8El3xmx5XUX+mtdGvWoWqPsz98DD8+fF2OjFrOFfEwMeYnXMlPacoum/LxDekjYX1eyqZ4XDwmqSv9yi20xcZ+NYzhhnZ6CvRVAJqe8Mv1KirIsKi3wNJaB89vrJY30OnkbD2hCfXReW7cXx6DtZ5UgrmJggepxMNL25kLWS3CfnfNo5hn7mcSmpASaKq2dj3DhXPYIYRu1sEx4zO3Nar6bFW3P4itd4IBfMppzGqUP09ms0SE+L4q1Rd6/qGdobo+rDKUU5Lo3aDScu8faWno8jHd68rpaXIq8ujemApxt/NNIMf4is3YMENWkvFy/cct17QYL5WtyBXZceTpbshuIlQkxSYu4w8lqZ0dEhA5pQbLnzxuyZd0D5WLwk4EiH0JxW2fAdCC/rGWALVpCf/CHhLfM51IrUkQe2E/gWyJSnTQLHkWkZxMthtrLRhO11JrTzKFWm1tvx04/sPQTtL/AcqyFFgvcsu+3vA1MOQZoguLPQxM2yCA+/Kz/gOBJd0Tl7JPNjE43XeaiQUjdR4PZMblRMLYd16kIZdAb4pOae/JQ4SLvNzK+EBWk9cAbPbKu+noS1ObLlqPiiLMZGin7Z2fv3+Zf945Pjw4POVzxHeJTARCrQRPpirzQLAW1iSF9VdiE3W02hZMb+7EL59jfwo/iPyklrKWCYHI5DJjRAygbVk+kluX0Bzq6v/vlP0JIuAU/wzkzSJU/SDz98sYf/rvxiCCBJgFXgHKj5pWJrtL/WyGe3P2Rd6EWjnpXArnMnNIYO4YPAOQiXeN+cfxLCiS0Msyw3XBC4D1J4DgnyxA2SELtgQCdONXPI5k5J3757KPvdvCbbwv4jiQJxlaOyQQUOBkZHMOceXVJGklWjFiNv8t6Bei9QyQhZEURbMfJGNqmTi9W0rCFFmdukg/kUa0XxOJP5jqj+/gKf1NHpYeiTerDJJ3X/wdGDY+uTsiP4jbxSKQvjk0fql3mk+Olf3RV1AKvwP9AuQ9PZzBbTVSdtZlhvEW8v5DnPWNYNJK3kE0jjK0aLkhx0o0Uzt6xQ6OcqCRUB/gMiruWv1GghwgikjOje0TEc9vXhD5JojtxxZQtzmj1UDKvJREezHzXNEvTneeHTcEYJ+uCrp+qwBDwS4u9aOYaS9MResvi4moBjiZi/aUpmDZbZNr96VY22CI+EsttcusTFYb6RQUpMdAeQYDPkCmCXzcyWmoI601jGkYv4+swH2QDIR8qHcrf3ClimzKI5Lghdr2HajMqJuqtK+9HJkR9H+rLYotb6TCbveHHoIUJiAIdOJCWKv0A47OorCH6m4tvH28EeCcHBnAxMDk2+g7k43cBhwgyPrv5RWD0CeUtqqkEBCJeriTmO09Il8HB7kxIwOZkC3F4R1hSxnyKxxiLnAMl5jyQ/OLBEoyjooOLp1RV8WjDyxEH0pnA9hUuGQsNBcvCoEL2LS27agK8GKRpyny2asJyu+7iYid4XFqycKW7OHBO39+V3KUYWsPpjJzgPtnSVO12cZALg1jxTiP9NTIaH8sWcxr9WgwUA4z1Qlz/0yC+S0KvT9Il+Q2ubIe/+o4vDQBhxSICrPGgJkWrDmMo6vsDwr/PnlrPEkok47tMY47qD5Ipg4pn5QuBwHVQRDLq9oKJsWe4byfpSleo9Ohyv7XO3FwDZyomj4O8JgJq8I/mqMBcZRTP458Q15rV8hvzbghfBzcTXoSLfQmaZNkgoxbaMOdM19sxpYfZZlhuf3nVjIspi3NBYEgnEjgWhE7T9fSVuU0juklLGTeZSjU5V4hPNmLARzZZFMFmMAS2ra8ws21EMtqAOYgAFiWGWdZg9wL2nEH904qrZKlZTLvrhAU3cHq/ePLvYe/tco+yc/7d0pVTrSXJM0YjIo4BYdko99cRjTnUK9jd5tLj8JsBoyesAEzYEBb+x0I43NzWwJzdzwsjhwopsAGs0SGcJ+sldqRATRZZnAU7OOAHmvOBCBky0dNfGH61Go1s6hjY+6Go9X6tqranqXU9h/5NuCFmi84qo+viQB3kxVkLaKWeYk/meN/Xs9uXZE/wuVRuSjnBKmh4laJRkpRG1XI0UeZsA7QV7j/7+Z0bzmQ2qxbXQJGOwHEYwcJYSNSPvpQp3SK9PZi0SX/p9SduifZOGHXWNcx+8WXOKiumfMuRgeHIZo3/KfSfpdsE4iZQQyi3T+Qvad/aLbjkr4yqXzssp7rbsCex727XwTplVTc5wcjETudKPFmvy0hjsik5Rdomk241aRSeUfJCucV+bT4PrDyo+nKMNIRMF3HcS6XYVcQGHzWdcbkohysPVNCbR2biejKSVM5CGNabpt8QOjs+/iDVNf4xcrEtYltvK3MegJVExVIi3FW/KAd3kD40wWoywlA3eiVyBuuIjzMDfcnaLTljJ8EBiHQKqL4EMGJ8fMxoOwSPgOZdK2o4H75Y9pPW64RPc+YmDO7vL0UjN+urW7pzHLHacfDhrJqup0RSwfHgS1Of39W2J7LC0ITs388tqZiZrVV2Sfd/BOYLfzbgv65kRUu6fIF0Dr2KLH0ltqA0a3DnZiG141BK72J2NtiHTxFI9yRm39bG9bHSZLmDEHFQ2edhsEVCwLON7E4/+MBHRFun1NdBOecUBGvLAkJgYwjUmeoSM4OziAmZ0z/T3twuhZh5Uss1Ao+7ewIsNczU7QA4IHPo8VhBfJIqceaqMvb4hcmseNWvXMprEqC9TlXEzqcpZdzXnIuAyShgi6Aws/KmcTUFCvgnKDwdiT0kJVM+kxrWNYcNc4VCIxRv8g4uRY3gPrvx86yjOzsvhOzJtQStleJOIH8zPaFatjAGBpBIjMVocqXnlTOWuVFt23vFyJTs+/D3KVHO6nSxjyXY/AG0IdRafghlEPRLn6nDdbW5zlzmMBxAb9L8uyYqDHybVklkRsPYgblfLijiUp2fl+/qaHf81zhULM7grr5aiIsvjk7A+t0q447iDUWmMSY0b0dwLk5KFupFrjC2wXOhW9QDKfC5BYV5p2AFL+rjdjvxPrQU2lDonKD2Yq6oagbPfxZiughQTUuYoFQrdBKg1IFNL/uC9FpZ7vyIDOCqAM4bkZ8u6BuoFUgSmQDrahRUITgbA1YkQvVkFI4BCc/dA1/k8vVchXbSlbkXHHI7LhTGTcOOJgtrM3lNCLayGxd6N1eTTrYihN5XrhVE4sH+ongFRWcAQufIFZHHj55VQ3RMzChf2mmkrY1KFa5MauYzBrsXu3y5efU37wagFBG8fUd4PbQsIeZL5NJebG49ZzXTgk0rS/8pi9/t6Tj8Fp+wO4/muTY2GduLeRxzUUwwm2sLOCpL/FLfRE6Zelt1s/VgTI28nVJIaFTajs9CGC3Qsmy9+WlS717sijx4C9gfd+vwDqX32T1LfquVwSwlq68eZO2nJkhBLZWOAAx9x1rYwCrn0M/tZYG77N+Fj7ds9LcT3C454dgDrUskecMmTsusdWbA9Rm5jvGJ1ALxHosBM+FNfwljhgg+kAt+5zNMB3BBVO/aQp7DAnJ4bGJPrxiLM3Hh+Fz79vcwhrPb/uplPJ10+n/9b8uwzFxHSVCEhtsZVwB1e1FdO+7LlfFr+vHWjJlFMufZsIFj2l86/G/n05TdPXl88f/V1B73OKDxFPuLMQhkAOIlKn5BJ5WteLAFK2NT18yLdWA69LA+qL2KK1i25VE3TXbgBiZOmRg2Lolzm9/qK7S3radsD9/cI0z8WxhapkakFM7rN311eCl0omkos2AshYUMHR+pG1HhsRZxyqA5xxivEfL5+++IFo6YBL4T/Ubv8L3yUPJLWn2EZpRG/80I1LBk2uvrEI3OXDkB/emmUINQyjJRpIRfJiO11VkIMjBVd5nXVZZM72Tn7t62S10qoFo2wJVh5HjQCzx7pL9fmbgJnATePOcjKpa6wMps9REqkyTBtIQBhQ8el0UgUs5soXpmYkE0edOc8kZtVMc2KcmrPNaum7I1bVHxDsYZitRs2iFBIuZwAvBkWwtVVL1zpwOKCjusbJQuWeG5Lr+SXefKpVJq601yac7OH+ioq7fdArdixRaRw6KPPrXsTsmvBGgitPk2Ku653mVBbWcFoxAOzfW0dHjI4iA79oflNPAaQrSGdQ2eTthSrsNmmw4Sp+029WGKOSMifuH0TLlgAWm5b7BWvjVmXrluQv6Ap5IF+1NB+gTmX1E+stQRXNi18a2RHG6kSdCYPrKovYYiUq21b/QGVBTy6ZAA2Tes2qiPIN9vYEtFZg4yvNrlq60XCnYjRBpR9V+V7UN7ZZxU2omnuqC0QiQum3Af0zpZfJBrJy3Le6lPrV1IPMnZcHuE3FEqiakm0ZPpOscdwiztFDSp8LRgNX4+tV9jElu/V1TzutLj1zChF9Yhuj7gVgcvMwcW2B6okGzIEDNDxn1RHFCVqp3BpD5vWbGKzh1mTrmfaHxx+fUJaR4B5Z2k++QA+jXqJrHWLd4A/oOG/q0GADQHP00IKxPCdFZ0EnMCpJY0yY8XaeLDlwKDbDpgE2tX1NTh8PXOYlN7SnDYWorxK+nKnQzkyJmNznelXsC3Wc00gH7YqnYVqudxIiGOT6MYEMiO8htt5OazW2ugzrLeHTgPtMxDnsyq7C3N5l9sFBTZfYc51I5ourAPygyjMhyTn8XXDM7amzwrls/LPot/5CtGSAEuqqU3eGGYfdEgj6NDmJi/1Qp9+CurJWuGZlz/sA3PMsr/LEQvvTDxyqzkWeJ/f0tlyR6tZOM8rHLMtJRv6a8REsooafJpZVDPdvmADnAgE8LsAC9yuBwBCuYXkUNm4NtsITRrUbOfNfDVvt2tPAUE6HJZ2QWm2cTqu9lHNOwSPMaB2Zl0bzJZrAl1mFMiWK2Pbi1gLdoyMOAHcZ7pQW+EtYIFb40PQBRVgqY0gmg8a4H7CHYgbAc5DCQoPb1dz9y1v03YTVYKGsM1TUAz4zLfF4f78AyX8zLWdJizU5YJLIvFqDapxTWW/wTlJcoMo8pLdvi5Rk68+VMMVaqGaJ4g8msQKZxFVKIGoTiqILtn3Ln5rzTpcMcBnbzeJn1246CFi9Knpz4ioU27rBcYi0LvHW4Qe2/bUAgAOj0vbWn3YCiSS4FsEJaWOoIo6iyvJQRCoquGHNc15LIz0OfCii5kyl8EOoNMgLkafQr5NWzjxz/4tUC26sACLq5I8qpRBl0w4S8aWhU15KYnVlMayB/mreD7H1aUcFuGywhD32+fJ9iDao29IsJpsdKVLA3tdsZkxBiceZX08RzVS+DLNlN8oCGP8FnwQ+7TN7OCIpFdaDsE8JgfJwTTrM8MUHjEG5mgMUB3WwO2GSWTMIQsawnPnc0Op3cYqTxR9yG/Xd1WFXmHI6CfiDshrbG3MHf4ChDPx5BqbD84HuloaAh5yyAEagx3FPrIttUiBSMMIgBKLASacGN98IFmqa7VsiD55212Mz2rGoWZjOTYTSfb+6xujYWj/e9H5t/9cNcvOlmMXc2YSGBmaP/vxwoiode1xXipqO4L9FHfigst75cIklPkIkrWcYglYLGiJosys2j+a1ZvVoIoRdr6Kao9J56IE1YaFPpEaQeAANgimCDXO7+gh0gRdT1+s4AMWnQ+c/hDIsUWEYvMmlClPQbG8NU9jao7vmCBdJalAesv/aliVs2/PORblom1j2GItORBy5WVz0A52/Ix7wMAlx7IVT43N3zJP9eDFcZ9Ha/VgBmuZB/rwAOf0iRgxHeyoRL8SQOj0MfKk0C8f2cfkX3Y8xi2K2wfMxHYaWmG4wJg72xkQIKHM4W2LIRWY0zY109ziFoH2xGjxu5ub5RX3Bj2KfhuERSuXA3cMJjkhAkTwuWe4xV1IqfsH93lVM34sqcaC9xe99c0SnO7sJPCxRTs+SndixTrMCUyeNxWWcx8G8RTnthbLgdNXdoS7iVagJVRKAziE2pZssMl9hGu3+YepzCkPD7+nkpK61NYeXkFdfqULm8ZouEZs0r/vdb7COg+QuOiB6X9Zp9KdmZVuCVXc6R+6PIH4OwU77PK3Xb4rusYSMEOGkcGbv/LIEtMhRQfwsrXTIpVscW9/pOkBV1dXXfymW6iv9iv3JpMO39nWbdDhM/r1409zA3L3Zm4nmOWw6pjr9prT2lZ+MP8dVNDFowhCgi5CPixGXbsi0YH3HvznwlzxsxH7NaGWtr1nSqmZgQzEnFyvqV7KGAOCv0ZSbgctJuzM2tWOgwZuSIRXCtMEDIeQZbsg/w8Y0gVamvnjj3/oCmw10MyL77uY+18sVozTXpbXLvVEINWMKxUU5iwQY3RtQS/iBSL/GISc2TrlCz6mR+UckfwQA+MBTbUbuHAcihM1AQ6tU7ASNezKudnAMOgQvTNg9ajTju7Vpx0//0ZX341Ix1FAO2540C4e+dTozSx/v+d65eg/VjbnmILH8ijwJdlQ9N0YtDQ///Sj20SMFWZ8p0A7c/2+BJ5m7pESyAF+ya56Hgjqc1svEgzgcP+Qbecr9A7PulHYPt8e5exhrG5eQrImo0ErcujC747At7bxGDdCo8UETf70o7fXBfuN+vgFFlhS295utth57s2Cnxs1aa6vqygpSkpfhx5vaAczPqLPB+OXw7ceKtjlUIgDxDfKT7yxOQcw05vwF/MSSQyyhnBYbQa+sOAiiw+ursBtBCcGndHC5WmLORMxU25f3czB6zz/6cd7bmeiHxoiRGYjzMftTz+yqvU5R2zkH5QnC2YgXgbo1IXkA4QDoBUFhMPoVXSl0qFoubyYbPGxAh7LzUOrw6gkrWSDRU2OKoYdgMBM1e5m+Bs5jtFTNsM9oDB3v7STxFeLkYNmw77PEGL+j3BpDpb2CtYb3tMR1OePCQ20GkzqFjATVoW2qT0Lclu0Q0il5jIWUAPeaOVTAN5xXSVwjgK3yE018DLDZCiBWar3lhmAlH9BYEyEP2k9NBMBqReV83jjdIcxuQBBFY1D7q+SSkXVw6IDwD4A4C7HHTdTKsmnmV2ZsyHsHs7tSpiS1uESt/p65thDMU87ssNIlU7x7PlTDeagUASA50xPFMLHsF6Q7Z0gXsCM6V9EBto79IkXjvY3ES8c7B8/OO5b5gU7hN+GecFPV/9EufB7LjV9cLCfIV74H5LKjwwMB+bTrRk7eg/ieNQlDE6axrDvKBke8vMQSMbnPWqGtS0nuRoOgJAQnSqSGEfcDGD2UHxVANasZAMYj6BVYkTNHMJPaKz/+AfCE7+XCCWqk1YT+PvLF9zyLibmzVcLI/0wHZl+rpnblfqU4Mkf/4DAnzpIsMDtgOYSTxLX3mZ7DO6nYQWbB7ixPpRYomh+a1+C2+mPfxBv8pjLEFLivajb5spE2EiSj+KoJ5SOUQ3C54B3LieOsmeteO4DL84dmZp7J939XvfgsDAnx6z+wVHAinN/k3A+PDnq93qKFuc3pGresF0/yerfJz1O/4EnpNdvcpB3poNpjeaf9cl17Z2cEngxB03xsmbHUijy1jaelHn9wx7LvNXSq1qIzhXEhCNDGbVqLwYU7s6TTG5aqQAF1u6OGN9gRwca6y6S/6GNNatQODmRW5OXCUreLzETYBmAR4Gr6gPiLMrFpGbcKrwCmp84ASz1MSeoC9rZyDkbz6YCeOBD1sxzZuyX9ejLo/3ewUmv89VfKSgpn48OenH0gVcdwXuYQ+R9IXjbUuLxcP9+Vj66+KxX8wn2tatEKGGuBL4m8z4tUBtd7fgpAg7WIMBJFG7PtExpHT6KlGcqJLCTBs4mGK1YzdGtR4ioCqLRdJkhI5/EQyWy5/XJwQRAnLHew+RPye4gFDGFHBuC0BPMGIJ9Fl/8cS6hfrd3DBaCEYgHgYWw+RIyW++4f/zfdAltECCfbqHf6y107NsKn2TJf7cs+YEEAlJgATCyC7F5LHqUvuZPFD27vFM8d+/4HO25ltMcdOZEvACfNlyTsksdz5ylrmb2KTQ2qEm0G8B/RdYBFlNL6v2H/R7fbMAx3MtTU8HUM9UJFeHySmLDInDXlpe2dJkXkKkjwx6lLVrOGsVk1WoyBLM0y16LQ83wsvuFxCH0MCbYMa75DQcJwD7mHYvQKc+7R6jXCRQEkJVlyK8Q6czkYykG9NouxIVpJz3cCFyUZXAOlxU/BHzY+AVI8CD2s85SeRIb+cJXs1i4FCJ/mW7q7wEXCT7FzDSny/mBa9JD9dPqxVMDuWVL+hIfufJ3n7k3fHMWknHlGLeYoO99Pz38WFtLsG47euW4iEpQb1k3niFttIlm1WJaUl6mi/XA/g4WOCCXN6ITsFwiGjKxMP+dLCF90udTWgB9IaVmkQ6bo0CgaXjeC+dywtAguBXGWLgSycV04Uhvb10RqW5i4jQHpOYxxD7cl8MiNbOKqp2XoxG6XXRi8FXFTIA2/xEnL91pnvYR4yYgCACx532CEJQKr3SSrr1ViM/dPj47rq/HCZ51GEZETWWHgTYbnkSd1EnBCsHkcal0FKqcd9lSJmCpbSW8E72Ny0auDmCqmZ678mZGP6kxi1ZNA1YootxSaN0njt6mtPtqbubNCuHD3f6fs3w9MEdHcfaJMEM75KHREdl4tUJSMlFlgDgtwSiDjmLGiSCem+CLTFzztC8WPLFyrwvGAkc1ioi2b8bgL5RloyJALVU6PSyEIx2CMW1xr96tdrkTmMfe7iEkcgcvm5M8ctWWbN7B55lvz4n2oHq6vcEdmsx+Au81zIfzt8W99nM3D7vF183NDosQHJUduWhh5IwALFh6tIwgpL8iNUVEIDrUMakblq3WFaH4a3gRbGFZdG9LYDi6pmTbTavluBlptiWcFSs1Nki/TFuUdq7uCWMfgIbHGYn6luBCTTydiWZnopjhGLGZpY+h5AnYol1v5nN6lh/ydycBW31X3Wb0iXzJB7vpZHbj+bQJx2ebE479dOO0bArnwtNgmWIC2ea57cwZqWf1JdZMkmuVNh5dqlDaylwNEGetr1eeXZRtT7KXJy7qW8JVQDWr4i/d9+eV47MRqAE3ABdbNkIkJcfQInyDQFL7Yxj3pXkcle2YsmqWxjpbGKFM92SgvQvOeYu9FulqLlvu2dvnbhRybVoQNlkaVlNxB0ysoYzGVRSxInBD1YAt92UgvekbRf6loM62SoKHUcWKl15HHIriwSb0Qj8DUdJvFI8kZFrYWz5TUrNnCy/o4diB2KQ7PZjMV8XVWjZ8j4uVsdmVafggsXdTeJy3r1/YanUMGSERp2ps++971bg1uX1h2piB9yhZxLxni0D4g4oFiK6jgYaQaFIMcU8Pi9VGnaPkLJ9wFxhxcnHxQrHJ4M87LCiH1QJEA/O/WI4/oicVZPpf37w5h17gf6OZknwI5LT25SEXYWe2bkKbmRZwLM2wmUjJ36vMV4nLQnZu5hj6M5/fZSXqNcizBnPv4qoop2HyAGMVNx37h4+hnCy4O34OiKS/X+yfAGJkP6jesRlE0jvuH95XFWVlCL9R+Y688+mTf/j3XVb2yHcT/+68cp2//PADnSREiqGnFBylsGYSHDfjMEoNelF799cU7LiQ59JYj6MDKMyB/I5MfTMym99BZjzgBBHhkDSyMVHAA9NgRj5BhZiKcHO9IyfhDRKUVu2pcxL5gUhlvdyboZtCQNc6Y1G0CIKJCk7DhlWtYQ4iHKBAKYcUX/VJL+6xhW9YEkX+q6f/Uv/dF0nLf933/jrx/jr2/jry/vLb7Ht/HXh/6ZHo5+gpLCUGWMUCC6pNpJzhcsycMadBobH93v6D+52vgl1zWjzEvNanRlZyXpNZ+mf2gWDFqa47ZXeMXVG2zYP56cePO5r4zsKCU2Z15Vww0PRS4pM9unzM3XPVrBbL227v8Li/3x0suwe7xhhBHJO5OvBGEiFkTlZVzYxEXkozx8fpO+xm3uXg0R5R/rV7B/u9o739w73gfO/OZ9d8rZYrs88X0tmrmZmBZ80Fsl628itO5yWG74MvCYcwNtIn7GwvG8o9AjzR/v3T/uHpwYO73tMHDx486J+oUK7M+29zT6eEph9GSj/xq987OD4Av/Si/rpD4EVMCnN4OjgIxKKYEem9Por0CVSOuqmofhSSLpIM16SG0hyxSBUXkiaIPKSSp7Qgw4DpILkVkLvmovuMUy7RfKi/ryDVBmNkxu5LitY+hNa1bIDspMfVEt0RJBUY582pSqRPw+VB5QbFKdDuzsdzLjH4xz8A6zTkMZpTbP6qr4p7BMy+RH9Ue6/47Nvzx48v+Yb4rPi8+LdyOv8L/r/iX6VN9zQXRbwcjSaXE/fS58U/4YamXoai6TdBz5zpdQ/7fHHJ3ISf/fI+NWImg9LofVx5dpKBbWwvz2ijU1re70G2HSOQvVcYVduc8MODu8JU+v3Dg/saK9n7DWEqeTni4+HWPffrgzD2AbD96Vhv3Sdo+wwBTxtQasZh/+AjodnkjARtPJnrBH4yL1Uz+4C6W8yzz5yhZa5BrPmMy37a2bdmiMD7NzV3DAALyQQIWuvzZwJAol0N7JXVXk7NPrFtwwasPszrhbUzzc/16cnRwbG1gg7gFN+2l5wUFxi1/KsUonUXL/Zu3p00xs6rvw8MWfgXZNkCH8jlcO7/C5+Jtjst8V+M9PgnnQ2LwkfebxFn9g94WbsY+WhC3U8RFB5VTfjvqgcKoXMPA/tHpjqjn+NyoIbx0nyK0cG5fLX0MsVfu1P1qxob+rB5VZfy3/oBhHTwA+/lv/XHgz+PP27K/7kF2McIac+zcvCA++/SFO/pP0B2RAsALgessopsueZodSl/Y48NQH5HzXlfQdBpmvf8P1U/bhlghnnC90YjQQvKo/5q6B78eQ9GlVmYQ54Ec+8Or+RZvTIg8c2djAuxJ/+hHrQr1D9WIzHLsqf/6CKH8kJNkazcYT/p+9pL/CZv+yv5AzY3LtsxaYVm9oeD48Pj/eGod3j/oBz1rvon5dFBNRr0rgaHo2ooUvIQZrJdXsLV2MJC1lV7SeF0uEJ7RyfHR/ePT3r9v5CD7NKI2Mve5f4l+jguwSk3OO395Yf/D+TZBcA=', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(144, 'wpml_dependencies:installed_plugins', 'a:1:{s:26:\"sitepress-multilingual-cms\";s:5:\"4.3.4\";}', 'yes'),
(147, 'wpml_language_switcher', 'a:6:{s:8:\"migrated\";i:0;s:18:\"converted_menu_ids\";i:0;s:14:\"additional_css\";s:0:\"\";s:5:\"menus\";a:0:{}s:8:\"sidebars\";a:0:{}s:7:\"statics\";a:3:{s:6:\"footer\";O:19:\"WPML_LS_Footer_Slot\":2:{s:24:\"\0WPML_LS_Slot\0properties\";a:19:{s:10:\"slot_group\";s:7:\"statics\";s:9:\"slot_slug\";s:6:\"footer\";s:4:\"show\";i:0;s:8:\"template\";s:27:\"wpml-legacy-horizontal-list\";s:13:\"display_flags\";i:0;s:29:\"display_link_for_current_lang\";i:0;s:28:\"display_names_in_native_lang\";i:0;s:29:\"display_names_in_current_lang\";i:1;s:17:\"background_normal\";N;s:13:\"border_normal\";N;s:19:\"font_current_normal\";N;s:18:\"font_current_hover\";N;s:25:\"background_current_normal\";N;s:24:\"background_current_hover\";N;s:17:\"font_other_normal\";N;s:16:\"font_other_hover\";N;s:23:\"background_other_normal\";N;s:22:\"background_other_hover\";N;s:15:\"template_string\";N;}s:34:\"\0WPML_LS_Slot\0protected_properties\";a:2:{i:0;s:10:\"slot_group\";i:1;s:9:\"slot_slug\";}}s:17:\"post_translations\";O:30:\"WPML_LS_Post_Translations_Slot\":2:{s:24:\"\0WPML_LS_Slot\0properties\";a:22:{s:10:\"slot_group\";s:7:\"statics\";s:9:\"slot_slug\";s:17:\"post_translations\";s:4:\"show\";i:0;s:8:\"template\";s:29:\"wpml-legacy-post-translations\";s:13:\"display_flags\";i:0;s:29:\"display_link_for_current_lang\";i:0;s:28:\"display_names_in_native_lang\";i:0;s:29:\"display_names_in_current_lang\";i:1;s:17:\"background_normal\";N;s:13:\"border_normal\";N;s:19:\"font_current_normal\";N;s:18:\"font_current_hover\";N;s:25:\"background_current_normal\";N;s:24:\"background_current_hover\";N;s:17:\"font_other_normal\";N;s:16:\"font_other_hover\";N;s:23:\"background_other_normal\";N;s:22:\"background_other_hover\";N;s:15:\"template_string\";N;s:22:\"display_before_content\";i:1;s:21:\"display_after_content\";i:0;s:17:\"availability_text\";s:34:\"This post is also available in: %s\";}s:34:\"\0WPML_LS_Slot\0protected_properties\";a:2:{i:0;s:10:\"slot_group\";i:1;s:9:\"slot_slug\";}}s:17:\"shortcode_actions\";O:30:\"WPML_LS_Shortcode_Actions_Slot\":2:{s:24:\"\0WPML_LS_Slot\0properties\";a:19:{s:10:\"slot_group\";s:7:\"statics\";s:9:\"slot_slug\";s:17:\"shortcode_actions\";s:4:\"show\";i:0;s:8:\"template\";s:27:\"wpml-legacy-horizontal-list\";s:13:\"display_flags\";i:0;s:29:\"display_link_for_current_lang\";i:0;s:28:\"display_names_in_native_lang\";i:0;s:29:\"display_names_in_current_lang\";i:1;s:17:\"background_normal\";N;s:13:\"border_normal\";N;s:19:\"font_current_normal\";N;s:18:\"font_current_hover\";N;s:25:\"background_current_normal\";N;s:24:\"background_current_hover\";N;s:17:\"font_other_normal\";N;s:16:\"font_other_hover\";N;s:23:\"background_other_normal\";N;s:22:\"background_other_hover\";N;s:15:\"template_string\";N;}s:34:\"\0WPML_LS_Slot\0protected_properties\";a:2:{i:0;s:10:\"slot_group\";i:1;s:9:\"slot_slug\";}}}}', 'yes'),
(149, 'wpml_language_switcher_template_objects', 'a:6:{s:20:\"wpml-legacy-dropdown\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:1:{i:0;s:118:\"/var/www/szerzodeskezelo_rc/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:8:\"Dropdown\";s:4:\"slug\";s:20:\"wpml-legacy-dropdown\";s:8:\"base_uri\";s:118:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown/\";s:3:\"css\";a:1:{i:0;s:127:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown/style.css\";}s:2:\"js\";a:1:{i:0;s:127:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown/script.js\";}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:2:{i:0;s:8:\"sidebars\";i:1;s:17:\"shortcode_actions\";}s:14:\"force_settings\";a:1:{s:29:\"display_link_for_current_lang\";i:1;}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:1:{i:0;s:118:\"/var/www/szerzodeskezelo_rc/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:26:\"wpml-legacy-dropdown-click\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:1:{i:0;s:124:\"/var/www/szerzodeskezelo_rc/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:14:\"Dropdown click\";s:4:\"slug\";s:26:\"wpml-legacy-dropdown-click\";s:8:\"base_uri\";s:124:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click/\";s:3:\"css\";a:1:{i:0;s:133:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click/style.css\";}s:2:\"js\";a:1:{i:0;s:133:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click/script.js\";}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:2:{i:0;s:8:\"sidebars\";i:1;s:17:\"shortcode_actions\";}s:14:\"force_settings\";a:1:{s:29:\"display_link_for_current_lang\";i:1;}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:1:{i:0;s:124:\"/var/www/szerzodeskezelo_rc/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:27:\"wpml-legacy-horizontal-list\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:1:{i:0;s:125:\"/var/www/szerzodeskezelo_rc/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-horizontal\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:15:\"Horizontal List\";s:4:\"slug\";s:27:\"wpml-legacy-horizontal-list\";s:8:\"base_uri\";s:125:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-horizontal/\";s:3:\"css\";a:1:{i:0;s:134:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-horizontal/style.css\";}s:2:\"js\";a:0:{}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:3:{i:0;s:8:\"sidebars\";i:1;s:6:\"footer\";i:2;s:17:\"shortcode_actions\";}s:14:\"force_settings\";a:0:{}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:1:{i:0;s:125:\"/var/www/szerzodeskezelo_rc/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-horizontal\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:25:\"wpml-legacy-vertical-list\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:1:{i:0;s:123:\"/var/www/szerzodeskezelo_rc/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-vertical\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:13:\"Vertical List\";s:4:\"slug\";s:25:\"wpml-legacy-vertical-list\";s:8:\"base_uri\";s:123:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-vertical/\";s:3:\"css\";a:1:{i:0;s:132:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-vertical/style.css\";}s:2:\"js\";a:0:{}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:3:{i:0;s:8:\"sidebars\";i:1;s:6:\"footer\";i:2;s:17:\"shortcode_actions\";}s:14:\"force_settings\";a:0:{}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:1:{i:0;s:123:\"/var/www/szerzodeskezelo_rc/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-vertical\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:29:\"wpml-legacy-post-translations\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:1:{i:0;s:127:\"/var/www/szerzodeskezelo_rc/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-post-translations\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:17:\"Post translations\";s:4:\"slug\";s:29:\"wpml-legacy-post-translations\";s:8:\"base_uri\";s:127:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-post-translations/\";s:3:\"css\";a:1:{i:0;s:136:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-post-translations/style.css\";}s:2:\"js\";a:0:{}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:1:{i:0;s:17:\"post_translations\";}s:14:\"force_settings\";a:0:{}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:1:{i:0;s:127:\"/var/www/szerzodeskezelo_rc/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-post-translations\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:14:\"wpml-menu-item\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:1:{i:0;s:112:\"/var/www/szerzodeskezelo_rc/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/menu-item\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:9:\"Menu Item\";s:4:\"slug\";s:14:\"wpml-menu-item\";s:8:\"base_uri\";s:112:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/menu-item/\";s:3:\"css\";a:1:{i:0;s:121:\"//szerzodeskezelo-rc.local/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/menu-item/style.css\";}s:2:\"js\";a:0:{}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:1:{i:0;s:5:\"menus\";}s:14:\"force_settings\";a:0:{}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:1:{i:0;s:112:\"/var/www/szerzodeskezelo_rc/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/menu-item\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}}', 'yes');

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint UNSIGNED NOT NULL,
  `post_id` bigint UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint UNSIGNED NOT NULL,
  `post_author` bigint UNSIGNED NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint UNSIGNED NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(4, 1, '2019-12-17 12:43:39', '0000-00-00 00:00:00', '', 'Auto Draft', '', 'auto-draft', 'open', 'open', '', '', '', '', '2019-12-17 12:43:39', '0000-00-00 00:00:00', '', 0, 'http://szerzodeskezelo-rc.local/?p=4', 0, 'post', '', 0);

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint UNSIGNED NOT NULL,
  `term_id` bigint UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint UNSIGNED NOT NULL,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_terms` (`term_id`, `name`, `slug`, `term_group`) VALUES
(1, 'Uncategorized', 'uncategorized', 0);

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint UNSIGNED NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint UNSIGNED NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint UNSIGNED NOT NULL,
  `term_id` bigint UNSIGNED NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint UNSIGNED NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_term_taxonomy` (`term_taxonomy_id`, `term_id`, `taxonomy`, `description`, `parent`, `count`) VALUES
(1, 1, 'category', '', 0, 0);

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_usermeta` (`umeta_id`, `user_id`, `meta_key`, `meta_value`) VALUES
(1, 1, 'nickname', 'dev'),
(2, 1, 'first_name', ''),
(3, 1, 'last_name', ''),
(4, 1, 'description', ''),
(5, 1, 'rich_editing', 'true'),
(6, 1, 'syntax_highlighting', 'true'),
(7, 1, 'comment_shortcuts', 'false'),
(8, 1, 'admin_color', 'fresh'),
(9, 1, 'use_ssl', '0'),
(10, 1, 'show_admin_bar_front', 'true'),
(11, 1, 'locale', ''),
(12, 1, 'wp_capabilities', 'a:16:{s:13:\"administrator\";b:1;s:34:\"wpml_manage_translation_management\";b:1;s:21:\"wpml_manage_languages\";b:1;s:41:\"wpml_manage_theme_and_plugin_localization\";b:1;s:19:\"wpml_manage_support\";b:1;s:36:\"wpml_manage_woocommerce_multilingual\";b:1;s:37:\"wpml_operate_woocommerce_multilingual\";b:1;s:29:\"wpml_manage_media_translation\";b:1;s:22:\"wpml_manage_navigation\";b:1;s:24:\"wpml_manage_sticky_links\";b:1;s:30:\"wpml_manage_string_translation\";b:1;s:33:\"wpml_manage_translation_analytics\";b:1;s:25:\"wpml_manage_wp_menus_sync\";b:1;s:32:\"wpml_manage_taxonomy_translation\";b:1;s:27:\"wpml_manage_troubleshooting\";b:1;s:31:\"wpml_manage_translation_options\";b:1;}'),
(13, 1, 'wp_user_level', '10'),
(14, 1, 'dismissed_wp_pointers', ''),
(15, 1, 'show_welcome_panel', '1'),
(17, 1, 'wp_dashboard_quick_press_last_post_id', '4'),
(18, 1, 'session_tokens', 'a:1:{s:64:\"e345dd16cd29dae5d97bc1cae53de18a288af9fc40b72c5de189ef659275e354\";a:4:{s:10:\"expiration\";i:1576759477;s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:104:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36\";s:5:\"login\";i:1576586677;}}'),
(19, 1, 'icl_admin_language_migrated_to_wp47', '1');

CREATE TABLE `wp_users` (
  `ID` bigint UNSIGNED NOT NULL,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_users` (`ID`, `user_login`, `user_pass`, `user_nicename`, `user_email`, `user_url`, `user_registered`, `user_activation_key`, `user_status`, `display_name`) VALUES
(1, 'dev', '$P$BdEheIUfRkjNsAso6n4wOT3K69Z1H/.', 'dev', 'dev@dev.hu', '', '2019-12-17 12:43:24', '', 0, 'dev');


ALTER TABLE `wp_commentmeta`
  ADD PRIMARY KEY (`meta_id`),
  ADD KEY `comment_id` (`comment_id`),
  ADD KEY `meta_key` (`meta_key`(191));

ALTER TABLE `wp_comments`
  ADD PRIMARY KEY (`comment_ID`),
  ADD KEY `comment_post_ID` (`comment_post_ID`),
  ADD KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  ADD KEY `comment_date_gmt` (`comment_date_gmt`),
  ADD KEY `comment_parent` (`comment_parent`),
  ADD KEY `comment_author_email` (`comment_author_email`(10));

ALTER TABLE `wp_icl_content_status`
  ADD PRIMARY KEY (`rid`),
  ADD KEY `nid` (`nid`);

ALTER TABLE `wp_icl_core_status`
  ADD PRIMARY KEY (`id`),
  ADD KEY `rid` (`rid`);

ALTER TABLE `wp_icl_flags`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `lang_code` (`lang_code`);

ALTER TABLE `wp_icl_languages`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`),
  ADD UNIQUE KEY `english_name` (`english_name`);

ALTER TABLE `wp_icl_languages_translations`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `language_code` (`language_code`,`display_language_code`);

ALTER TABLE `wp_icl_locale_map`
  ADD UNIQUE KEY `code` (`code`,`locale`);

ALTER TABLE `wp_icl_message_status`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `rid` (`rid`),
  ADD KEY `object_id` (`object_id`);

ALTER TABLE `wp_icl_node`
  ADD PRIMARY KEY (`nid`);

ALTER TABLE `wp_icl_reminders`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `wp_icl_strings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uc_domain_name_context_md5` (`domain_name_context_md5`),
  ADD KEY `language_context` (`language`,`context`),
  ADD KEY `icl_strings_name` (`name`),
  ADD KEY `icl_strings_translation_priority` (`translation_priority`),
  ADD KEY `context` (`context`);

ALTER TABLE `wp_icl_string_positions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `string_id` (`string_id`);

ALTER TABLE `wp_icl_string_status`
  ADD PRIMARY KEY (`id`),
  ADD KEY `string_translation_id` (`string_translation_id`);

ALTER TABLE `wp_icl_string_translations`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `string_language` (`string_id`,`language`);

ALTER TABLE `wp_icl_translate`
  ADD PRIMARY KEY (`tid`),
  ADD KEY `job_id` (`job_id`);

ALTER TABLE `wp_icl_translate_job`
  ADD PRIMARY KEY (`job_id`),
  ADD KEY `rid` (`rid`,`translator_id`);

ALTER TABLE `wp_icl_translations`
  ADD PRIMARY KEY (`translation_id`),
  ADD UNIQUE KEY `trid_lang` (`trid`,`language_code`),
  ADD UNIQUE KEY `el_type_id` (`element_type`,`element_id`),
  ADD KEY `trid` (`trid`),
  ADD KEY `id_type_language` (`element_id`,`element_type`,`language_code`);

ALTER TABLE `wp_icl_translation_batches`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `wp_icl_translation_status`
  ADD PRIMARY KEY (`rid`),
  ADD UNIQUE KEY `translation_id` (`translation_id`);

ALTER TABLE `wp_links`
  ADD PRIMARY KEY (`link_id`),
  ADD KEY `link_visible` (`link_visible`);

ALTER TABLE `wp_options`
  ADD PRIMARY KEY (`option_id`),
  ADD UNIQUE KEY `option_name` (`option_name`);

ALTER TABLE `wp_postmeta`
  ADD PRIMARY KEY (`meta_id`),
  ADD KEY `post_id` (`post_id`),
  ADD KEY `meta_key` (`meta_key`(191));

ALTER TABLE `wp_posts`
  ADD PRIMARY KEY (`ID`),
  ADD KEY `post_name` (`post_name`(191)),
  ADD KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  ADD KEY `post_parent` (`post_parent`),
  ADD KEY `post_author` (`post_author`);

ALTER TABLE `wp_termmeta`
  ADD PRIMARY KEY (`meta_id`),
  ADD KEY `term_id` (`term_id`),
  ADD KEY `meta_key` (`meta_key`(191));

ALTER TABLE `wp_terms`
  ADD PRIMARY KEY (`term_id`),
  ADD KEY `slug` (`slug`(191)),
  ADD KEY `name` (`name`(191));

ALTER TABLE `wp_term_relationships`
  ADD PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  ADD KEY `term_taxonomy_id` (`term_taxonomy_id`);

ALTER TABLE `wp_term_taxonomy`
  ADD PRIMARY KEY (`term_taxonomy_id`),
  ADD UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  ADD KEY `taxonomy` (`taxonomy`);

ALTER TABLE `wp_usermeta`
  ADD PRIMARY KEY (`umeta_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `meta_key` (`meta_key`(191));

ALTER TABLE `wp_users`
  ADD PRIMARY KEY (`ID`),
  ADD KEY `user_login_key` (`user_login`),
  ADD KEY `user_nicename` (`user_nicename`),
  ADD KEY `user_email` (`user_email`);


ALTER TABLE `wp_commentmeta`
  MODIFY `meta_id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_comments`
  MODIFY `comment_ID` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

ALTER TABLE `wp_icl_core_status`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_icl_flags`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=65;

ALTER TABLE `wp_icl_languages`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=65;

ALTER TABLE `wp_icl_languages_translations`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4097;

ALTER TABLE `wp_icl_message_status`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_icl_strings`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_icl_string_positions`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_icl_string_status`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_icl_string_translations`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_icl_translate`
  MODIFY `tid` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_icl_translate_job`
  MODIFY `job_id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_icl_translations`
  MODIFY `translation_id` bigint NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_icl_translation_batches`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_icl_translation_status`
  MODIFY `rid` bigint NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_links`
  MODIFY `link_id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_options`
  MODIFY `option_id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=151;

ALTER TABLE `wp_postmeta`
  MODIFY `meta_id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

ALTER TABLE `wp_posts`
  MODIFY `ID` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

ALTER TABLE `wp_termmeta`
  MODIFY `meta_id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `wp_terms`
  MODIFY `term_id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

ALTER TABLE `wp_term_taxonomy`
  MODIFY `term_taxonomy_id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

ALTER TABLE `wp_usermeta`
  MODIFY `umeta_id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;

ALTER TABLE `wp_users`
  MODIFY `ID` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
SET FOREIGN_KEY_CHECKS=1;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
