<?php
if ( ! function_exists( 'add_action' )) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}

// Setup Form
$form = tr_form()->useJson()->setGroup( 'fdg_template_options' );
?>

<h1><?php echo __('Templates', 'onlinecontract'); ?></h1>
<div class="typerocket-container">
    <?php
    echo $form->open();

    $contracttemplates = function() use ($form) {
        $repeater = $form->repeater('Contract Templates')
          ->setLabel(__('Contract Templates', 'onlinecontract'))
          ->setFields(array(
          $form->text('Contract Name')->setLabel(__('Contract Name', 'onlinecontract')),
          $form->editor('Contract Content')->setLabel(__('Contract Content', 'onlinecontract'))
          )
        );
    echo $repeater;
    if(tr_options_field('fdg_shortcodes.contract_shortcodes')!=NULL) {
      echo getallshortcodes();
  
    }
    };

    $othertemplates = function() use ($form) {
      echo '<h2>'.__('Notification Email Template', 'onlinecontract').'</h2>';
      echo $form->text('Email Subject')->setLabel(__('Email Subject', 'onlinecontract'));
      echo $form->editor('Email Content')->setLabel(__('Email Content', 'onlinecontract'));
      echo '
        <p>'.__('If you wish to change the notification email, please enter it here using HTML code. Use the shortcode [contract-link] to add a link back to the contract. You can use your custom shortcodes name (ex: [shortcodename]) to customize this notification template.', 'onlinecontract').'</p>';
      echo '<strong>[contract-link]</strong><br>'.__('This will display a link to the contract', 'onlinecontract').'<br><br>';
      if(tr_options_field('fdg_shortcodes.contract_shortcodes')!=NULL) {
        echo getallshortcodes();
      }
      echo '<h2>'.__('CSS & Styling', 'onlinecontract').'</h2>';
      echo $form->textarea('Contract CSS')->setLabel(__('Contract CSS', 'onlinecontract'));
      echo '<small>'.__('You can change the default style of the plugin by modifying the stylesheet above. Leave as is if you want to use the default style.', 'onlinecontract').'<br>'.__('Only change what you need, as most of this is WP specific and it helps the style of your contract and is responsive.', 'onlinecontract').' <strong style="color:red;">'.__('Modify at your own risk.', 'onlinecontract').'</strong></small>';
      echo '<br><br>';
      echo $form->textarea('Contract Print CSS')->setLabel(__('Contract Print CSS', 'onlinecontract'));  
      echo '<small>'.__('You can change the default print style of the plugin by modifying the stylesheet above. Leave as is if you want to use the default print style. Also, keep in mind this will only effect the browser print ability. Styling is not allowed with the PDF as it is preset.', 'onlinecontract').'<br><strong style="color:red;">'.__('In order to work properly, this template MUST BE ON ONE LINE. Modify at your own risk.', 'onlinecontract').'</strong></small>';
    };


   $save = $form->submit( __('Save', 'onlinecontract') );

    // Layout
    tr_tabs()->setSidebar( $save )
    ->addTab( __('Contract Templates', 'onlinecontract'), $contracttemplates )
    ->addTab( __('Other Templates', 'onlinecontract'), $othertemplates )
    ->render( 'box' );
    echo $form->close();
    ?>

</div>
