<?php
if ( ! function_exists( 'add_action' )) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}

// Setup Form
$form = tr_form()->useJson()->setGroup( 'fdg_shortcodes' );
?>

<h1><?php echo __('Shortcodes','onlinecontract'); ?></h1>
<div class="typerocket-container shortcodes">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.1.0/css/all.css">
    <?php
    echo $form->open();
    echo '<p>'.__('Add your custom shortcodes here. If you do not understand what a field is, please refer to the information icon next to the field.', 'onlinecontract').'</p>';
    $repeater = $form->repeater('Contract Shortcodes')
        ->setLabel(__('Contract Shortcodes', 'onlinecontract'))
        ->setFields(array(
        $form->row(
            $form->text('Label')->setLabel(__('Label','onlinecontract').' <em class="fa fa-info-circle tooltip"><span class="tooltiptext">'.__('This is the text that shows with the input.','onlinecontract').'</span></em>'),
            $form->text('Shortcode')->setLabel(__('Shortcode','onlinecontract').' <em class="fa fa-info-circle tooltip"><span class="tooltiptext">'.__('This is how your shortcodes will be used in your templates. Remember to add brackets ([shortcodesname]) around your shortcodes and do not use spaces or special characters.','onlinecontract').'</span></em>'), 
            $form->text('Function')->setLabel(__('Function','onlinecontract').' <em class="fa fa-info-circle tooltip"><span class="tooltiptext">'.__('The shortcode function gives you the ability to create functionality for certain shortcodes. You can add, mutiple, divide, etc your shortcodes. Just put a standard math function in the text box and have it do the math function for the shortcodes you add. For example, "([shortcode1] + [shortcode2]) / 2" would add shortcode1 and shortcode2 then divide by 2. This is an easy way to make your contracts more dynamic.','onlinecontract').'</span></em>'),
            $form->text('Options')->setLabel(__('Options','onlinecontract').' <em class="fa fa-info-circle tooltip"><span class="tooltiptext">'.__('The options is only used when a data type of select is selected. This will add options to your select box. So, if you add "red, blue, green, yellow" in the text box, the add new or edit contract window will display a drop down box with the options red, blue, green, yellow. This will give you a way to quickly add selectable options to your contract.','onlinecontract').'</span></em>'), 
            $form->select('Data Type')
                ->setOptions( 
                    array('Text'=>'text',
                        'Select Box'=>'select',
                        'Text Area'=>'textarea',
                        'Date'=>'date',
                        'Check Box'=>'checkbox',
                        'Radio Select'=>'radio',
                        'File Upload'=>'file',
                        'Editor'=>'editor'
                    )
                )
                ->setLabel(__('Data Type','onlinecontract').' <em class="fa fa-info-circle tooltip"><span class="tooltiptext">'.__('The type of input for the shortcode.','onlinecontract').'</span></em>')
        ),
        $form->textarea('Descriptive Text')->setLabel(__('Descriptive Text','onlinecontract').' <em class="fa fa-info-circle tooltip"><span class="tooltiptext">'.__('Visible description for the shortcode. Displayed on the admin and client input form to describe the form input.','onlinecontract').'</span></em>'),
        $form->checkbox('Function Only')
                ->setSetting('default', false)
                ->setLabel(__('Function Only','onlinecontract').' <em class="fa fa-info-circle tooltip"><span class="tooltiptext">'.__('This option allows you to set a shortcode that is not used for input but only for calculations. Typically used with the Function option.','onlinecontract').'</span></em>'),
        $form->checkbox('Visible on Front')
            ->setSetting('default', false)
            ->setLabel(__('Visible on Front','onlinecontract').' <em class="fa fa-info-circle tooltip"><span class="tooltiptext">'.__('Check this box to show this shortcode as a form field on the client input form.','onlinecontract').'</span></em>'),
        $form->checkbox('Required Input on Front')
            ->setSetting('default', false)
            ->setLabel(__('Required?','onlinecontract').' <em class="fa fa-info-circle tooltip"><span class="tooltiptext">'.__('Check this box to force this field to a required input.','onlinecontract').'</span></em>'),
        $form->checkbox('Prepared Field')
            ->setSetting('default', false)
            ->setLabel(__('Prepared Field','onlinecontract').' <em class="fa fa-info-circle tooltip"><span class="tooltiptext">'.__('Check this box to show this field as a required item that must be filled out during the contract signing. Since a printed name can be required on the contract, it is not necessary to force the client name to be a prepared field unless you need it to be.','onlinecontract').'</span></em>')
    ));
    echo $repeater;
    echo $form->close(__('Modify Shortcodes', 'onlinecontract'));
    ?>

</div>
