<?php
if ( ! function_exists( 'add_action' )) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}

$form = tr_form()->useUrl('post', '/validatecontractkey')->setGroup( 'fdg_plugin_options_purchase' );
//$form = tr_form()->useJson()->setGroup( 'fdg_plugin_options_purchase' );

?>

<h1><?php _e('Purchase Code', 'onlinecontract'); ?></h1>
<div class="typerocket-container">
    <?php
    echo $form->open();
    $auth = function() use ($form) {
        echo '<p>In order to use our plugin and receive support, you must enter your purchase code below. Failure to do this or if you are using a hacked version of our plugin could result in a permanent \disable of your installation.</p>';
        echo $form->text('Purchase Code')->setLabel(__('Purchase Code', 'onlinecontract'))->setDefault(tr_options_field('fdg_plugin_options_purchase.purchase_code'));
        if(validatepurchasecode()) {
            echo '<small style="color:green;">'.__('You purchase code is valid', 'onlinecontract').'</small>';    
        }else{
            echo '<small style="color:red;">'.__('You purchase code is invalid', 'onlinecontract').'</small>';
        }
        
        echo $form->submit( __('Update Key', 'onlinecontract') );
        echo '<p>Don\'t know where your purchase code is? Take a look at our instructions below to retrieve it from CodeCanyon.</p>
        <ul>
            <li>Log into your Envato Market account.</li>
            <li>Hover the mouse over your username at the top of the screen.</li>
            <li>Click "Downloads" from the drop down menu.</li>
            <li>Click "License certificate & purchase code" (available as PDF or text file).</li>
        </ul>
        <p>You can read these instructions as well as see a video and a sample of the license file at the following URL:
        <br>
        <a href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Can-I-Find-my-Purchase-Code" target="_blank">https://help.market.envato.com/hc/en-us/articles/202822600-Where-Can-I-Find-my-Purchase-Code</a>';
        include (WP_PLUGIN_DIR.'/onlinecontract/gethelp.php');
        echo '<p style="text-align:right">'.__('Version','onlinecontract').' '._onlinecontract_version_num.'</p>';
    };

    $about = function() use ($form) {
        $aboutfdg = '
        <a href="https://codecanyon.net/item/wp-online-contract/7698011?ref=futuredesigngrp" target="_blank"><img src="'.plugin_dir_url(dirname(dirname(dirname(__FILE__)))).'img/wp-online-contractlogo-small.png" style="max-width:500px; width:100%; margin:0 auto; display:block;"></a>          
        <hr>            
        <p>
                Thank you for using our Online Contract plugin. We hope our plugin gives you as much use as we have found in it.  Please rate this plugin if you like how it functions and if it helps you create unique, usable contracts that help you keep track of signatures and clients.
        </p>          
        <p>
                You can rate our plugin and view other reviews using the following link through CodeCanyon in your downloads:<br><a href="https://codecanyon.net/downloads?ref=futuredesigngrp" target="_blank">https://codecanyon.com/downloads</a>
        </p>           
        <p>
                Interested in more of our plugins?  Please take a look at our CodeCanyon portfolio for all of our plugins and code:
                <br>
                <a href="https://codecanyon.net/user/futuredesigngrp/portfolio?ref=futuredesigngrp" target="_blank">https://codecanyon.net/user/futuredesigngrp/portfolio</a></p>          
         <p>
                See this plugin\'s full documentation online using the following URL:
                <br>         
                <a href="https://onlinecontract.futuredesigngroup.com/documentation/" target="_blank">http://onlinecontract.futuredesigngroup.com/documentation/</a>         
         </p>            

         <hr>
         <strong>All Items By Future Design Group</strong>
         <br>
         Who is Future Design Group? Well, for starters, we are your FUTURE design group. We are an agency that prides ourselves with our work and are always attentive of our user\'s needs. Please check out what else we offer and see how we can help you.       
         <br>        
         <br>        
         <br>        
         <p style="text-align:center;">
         <a href="http://codecanyon.net/user/futuredesigngrp/portfolio?ref=futuredesigngrp" target="_blank" style="padding:10px; text-center; background-color:#1eb033; color:#fff; text-decoration:none;">View All Items By Future Design Group</a>       
         </p>
         <p style="text-align:right">'.__('Version','onlinecontract').' '._onlinecontract_version_num.'</p>
        ';
        echo $aboutfdg;
    };

     

    // Layout
    tr_tabs()
        ->addTab( __('Purchase Confirmation','onlinecontract'), $auth )
        ->addTab( __('About','onlinecontract'), $about )
        ->render( 'box' );
        echo $form->close();
    ?>

</div>
