<?php
if ( ! function_exists( 'add_action' )) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}
require_once WP_PLUGIN_DIR.'/onlinecontract/includes/payments/paypal.php';

// Setup Form
$form = tr_form()->useJson()->setGroup( 'fdg_payment_options' );
?>

<h1>WP Online Contract Settings</h1>
<div class="typerocket-container">
    <?php
    echo $form->open();



    $paypal = getpaypalform($form);

    if (is_plugin_active('wp-online-contract-stripe-payments/online-contract-stripe-payments.php')) {
        require_once WP_PLUGIN_DIR.'/wp-online-contract-stripe-payments/online-contract-stripe-payments.php';
        $stripe = getstripeform($form);
    }else{
        $stripe = '<p>'.__('You do not have this addon currently installed. You can purchase it here', 'onlinecontract').': <a href="https://codecanyon.net/item/wp-online-contract-stripe-payments/8001391?ref=futuredesigngrp" target="_blank">Purchase Addon</a></p>';
    }

    if (is_plugin_active('wp-online-contract-skrill-payments/online-contract-skrill-payments.php')) {
        require_once WP_PLUGIN_DIR.'/wp-online-contract-skrill-payments/online-contract-skrill-payments.php';
        $skrill = getskrillform($form);
    }else{
        $skrill = '<p>'.__('You do not have this addon currently installed. You can purchase it here', 'onlinecontract').': <a href="https://codecanyon.net/item/wp-online-contract-skrill-payments/8198739?ref=futuredesigngrp" target="_blank">Purchase Addon</a></p>';
    }

    if (is_plugin_active('wp-online-contract-authorize-payments/online-contract-authorize-payments.php')) {
        require_once WP_PLUGIN_DIR.'/wp-online-contract-authorize-payments/online-contract-authorize-payments.php';
        $authorize = getauthorizeform($form);
    }else{
        $authorize = '<p>'.__('You do not have this addon currently installed. You can purchase it here', 'onlinecontract').': <a href="https://codecanyon.net/item/wp-online-contract-authorizenet-payments/8198739?ref=futuredesigngrp" target="_blank">Purchase Addon</a></p>';
    }

   $save = $form->submit( 'Save' );

    // Layout
    tr_tabs()->setSidebar( $save )
    ->addTab( 'PayPal', $paypal )
    ->addTab( 'Stripe', $stripe )
    //->addTab( 'Authorize.net', $authorize )
    //->addTab( 'Skrill', $skrill )
    ->render( 'box' );
    echo $form->close();
    ?>

</div>
