<?php
if ( ! function_exists( 'add_action' )) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}

// Setup Form
$form = tr_form()->useJson()->setGroup( 'fdg_plugin_options' );
?>

<h1><?php _e('Settings', 'onlinecontract'); ?></h1>
<div class="typerocket-container">
    <?php

    echo $form->open();
    $setup = function() use ($form) {

        echo $form->text('Contract Permalink')->setDefault('contract')->setLabel(__('Contract Permalink', 'onlinecontract'));
        echo '<small>You can modify your contract permalink here. Once this is changed, you may have to <a href="options-permalink.php" target="_blank">resave your permalinks</a>.</small><br><br>';
        echo $form->text('Your Company Name')->setLabel(__('Your Company Name', 'onlinecontract'));
        echo '<small>Enter the name of your company that will display on the contract.</small><br><br>';
        echo $form->text('Administration Email')->setLabel(__('Administration Email', 'onlinecontract'));
        echo '<small>Enter the email address you want status emails to be directed to.</small><br><br>';
        echo $form->text('Decimal Round')->setDefault('2')->setLabel(__('Decimal Round', 'onlinecontract'));
        echo '<small>Enter the number of places to round all decimals</small><br><br>';
        echo $form->text('Currency Symbol')->setDefault('$')->setLabel(__('Currency Symbol', 'onlinecontract'));
        echo '<small>Enter your current symbol (ex: $ or €, etc)</small><br><br>';
        echo $form->text('Currency Type')->setDefault('USD')->setLabel(__('Currency Type', 'onlinecontract'));
        echo '<small>Enter your currency type. (ex: USD or EUR, etc)  A complete list can be found <a href="https://developer.paypal.com/docs/classic/api/currency_codes/" target="_blank">here</a></small><br><br>';
        echo $form->text('Date Format')->setDefault('d/m/Y')->setLabel(__('Date Format', 'onlinecontract'));
        echo '<small>Enter the format in which you want to see dates. You can find more information about date formats <a href="http://php.net/manual/en/function.date.php" target="_blank">here</a></small><br><br>';
        echo $form->text('Datepicker Format')->setDefault('d/m/yy')->setLabel(__('Datepicker Format', 'onlinecontract'));
        echo '<small>Enter the format in which you want to enter a date. You can find more information about date formats <a href="https://api.jqueryui.com/datepicker/#utility-formatDate" target="_blank">here</a>. <span style="color:red;">This is different than the Date Format.</span></small><br><br>';
        if(tr_options_field('fdg_shortcodes.contract_shortcodes') != NULL) {
            foreach(tr_options_field('fdg_shortcodes.contract_shortcodes') as $shortcode) {

                $shortcodes[$shortcode['label']] = str_replace(array('[',']'),'',$shortcode['shortcode']);
            }
            echo $form->select('Client Email Shortcode')->setOptions($shortcodes)->setLabel(__('Client Email Shortcode', 'onlinecontract'));
            echo '<small>This will be used to display their contract when you use the front end to show all client\'s contract based on their email.</small><br><br>';
            echo '<br>';
        }
        echo '<div style="background-color:#f8f8f8; padding:10px; border:1px solid #c0c0c0; margin-bottom:20px;">';
        echo $form->checkbox('Auto Redirect Initiated Contracts')->setLabel(__('Auto Redirect Initiated Contracts', 'onlinecontract'));
        echo '<small>If you allow clients to create their own contracts, do you want to redirect them to their contract? Keep in mind that if you have values that the client cannot fill out, they will be able to sign the contract without those values which could result in the contract being incorrect. If you do not use this, you will have to manually approve all client initiated contracts. <span style="color:red;">Use at your own discretion.</span></small><br><br>';
        $options[''] = '';
        if(tr_options_field('fdg_template_options.contract_templates') != NULL) {
            foreach(tr_options_field('fdg_template_options.contract_templates') as $template) {
                $options[$template['contract_name']] = $template['contract_name'];
            }
            echo $form->select('Default Contract Template')->setOptions($options)->setLabel(__('Default Contract Template', 'onlinecontract'));
            echo '<small>If you auto redirect initiated contracts, you must select a default template to use. If one is not selected, then they will not see any contracts, just a blank page. This template <strong>MUST NOT</strong> use functional shortcodes as the information will not be populated by the client and will result in an error. This section is more for TOS agreements, not contracts. All shortcodes they complete should be present on the contract or it will show a blank screen. If you are not allowing auto redirect then skip this step. <span style="color:red;">Use at your own discretion.</span></small><br><br>';
        }
        echo $form->textarea('Response if not auto redirect?')->setDefault('Your contract has been submitted. Once approved, you will receive a notification to sign.')->setLabel(__('Response if not auto redirect?', 'onlinecontract'));
        echo '<small>If you do not auto redirect the contract, you can display a message to the user saying their contract was received.</small><br><br>';
        echo '</div>';
        echo $form->checkbox('Use FontAwesome Icons?')->setLabel(__('Use FontAwesome Icons?', 'onlinecontract'));
        echo '<small>Spruce up the buttons by adding FontAwesome icons where they are needed.</small><br><br>';
        echo $form->editor('Signature Message')->setDefault('Please sign using a stylus, your mouse, or your finger below to authorize this contract. By electronically signing this document, you agree to the terms established above.<br>After the document is signed, you can proceed to print it or save it as a PDF.')->setLabel(__('Signature Message', 'onlinecontract'));
        echo '<small>Enter the bold message to display above where the client will sign the contract.</small>';
        include (WP_PLUGIN_DIR.'/onlinecontract/gethelp.php');
        echo '<br>';
        echo '<p style="text-align:right">'.__('Version','onlinecontract').' '._onlinecontract_version_num.'</p>';
    };


    $advanced = function() use ($form) {
        global $slug;
        $advancedfdg = '
        <p>Want to spice up our plugin with user client initiation or user accounts? Use the following shortcodes to add items to your website with ease. You can customize these shortcodes more on your shortcodes page if required.</p>
        <hr>
        <h2>Break Pages When Printed</h2>
        <p>If you require a page break in your contract template, you can use the following shortcode where that break is needed. This will create a page break in the PDF view of the contract:</p> <strong><span style="color: white; background-color: green; border-radius: 3px; padding: 2px 5px; font-size:14px;">[onlinecontractpagebreak]</span></strong>
        <p></p>
        <hr>
        <h2>Allow Clients to Initiate A Contract</h2>
        <p>If you would like to give your clients the opportunity to initiate a contract, you can easily add the following shortcode to any page or theme file:
            <br> <strong><span style="color: white; background-color: green; border-radius: 3px; padding: 2px 5px; font-size:14px;">[clientadd]</span></strong></p>
        <p>This will add a short form that can be styled by you that will allow a client to create a pending contract and send your administrative contact an email notification.</p>
        <hr>
        <h2>Show All Contracts Based on Email</h2>
            <em>'.site_url().'/'.$slug.'/contractlist/test@example.com</em>
            <br>Just replace the email with their email address. If they have an account with your website, do not include the email in the url. Our plugin will use the email associated with their account.</p>
        <p>You can style this list using the following class:
            <br><em>.contractlistitem</em>
            <br><em>.contractlistiteminner</em></p>
        <p style="text-align:right">'.__('Version','onlinecontract').' '._onlinecontract_version_num.'</p>
        ';
        echo $advancedfdg;
    };

    $removeheader = function() use ($form) {
        $removeheaderfdg = '
        <p>If you do not want to use your theme header and footer with the contracts, we have it setup to display a white page with nothing but the contract. We cannot do this from the plugin, but have created a way to use your theme for this.</p>
        <p>If you wish to remove the header and footer create the following files in either your primary or child theme:</p>
        <hr>
        <p><strong>header-contract.php</strong></p>
        <p>Add the following code to this file:<br>
<pre>
&lt;!DOCTYPE html&gt;
&lt;html class="no-js no-svg"&gt;
&lt;head&gt;
&lt;meta charset="&lt;?php bloginfo( \'charset\' ); ?&gt;"&gt;
&lt;meta name="viewport" content="width=device-width, initial-scale=1"&gt;
&lt;link rel="profile" href="http://gmpg.org/xfn/11"&gt;
&lt;?php wp_head(); ?&gt;
&lt;/head&gt;
&lt;body&gt;
</pre>
        </p>
        <hr>
        <p><strong>footer-contract.php</strong></p>
        <p>Add the following code to this file:<br>
<pre>
&lt;?php wp_footer(); ?&gt;
&lt;/body&gt;
&lt;/html&gt;
</pre>
        </p>
        ';
        echo $removeheaderfdg;
    };

    $about = function() use ($form) {
        $aboutfdg = '
        <a href="https://codecanyon.net/item/wp-online-contract/7698011?ref=futuredesigngrp" target="_blank"><img src="'.plugin_dir_url(dirname(dirname(dirname(__FILE__)))).'img/wp-online-contractlogo-small.png" style="max-width:500px; width:100%; margin:0 auto; display:block;"></a>          
        <hr>            
        <p>
                Thank you for using our Online Contract plugin. We hope our plugin gives you as much use as we have found in it.  Please rate this plugin if you like how it functions and if it helps you create unique, usable contracts that help you keep track of signatures and clients.
        </p>          
        <p>
                You can rate our plugin and view other reviews using the following link through CodeCanyon in your downloads:<br><a href="https://codecanyon.net/downloads?ref=futuredesigngrp" target="_blank">https://codecanyon.com/downloads</a>
        </p>           
        <p>
                Interested in more of our plugins?  Please take a look at our CodeCanyon portfolio for all of our plugins and code:
                <br>
                <a href="https://codecanyon.net/user/futuredesigngrp/portfolio?ref=futuredesigngrp" target="_blank">https://codecanyon.net/user/futuredesigngrp/portfolio</a></p>          
         <p>
                See this plugin\'s full documentation online using the following URL:
                <br>         
                <a href="https://onlinecontract.futuredesigngroup.com/documentation/" target="_blank">http://onlinecontract.futuredesigngroup.com/documentation/</a>         
         </p>            

         <hr>
         <strong>All Items By Future Design Group</strong>
         <br>
         Who is Future Design Group? Well, for starters, we are your FUTURE design group. We are an agency that prides ourselves with our work and are always attentive of our user\'s needs. Please check out what else we offer and see how we can help you.       
         <br>        
         <br>        
         <br>        
         <p style="text-align:center;">
         <a href="http://codecanyon.net/user/futuredesigngrp/portfolio?ref=futuredesigngrp" target="_blank" style="padding:10px; text-center; background-color:#1eb033; color:#fff; text-decoration:none;">View All Items By Future Design Group</a>       
         </p>
         <p style="text-align:right">'.__('Version','onlinecontract').' '._onlinecontract_version_num.'</p>
        ';
        echo $aboutfdg;
    };

    $save = $form->submit( __('Save', 'onlinecontract') );

    // Layout
    tr_tabs()->setSidebar( $save )
        ->addTab( __('Plugin Setup','onlinecontract'), $setup )
        ->addTab( __('Remove Theme Files','onlinecontract'), $removeheader )
        ->addTab( __('Advanced Usage','onlinecontract'), $advanced )
        ->addTab( __('About','onlinecontract'), $about )
        ->render( 'box' );
    echo $form->close();
    ?>

</div>
