<?php 
define('_onlinecontract_version_num', '5.0.1'); 

/*
Plugin Name: WP Online Contract
Plugin URI: https://www.futuredesigngroup.com/wp-online-contract
Description: WP Online Contract allows you to create, manage, and save contracts online through Wordpress.  You can customize contracts via WP Editor and shortcodes and view revisions of your existing contracts.  Give your clients a way to view and sign your contracts online in one place.
Version: 5.0.1
Author: Future Design Group
Author URI: http://futuredesigngroup.com
Text Domain: onlinecontract
Domain Path: /languages/
License: GPL2
Copyright 2014-2018  Future Design Group  (email : olivere@futuredesigngroup.com)

LICENSE
Copyright 2014-2018 Future Design Group <olivere@futuredesigngroup.com>
This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.	 See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place, Suite 330, Boston, MA 02111-1307 USA 
*/
include('functions.php' );
register_deactivation_hook( __FILE__, 'fdg_deactivate' );
register_activation_hook( __FILE__, 'fdg_activate' );

function fdg_deactivate() {
  file_put_contents(WP_PLUGIN_DIR.'/onlinecontract/includes/api-cache.json', '{}');
  flush_rewrite_rules();
}

function fdg_activate() {
  flush_rewrite_rules();
}
function fdg_activate_auto() {
    $plugin_current_version = _onlinecontract_version_num;
    $plugin_remote_path     = 'https://www.futuredesigngroup.com/apps/onlinecontract/update.php';
    $plugin_slug            = plugin_basename(__FILE__);
    $license_user           = '';
    $license_key            = tr_options_field('fdg_plugin_options_purchase.purchase_code');
    new wp_autoupdate ($plugin_current_version, $plugin_remote_path, $plugin_slug, $license_user, $license_key);
  }
add_action('init', 'fdg_activate_auto');
/* 

*/
?>