document.addEventListener('DOMContentLoaded',function(){
  var wrapper = document.getElementById("signature-pad")
  if ( jQuery('#signature-pad').length ) {
    jQuery('#signature, .afterbuttons').css('display','none');
    var clearButton = wrapper.querySelector("[data-action=clear]");
    var savePNGButton = wrapper.querySelector("[data-action=save-png]");
    var saveSVGButton = wrapper.querySelector("[data-action=save-svg]");
    var canvas = wrapper.querySelector("canvas");
    var signaturePad = new SignaturePad(canvas, {
    });

    function resizeCanvas() {
      var ratio =  Math.max(window.devicePixelRatio || 1, 1);
      canvas.width = canvas.offsetWidth * ratio;
      canvas.height = canvas.offsetHeight * ratio;
      canvas.getContext("2d").scale(ratio, ratio);
      signaturePad.clear();
    }

    window.onresize = resizeCanvas;
    resizeCanvas();

    function download(dataURL, filename) {
      var blob = dataURLToBlob(dataURL);
      var url = window.URL.createObjectURL(blob);

      var a = document.createElement("a");
      a.style = "display: none";
      a.href = url;
      a.download = filename;
      document.body.appendChild(a);
      a.click();

      window.URL.revokeObjectURL(url);
    }

    function dataURLToBlob(dataURL) {
      var parts = dataURL.split(';base64,');
      var contentType = parts[0].split(":")[1];
      var raw = window.atob(parts[1]);
      var rawLength = raw.length;
      var uInt8Array = new Uint8Array(rawLength);

      for (var i = 0; i < rawLength; ++i) {
        uInt8Array[i] = raw.charCodeAt(i);
      }

      return new Blob([uInt8Array], { type: contentType });
    }

    clearButton.addEventListener("click", function (event) {
      signaturePad.clear();
    });

    saveSVGButton.addEventListener("click", function (event) {
      if (signaturePad.isEmpty()) {
        alert('Please provide a signature first.');
      } else {
        var missing = 0;
        jQuery('#printfields input').each(function() {
            if(!jQuery(this).val()){
               missing = missing+1;
               return false;
            }
        });
        if (missing != 0) {
          alert("All fields are required");
        }else if (!jQuery('#printname').val() && jQuery('#printname').length != 0) {
          alert('Printed Name is required');
        }else{
          if (jQuery('#printname').length != 0) {
            printname = jQuery('#printname').val();
          }else{
            printname = '-';
          }
          jQuery('.button.save').hide();
          jQuery('.button.clear').hide();
          jQuery('.printname').hide();
          jQuery('.spinner_fdg').show();
          var dataURL = signaturePad.toDataURL('image/svg+xml');
          var img = document.createElement("img");
          img.src = dataURL;
          var src = document.getElementById("signature");
          src.appendChild(img);
          var timestamp = new Date(jQuery.now());
          jQuery.getJSON('https://api.ipify.org?format=json', function(data){
              ipaddressval = data.ip;
              runajax();
          });
          function runajax() {
              if(jQuery("#printfields").length == 0) {
                var formfields = '';
              }else{
                var formfields = jQuery("#printfields").serialize();
              }
              if(jQuery('#repeat').val() == 1) {
                console.log(_fdg_contract_send.ajax_url_repeat);
                jQuery.ajax({
                  url: _fdg_contract_send.ajax_url_repeat,
                  type : 'POST',
                  data: {svg : dataURL, id : jQuery('#postid').val(), ipaddress : ipaddressval, timestamp : timestamp, printname : printname, form : formfields, adminemail : jQuery('#adminemail').val()},
                  success:function(data) {
                      window.open(data + '#signed', '_self');
                      
                  },
                  error: function(errorThrown){
                      console.log(errorThrown);
                  }
                });
              }else{
                jQuery.ajax({
                  url: _fdg_contract_send.ajax_url,
                  type : 'POST',
                  data: {svg : dataURL, id : jQuery('#postid').val(), ipaddress : ipaddressval, timestamp : timestamp, printname : printname, form : formfields, adminemail : jQuery('#adminemail').val()},
                  success:function(data) {
                      if(jQuery('#redirect').val() != '') {
                        window.open(jQuery('#redirect').val());
                        window.location.hash = '#signed';
                        window.location.reload(true);
                      }else{
                        window.location.hash = '#signed';
                        window.location.reload(true);
                        console.log(data);
                      }
                      
                  },
                  error: function(errorThrown){
                      console.log(errorThrown);
                  }
                });
            }
          }
        }
      }
    });
  };

  jQuery('.printbtn').click(function () {
    window.onafterprint = function(e){
      jQuery(window).off('mousemove', window.onafterprint);
      console.log('Print Dialog Closed..');
    };
    if(jQuery('.signedby')[0]) {
      html2canvas(document.querySelector('.signedby')).then(canvas => {
            jQuery('.signedby').hide();
            jQuery(canvas).insertAfter('.signedby');
      });
    }
    window.setTimeout( show_popup, 1000 )
    setTimeout(function(){
        jQuery(window).one('mousemove', window.onafterprint);
    }, 1);
  });
});

function show_popup(){
    print();
}