<?php
add_action( 'pre_post_update', '_fdg_send_mails_on_publish' );

function _fdg_send_mails_on_publish($id)
{
	$current_user = wp_get_current_user();
	$dateformat = tr_options_field('fdg_plugin_options.date_format');
	global $wpdb;
  if ( is_admin() && function_exists('get_current_screen') ) {
    $post = get_current_screen();
    if ( $post->id == 'contract' ) {
  		$str = tr_posts_field('audit_log');
  		$contractstatus = get_post($id);
  	    if( $contractstatus->post_modified_gmt == $contractstatus->post_date_gmt ){
  	        $str .= '<em>'.date($dateformat.' G:i:s').'</em>, '.__('Contract created by', 'onlinecontract').' <strong>'.$current_user->user_login.'</strong>';
  	    }else{
  	        $str .= '<br><em>'.date($dateformat.' G:i:s').'</em>, '.__('Contract updated by', 'onlinecontract').' <strong>'.$current_user->user_login.'</strong>';
  	    }
  		$midname = $wpdb->get_results( $wpdb->prepare("SELECT meta_id FROM $wpdb->postmeta WHERE post_id = %d AND meta_key = %s", $id, 'audit_log') );
    	if(isset($midname[0])) {
        $meta_idname = $midname[0]->meta_id;
  			$auditlog = [
  			    'post_id' => $id,
  			    'meta_key' => 'audit_log',
  			    'meta_value' => $str
  			];

  			if($meta_idname != NULL) {
  				tr_query()->table('wp_postmeta')
  			      ->setIdColumn('meta_id')
  			      ->findById($meta_idname)
  			      ->update($auditlog);
  			}else{
  				tr_query()->table('wp_postmeta')
  			      ->setIdColumn('meta_id')
  			      ->create($auditlog);
  			}
      }

  		if(tr_posts_field('send_email_to_client_on_update?') == 1) {
      		$subject = tr_options_field('fdg_template_options.email_subject');
      		$convertedbody = formattemplate(tr_options_field('fdg_template_options.email_content'));
      		$convertedbody = str_replace('[contract-link]', get_the_permalink(), $convertedbody);
  	    	$body = $convertedbody;
          $emailshortcode = get_post_meta($id, 'client_email_shortcode', true);
          if($emailshortcode!='') {
            $clientemail = get_post_meta($id, $emailshortcode, true);
            sendmail($clientemail, $subject, $body);
          }
  		}
  	}
  }
}

function sendmail($email, $subject, $body) {
	$headers = '';
	if(tr_options_field('fdg_plugin_options.administration_email') != NULL) {
		$headers .= 'From: '.tr_options_field('fdg_plugin_options.your_company_name').' <' . strip_tags(tr_options_field('fdg_plugin_options.administration_email')) . '>'. "\r\n";
		$headers .= 'Reply-To: '. strip_tags(tr_options_field('fdg_plugin_options.administration_email')) . "\r\n";
	}else{
		$headers .= 'From: '.tr_options_field('fdg_plugin_options.your_company_name').' <' . strip_tags(bloginfo('admin_email')) . '>'. "\r\n";
		$headers .= 'Reply-To: '. strip_tags(bloginfo('admin_email')) . "\r\n";
	}
	$headers .= 'MIME-Version: 1.0'."\r\n";
	$headers .= 'Content-Type: text/html; charset=ISO-8859-1'."\r\n";
	wp_mail( $email, $subject, $body, $headers );
}