<?php
function getpaypalform($form) {
	$paypal = function() use ($form) {
	    echo '<p>'.__('If you are wanting to use PayPal as a integrated method of Payment after a contract is signed, use the following section to provide a bit of information for our plugin to use, otherwise leave this section blank.', 'onlinecontract').'</p>';
	    echo $form->text(__('PayPal Email Address', 'onlinecontract'));
	    echo $form->text(__('PayPal Fee', 'onlinecontract'));
	    echo $form->text(__('PayPal Button Label', 'onlinecontract'));
	    echo $form->checkbox(__('Turn Off PayPal?', 'onlinecontract'));
	    echo '<br>';
	    echo '
	    <h3>'.__('PayPal Payment Integration', 'onlinecontract').'</h3>
	    <p>'.__('Add a payment option to your contracts using PayPal.  Setup your PayPal button using the options to the left. Once you configure the options, a PayPal button will be added to your contract automatically.', 'onlinecontract').'</p>          
	    <h3>'.__('Need to Create a Account?', 'onlinecontract').'</h3>
	    <p>'.__('If you would like to use the payment option but do not have a PayPal account, you can join on their website.  It is free and easy to get started.  Visit <a href="http://paypal.com" target="_blank" onclick="return makesureSave();">www.paypal.com</a> to see the benefits of signing up and to create an account.', 'onlinecontract').'</p>
	    <h3>'.__('Need More Payment Methods?', 'onlinecontract').'</h3>
	    <p>Please see our <a href="http://codecanyon.net/user/futuredesigngrp/portfolio?ref=futuredesigngrp" onclick="return makesureSave();" target="_blank">portfolio</a>  for more payment processing plugins built by Future Design Group for our WP Online Contract plugin.</p>
	    <p style="text-align:right">Version: '._onlinecontract_version_num.'</p>
	    ';
	};
	return $paypal;
}


function getpaypalbutton($amount,$itemname) {
	global $Parser;
	$fontawesome = '';
	$amount = formattemplate('['.$amount.']');
	$paypalfee = tr_options_field('fdg_payment_options.paypal_fee');
	if (strpos($paypalfee, '%') !== false) {
    	$paypalfee = str_replace('%','',$paypalfee);
    	$paypaltotal = round($Parser->Execute($amount*($paypalfee / 100)),tr_options_field('fdg_plugin_options.decimal_round'));
    	$paypaltotal =  round($Parser->Execute($amount + $paypaltotal),tr_options_field('fdg_plugin_options.decimal_round'));
	}else{
		$paypaltotal =  round($Parser->Execute($amount + $paypalfee),tr_options_field('fdg_plugin_options.decimal_round'));
	}
	$itemname = formattemplate('['.$itemname.']');
	if(tr_options_field('fdg_plugin_options.use_fontawesome_icons?') == 1) {
		$fontawesome = '<em class="fab fa-paypal" aria-hidden="true"></em> ';
	}
	$paypalbutton = '
	<div style="float:right;margin-left:10px;">	
		<button type="button" class="btn button paypal" onclick="window.open(\'https://www.paypal.com/cgi-bin/webscr?business='.tr_options_field('fdg_payment_options.paypal_email_address').'&amp;cmd=_xclick&amp;currency_code='.tr_options_field('fdg_plugin_options.currency_type').'&amp;amount='.$paypaltotal.'&amp;item_name='.$itemname.'\',\'_blank\')">'.$fontawesome.tr_options_field('fdg_payment_options.paypal_button_label').'</button>
	</div>';

	return $paypalbutton;

}