<?php
if(tr_options_field('fdg_plugin_options.debug_plugin')!= NULL && tr_options_field('fdg_plugin_options.debug_plugin')!= 0) {
	ini_set('display_errors', 1);
}
$pluginbasename = plugin_basename(dirname(dirname(__FILE__)));

if(tr_options_field('fdg_plugin_options.contract_permalink')!=NULL) {
    $slug = tr_options_field('fdg_plugin_options.contract_permalink');
}else{
    $slug = 'contract';
}

function _fdg_preventindex() {
    if ( is_singular('contract') ) {
        echo '<meta name="robots" content="noindex, nofollow" />'."\r\n";
    }
}
    
add_action('wp_head','_fdg_preventindex',1,1);

add_action( 'admin_enqueue_scripts', function() {
    $themeUrl = plugin_dir_url(__DIR__ . '..').'typerocket/wordpress/assets/templates';
    wp_enqueue_style( 'fdg_contract_admin_css', $themeUrl . '/css/admin.css' );
    wp_enqueue_script( 'fdg_contract_admin_js', $themeUrl . '/js/admin.js' );
} );

add_filter( 'template_include','_fdg_onlinecontract_include_template_function', 1 );

function _fdg_onlinecontract_include_template_function( $template_path ) {
	if ( get_post_type() == 'contract' ) {
		if ( is_single() ) {
			if ( $theme_file = locate_template( array( 'single-contract.php' ) ) ) {
				$template_path = $theme_file;
			} else {
				$template_path = plugin_dir_path( __FILE__ ) .'single-contract.php';
			}
		}
	}
	return $template_path;
}

function envato_api_results( $cache_file = NULL, $expires = NULL ) {
    global $request_type, $purge_cache, $limit_reached, $request_limit;

    if( !$cache_file ) $cache_file = dirname(__FILE__) . '/api-cache.json';
    if( !$expires) $expires = time() - 2*60*60;

    if( !file_exists($cache_file) ) die("Cache file is missing: $cache_file");
    if ( filectime($cache_file) < $expires || file_get_contents($cache_file)  == '' ) {
    		if(tr_options_field('fdg_plugin_options_purchase.purchase_code') != NULL) {
	        $api_results = validatepurchasecodeenvato( tr_options_field('fdg_plugin_options_purchase.purchase_code'));
	        $json_results = $api_results;
	        if ( $api_results && $json_results )
	         file_put_contents($cache_file, $json_results);
	        else
         	file_put_contents($cache_file, '');
	       }else{
	       	$json_results = '';
	       }

    } else {
        $json_results = file_get_contents($cache_file);
        $request_type = 'JSON';
    }
    $json_results = json_decode($json_results);
    if(isset($json_results->error)) {
		  return false;
	}else{
      if(isset($json_results->item->id)) {
  	    if($json_results->item->id == 7698011) {
  	    	flush_rewrite_rules();
  	    	return true;
  	    }else{
  	    	return false;
  	    }
      }else{
        return false;
      }
	}
}

function envato_api_resultsnew( $cache_file = NULL, $expires = NULL ) {
    global $request_type, $purge_cache, $limit_reached, $request_limit;

    if( !$cache_file ) $cache_file = dirname(__FILE__) . '/api-cache.json';
    if( !$expires) $expires = time() - 2*60*60;

    if( !file_exists($cache_file) ) die("Cache file is missing: $cache_file");

    file_put_contents($cache_file, '');    
}

function validatepurchasecode() {
	return envato_api_results();
}

function validatepurchasecodeenvato($purchasecode) {
	$envato_url = 'https://api.envato.com/v3/market/author/sale?code='.urlencode(trim($purchasecode)).'';

	$response = wp_remote_get($envato_url,       
	    array(
		'headers' => array(
        'Authorization' => 'Bearer xiFg3WxW6001C77aVUqUYPNlex3hmvWx',
        'User-Agent' => 'WPONLINECONTRACT',
		)
	)    
	); 

	return $response['body'];
}

function convertshortcodeadmin($form, $shortcode) {
	$formret = '';
	$desc = '';
	switch ($shortcode['data_type']) {
		case 'text':
			$formret = $form->text($shortcode['label']);
			if(isset($shortcode['required_input_on_front'])) {
      			$formret->setAttribute('required', true);
      		}
			if($shortcode['descriptive_text']) {
				$desc = '<small>'.$shortcode['descriptive_text'].'</small><br><br>';
			}
			break;
		case 'textarea':
			$formret = $form->textarea($shortcode['label']);
      		if(isset($shortcode['required_input_on_front'])) {
      			$formret->setAttribute('required', true);
      		}
			if($shortcode['descriptive_text']) {
				$desc = '<small>'.$shortcode['descriptive_text'].'</small><br><br>';
			}
			break;
		case 'date':
			$formret = $form->date($shortcode['label']);
      		if(isset($shortcode['required_input_on_front'])) {
      			$formret->setAttribute('required', true);
      		}
			if($shortcode['descriptive_text']) {
				$desc = '<small>'.$shortcode['descriptive_text'].'</small><br><br>';
			}
			break;
		case 'checkbox':
			$formret = $form->checkbox($shortcode['label']);
      		if(isset($shortcode['required_input_on_front'])) {
      			$formret->setAttribute('required', true);
      		}
			break;
		case 'radio':
			$options = array();
			$optionsarr = explode(',',str_replace(', ', ',',$shortcode['options']));
			foreach ($optionsarr as $option) {
				$optionval = strtolower(str_replace(' ','_',preg_replace("/[^A-Za-z0-9 ]/", '', $option)));
				$options[$option] = $optionval;
			}
			$formret = $form->radio($shortcode['label'])->setOptions($options);
      		if(isset($shortcode['required_input_on_front'])) {
      			$formret->setAttribute('required', true);
      		}
			break;
		case 'select':
			$options = array();
			$optionsarr = explode(',',str_replace(', ', ',',$shortcode['options']));
			foreach ($optionsarr as $option) {
				$optionval = strtolower(str_replace(' ','_',preg_replace("/[^A-Za-z0-9 ]/", '', $option)));
				$options[$option] = $optionval;
			}
			$formret = $form->select($shortcode['label'])->setOptions($options);
      		if($shortcode['required_input_on_front']==1) {
      			$formret->setAttribute('required', true);
      		}
			if($shortcode['descriptive_text']) {
				$desc = '<small>'.$shortcode['descriptive_text'].'</small><br><br>';
			}
			break;
		case 'file':
			$formret = $form->file($shortcode['label']);
      		if(isset($shortcode['required_input_on_front'])) {
      			$formret->setAttribute('required', true);
      		}
			if($shortcode['descriptive_text']) {
				$desc = '<small>'.$shortcode['descriptive_text'].'</small><br><br>';
			}
			break;
		case 'editor':
			$formret = $form->editor($shortcode['label']);
    		if(isset($shortcode['required_input_on_front'])) {
      			$formret->setAttribute('required', true);
      		}
			if($shortcode['descriptive_text']) {
				$desc = '<small style="position: relative; top: -20px;">'.$shortcode['descriptive_text'].'</small><br><br>';
			}
			break;
	}
	
	return $formret.$desc;
}

function fieldchecks() {
	$chk = '';

	if(tr_options_field('fdg_shortcodes.contract_shortcodes')==null) {
		$chk .= '<li>'.__( 'You have not created any shortcodes. Please add new shortcodes or the plugin will not work as expected.', 'onlinecontract' ).'</li>';
	}

	if(tr_options_field('fdg_template_options.contract_templates')==null) {
		$chk .= '<li>'.__( 'You have not created any contract templates. Please add new contract template under Templates > Contract Templates in order to create a new contract.', 'onlinecontract' ).'</li>';
	}

	if(tr_options_field('fdg_plugin_options.your_company_name')==null) {
		$chk .= '<li>'.__( 'Enter your company name into the Settings > Plugin Setup to ensure your company is used in the email notifications.', 'onlinecontract' ).'</li>';
	}

  if(tr_options_field('fdg_plugin_options.currency_type')==null) {
    $chk .= '<li>'.__( 'Enter your your currency type into the Settings > Plugin Setup to ensure payments are setup to us the correct type.', 'onlinecontract' ).'</li>';
  }

	if(tr_options_field('fdg_plugin_options.administration_email')==null) {
		$chk .= '<li>'.__( 'Enter your administrative email into the Settings > Plugin Setup. This will be used to send emails from.', 'onlinecontract' ).'</li>';
	}

  if(tr_options_field('fdg_plugin_options.date_format')==null) {
    $chk .= '<li>'.__( 'You should add a date format in the Settings > Plugin Setup. This will set the visible format for the dates throughout the plugin.', 'onlinecontract' ).'</li>';
  }

  if(tr_options_field('fdg_plugin_options.datepicker_format')==null) {
    $chk .= '<li>'.__( 'You should add a date picker format in the Settings > Plugin Setup. This will set the date format for the date pickers used throughout the plugin.', 'onlinecontract' ).'</li>';
  }

	if(tr_options_field('fdg_template_options.email_subject')==null) {
		$chk .= '<li>'.__( 'You should add a email subject in the Notification Email Template on the Templates > Other Templates screen. This will allow you to send emails with a custom subject.', 'onlinecontract' ).'</li>';
	}

	if(tr_options_field('fdg_template_options.email_content')==null) {
		$chk .= '<li>'.__( 'You should add contents of your notification email in the Notification Email Template on the Templates > Other Templates screen. This ensures that you notification email has content.', 'onlinecontract' ).'</li>';
	}

	if ($chk != '') {
		$chk = '<h3>'.__( 'Before creating a contract, make sure you have finished your setup.', 'onlinecontract' ).'</h3><ul class="fieldcheck">'.$chk.'</ul><p>'.__( 'Need help? We are here to assist you. Drop us a line by visiting our Help Desk and submitting a ticket or view our answers to common problems. You can view our help desk here:', 'onlinecontract' ).' <a href="https://support.futuredesigngroup.com" target="_blank">https://support.futuredesigngroup.com/</a>';
	}

	return $chk;
}

function formattemplate($template) {
	global $Parser;
	$formattedtemplate = $template;
	preg_match_all("^\[(.*?)\]^",$formattedtemplate,$extract, PREG_PATTERN_ORDER);
	array_pop($extract);

	foreach ($extract[0] as $extractval) {
		if(getdefaultshortcodes($extractval)!=NULL) {
			$formattedtemplate = str_replace($extractval, getdefaultshortcodes($extractval), $formattedtemplate);
		}
		foreach (tr_options_field('fdg_shortcodes.contract_shortcodes') as $shortcode) {
			if($extractval == $shortcode['shortcode']) {
				$shortcodefunction = $shortcode['function'];
				if($shortcodefunction != '') {
					preg_match_all("^\[(.*?)\]^",$shortcodefunction,$extractfunction, PREG_PATTERN_ORDER);
					array_pop($extractfunction);
					foreach ($extractfunction[0] as $extractfunctionval) {
						foreach (tr_options_field('fdg_shortcodes.contract_shortcodes') as $shortcodefunctionarr) {
							if($extractfunctionval == $shortcodefunctionarr['shortcode']) {
								$shortcodeconvertedfunction = strtolower(str_replace(array(), '', str_replace(' ', '_',$shortcodefunctionarr['label'])));
								$shortcodefunction = str_replace($extractfunctionval, tr_posts_field($shortcodeconvertedfunction), $shortcodefunction);
							}
						}
					}
					$shortcodefunctionstring = round($Parser->Execute($shortcodefunction),tr_options_field('fdg_plugin_options.decimal_round'));
					$shortcodeconverted = strtolower(str_replace(array(), '', str_replace(' ', '_',$shortcode['label'])));
					$formattedtemplate = str_replace($extractval, $shortcodefunctionstring, $formattedtemplate);
				}else{
					$shortcodeconverted = strtolower(str_replace(array(), '', str_replace(' ', '_',$shortcode['label'])));
					$formattedtemplate = str_replace($extractval, tr_posts_field($shortcodeconverted), $formattedtemplate);
				}
			}
		}
	}

	return $formattedtemplate;
}

function formatsingleshortcode($shortcode) {
	global $Parser;
	$formattedshortcode = $shortcode;
	preg_match_all("^\[(.*?)\]^",$formattedshortcode,$extract, PREG_PATTERN_ORDER);
	array_pop($extract);

	foreach ($extract[0] as $extractval) {
		if(getdefaultshortcodes($extractval)!=NULL) {
			$formattedshortcode = str_replace($extractval, getdefaultshortcodes($extractval), $formattedshortcode);
		}
		foreach (tr_options_field('fdg_shortcodes.contract_shortcodes') as $shortcode) {
			if($extractval == $shortcode['shortcode']) {
				$shortcodeconverted = strtolower(str_replace(array(), '', str_replace(' ', '_',$shortcode['label'])));
				$formattedshortcode = str_replace($extractval, tr_posts_field($shortcodeconverted), $formattedshortcode);
			}
		}
	}

	return $formattedshortcode;
}

function convertsingleshortcode($shortcode) {
	global $Parser;
	$formattedshortcode = $shortcode;
	preg_match_all("^\[(.*?)\]^",$formattedshortcode,$extract, PREG_PATTERN_ORDER);
	array_pop($extract);

	foreach ($extract[0] as $extractval) {
		if(getdefaultshortcodes($extractval)!=NULL) {
			$formattedshortcode = str_replace($extractval, getdefaultshortcodes($extractval), $formattedshortcode);
		}
		if(tr_options_field('fdg_shortcodes.contract_shortcodes')!= NULL) {
			foreach (tr_options_field('fdg_shortcodes.contract_shortcodes') as $shortcode) {
				if($extractval == $shortcode['shortcode']) {
					$shortcodeconverted = preg_replace('/[^\da-z ]/i', '', $shortcode['label']);
					$shortcodeconverted = strtolower(str_replace(array(), '', str_replace(' ', '_',$shortcodeconverted)));
					$formattedshortcode = str_replace($extractval, $shortcodeconverted, $formattedshortcode);

				}
			}
		}
	}

	return $formattedshortcode;
}

function getallshortcodes() {
	$str = '<p><strong>'.__('Available Shortcodes', 'onlinecontract').'</strong></p>';
	$str .= '<strong>[businessname]</strong><br>'.__('This will allow you to add your business name on your contract', 'onlinecontract').'<br><br>';
	$str .= '<strong>[contractcurrency]</strong><br>'.__('This will display your currency symbol on your contract', 'onlinecontract').'<br><br>';
    foreach(tr_options_field('fdg_shortcodes.contract_shortcodes') as $shortcode) {
      $str .= '<strong>'.$shortcode['shortcode'].'</strong><br>'.$shortcode['descriptive_text'].'<br><br>';
    }
    return $str;
}

function getdefaultshortcodes($extract) {
	$val = '';
	switch ($extract) {
		case '[businessname]':
			$val = tr_options_field('fdg_plugin_options.your_company_name');
			break;
		case '[contractcurrency]':
			$val = tr_options_field('fdg_plugin_options.currency_symbol');
			break;
		case '[onlinecontractpagebreak]':
			$val = '<div class="page-break"></div>';
			break;
	}

	return $val;

}

function _onlinecontract_plugin_action_links_documentation( $links, $file) {
	global $pluginbasename;
	if ( $file == $pluginbasename.'/onlinecontract.php' ) {
		$documentation_link = '<a href="http://onlinecontract.futuredesigngroup.com/documentation" target="_blank">'.__( 'Documentation', 'onlinecontract' ).'</a>';
		array_unshift( $links, $documentation_link );
	}
	if ( $file == $pluginbasename.'/onlinecontract.php' ) {
		$settings_link = '<a href="'.get_admin_url().'/edit.php?post_type=contract&page=contract-settings">'.__( 'Settings', 'onlinecontract' ).'</a>';
		array_unshift( $links, $settings_link );
	}
	return $links;
}
add_filter( 'plugin_action_links', '_onlinecontract_plugin_action_links_documentation', 10, 2 );

function fdg_contract_glance_items( $items = array() ) {
	global $slug;
	echo '<style>';
		echo '.post-count.contract-count a:before, .post-count.contract-count span:before{
	    font: 400 15px/1 typerocket-icons !important;
	    content: \'\e905\' !important;
	    speak: none !important;
	    top: 2px;
	    position: relative;
	    -webkit-font-smoothing: antialiased;
	}';
	echo '</style>';
    $post_types = array( 'contract' );
    foreach( $post_types as $type ) {
        if( ! post_type_exists( $type ) ) continue;
        $num_posts = wp_count_posts( $type );
        if( $num_posts ) {
            $published = intval( $num_posts->publish );
            $post_type = get_post_type_object( $type );
            $text = _n( '%s ' . $post_type->labels->singular_name, '%s ' . $post_type->labels->name, $published, 'onlinecontract' );
            $text = sprintf( $text, number_format_i18n( $published ) );
    		if ( current_user_can( $post_type->cap->edit_posts ) ) {
            	$output = '<a href="edit.php?post_type=' . $post_type->name . '">' . $text . '</a>';
                echo '<li class="post-count ' . $post_type->name . '-count">' . $output . '</li>';
            } else {
            	$output = '<span>' . $text . '</span>';
                echo '<li class="post-count ' . $post_type->name . '-count">' . $output . '</li>';
            }
        }
    }
    return $items;
}

add_filter( 'dashboard_glance_items', 'fdg_contract_glance_items', 10, 1 );

function _fdg_dashboard_widget_function( $post, $callback_args ) {
	global $slug;
	$contracts ='';
	$current_user = wp_get_current_user();
	$email = $current_user->user_email;

	$emailshortcode = tr_options_field('fdg_plugin_options.client_email_shortcode');

	$emailshortcode = convertsingleshortcode('['.$emailshortcode.']');
	$args = array(
		'post_type' => 'contract',
			'meta_query' => array(
	       array(
	           'key' => $emailshortcode,
	           'value' => $email,
	           'compare' => '=',
	       )
	   )
	);
	$query = new WP_Query($args);
	$i = 0;
	if ( $query->have_posts() ) :
		while ( $query->have_posts() ) : $query->the_post();
			if(tr_posts_field('remove_signature_box?') != 1) {
				if(tr_posts_field('signature') == '-') {
					$status = array('Unsigned','red');
				}else{
					$status = array('Signed','green');
				}
			}else{
				$status = array('Cannot Sign Online','gray');
			}
			$contracts .= '<a href="'.get_the_permalink().'" target="_blank"><div style="float:right; background-color:'.$status[1].'; color:#fff; font-weight:bold; padding:5px 10px; position:relative; top:-5px;">'.$status[0].'</div>'.__('View').' '.get_the_title().'</a><div style="clear:both; float:none;"></div><br>';		
		endwhile;		
	else:
		$contracts = '<p>'.__('You do not have any open contracts.', 'onlinecontract').'</p>';

	endif;

	echo $contracts;
}

// Function used in the action hook
function _fdg_add_dashboard_widgets() {
	wp_add_dashboard_widget('dashboard_widget', __('Your Contracts', 'onlinecontract'), '_fdg_dashboard_widget_function');
}

// Register the new dashboard widget with the 'wp_dashboard_setup' action
add_action('wp_dashboard_setup', '_fdg_add_dashboard_widgets' );

function _fdgclientadd( $atts ) {
	global $slug;
	$shortcodeout = '<div class="typerocket-container">';
	$form = tr_form()->useUrl('post', $slug.'/createcontract');
	$shortcodeout .=  $form->open();
    $shortcodeout .=  $form->hidden('Signature')->setDefault('-');
    $shortcodeout .=  $form->hidden('Printed Name')->setDefault('-');
    $shortcodeout .=  $form->hidden('IP Address')->setDefault('-');
    $shortcodeout .=  $form->hidden('Generated Sign Date')->setDefault('-'); 
    $shortcodeout .=  $form->hidden('Can This Contract Be Repeatedly Signed?')->setDefault('');       
    $shortcodeout .=  $form->hidden('Contract Template')->setDefault('-');
    foreach(tr_options_field('fdg_shortcodes.contract_shortcodes') as $shortcode) {
        if (!isset($shortcode['function_only']) && isset($shortcode['visible_on_front'])) {
            $shortcodeout .=  convertshortcodeadmin($form, $shortcode);
        }
    }
	$shortcodeout .=  $form->submit( __('Initiate Contract', 'onlinecontract') );
	$shortcodeout .=  '</div>';
  return $shortcodeout;
}
add_shortcode( 'clientadd', '_fdgclientadd' );