<?php
$fdg_contract = tr_post_type('contract', __('Contracts', 'onlinecontract')); 
$fdg_contract->setIcon('pencil');
$fieldchecks = fieldchecks();
if(tr_options_field('fdg_plugin_options.contract_permalink')!=NULL && validatepurchasecode()) {
    $fdg_contract->setSlug(tr_options_field('fdg_plugin_options.contract_permalink'));
}else{
    $fdg_contract->setSlug('contract');
}
if(validatepurchasecode() == true) {
    $fdg_contracttype = tr_taxonomy('Contract Type');
    $fdg_contracttype->apply($fdg_contract);
    $fdg_contracttype->setArgument( 'labels',
        array(
            'add_new_item' => 'Add New '.__('Contract Type', 'onlinecontract'),
            'add_or_remove_items' => 'Add or remove contract types',
            'all_items' => 'All '.__('Contract Type', 'onlinecontract').'s',
            'choose_from_most_used' => 'Choose from the most used contract types',
            'edit_item' => 'Edit '.__('Contract Type', 'onlinecontract'),
            'name' => ''.__('Contract Type', 'onlinecontract').'s',
            'menu_name' => ''.__('Contract Type', 'onlinecontract').'s',
            'new_item_name' => 'New '.__('Contract Type', 'onlinecontract').' Name',
            'not_found' => 'No contract types found.',
            'parent_item' => 'Parent '.__('Contract Type', 'onlinecontract'),
            'parent_item_colon' => 'Parent '.__('Contract Type', 'onlinecontract').':',
            'popular_items' => 'Popular '.__('Contract Type', 'onlinecontract').'s',
            'search_items' => 'Search '.__('Contract Type', 'onlinecontract').'s',
            'separate_items_with_commas' => 'Separate contract types with commas',
            'singular_name' => ''.__('Contract Type', 'onlinecontract'),
            'update_item' => 'Update '.__('Contract Type', 'onlinecontract'),
            'view_item' => 'View '.__('Contract Type', 'onlinecontract')
        )
    );
    $fdg_contracttype->setHierarchical();
    if($fieldchecks == '') {
        $fdg_contract->setArgument('supports', ['title', 'revisions'] );
    }else{
        $fdg_contract->setArgument('supports',[''] );
    }
    $fdg_contract->addColumn('signature', true, __('Signed', 'onlinecontract'), function($value) {
        if($value != '-') {
            echo '<span style="color:#fff; background-color:green; padding:5px 10px; border-radius:5px;">'.__('Signed', 'onlinecontract').'</span>';
        }else{
            echo '<span style="color:#fff; background-color:red; padding:5px 10px; border-radius:5px;">'.__('Unsigned', 'onlinecontract').'</span>';
        }
    }, 'string');
    $fdg_contract->addColumn('printed_name', true, __('Printed Name', 'onlinecontract'), function($value) {
        if($value!='-') {
            echo $value;        
        }else{
            echo '<em>'.__('Not Set', 'onlinecontract').'</em>';
        }
    }, 'string');
    $fdg_contract->addColumn('redirect_after_signing?', true, __('Redirected?', 'onlinecontract'), function($value) {
        if($value!='') {
            echo $value;        
        }else{
            echo '<em>'.__('Not Set', 'onlinecontract').'</em>';
        }
    }, 'string');
    $fdg_contract->addColumn('id', true, __('Contract Type', 'onlinecontract'), function($value) {
        $termsind = '';
        $terms = get_the_terms( $value , 'contract_type' );
        if($terms!='') {
            foreach ( $terms as $term ) {
                $termsind .= $term->name.', ';
            }
            echo rtrim($termsind, ', ');
        }else{
            echo '<em>'.__('Not Set', 'onlinecontract').'</em>';
        }
    }, 'string');

    $fdg_contractMeta = tr_meta_box(__('Default Options', 'onlinecontract'));
    $fdg_contractMeta->setLabel(__('Default Options', 'onlinecontract'));
    $fdg_contractMeta->addScreen('contract');
    $fdg_contractMeta->setPriority('high');
    $fdg_contractMeta->setCallback(
        function(){
            global $post;
            $fieldchecks = fieldchecks();
            if($fieldchecks == '') {
                $options = array();
                $shortcodespayment = array(__('Do not display payment options', 'onlinecontract')=>'no');
                $shortcodes = array(''=>'');
                $shortcodessimple = array(''=>'');
                $form = tr_form();
                if (tr_posts_field('signature')!='-' && tr_posts_field('signature')!=NULL) {
                    echo '<img src="'.tr_posts_field('signature').'" style="width:100%; height:auto;">';
                    echo '<p style="text-align:center;">'.__('This contract has already been signed. It cannot be modified until you remove the signature and have your client resign.', 'onlinecontract').'</p>';
                    echo '<p style="text-align:center;">'.__('Signed');
                    if (tr_posts_field('printed_name')!='-' && tr_posts_field('printed_name')!=NULL) {
                        echo ' by <strong>'.tr_posts_field('printed_name').'</strong>';
                    }
                    echo ' on <strong>'.tr_posts_field('generated_sign_date').'</strong>';
                    echo '</p>';
                    echo '<p style="text-align:center;"><span class="spinner_fdg"></span><a href="'.get_permalink().'removesignature/'.$post->ID.'" onclick="addSpinner(jQuery(\'spinner\'))" class="removesignature">Remove Signature</a></p>';
                }else{
                    echo $form->hidden('Signature')->setDefault('-');
                    echo $form->hidden('Printed Name')->setDefault('-');
                    echo $form->hidden('IP Address')->setDefault('-');
                    echo $form->hidden('Generated Sign Date')->setDefault('-');
                    foreach(tr_options_field('fdg_template_options.contract_templates') as $template) {
                        $options[$template['contract_name']] = $template['contract_name'];
                    }
                    foreach(tr_options_field('fdg_shortcodes.contract_shortcodes') as $shortcode) {
                        $shortcodespayment[$shortcode['label']] = str_replace(array('[',']'),'',$shortcode['shortcode']);
                        $shortcodes[$shortcode['label']] = str_replace(array('[',']'),'',$shortcode['shortcode']);
                        $shortcodessimple[$shortcode['label']] = strtolower(str_replace(array(' '),'_',$shortcode['label']));
                    }
                    echo $form->row(
                            $form->select('Contract Template')->setOptions($options)->setLabel(__('Contract Template', 'onlinecontract')), 
                            $form->text('Redirect after signing?')->setLabel(__('Redirect after signing?', 'onlinecontract'))
                        );
                    echo $form->row(
                            $form->select('Payment Option Shortcode')->setOptions($shortcodespayment)->setLabel(__('Payment Option Shortcode', 'onlinecontract')), 
                            $form->select('Payment Item Name Shortcode')->setOptions($shortcodes)->setLabel(__('Payment Item Name Shortcode', 'onlinecontract'))
                        );
                    echo $form->row(
                            $form->select('Your Representative Shortcode')->setOptions($shortcodes)->setLabel(__('Your Representative Shortcode', 'onlinecontract')), 
                            $form->select('Client Email Shortcode')->setOptions($shortcodessimple)->setLabel(__('Client Email Shortcode', 'onlinecontract'))
                        );
                    echo $form->checkbox('Can This Contract Be Repeatedly Signed?')->setLabel(__('Can This Contract Be Repeatedly Signed?', 'onlinecontract'));
                    echo $form->checkbox('Remove Signature Box?')->setLabel(__('Remove Signature Box?', 'onlinecontract'));
                    echo $form->checkbox('Force Use to Print Name?')->setLabel(__('Force User to Print Name?', 'onlinecontract'));
                    echo $form->checkbox('Force Use to Use Prepared Fields?')->setLabel(__('Force User to Use Prepared Fields?', 'onlinecontract'));
                    echo $form->checkbox('Send Email to Client on Update?')->setLabel(__('Send Email to Client on Update?', 'onlinecontract'));
                    echo '<small>'.__('Only check this box after you have saved the contract at least once. If not, the email may be sent with incomplete information.', 'onlinecontract').'</small>';
                }
            }else{
                echo $fieldchecks;
            }
        }
    );

    $fdg_contractMeta = tr_meta_box('Custom Options');
    if (tr_posts_field('signature')=='-' || tr_posts_field('signature')==NULL) {
        $fdg_contractMeta->setLabel(__('Contract Details', 'onlinecontract'));
    }else{
        $fdg_contractMeta->setLabel(__('Custom Options', 'onlinecontract'));
    }
    $fdg_contractMeta->addScreen('contract');
    $fdg_contractMeta->setPriority('core');
    $fdg_contractMeta->setCallback(
        function(){
            global $post;
            $fieldchecks = fieldchecks();
            if($fieldchecks == '') {
                if (tr_posts_field('signature')=='-' || tr_posts_field('signature')==NULL) {
                    $form = tr_form();
            
                    foreach(tr_options_field('fdg_shortcodes.contract_shortcodes') as $shortcode) {
                        if(!isset($shortcode['function_only'])) {
                            echo convertshortcodeadmin($form, $shortcode);
                        }
                    }
                }else{
                    echo '<table style="width:100%;">';
                    echo '<tr><td colspan="2"><h3>'.__('Default Options', 'onlinecontract').'</h3></td></tr>';
                    echo '<tr>
                            <td><strong>'.__('Contract Template', 'onlinecontract').'</strong></td>
                            <td style="text-align:left; width:70%;">'.tr_posts_field('contract_template').'</td>
                          </tr>
                          <tr><td colspan="2">&nbsp;</td></tr>';
                    if (tr_posts_field('payment_option_shortcode') != 'no') {
                        echo '<tr>
                            <td><strong>'.__('Accept Payment?', 'onlinecontract').'</strong></td>
                            <td style="text-align:left; width:70%;">'.__('Yes', 'onlinecontract').'</td>
                          </tr>
                          <tr><td colspan="2">&nbsp;</td></tr>';
                    }else{
                        echo '<tr>
                            <td><strong>'.__('Accept Payment?', 'onlinecontract').'</strong></td>
                            <td style="text-align:left; width:70%;">'.__('No', 'onlinecontract').'</td>
                          </tr>
                          <tr><td colspan="2">&nbsp;</td></tr>';
                    }
                    if (tr_posts_field('redirect_after_signing?') != NULL) {
                        echo '<tr>
                            <td><strong>'.__('Redirect After Signing?', 'onlinecontract').'</strong></td>
                            <td style="text-align:left; width:70%;">'.tr_posts_field('redirect_after_signing?').'</td>
                          </tr>
                          <tr><td colspan="2">&nbsp;</td></tr>';
                    }else{
                        echo '<tr>
                            <td><strong>'.__('Redirect After Signing?', 'onlinecontract').'</strong></td>
                            <td style="text-align:left; width:70%;">'.__('No', 'onlinecontract').'</td>
                          </tr>
                          <tr><td colspan="2">&nbsp;</td></tr>';
                    }
                    echo '<tr><td colspan="2"><hr></td></tr>';
                    echo '<tr><td colspan="2"><h3>'.__('Custom Options', 'onlinecontract').'</h3></td></tr>';
                    foreach(tr_options_field('fdg_shortcodes.contract_shortcodes') as $shortcode) {
                        if(!isset($shortcode['function_only'])) {
                           echo '<tr><td><strong>'.$shortcode['label'].'</strong></td><td style="text-align:left; width:70%;">'.formatsingleshortcode($shortcode['shortcode']).'</td></tr><tr><td colspan="2">&nbsp;</td></tr>';
                        }
                    }
                    echo '</table>';
                    //echo '<p style="text-align:center;">'.__('Options Unavailable.', 'onlinecontract').'</p>';
                }
            }else{
                echo '<p>'.__('Please fix the items above before this section will open.', 'onlinecontract').'</p>';
            }
        }
    );
    /* Audit Log */
    $fdg_contractMeta = tr_meta_box('Audit Log');
    $fdg_contractMeta->setPriority('low');
    $fdg_contractMeta->addScreen('contract');
    $fdg_contractMeta->setCallback(
        function(){
            global $post;
            $form = tr_form();
            echo $form->hidden('Audit Log');
            echo $form->textarea('Audit Log')->getValue();
        }
    );
}else{
    $fdg_contract->setArgument('supports', [''] );
    $fdg_contractMeta = tr_meta_box(__('Purchase Code Missing or Invalid', 'onlinecontract'));
    $fdg_contractMeta->addScreen('contract');
    $fdg_contractMeta->setCallback(
        function(){
            echo '<p>Your purchase is either invalid or has not been input. Please go to the <a href="'.get_admin_url().'edit.php?post_type=contract&page=purchase">Purchase Code</a> page and complete the installation of our plugin. Once this is done, your custom options will appear here.</p>';
        }
    );
}
