<?php
require_once( 'fdg_onlinecontract_autoupdate.php' );
require_once('typerocket/init.php');

//tr_frontend();

require ('includes/parser.php');
require ('includes/sendmail.php');
$Parser = new \Matex\Parser();

if(tr_options_field('fdg_plugin_options.contract_permalink')!=NULL) {
    $slug = tr_options_field('fdg_plugin_options.contract_permalink');
}else{
    $slug = 'contract';
}

add_action( 'typerocket_loaded', function() {
    load_plugin_textdomain( 'onlinecontract', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    require ('includes/contract.php');
});

require ('includes/functions.php');

function _fdg_onlinecontract_enqueue_script() {
	global $slug;
    /*included styles */
    wp_enqueue_style( 'fdg_contract_css', plugin_dir_url( __FILE__ ). 'css/style.css' );
    if(tr_options_field('fdg_plugin_options.use_fontawesome_icons?') == 1) {
        wp_enqueue_style( 'font-awesome', 'https://use.fontawesome.com/releases/v5.1.0/css/all.css' );
        wp_enqueue_style( 'font-awesome', 'https://use.fontawesome.com/releases/v5.1.0/css/brands.css' );
    }
        /* included scripts */
    wp_enqueue_script( 'fdg_contract_signature_js', plugin_dir_url( __FILE__ ). 'js/signature_pad.min.js', array('jquery') );
    wp_enqueue_script( 'fdg_contract_signatureoverwrite_js', plugin_dir_url( __FILE__ ). 'js/html2canvas.min.js', array('jquery') );
    wp_enqueue_script( 'fdg_contract_js', plugin_dir_url( __FILE__ ). 'js/init.js', array('jquery') );
    wp_localize_script( 'fdg_contract_js', '_fdg_contract_send', array(
        'ajax_url' => site_url().'/'.$slug.'/savesignature',
        'ajax_url_repeat' => site_url().'/'.$slug.'/duplicate'
    ));
    
    if( is_page() || is_single() ) {
      wp_enqueue_style( 'datepicker-style', 'https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css', array(), null);
      wp_enqueue_script('jquery-ui-datepicker');
      if(tr_options_field('fdg_plugin_options.datepicker_format')!=NULL){
        wp_enqueue_script( 'fdg_contract_date_js', plugin_dir_url( __FILE__ ). 'js/admin.js', array('jquery') );
        $data = array(
          'dateformat' =>tr_options_field('fdg_plugin_options.datepicker_format')
        );
        wp_localize_script( 'fdg_contract_date_js', '_fdg_contractadmin_send', $data );
      }
    }
}
add_action('wp_enqueue_scripts', '_fdg_onlinecontract_enqueue_script');

// Function to set date picker to date format
function _fdg_onlinecontract_admin_enqueue_script() {
  global $post_type;
  if( $post_type == 'contract' ) {
    if(tr_options_field('fdg_plugin_options.datepicker_format')!=NULL){
      wp_enqueue_script( 'fdg_contract_date_js', plugin_dir_url( __FILE__ ). 'js/admin.js', array('jquery') );
      $data = array(
        'dateformat' =>tr_options_field('fdg_plugin_options.datepicker_format')
      );
      wp_localize_script( 'fdg_contract_date_js', '_fdg_contractadmin_send', $data );
    }
  }
}
add_action('admin_enqueue_scripts', '_fdg_onlinecontract_admin_enqueue_script');

/* Disabled rss links */
function _fdg_wponlinecontract_disable_feed( $query ) {
  if ( $query->is_feed() && in_array( 'contract', (array) $query->get( 'post_type' ) ) ) {
    die( 'Feed disabled' );
  }
}
add_action( 'pre_get_posts', '_fdg_wponlinecontract_disable_feed' );